/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.scale;

import java.io.IOException;
import java.io.InputStream;
import ro.atreides.restaurant.modules.scale.ScaleAck;
import ro.atreides.restaurant.modules.scale.ScaleContent;
import ro.atreides.restaurant.modules.scale.ScaleMessageReadInternalInterface;
import ro.atreides.restaurant.modules.scale.ScaleNack;
import ro.atreides.utils.Logger;

public class MessageReader
extends Thread {
    InputStream inS;
    boolean running = true;
    ScaleMessageReadInternalInterface inter;

    public MessageReader(InputStream inS, ScaleMessageReadInternalInterface inter) {
        this.inS = inS;
        this.inter = inter;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    private String printByteArray(byte[] arr, int size) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            byte b = arr[i];
            s = s + "[" + b + "] ";
        }
        return s;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[65536];
        while (this.running) {
            try {
                int length = this.inS.read(buffer, 0, 1);
                if (length == 1) {
                    switch (buffer[0]) {
                        case 6: {
                            this.inter.messageRead(new ScaleAck());
                            break;
                        }
                        case 21: {
                            this.inter.messageRead(new ScaleNack());
                            break;
                        }
                        case 1: {
                            while (length < 15) {
                                int k = this.inS.read(buffer, length, 1);
                                if (k > 0) {
                                    ++length;
                                    continue;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e) {}
                            }
                            long v = 0L;
                            if (buffer[4] > 48) {
                                v += (long)((buffer[4] - 48) * 10000);
                            }
                            double f = (double)(v += (long)((buffer[5] - 48) * 1000 + (buffer[7] - 48) * 100 + (buffer[8] - 48) * 10 + (buffer[9] - 48))) / 1000.0;
                            if (buffer[3] == 45) {
                                f = -f;
                            }
                            this.inter.messageRead(new ScaleContent(f));
                        }
                    }
                    continue;
                }
                if (length == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.running = false;
                this.inter.eof();
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                this.running = false;
                this.inter.eof();
            }
        }
    }
}

