/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.scale;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.scale.MessageReader;
import ro.atreides.restaurant.modules.scale.ScaleAck;
import ro.atreides.restaurant.modules.scale.ScaleContent;
import ro.atreides.restaurant.modules.scale.ScaleInterfaceSerialPortImpl;
import ro.atreides.restaurant.modules.scale.ScaleInterfaceTcpPortImpl;
import ro.atreides.restaurant.modules.scale.ScaleMessage;
import ro.atreides.restaurant.modules.scale.ScaleMessageConsumer;
import ro.atreides.restaurant.modules.scale.ScaleMessageReadInternalInterface;
import ro.atreides.restaurant.modules.scale.ScaleNack;
import ro.atreides.restaurant.modules.scale.ScalePortInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;

public class Module
implements ro.atreides.utils.Module {
    private InputStream inS;
    private OutputStream outS;
    private boolean connected = false;
    private Object lock1 = new Object();
    private Object lock2 = new Object();
    private ScaleMessage reply1;
    private ScaleMessage reply2;
    private Vector consumers = new Vector();
    private boolean isLastValueZero = true;

    @Override
    public String getModuleName() {
        return "scale";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params1 = Utils.getCmdlineValue("-scaleparams", cmdArgs, "/dev/ttyS0=9600=8=1=0");
        final String params = params1.replace("/dev/", "");
        Logger.logDebug(this, "scaleparams : " + params);
        System.out.println("scaleparams : " + params);
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScalePortInterface portInterface = null;
                portInterface = params.startsWith("tcp") ? new ScaleInterfaceTcpPortImpl() : new ScaleInterfaceSerialPortImpl();
                MessageReader reader = null;
                ScaleMessageReadInternalInterface inter = new ScaleMessageReadInternalInterface(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void messageRead(ScaleMessage sm) {
                        Object object;
                        if (sm instanceof ScaleAck || sm instanceof ScaleNack) {
                            object = Module.this.lock1;
                            synchronized (object) {
                                Module.this.reply1 = sm;
                                Module.this.lock1.notify();
                            }
                        }
                        if (sm instanceof ScaleContent) {
                            object = Module.this.lock2;
                            synchronized (object) {
                                Module.this.reply2 = sm;
                                Module.this.lock2.notify();
                            }
                        }
                    }

                    @Override
                    public void eof() {
                        Module.this.connected = false;
                    }
                };
                boolean showErr = true;
                while (true) {
                    if (!Module.this.connected) {
                        boolean buildOK = portInterface.buildPort(params, showErr);
                        if (buildOK) {
                            Module.this.outS = portInterface.getOutS();
                            Module.this.inS = portInterface.getInS();
                            Module.this.connected = true;
                            reader = new MessageReader(Module.this.inS, inter);
                            reader.setName("ScaleMessageReader");
                            reader.start();
                            showErr = true;
                        } else {
                            showErr = false;
                        }
                    }
                    while (Module.this.connected) {
                        try {
                            boolean correct = false;
                            Module.this.outS.write(5);
                            Module.this.outS.flush();
                            Object object = Module.this.lock1;
                            synchronized (object) {
                                try {
                                    Module.this.lock1.wait(5000L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (Module.this.reply1 != null && Module.this.reply1 instanceof ScaleAck) {
                                ScaleContent value;
                                Module.this.outS.write(17);
                                Module.this.outS.flush();
                                object = Module.this.lock2;
                                synchronized (object) {
                                    try {
                                        Module.this.lock2.wait(5000L);
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                                if (Module.this.reply2 != null && Module.this.reply2 instanceof ScaleContent && ((value = (ScaleContent)Module.this.reply2).getValue() > 0.0 || !Module.this.isLastValueZero)) {
                                    Logger.logDebug(this, "<< Scale Content: " + value.getValue());
                                    correct = true;
                                    for (int i = 0; i < Module.this.consumers.size(); ++i) {
                                        ScaleMessageConsumer scaleMessageConsumer = (ScaleMessageConsumer)Module.this.consumers.elementAt(i);
                                        scaleMessageConsumer.readQuantity(value.getValue());
                                    }
                                    Module.this.isLastValueZero = value.getValue() <= 0.0;
                                }
                                Module.this.reply2 = null;
                            } else if (Module.this.reply1 instanceof ScaleNack) {
                                Logger.logDebugVerbose(this, "<< NACK");
                            }
                            Module.this.reply1 = null;
                            if (correct) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                            }
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                            Module.this.connected = false;
                        }
                    }
                    portInterface.closePort();
                    if (reader != null) {
                        reader.setRunning(false);
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
        };
        th.setName("ScaleThread");
        th.start();
        this.consumers.add(RestLogic.getInstance());
    }

    private String printByteArray(byte[] arr, int size) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            byte b = arr[i];
            s = s + "[" + b + "] ";
        }
        return s;
    }
}

