/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.scale;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.restaurant.modules.scale.ScalePortInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class ScaleInterfaceSerialPortImpl
implements ScalePortInterface {
    private SerialPort serialPort = null;
    private InputStream inS;
    private OutputStream outS;

    @Override
    public boolean buildPort(String params, boolean showErr) {
        Vector p = Utils.splitString(params, '=');
        String portName = (String)p.get(0);
        if (!Validators.correctString(portName)) {
            Logger.logError((Object)this, "Port serial incorect!!");
            Utils.systemExit();
        }
        String speedS = (String)p.get(1);
        int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        int parity = Integer.parseInt(parityS);
        try {
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = portName.replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                if (showErr) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Scale: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                }
                Logger.logDebug(this, "Port incorect: " + portName);
                return false;
            }
            PortSettingsPureJava settings = new PortSettingsPureJava();
            settings.setName(portName);
            settings.setSpeed(speed);
            settings.setDataBits(dataBits);
            settings.setStopBits(stopBits);
            settings.setPariry(parity);
            Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
            this.serialPort = (SerialPort)portId.open("Scale", 2000);
            this.serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
            Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + this.serialPort.getBaudRate() + " dataBits=" + this.serialPort.getDataBits() + " stopBits=" + this.serialPort.getStopBits() + " parity=" + this.serialPort.getParity());
            this.inS = this.serialPort.getInputStream();
            this.outS = this.serialPort.getOutputStream();
            Logger.logDebug(this, "initializat port: " + portName);
            return true;
        }
        catch (PortInUseException e) {
            Logger.logError((Object)this, "Scale: port ocupat : \"" + portName + "\"");
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return false;
    }

    @Override
    public void closePort() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
    }

    @Override
    public OutputStream getOutS() {
        return this.outS;
    }

    @Override
    public InputStream getInS() {
        return this.inS;
    }
}

