/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.serialbarcodereader;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
implements ro.atreides.utils.Module {
    private InputStream inS;

    @Override
    public String getModuleName() {
        return "serialbarcodereader";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-serialbarcodeparams", cmdArgs, "/dev/ttyS0=9600=8=1=0");
        params = params.replace("/dev/", "");
        String skipedCharsString = Utils.getCmdlineValue("-serialbarcodeskipchars", cmdArgs, "");
        final Vector skipedChars = Utils.splitString(skipedCharsString, ',');
        Logger.logDebug(this, "serialbarcodeparams : " + params);
        System.out.println("serialbarcodeparams : " + params);
        Vector p = Utils.splitString(params, '=');
        final String portName = (String)p.get(0);
        String speedS = (String)p.get(1);
        final int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        final int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        final int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        final int parity = Integer.parseInt(parityS);
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Robot robot = null;
                try {
                    robot = new Robot();
                }
                catch (AWTException e) {
                    Logger.logException(this, (Exception)e);
                }
                SerialPort serialPort = null;
                if (Validators.correctString(portName)) {
                    while (true) {
                        boolean portFound = false;
                        CommPortIdentifier portId = null;
                        Logger.logDebug(this, "initializing port: " + portName);
                        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                        while (portList.hasMoreElements()) {
                            portId = (CommPortIdentifier)portList.nextElement();
                            String shortPortName = portName.replace("/dev/", "");
                            String curentElementPortName = portId.getName();
                            if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                            Logger.logDebug(this, "Found port: " + portName);
                            portFound = true;
                            break;
                        }
                        if (!portFound) {
                            Logger.logDebug(this, "Port incorect: " + portName);
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "SerialBarCodeReader: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                            break;
                        }
                        try {
                            PortSettingsPureJava settings = new PortSettingsPureJava();
                            settings.setName(portName);
                            settings.setSpeed(speed);
                            settings.setDataBits(dataBits);
                            settings.setStopBits(stopBits);
                            settings.setPariry(parity);
                            Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
                            serialPort = (SerialPort)portId.open("SerialBarCodeReader", 2000);
                            Module.this.inS = serialPort.getInputStream();
                            serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
                            Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + serialPort.getBaudRate() + " dataBits=" + serialPort.getDataBits() + " stopBits=" + serialPort.getStopBits() + " parity=" + serialPort.getParity());
                            try {
                                while (true) {
                                    int toRead = Module.this.inS.available();
                                    boolean somethingDone = false;
                                    if (toRead > 0) {
                                        int r = Module.this.inS.read();
                                        Logger.logDebug(this, "Am citit: \"" + (char)r + "\" keycode: \"" + r + "\"");
                                        if (!skipedChars.contains("" + r)) {
                                            try {
                                                robot.keyPress(r);
                                                robot.keyRelease(r);
                                                somethingDone = true;
                                                Logger.logDebug(this, "RobotSend: \"" + (char)r + "\" keycode: \"" + r + "\"");
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        } else {
                                            Logger.logDebug(this, "Am ignorat: \"" + (char)r + "\" keycode: \"" + r + "\"");
                                        }
                                    }
                                    if (somethingDone) continue;
                                    Thread.sleep(200L);
                                }
                            }
                            catch (IOException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            catch (Throwable th) {
                                Logger.logError((Object)this, th);
                            }
                        }
                        catch (PortInUseException e) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "SerialBarCodeReader: port ocupat : \"" + portName + "\"", LangRoAll.nuPotContinua);
                        }
                        catch (Exception e) {
                            Logger.logException(this, e);
                        }
                        catch (Throwable th) {
                            Logger.logError((Object)this, th);
                        }
                        finally {
                            serialPort.close();
                            Logger.logDebug(this, "Am inchis portul: " + portName);
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
        };
        th.setName("SerialBarcodeReaderThread");
        th.start();
    }
}

