/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.serialcardreader;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
extends EventGenerator
implements ro.atreides.utils.Module {
    private InputStream inS;

    @Override
    public String getModuleName() {
        return "serialcardreader";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-serialcardparams", cmdArgs, "/dev/ttyUSB0=9600=8=1=0");
        params = params.replace("/dev/", "");
        final Vector<String> skipedChars = new Vector<String>();
        skipedChars.add("\u0002");
        skipedChars.add("\u0003");
        Logger.logDebug(this, "serialcardparams : " + params);
        System.out.println("serialcardparams : " + params);
        Vector p = Utils.splitString(params, '=');
        final String portName = (String)p.get(0);
        String speedS = (String)p.get(1);
        final int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        final int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        final int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        final int parity = Integer.parseInt(parityS);
        RestLogic.getInstance().setAccesInterface(this);
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SerialPort serialPort = null;
                if (Validators.correctString(portName)) {
                    while (true) {
                        boolean portFound = false;
                        CommPortIdentifier portId = null;
                        Logger.logDebug(this, "initializing port: " + portName);
                        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                        while (portList.hasMoreElements()) {
                            portId = (CommPortIdentifier)portList.nextElement();
                            String shortPortName = portName.replace("/dev/", "");
                            String curentElementPortName = portId.getName();
                            if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                            Logger.logDebug(this, "Found port: " + portName);
                            portFound = true;
                            break;
                        }
                        if (!portFound) {
                            Logger.logDebug(this, "Port incorect: " + portName);
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "serialcardreader: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                            break;
                        }
                        try {
                            String userInput;
                            PortSettingsPureJava settings = new PortSettingsPureJava();
                            settings.setName(portName);
                            settings.setSpeed(speed);
                            settings.setDataBits(dataBits);
                            settings.setStopBits(stopBits);
                            settings.setPariry(parity);
                            Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
                            serialPort = (SerialPort)portId.open("serialcardreader", 2000);
                            Module.this.inS = serialPort.getInputStream();
                            serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
                            Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + serialPort.getBaudRate() + " dataBits=" + serialPort.getDataBits() + " stopBits=" + serialPort.getStopBits() + " parity=" + serialPort.getParity());
                            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(Module.this.inS));
                            String replaceAsString = Utils.getSqlInSequence(skipedChars, false, '|');
                            while ((userInput = lineNumberReader.readLine()) != null) {
                                String stripped = userInput.replaceAll(replaceAsString, "");
                                if (!Validators.correctString(stripped)) continue;
                                System.out.println("echo: " + stripped);
                                Logger.logDebug(this, "Am citit : " + stripped);
                                Module.this.notifyObjectListeners(701, stripped);
                            }
                        }
                        catch (PortInUseException e) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "serialcardreader: port ocupat : \"" + portName + "\"", LangRoAll.nuPotContinua);
                        }
                        catch (Exception e) {
                            Logger.logException(this, e);
                        }
                        catch (Throwable th) {
                            Logger.logError((Object)this, th);
                        }
                        finally {
                            serialPort.close();
                            Logger.logDebug(this, "Am inchis portul: " + portName);
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
        };
        th.setName("serialcardreaderThread");
        th.start();
    }
}

