/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.simplestocks;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.simplestocks.SimpleStockLogic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Order;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.licensing.LicenseManager;

public class Module
implements ro.atreides.utils.Module {
    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "SimpleStocks";
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        if (LicenseManager.getInstance().isFunctionLicensed("simplestocks")) {
            RestLogic.getInstance().addListener(new EventListener(){

                @Override
                public void dataChanged() {
                    if (Config.getInstance().getBoolean("fisaStocProcessLaInchidereZi")) {
                        SimpleStockLogic.getInstance().closeDay();
                    }
                }

                @Override
                public String getName() {
                    return "SimpleStockLogic_closeDay";
                }
            }, 6);
            RestLogic.getInstance().addObjectListener(new ObjectEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dataChanged(Object o) {
                    Order order = (Order)o;
                    String document = "Nota " + order.getId();
                    try {
                        RestLogic.getInstance().descarcaNotaSimpleSale(order, document);
                        ConnectionPool.getInstance().commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            ConnectionPool.getInstance().rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    }
                    finally {
                        ConnectionPool.getInstance().releaseConnection();
                    }
                }

                @Override
                public String getName() {
                    return "SimpleStockLogic_notaClosed";
                }
            }, 104);
            RestLogic.getInstance().addObjectListener(new ObjectEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dataChanged(Object o) {
                    Hashtable params = (Hashtable)o;
                    Sale s = (Sale)params.get("sale");
                    Timestamp t = (Timestamp)params.get("timestamp");
                    int idLocatie = (Integer)params.get("idLocatie");
                    String numeNota = (String)params.get("numeNota");
                    double toRemove = (Double)params.get("quantity");
                    Order o1 = RestLogic.getInstance().getOrderById(s.getIdOrder());
                    boolean fiscal = true;
                    if (o != null) {
                        fiscal = o1.isFiscal();
                    }
                    try {
                        RestLogic.getInstance().descarcaSaleSimpleStock(s, t, idLocatie, numeNota, true, toRemove, fiscal, o1.isProtocol());
                        ConnectionPool.getInstance().commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            ConnectionPool.getInstance().rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    }
                    finally {
                        ConnectionPool.getInstance().releaseConnection();
                    }
                }

                @Override
                public String getName() {
                    return "SimpleStockLogic_saleDeleted";
                }
            }, 105);
            ContaLogic.getInstance().setCheckStockInterface(SimpleStockLogic.getInstance());
        }
    }
}

