/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.webcontrol;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class WebControlServlet
extends HttpServlet {
    private static String filterS = "NF";
    private static Vector filteredOrders = new Vector();

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String homePage = "webcontrol";
        System.out.println("query: " + request.getQueryString());
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        if (action.equalsIgnoreCase("fdefault")) {
            String value = request.getParameter("value");
            boolean bol = Boolean.valueOf(value);
            int fType = 1;
            fType = bol ? 3 : 2;
            RestLogic.getInstance().setFiscalDefault(fType);
            response.sendRedirect(homePage);
            return;
        }
        if (action.equalsIgnoreCase("minutes")) {
            String value = request.getParameter("value");
            if (Validators.correctInteger(value)) {
                int min;
                VpConfig.getInstance().ordersReprintableMinutes = min = Integer.parseInt(value);
            }
            response.sendRedirect(homePage);
            return;
        }
        if (action.equalsIgnoreCase("printAllNf")) {
            WebControlServlet value = this;
            synchronized (value) {
                for (int i = 0; i < filteredOrders.size(); ++i) {
                    Order order = (Order)filteredOrders.elementAt(i);
                    if (order.isFiscal()) continue;
                    RestLogic.getInstance().printBonFiscalSeparat(order, true);
                }
            }
            response.sendRedirect(homePage);
            return;
        }
        if (action.equalsIgnoreCase("printBon")) {
            String value = request.getParameter("id");
            if (Validators.correctInteger(value)) {
                int id = Integer.parseInt(value);
                Order order = RestLogic.getInstance().getOrderById(id);
                if (order != null) {
                    RestLogic.getInstance().printBonFiscalSeparat(order, true);
                }
            }
            response.sendRedirect(homePage);
            return;
        }
        if (action.equalsIgnoreCase("filter")) {
            String value;
            filterS = value = request.getParameter("value");
        }
        String frame = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps" + File.separator + "webcontrol" + File.separator + "frame.html");
        frame = frame.replaceAll("%%last_refresh%%", Formatters.TIME_FORMAT.format(new Date()));
        String text = "";
        boolean value = false;
        switch (RestLogic.getInstance().fiscalStatus) {
            case 3: {
                text = "AUTO OFF";
                value = false;
                break;
            }
            case 1: {
                RestLogic.getInstance().setFiscalDefault(2);
            }
            case 2: {
                text = "AUTO ON";
                value = true;
            }
        }
        frame = frame.replaceAll("%%fdefault_value%%", value + "");
        frame = frame.replaceAll("%%fdefault_text%%", text);
        frame = frame.replaceAll("%%filter_value%%", filterS.equalsIgnoreCase("ALL") ? "NF" : "ALL");
        frame = frame.replaceAll("%%filter_text%%", filterS.equalsIgnoreCase("ALL") ? "NF" : "ALL");
        StringBuffer sb = new StringBuffer();
        WebControlServlet webControlServlet = this;
        synchronized (webControlServlet) {
            Vector orders = RestLogic.getInstance().getReprintableOrders();
            Collections.sort(orders, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Order or1 = (Order)o1;
                    Order or2 = (Order)o2;
                    if (or1.getStopTime() < or2.getStopTime()) {
                        return 1;
                    }
                    return 0;
                }
            });
            filteredOrders.clear();
            for (int i = 0; i < orders.size(); ++i) {
                Order order = (Order)orders.elementAt(i);
                if (order.isFiscal() && !filterS.equalsIgnoreCase("ALL")) continue;
                String orderFile = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps" + File.separator + "webcontrol" + File.separator + "order.txt");
                orderFile = orderFile.replaceAll("%%tip%%", order.isFiscal() ? "F" : "NF");
                User u = UsersLogic.getInstance().getUserById(order.getUser());
                orderFile = orderFile.replaceAll("%%ospatar%%", u.getLogin());
                orderFile = orderFile.replaceAll("%%data%%", Formatters.TIME_FORMAT.format(new Date(order.getStopTime())));
                double total = RestLogic.getInstance().getTotal(order);
                orderFile = orderFile.replaceAll("%%total%%", Utils.getString2Decimals(total));
                orderFile = orderFile.replaceAll("%%id%%", order.getId() + "");
                filteredOrders.add(order);
                sb.append(orderFile + "<br>\n");
            }
        }
        frame = frame.replaceAll("%%orders%%", sb.toString());
        response.setContentType("text/html");
        this.sendResponse(frame, out);
    }

    private void sendResponse(String s, PrintWriter out) {
        out.write(s);
        out.flush();
    }
}

