/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.pda2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.pda2.PdaUsersEntry;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class UsersPdaPanel
extends AbstractListPanel
implements CleanupRequired {
    private AbstractTM tm;
    private String[] columns;

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                PdaUsersEntry e = (PdaUsersEntry)data.elementAt(rowIndex);
                if (columnIndex > 0) {
                    boolean b = (Boolean)aValue;
                    e.setPda(0);
                    if (b) {
                        for (int i = 0; i < data.size(); ++i) {
                            PdaUsersEntry pdaUsersEntry = (PdaUsersEntry)data.elementAt(i);
                            if (pdaUsersEntry.getPda() != columnIndex) continue;
                            pdaUsersEntry.setPda(0);
                        }
                        e.setPda(columnIndex);
                    }
                    UsersPdaPanel.this.tm.fireTableDataChanged();
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex > 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PdaUsersEntry e = (PdaUsersEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getUser();
                    }
                }
                return e.containsPda(columnIndex);
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel actiuni = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final UsersPdaPanel parent = this;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestLogic.getInstance().savePdaUsersEntries(UsersPdaPanel.this.tm.getData());
                DialogUtils.okDialog(parent, "Operatie efectuata", LangRoAll.succes);
            }
        });
        actiuni.add((Component)salveaza, c);
        actiuni.setBorder(new TitledBorder(LangRoAll.actiuni));
        return actiuni;
    }

    @Override
    public Vector buildData() {
        return RestLogic.getInstance().getPdaUsersEntries();
    }

    @Override
    public String[] buildColumns() {
        int pdas = VpConfig.getInstance().noOfPdas;
        this.columns = new String[pdas + 1];
        this.columns[0] = "Ospatar";
        for (int i = 1; i <= pdas; ++i) {
            this.columns[i] = "Pda " + i;
        }
        return this.columns;
    }

    @Override
    public Class[] buildTypes() {
        Class[] types = new Class[this.columns.length];
        types[0] = String.class;
        for (int i = 1; i < types.length; ++i) {
            types[i] = Boolean.class;
        }
        return types;
    }

    @Override
    public void doStuff() {
        this.display();
    }

    public Vector getData() {
        return this.tm.getData();
    }

    @Override
    public void cleanup() {
        this.tm.refresh(new Vector());
    }
}

