/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.restaurant.base.Bon;
import ro.atreides.utils.db.DaoInterface;

public class BonImpl
implements DaoInterface {
    private PreparedStatement addBon;
    private PreparedStatement processAllBons;
    private PreparedStatement getLastBonForCategory;
    private PreparedStatement addBonEntry;
    private PreparedStatement processAllBonEntries;
    private PreparedStatement getAllBonuri;
    private PreparedStatement getBonItemsByNr;
    private Connection conn;

    public BonImpl(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getLastBonForCategory = this.conn.prepareStatement("select max(nrbon) from bons where id_category = ? and status = 1");
        this.addBon = this.conn.prepareStatement("insert into bons ( nrbon, date, id_waiter, id_category, status ) values ( ?, ?, ?, ?, ?)");
        this.processAllBons = this.conn.prepareStatement("delete from bons");
        this.processAllBonEntries = this.conn.prepareStatement("delete from bon_entries");
        this.addBonEntry = this.conn.prepareStatement("insert into bon_entries( text, id_bon) values ( ? , ? )");
        this.getAllBonuri = this.conn.prepareStatement("select  users.login as login, categories.label as categorie, bons.nrbon, bons.date as data, bon_entries.text, id_bon from bons inner join bon_entries on bons.id = bon_entries.id_bon inner join users on bons.id_waiter = users.id inner join categories on bons.id_category = categories.id order by data, login, bon_entries.id");
        this.getBonItemsByNr = this.conn.prepareStatement("select text from bon_entries where id_bon = ( select max(id) from bons where nrbon = ? and id_category = ?) ");
    }

    public Vector getEntriesForBon(int nrBon, int idCategory) throws SQLException {
        Vector<String> result = new Vector<String>();
        this.getBonItemsByNr.setInt(1, nrBon);
        this.getBonItemsByNr.setInt(2, idCategory);
        ResultSet rs = this.getBonItemsByNr.executeQuery();
        while (rs.next()) {
            String t = rs.getString(1);
            result.add(t);
        }
        return result;
    }

    public void addBon(Bon bon) throws SQLException {
        this.addBon.setInt(1, bon.getNrBon());
        this.addBon.setTimestamp(2, new Timestamp(bon.getTimestamp()));
        this.addBon.setInt(3, bon.getIdUser());
        this.addBon.setInt(4, bon.getIdCategory());
        this.addBon.setInt(5, 1);
        this.addBon.execute();
    }

    public void addBonEntry(int idBon, String entry) throws SQLException {
        this.addBonEntry.setString(1, entry);
        this.addBonEntry.setInt(2, idBon);
        this.addBonEntry.execute();
    }

    public void processAllBons() throws SQLException {
        this.processAllBonEntries.execute();
        this.processAllBons.execute();
    }

    public Vector getAllBons() throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet rs = this.getAllBonuri.executeQuery();
        int lastNrBon = -1;
        while (rs.next()) {
            int nrBon = rs.getInt("nrbon");
            String s = "";
            if (nrBon == lastNrBon) {
                s = s + "   ";
            }
            s = s + rs.getString("text");
            lastNrBon = nrBon;
            result.add(s);
        }
        return result;
    }

    public int getLastBonForCategory(Integer idCategory) throws SQLException {
        int result = -1;
        this.getLastBonForCategory.setInt(1, idCategory);
        ResultSet rs = this.getLastBonForCategory.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }
}

