/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.promo.Promotion;
import ro.atreides.restaurant.Fabricare;
import ro.atreides.restaurant.PreparareEntry;
import ro.atreides.restaurant.RaportProductieEntry;
import ro.atreides.restaurant.VanzariPeZileEntry;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.MonetarView;
import ro.atreides.restaurant.base.Optiune;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.OptiuneProduseMeniu;
import ro.atreides.restaurant.base.RaportPeCategoriiSiCoteTva;
import ro.atreides.restaurant.base.SimpleMonetarView;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.reports.CorrectionsEntry;
import ro.atreides.restaurant.base.reports.IncasariEntry;
import ro.atreides.restaurant.base.reports.ProtocolEntry;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.base.reports.SimpleIncasariEntry;
import ro.atreides.restaurant.gui.admin.articole.ArticolBean;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.ClientiPeZileBean;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportMapping;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.documente.Document;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.tva.Tva;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class ClDaoImpl
implements DaoInterface {
    private Connection connection;
    private PreparedStatement totalBySectieAndUser;
    private PreparedStatement getIdStockForIdReteta;
    private PreparedStatement getIdProductByIdStock;
    private PreparedStatement addPreparat;
    private PreparedStatement addFabricare;
    private PreparedStatement getFabricareById;
    private PreparedStatement addFabricareItem;
    private PreparedStatement getFabricareItems;
    private PreparedStatement getRaportProductie;
    private PreparedStatement updateFabricare;
    private PreparedStatement deleteFabricareItems;
    private PreparedStatement deleteFabricare;
    private PreparedStatement getDocumente;
    private PreparedStatement getDocumentById;
    private PreparedStatement getDocumenteByStatus;
    private PreparedStatement getDocumenteByNegateStatus;
    private PreparedStatement setDocumentStatusPanaLaData;
    private PreparedStatement setDocumentStatus;
    private PreparedStatement setStatusAfterTimestamp;
    private PreparedStatement addDocumentFactura;
    private PreparedStatement addDocumentModificarePret;
    private PreparedStatement addDocumentOrder;
    private PreparedStatement addDocumentConsum;
    private PreparedStatement addDocumentCorectie;
    private PreparedStatement addDocumentAlterarePret;
    private PreparedStatement addDocumentTransfer;
    private PreparedStatement addDocumentFacturaEmisa;
    private PreparedStatement updateDocument;
    private PreparedStatement addDocumentFabricare;
    private PreparedStatement getLastValidate;
    private PreparedStatement setVanzariProcesateDupaData;
    private PreparedStatement deletePdaMese;
    private PreparedStatement addPdaMasa;
    private PreparedStatement getPdaMese;
    private PreparedStatement deletePdaUsers;
    private PreparedStatement addPdaUser;
    private PreparedStatement getPdaUsers;
    private PreparedStatement getAllMeniuri;
    private PreparedStatement getMeniuById;
    private PreparedStatement addMeniu;
    private PreparedStatement deleteMeniu;
    private PreparedStatement updateMeniu;
    private PreparedStatement getIdMeniuFromLabel;
    private PreparedStatement getIdMeniuFromCodsync;
    private PreparedStatement setCodsyncForMeniu;
    private PreparedStatement addOptiuneProdus;
    private PreparedStatement deleteOptiuneProdus;
    private PreparedStatement getAllOptiuni;
    private PreparedStatement getLabelOptiuneFromId;
    private PreparedStatement getOptiuniProdus;
    private PreparedStatement getAllOptiuniProduse;
    private PreparedStatement getIdOptiuneFromLabel;
    private PreparedStatement deleteAllOptiuniProduse;
    private PreparedStatement getOptiuniForMenu;
    private PreparedStatement getPretForOptiuneProdus;
    private PreparedStatement getRaportPreturi;
    private PreparedStatement getNrNotaInZiuaCurenta;
    private PreparedStatement getTotalIncasariInPerioada;
    private PreparedStatement deleteAllDocumentsNF;
    private PreparedStatement setNonFiscalForOrder;
    private PreparedStatement getNoteLimitsInPerioada;
    private PreparedStatement getOpenOrdersCount;
    private PreparedStatement getOpenOrdersValue;
    private PreparedStatement getOpenOrdersIds;
    private PreparedStatement deleteAllCorrections;
    private PreparedStatement getOrdersForTipPlataRosu;
    private PreparedStatement getAllContaExportMapping;
    private PreparedStatement getContaExportMappingForCodExtern;
    private PreparedStatement getContaExportMappingForIdProduct;
    private PreparedStatement getContaExportMappingForIdStock;
    private PreparedStatement addContaExportMapping;
    private PreparedStatement updateMappingCodExternById;
    private PreparedStatement updateMappingTvaByIdStock;

    public ClDaoImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public void addContaExportMapping(int idStock, int idProduct, String codExtern) throws SQLException {
        if (idStock > 0) {
            this.addContaExportMapping.setInt(1, idStock);
        } else {
            this.addContaExportMapping.setNull(1, 4);
        }
        if (idProduct > 0) {
            this.addContaExportMapping.setInt(2, idProduct);
        } else {
            this.addContaExportMapping.setNull(2, 4);
        }
        this.addContaExportMapping.setString(3, codExtern);
        this.addContaExportMapping.execute();
    }

    public void updateContaExportMappingById(String codExtern, int id) throws SQLException {
        this.updateMappingCodExternById.setString(1, codExtern);
        this.updateMappingCodExternById.setInt(2, id);
        this.updateMappingCodExternById.execute();
    }

    public void updateContaExportTvaByIdStock(double cotaTva, int idStock) throws SQLException {
        this.updateMappingTvaByIdStock.setDouble(1, cotaTva);
        this.updateMappingTvaByIdStock.setInt(2, idStock);
        this.updateMappingTvaByIdStock.execute();
    }

    public ContaExportMapping getContaExportMappingForCodExtern(String codExtern) throws SQLException {
        ContaExportMapping result = null;
        this.getContaExportMappingForCodExtern.setString(1, codExtern);
        ResultSet rs = this.getContaExportMappingForCodExtern.executeQuery();
        while (rs.next()) {
            result = this.getContaExportMappingFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public ContaExportMapping getContaExportMappingForIdProduct(int idProduct) throws SQLException {
        ContaExportMapping result = null;
        this.getContaExportMappingForIdProduct.setInt(1, idProduct);
        ResultSet rs = this.getContaExportMappingForIdProduct.executeQuery();
        if (rs.next()) {
            result = this.getContaExportMappingFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector<ContaExportMapping> getAllContaExportMapping() throws SQLException {
        Vector<ContaExportMapping> result = new Vector<ContaExportMapping>();
        ResultSet rs = this.getAllContaExportMapping.executeQuery();
        while (rs.next()) {
            ContaExportMapping item = this.getContaExportMappingFromResultSet(rs);
            result.add(item);
        }
        rs.close();
        return result;
    }

    public ContaExportMapping getContaExportMappingForIdStock(int idStock) throws SQLException {
        ContaExportMapping result = null;
        this.getContaExportMappingForIdStock.setInt(1, idStock);
        ResultSet rs = this.getContaExportMappingForIdStock.executeQuery();
        while (rs.next()) {
            result = this.getContaExportMappingFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private ContaExportMapping getContaExportMappingFromResultSet(ResultSet rs) throws SQLException {
        ContaExportMapping result = new ContaExportMapping();
        result.setExternalCode(rs.getString("cod_extern"));
        result.setIdProduct(rs.getInt("product_id"));
        result.setIdStock(rs.getInt("stock_id"));
        result.setTva(rs.getDouble("tva"));
        return result;
    }

    public Hashtable<Integer, Double> getLatestBuyPriceForStocks(Connection conn) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        String s = "select BUY_PRICE, id_stock, add_time from FISE_ACTIVE a where add_time = (select max(add_time) from FISE_ACTIVE b where a.id_stock = b.id_stock) order by id_stock";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            double buyPrice = rs.getDouble("buy_price");
            int idStock = rs.getInt("id_stock");
            result.put(idStock, buyPrice);
        }
        rs.close();
        return result;
    }

    public void setNonFiscalForOrder(int idOrder, int newValue) throws SQLException {
        this.setNonFiscalForOrder.setInt(1, newValue);
        this.setNonFiscalForOrder.setInt(2, idOrder);
        this.setNonFiscalForOrder.execute();
    }

    public double[] getTotalNote(Hashtable criteria, int what) throws SQLException {
        double[] result = new double[2];
        Vector orderIds = this.getOrdersForNote(criteria, what, false);
        if (orderIds.size() > 0) {
            String s = "select sum(ppu * quantity_float), sum(discount * quantity_float) from sales where id_order in " + Utils.getSqlInSequence(orderIds);
            ResultSet rs = SqlUtils.executeQuery(s, this.connection);
            if (rs.next()) {
                result[0] = rs.getDouble(1);
                result[1] = rs.getDouble(2);
            }
            rs.close();
        }
        return result;
    }

    public double getComision(Hashtable criteria, int what) throws SQLException {
        double result = 0.0;
        Vector orderIds = this.getOrdersForNote(criteria, what, false);
        if (orderIds.size() > 0) {
            String s = " select sum(quantity_float * sales.ppu * subcategories.comision / 100) as comision  from sales inner JOIN products ON sales.id_product = products.id inner JOIN subcategories ON products.id_subcategory = subcategories.id where sales.id_order in " + Utils.getSqlInSequence(orderIds);
            ResultSet rs = SqlUtils.executeQuery(s, this.connection);
            if (rs.next()) {
                result = rs.getDouble(1);
            }
            rs.close();
        }
        return result;
    }

    public long getDurataTotalaNote(Hashtable criteria, int what) throws SQLException {
        long result = 0L;
        Vector orderIds = this.getOrdersForNote(criteria, what, false);
        if (orderIds.size() > 0) {
            String s = "select closedate, opendate from orders where id in" + Utils.getSqlInSequence(orderIds);
            ResultSet rs = SqlUtils.executeQuery(s, this.connection);
            while (rs.next()) {
                Timestamp s1 = rs.getTimestamp("closedate");
                Timestamp s2 = rs.getTimestamp("opendate");
                long diff = s1.getTime() - s2.getTime();
                result += diff;
            }
            rs.close();
        }
        return result;
    }

    public Vector<PricePanelEntry> getRaportPreturi(int idProductg, String codBare, int idCategorie) throws SQLException {
        Vector<PricePanelEntry> result = new Vector<PricePanelEntry>();
        this.getRaportPreturi.setInt(1, idProductg);
        this.getRaportPreturi.setInt(2, idProductg);
        this.getRaportPreturi.setInt(3, idCategorie);
        this.getRaportPreturi.setInt(4, idCategorie);
        this.getRaportPreturi.setString(5, codBare);
        this.getRaportPreturi.setString(6, codBare);
        ResultSet rs = this.getRaportPreturi.executeQuery();
        while (rs.next()) {
            PricePanelEntry pe = new PricePanelEntry();
            if (rs.getInt("id_stoc") > 0) {
                pe.setIdStock(rs.getInt("id_stoc"));
                pe.setPret(rs.getDouble("pret_finit"));
            } else {
                pe.setIdReteta(rs.getInt("id_reteta"));
                pe.setPret(rs.getDouble("pret_reteta"));
            }
            pe.setCodIntern(rs.getString("cod_intern"));
            pe.setCategory(rs.getString("categorie"));
            pe.setProduct(rs.getString("label"));
            pe.setMustPrint(rs.getInt("to_print") == 1);
            pe.setIdProduct(rs.getInt("id_product"));
            pe.setCodBare(rs.getString("cod_bare"));
            pe.setIdCategorie(rs.getInt("id_categorie"));
            result.add(pe);
        }
        rs.close();
        return result;
    }

    public Vector getMonetarPeZile(Timestamp start, Timestamp stop) throws SQLException {
        Vector result = new Vector();
        return result;
    }

    public void deleteAllDocuments(String coloana, Connection conn) throws SQLException {
        String s = "delete from documente where " + coloana + " > 0";
        SqlUtils.executeUpdate(s, conn);
    }

    public void valideazaPanaLaData(Timestamp t1) throws SQLException {
        this.setDocumentStatusPanaLaData.setInt(1, 3);
        this.setDocumentStatusPanaLaData.setTimestamp(2, t1);
        this.setDocumentStatusPanaLaData.setInt(3, 2);
        this.setDocumentStatusPanaLaData.execute();
    }

    public void documentProcesat(int id) throws SQLException {
        this.setDocumentStatus.setInt(1, 2);
        this.setDocumentStatus.setInt(2, id);
        this.setDocumentStatus.execute();
    }

    public void documentNeprocesat(int id) throws SQLException {
        this.setDocumentStatus.setInt(1, 1);
        this.setDocumentStatus.setInt(2, id);
        this.setDocumentStatus.execute();
    }

    public Vector getDocumente(Timestamp t1, Timestamp t2, int what) throws SQLException {
        Vector<Document> result = new Vector<Document>();
        this.getDocumente.setTimestamp(1, t1);
        this.getDocumente.setTimestamp(2, t2);
        int w = -1;
        switch (what) {
            case 2: {
                w = 1;
                break;
            }
            case 3: {
                w = 0;
                break;
            }
            default: {
                w = -1;
            }
        }
        this.getDocumente.setInt(3, w);
        this.getDocumente.setInt(4, w);
        ResultSet rs = this.getDocumente.executeQuery();
        while (rs.next()) {
            Document d = this.getDocumentFromResultSet(rs);
            result.add(d);
        }
        rs.close();
        return result;
    }

    public Document getDocumentById(int idDocument) throws SQLException {
        Document result = null;
        this.getDocumentById.setInt(1, idDocument);
        ResultSet rs = this.getDocumentById.executeQuery();
        if (rs.next()) {
            result = this.getDocumentFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Document getDocumentNeprocesat() throws SQLException {
        Document result = null;
        this.getDocumenteByStatus.setInt(1, 1);
        ResultSet rs = this.getDocumenteByStatus.executeQuery();
        if (rs.next()) {
            result = this.getDocumentFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getDocumentNevalidate() throws SQLException {
        return this.getDocumenteByNegateStatus(3);
    }

    public Vector getDocumenteByNegateStatus(int status) throws SQLException {
        Vector<Document> result = new Vector<Document>();
        this.getDocumenteByNegateStatus.setInt(1, status);
        ResultSet rs = this.getDocumenteByNegateStatus.executeQuery();
        while (rs.next()) {
            Document d = this.getDocumentFromResultSet(rs);
            result.add(d);
        }
        rs.close();
        return result;
    }

    private Document getDocumentFromResultSet(ResultSet rs) throws SQLException {
        Document d = new Document();
        d.setDocument(rs.getString("nume"));
        d.setTimeDocument(rs.getTimestamp("time_document"));
        d.setStatus(rs.getInt("status"));
        d.setIdOrder(rs.getInt("nota"));
        d.setIdConsum(rs.getInt("consum"));
        d.setIdTransfer(rs.getInt("transfer"));
        d.setIdProductie(rs.getInt("fabricare"));
        d.setIdFacturaEmisa(rs.getInt("factura_emisa"));
        d.setIdCorectie(rs.getInt("corectie"));
        d.setIdModificarePret(rs.getInt("modif_pret"));
        d.setIdFactura(rs.getInt("factura"));
        d.setFiscal(rs.getInt("fiscal") == 1);
        d.setId(rs.getInt("id"));
        d.setComandaType(StockLogic.getInstance().getComandaTypeById(rs.getInt("comanda_type")));
        return d;
    }

    public Timestamp getLastValidate() throws SQLException {
        Timestamp result = new Timestamp(0L);
        ResultSet rs = this.getLastValidate.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Fabricare getFabricareById(int idFabricare) throws SQLException {
        Fabricare result = null;
        this.getFabricareById.setInt(1, idFabricare);
        ResultSet rs = this.getFabricareById.executeQuery();
        if (rs.next()) {
            result = new Fabricare();
            result.setData(rs.getTimestamp("dateadd"));
            result.setId(rs.getInt("id"));
            result.setIdMagazie(rs.getInt("id_magazie"));
        }
        rs.close();
        return result;
    }

    public void addFabricare(int idMagazie, Timestamp dateadd) throws SQLException {
        this.addFabricare.setInt(1, idMagazie);
        this.addFabricare.setTimestamp(2, dateadd);
        this.addFabricare.execute();
    }

    public void addFabricareItem(int idPreparare, int idProdusReteta, double quantity) throws SQLException {
        this.addFabricareItem.setInt(1, idPreparare);
        this.addFabricareItem.setInt(2, idProdusReteta);
        this.addFabricareItem.setDouble(3, quantity);
        this.addFabricareItem.execute();
    }

    public Vector getFabricareItems(int idFabricare) throws SQLException {
        Vector<PreparareEntry> result = new Vector<PreparareEntry>();
        this.getFabricareItems.setInt(1, idFabricare);
        ResultSet rs = this.getFabricareItems.executeQuery();
        while (rs.next()) {
            PreparareEntry pe = new PreparareEntry();
            pe.setCantitate(rs.getDouble("quantity"));
            pe.setIdFabricare(rs.getInt("id_fabricare"));
            pe.setIdProdusReteta(rs.getInt("id_produs_reteta"));
            pe.setProdus(rs.getString("produs"));
            result.add(pe);
        }
        rs.close();
        return result;
    }

    public Vector getRaportProductie(Hashtable criteria) throws SQLException {
        Vector<RaportProductieEntry> result = new Vector<RaportProductieEntry>();
        java.util.Date start = (java.util.Date)criteria.get(Constants.START_KEY);
        java.util.Date stop = (java.util.Date)criteria.get(Constants.STOP_KEY);
        this.getRaportProductie.setTimestamp(1, new Timestamp(start.getTime()));
        this.getRaportProductie.setTimestamp(2, new Timestamp(stop.getTime()));
        ResultSet rs = this.getRaportProductie.executeQuery();
        while (rs.next()) {
            RaportProductieEntry e = new RaportProductieEntry();
            double q = rs.getDouble("cantitate");
            e.setCantitate(q);
            e.setProdus(rs.getString("produs"));
            Timestamp dateadd = rs.getTimestamp("dateadd");
            e.setData(Formatters.DATE_AND_TIME_FORMAT.format(dateadd));
            e.setIdProductie(rs.getInt("id_productie"));
            e.setIdMagazie(rs.getInt("id_magazie"));
            e.setDateadd(dateadd);
            double pTva = rs.getDouble("pretCuTva");
            e.setPretCuTva(pTva);
            e.setValoareCuTva(pTva * q);
            result.add(e);
        }
        rs.close();
        return result;
    }

    public void deletePdaMese() throws SQLException {
        this.deletePdaMese.execute();
    }

    public void addPdaMasa(int idMasa, int pda) throws SQLException {
        this.addPdaMasa.setInt(1, idMasa);
        this.addPdaMasa.setInt(2, pda);
        this.addPdaMasa.execute();
    }

    public Vector getPdaMese(int idMasa) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getPdaMese.setInt(1, idMasa);
        ResultSet rs = this.getPdaMese.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt("pda"));
        }
        rs.close();
        return result;
    }

    public void deletePdaUsers(int idPda) throws SQLException {
        this.deletePdaUsers.setInt(1, idPda);
        this.deletePdaUsers.setInt(2, idPda);
        this.deletePdaUsers.execute();
    }

    public void addPdaUser(int idUser, int pda) throws SQLException {
        this.addPdaUser.setInt(1, idUser);
        this.addPdaUser.setInt(2, pda);
        this.addPdaUser.execute();
    }

    public int getPdaUsers(int idUser) throws SQLException {
        int result = -1;
        this.getPdaUsers.setInt(1, idUser);
        ResultSet rs = this.getPdaUsers.executeQuery();
        if (rs.next()) {
            result = rs.getInt("pda");
        }
        rs.close();
        return result;
    }

    private Meniu getMeniuFromRs(ResultSet rs) throws SQLException {
        Meniu m = new Meniu();
        m.setLabel(rs.getString("label"));
        m.setActiv(rs.getInt("activ") == 1);
        m.setZile(rs.getString("zile"));
        m.setOraStart(rs.getString("orastart"));
        m.setOraStop(rs.getString("orastop"));
        m.setId(rs.getInt("id"));
        m.setCodsync(rs.getString("cod_sync"));
        m.setStatus(rs.getInt("status"));
        return m;
    }

    public Meniu getMeniuById(int id) throws SQLException {
        Meniu result = null;
        this.getMeniuById.setInt(1, id);
        ResultSet rs = this.getMeniuById.executeQuery();
        if (rs.next()) {
            result = this.getMeniuFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Vector<Meniu> getAllMeniuri(int status) throws SQLException {
        Vector<Meniu> result = new Vector<Meniu>();
        this.getAllMeniuri.setInt(1, status);
        this.getAllMeniuri.setInt(2, status);
        ResultSet rs = this.getAllMeniuri.executeQuery();
        while (rs.next()) {
            Meniu m = this.getMeniuFromRs(rs);
            if (m.getStatus() != 1) continue;
            result.add(m);
        }
        rs.close();
        return result;
    }

    public void addMeniu(String label, String zile, String oraStart, String oraStop, String codsync) throws SQLException {
        this.addMeniu.setString(1, label);
        this.addMeniu.setString(2, zile);
        this.addMeniu.setString(3, oraStart);
        this.addMeniu.setString(4, oraStop);
        this.addMeniu.setString(5, codsync);
        this.addMeniu.execute();
    }

    public void updateMeniu(String label, boolean activ, String zile, String oraStart, String oraStop, int id) throws SQLException {
        this.updateMeniu.setString(1, label);
        this.updateMeniu.setInt(2, activ ? 1 : 0);
        this.updateMeniu.setString(3, zile);
        this.updateMeniu.setString(4, oraStart);
        this.updateMeniu.setString(5, oraStop);
        this.updateMeniu.setInt(6, id);
        this.updateMeniu.execute();
    }

    public void deleteMeniu(int id) throws SQLException {
        this.deleteMeniu.setInt(1, id);
        this.deleteMeniu.execute();
    }

    public void addOptiuneProdus(int idMeniu, int categorie, int idProdus, int idOptiune, double pret, double cant) throws SQLException {
        this.addOptiuneProdus.setInt(1, idMeniu);
        if (categorie > 0) {
            this.addOptiuneProdus.setInt(2, categorie);
        } else {
            this.addOptiuneProdus.setNull(2, 4);
        }
        if (idProdus > 0) {
            this.addOptiuneProdus.setInt(3, idProdus);
        } else {
            this.addOptiuneProdus.setNull(3, 4);
        }
        this.addOptiuneProdus.setInt(4, idOptiune);
        this.addOptiuneProdus.setDouble(5, pret);
        this.addOptiuneProdus.setDouble(6, cant);
        this.addOptiuneProdus.execute();
    }

    public void deleteOptiuneProdus(int id) throws SQLException {
        this.deleteOptiuneProdus.setInt(1, id);
        this.deleteOptiuneProdus.execute();
    }

    public Vector getAllOptiuni() throws SQLException {
        Vector<Optiune> result = new Vector<Optiune>();
        ResultSet rs = this.getAllOptiuni.executeQuery();
        while (rs.next()) {
            Optiune o = new Optiune();
            o.setId(rs.getInt("id"));
            o.setLabel(rs.getString("label"));
            result.add(o);
        }
        rs.close();
        return result;
    }

    public Vector<OptiuneProdus> getOptiuniProdus(int idMeniu, int idOptiune) throws SQLException {
        Vector<OptiuneProdus> result = new Vector<OptiuneProdus>();
        this.getOptiuniProdus.setInt(1, idMeniu);
        this.getOptiuniProdus.setInt(2, idOptiune);
        this.getOptiuniProdus.setInt(3, idOptiune);
        ResultSet rs = this.getOptiuniProdus.executeQuery();
        while (rs.next()) {
            OptiuneProdus op = new OptiuneProdus();
            op.setOptiune(rs.getString("optiune"));
            int idProdus = rs.getInt("id_product");
            int idCategorie = rs.getInt("id_subcategory");
            op.setIdCategorie(idCategorie);
            op.setIdProdus(idProdus);
            op.setPret(rs.getDouble("pret"));
            op.setCantitate(rs.getDouble("cantitate"));
            op.setProduct(rs.getString("product"));
            op.setCategorie(rs.getString("subcategory"));
            op.setId(rs.getInt("id"));
            result.add(op);
        }
        return result;
    }

    public double getPretOptiuneProdusById(int id) throws SQLException {
        this.getPretForOptiuneProdus.setInt(1, id);
        ResultSet rs = this.getPretForOptiuneProdus.executeQuery();
        double result = -1.0;
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public int getNrPersoaneInPerioada(Hashtable criteria, int what) throws SQLException {
        int result = 0;
        Vector orderIds = this.getOrdersForNote(criteria, what, false);
        if (orderIds.size() > 0) {
            String s = "select sum(nr_persoane) from orders where id in " + Utils.getSqlInSequence(orderIds);
            ResultSet rs = SqlUtils.executeQuery(s, this.connection);
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        return result;
    }

    public int getNrNoteInPerioada(Hashtable criteria, int what) throws SQLException {
        Vector orderIds = this.getOrdersForNote(criteria, what, false);
        return orderIds.size();
    }

    public void deleteCorrections() throws SQLException {
        this.deleteAllCorrections.execute();
    }

    public Vector<Integer> getOrdersForTipPlataRosu(int idTipPlata) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getOrdersForTipPlataRosu.setInt(1, idTipPlata);
        ResultSet rs = this.getOrdersForTipPlataRosu.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.updateMappingCodExternById = this.connection.prepareStatement("update conta_export_mapping set cod_extern = ? where id = ?");
        this.updateMappingTvaByIdStock = this.connection.prepareStatement("update conta_export_mapping set cota_tva = ? where id_stock = ?");
        String selectContaMapping = "select cod_extern, coalesce(id_stock, -1) as stock_id ,  coalesce(id_product, -1) as product_id, coalesce(cota_tva, -1) as tva  from conta_export_mapping ";
        this.addContaExportMapping = this.connection.prepareStatement("insert into conta_export_mapping ( id_stock, id_product, cod_extern) values ( ?, ? , ?)");
        this.getAllContaExportMapping = this.connection.prepareStatement(selectContaMapping);
        this.getContaExportMappingForCodExtern = this.connection.prepareStatement(selectContaMapping + " where cod_extern = ?");
        this.getContaExportMappingForIdProduct = this.connection.prepareStatement(selectContaMapping + " where id_product = ?");
        this.getContaExportMappingForIdStock = this.connection.prepareStatement(selectContaMapping + " where id_stock = ?");
        this.addDocumentModificarePret = this.connection.prepareStatement("insert into documente (time_document, nume, id_modif_pret, status, fiscal) values ( ?, ?, ? , 1, ?)");
        this.getOrdersForTipPlataRosu = this.connection.prepareStatement("select orders.id from orders inner join rest_incasari on orders.id = rest_incasari.id_order where rest_incasari.id_tip_plata = ? and orders.fiscal='true'");
        this.deleteAllCorrections = this.connection.prepareStatement("delete from corrections");
        this.setNonFiscalForOrder = this.connection.prepareStatement("update documente set fiscal = ?, status = 1 where id_order = ?");
        this.getPretForOptiuneProdus = this.connection.prepareStatement("select optiuni_produse.pret as pret from optiuni_produse where id = ?");
        this.getRaportPreturi = this.connection.prepareStatement("select products.label, stocks.sell_price as pret_finit, produse_reteta.sell_price as pret_reteta, stocks.id as id_stoc, produse_Reteta.id as id_reteta, subcategories.label as categorie, subcategories.id as id_categorie, products.to_print, products.id as id_product, products.cod_bare as cod_bare, products.cod as cod_intern from products inner join subcategories on products.id_subcategory = subcategories.id left join produse_reteta on products.id = produse_reteta.id_product left join produse_finite on products.id = produse_finite.id_product left join stocks on produse_finite.id_stock = stocks.id where products.status = 1 and (products.id = ? or ? = -1 ) and (products.id_subcategory = ? or ? = -1 ) and (products.cod_bare = ? or ? = 'NULL' ) order by categorie, products.label");
        this.getOptiuniForMenu = this.connection.prepareStatement("select distinct(optiuni.label) as optiune, optiuni.id as id_optiune from optiuni_produse inner join optiuni on optiuni_produse.id_optiune = optiuni.id where optiuni_produse.id_meniu = ? order by optiune ");
        this.getOptiuniProdus = this.connection.prepareStatement("select optiuni_produse.id, coalesce(products.label, '-') as product, coalesce(subcategories.label, '-') as subcategory, optiuni.label as optiune, optiuni_produse.pret as pret, optiuni_produse.cantitate as cantitate, coalesce(optiuni_produse.id_product, -1) as id_product, coalesce(optiuni_produse.id_subcategory, -1) as id_subcategory from optiuni_produse inner join optiuni on optiuni_produse.id_optiune = optiuni.id left outer join products on optiuni_produse.id_product = products.id left outer join subcategories on optiuni_produse.id_subcategory = subcategories.id where optiuni_produse.id_meniu = ?  and ( optiuni_produse.id_optiune = ? or ? = -1 ) order by optiune, subcategory, product ");
        this.getMeniuById = this.connection.prepareStatement("select * from meniuri where id = ?");
        this.getAllOptiuni = this.connection.prepareStatement("select * from optiuni");
        this.getAllMeniuri = this.connection.prepareStatement("select * from meniuri where activ = ? or -1 = ? ");
        this.addMeniu = this.connection.prepareStatement("insert into meniuri ( label, zile, orastart, orastop, cod_sync ) values ( ?, ?, ?, ?, ? )");
        this.updateMeniu = this.connection.prepareStatement("update meniuri set label = ?, activ = ?, zile = ?, orastart = ?, orastop = ?, status = 1 where id = ?");
        this.deleteMeniu = this.connection.prepareStatement("update meniuri set status = 2 where id = ?");
        this.addOptiuneProdus = this.connection.prepareStatement("insert into optiuni_produse ( id_meniu , id_subcategory, id_product, id_optiune, pret, cantitate ) values ( ?, ?, ?, ?, ?, ? )");
        this.deleteOptiuneProdus = this.connection.prepareStatement("delete from optiuni_produse where id = ?");
        this.addPdaMasa = this.connection.prepareStatement("insert into pda_mese( id_table, pda ) values ( ?, ? )");
        this.getPdaMese = this.connection.prepareStatement("select pda from pda_mese where id_table = ?");
        this.deletePdaMese = this.connection.prepareStatement("delete from pda_mese");
        this.addPdaUser = this.connection.prepareStatement("insert into pda_users( id_user, pda ) values ( ?, ? )");
        this.getPdaUsers = this.connection.prepareStatement("select pda from pda_users where id_user = ?");
        this.deletePdaUsers = this.connection.prepareStatement("delete from pda_users where (pda = ? or ? = -1)");
        this.getLastValidate = this.connection.prepareStatement("select max(time_document) from documente where status = 3");
        this.addDocumentFactura = this.connection.prepareStatement("insert into documente (time_document, nume, id_factura, status, fiscal, comanda_type) values ( ?, ?, ? , 1, ?, ?)");
        this.addDocumentOrder = this.connection.prepareStatement("insert into documente (time_document, nume, id_order, status, fiscal, comanda_type) values ( ?, ?, ? , 1, ?, ?)");
        this.addDocumentConsum = this.connection.prepareStatement("insert into documente (time_document, nume, id_consum, status, fiscal) values ( ?, ?, ? , 1, ?)");
        this.addDocumentCorectie = this.connection.prepareStatement("insert into documente (time_document, nume, id_corectie, status, fiscal) values ( ?, ?, ? , 1, ?)");
        this.addDocumentAlterarePret = this.connection.prepareStatement("insert into documente (time_document, nume, id_alterare_pret, status) values ( ?, ?, ? , 1)");
        this.addDocumentTransfer = this.connection.prepareStatement("insert into documente (time_document, nume, id_transfer, status) values ( ?, ?, ? , 1)");
        this.addDocumentFacturaEmisa = this.connection.prepareStatement("insert into documente (time_document, nume, id_factura_emisa, status, fiscal, comanda_type) values ( ?, ?, ? , 1, ?, ?)");
        this.updateDocument = this.connection.prepareStatement("update documente set time_document = ?, nume = ?, fiscal = ?, comanda_type = ? where id = ?");
        this.addDocumentFabricare = this.connection.prepareStatement("insert into documente (time_document, nume, id_fabricare, status) values ( ?, ?, ? , 1)");
        this.setDocumentStatus = this.connection.prepareStatement("update documente set status = ? where id = ?");
        this.setStatusAfterTimestamp = this.connection.prepareStatement("update documente set status = ? where time_document > ?");
        this.getRaportProductie = this.connection.prepareStatement("select products.label as produs, fabricare_items.quantity as cantitate, produse_reteta.sell_price as pretCuTva, fabricare.dateadd, fabricare.id as id_productie, fabricare.id_magazie as id_magazie from fabricare inner join fabricare_items on fabricare.id = fabricare_items.id_fabricare inner join produse_reteta on fabricare_items.id_produs_reteta = produse_reteta.id inner join products on produse_reteta.id_product = products.id where fabricare.dateadd >= ? and fabricare.dateadd < ? order by products.label");
        this.getFabricareById = this.connection.prepareStatement("select * from fabricare where id = ?");
        this.addFabricare = this.connection.prepareStatement("insert into fabricare ( id_magazie, dateadd) values ( ?, ?)");
        this.updateFabricare = this.connection.prepareStatement("update fabricare set id_magazie = ? , dateadd = ? where id = ?");
        this.deleteFabricareItems = this.connection.prepareStatement("delete from fabricare_items where id_fabricare = ?");
        this.deleteFabricare = this.connection.prepareStatement("delete from fabricare where id = ?");
        this.addFabricareItem = this.connection.prepareStatement("insert into fabricare_items ( id_fabricare, id_produs_reteta, quantity) values ( ?, ?, ?)");
        this.getFabricareItems = this.connection.prepareStatement("select fabricare_items.*, products.label as produs from fabricare_items inner join produse_reteta on fabricare_items.id_produs_reteta = produse_Reteta.id inner join products on produse_reteta.id_product = products.id where id_fabricare = ?");
        this.setDocumentStatusPanaLaData = this.connection.prepareStatement("update documente set status = ? where time_document <= ? and status = ?");
        String selectDocumentStatus = "select nume, time_document, status, fiscal, coalesce(id_factura, 0) as factura, coalesce(id_order, 0) as nota, coalesce(id_consum, 0) as consum, coalesce(id_transfer, 0) as transfer, coalesce(id_fabricare, 0) as fabricare, coalesce(id_factura_emisa, 0) as factura_emisa, coalesce(id_corectie, 0) as corectie, coalesce(id_modif_pret, 0) as modif_pret, id, comanda_type from documente";
        this.getDocumentById = this.connection.prepareStatement(selectDocumentStatus + " where documente.id = ? ");
        this.getDocumenteByStatus = this.connection.prepareStatement(selectDocumentStatus + " where status = ? " + " order by time_document, id");
        this.getDocumenteByNegateStatus = this.connection.prepareStatement(selectDocumentStatus + " where NOT (status = ?) " + " order by time_document, id");
        this.getDocumente = this.connection.prepareStatement(selectDocumentStatus + " where" + " time_document >= ?" + " and time_document < ?" + " and (fiscal = ? or ? = " + -1 + ")" + " order by time_document, id");
        this.getIdStockForIdReteta = this.connection.prepareStatement("select preparate.id_stock as id_stock from preparate inner join stocks on preparate.id_stock = stocks.id where id_reteta = ? and stocks.status = 1");
        this.getIdProductByIdStock = this.connection.prepareStatement("select produse_reteta.id_product from preparate inner join produse_reteta on preparate.id_reteta = produse_reteta.id where preparate.id_stock = ?");
        this.addPreparat = this.connection.prepareStatement("insert into preparate ( id_reteta, id_stock ) values ( ?, ? )");
        this.getOpenOrdersCount = this.connection.prepareStatement("select count(id) from orders where closedate is null");
        this.getOpenOrdersValue = this.connection.prepareStatement("select sum(quantity_float * sales.ppu ) as total from sales where id_order in (select id from orders where closedate is null)");
        this.getOpenOrdersIds = this.connection.prepareStatement("select id from orders where closedate is null");
        this.getAllOptiuniProduse = this.connection.prepareStatement("select * from optiuni_produse");
        this.getLabelOptiuneFromId = this.connection.prepareStatement("select label from optiuni where id = ?");
        this.getIdMeniuFromLabel = this.connection.prepareStatement("select id from meniuri where label = ? and status = 1");
        this.getIdOptiuneFromLabel = this.connection.prepareStatement("select id from optiuni where label = ?");
        this.deleteAllOptiuniProduse = this.connection.prepareStatement("delete from optiuni_produse where (id_meniu = ? or ? = -1)");
        this.getIdMeniuFromCodsync = this.connection.prepareStatement("select id from meniuri where cod_sync = ? and status = 1");
        this.setCodsyncForMeniu = this.connection.prepareStatement("update meniuri set cod_sync = ? where id = ?");
    }

    public String getLabelOptiuneFromId(int id) throws SQLException {
        String result = "";
        this.getLabelOptiuneFromId.setInt(1, id);
        ResultSet rs = this.getLabelOptiuneFromId.executeQuery();
        if (rs.next()) {
            result = rs.getString("label");
        }
        return result;
    }

    public Vector<Integer> getOpenOrdersIds() throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        ResultSet rs = this.getOpenOrdersIds.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public int getOpenOrdersCount() throws SQLException {
        int result = 0;
        ResultSet rs = this.getOpenOrdersCount.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public double getOpenOrdersValue() throws SQLException {
        double result = 0.0;
        ResultSet rs = this.getOpenOrdersValue.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public void updateFabricare(int id, Timestamp newDate, int idMagazie) throws SQLException {
        this.updateFabricare.setInt(1, idMagazie);
        this.updateFabricare.setTimestamp(2, newDate);
        this.updateFabricare.setInt(3, id);
        this.updateFabricare.execute();
    }

    public void deleteFabricare(int id) throws SQLException {
        this.deleteFabricare.setInt(1, id);
        this.deleteFabricare.execute();
    }

    public void deleteFabricareItems(int idFabricare) throws SQLException {
        this.deleteFabricareItems.setInt(1, idFabricare);
        this.deleteFabricareItems.execute();
    }

    public Vector getOptiuniForMenu(int idMenu) throws SQLException {
        Vector<OptiuneMeniu> result = new Vector<OptiuneMeniu>();
        this.getOptiuniForMenu.setInt(1, idMenu);
        ResultSet rs = this.getOptiuniForMenu.executeQuery();
        while (rs.next()) {
            OptiuneMeniu om = new OptiuneMeniu();
            om.setIdOptiune(rs.getInt("id_optiune"));
            om.setNumeOptiune(rs.getString("optiune"));
            result.add(om);
        }
        rs.close();
        return result;
    }

    public int getPreparatByIdReteta(int idReteta) throws SQLException {
        int result = -1;
        this.getIdStockForIdReteta.setInt(1, idReteta);
        ResultSet rs = this.getIdStockForIdReteta.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getIdProductByIdStock(int idStock) throws SQLException {
        int result = -1;
        this.getIdProductByIdStock.setInt(1, idStock);
        ResultSet rs = this.getIdProductByIdStock.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addPreparare(int idReteta, int idStock) throws SQLException {
        this.addPreparat.setInt(1, idReteta);
        this.addPreparat.setInt(2, idStock);
        this.addPreparat.execute();
    }

    public double[] getTotalForSectieAndUser(int idSectie, int idUser, int what, int idLocatie) throws SQLException {
        return ClDaoImpl.getTotalForSectieAndUser(idSectie, idUser, what, idLocatie, this.connection);
    }

    public static double[] getTotalForSectieAndUser(int idSectie, int idUser, int what, int idLocatie, Connection connection) throws SQLException {
        return ClDaoImpl.getTotalForSectieAndUser(idSectie, idUser, what, idLocatie, connection, 4);
    }

    public static double[] getTotalForSectieAndUser(int idSectie, int idUser, int what, int idLocatie, Connection connection, int orderStatus) throws SQLException {
        String s = "select sum(quantity_float * sales.ppu ) as total, sum(quantity_float * discount ) as discount, sum(quantity_float * sales.ppu * subcategories.comision / 100) as comision  from sales JOIN products ON sales.id_product = products.id JOIN subcategories ON products.id_subcategory = subcategories.id JOIN categories ON subcategories.id_category = categories.id inner join orders on sales.id_order = orders.id inner JOIN tables ON orders.id_table = tables.id where (orders.status = " + orderStatus + " or " + orderStatus + " = " + -1 + " ) ";
        if (idSectie != -1) {
            s = s + " and categories.id = " + idSectie;
        }
        if (idUser != -1) {
            s = s + " and id_user = " + idUser;
        }
        if (idLocatie != -1) {
            s = s + " and tables.id_locatie = " + idLocatie;
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        double[] total = new double[3];
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        boolean empty = true;
        if (rs.next()) {
            total[0] = rs.getDouble("total");
            total[1] = rs.getDouble("discount");
            total[2] = rs.getDouble("comision");
            empty = false;
        }
        if (empty) {
            Logger.logError(ClDaoImpl.class, "Empty set fetched");
        }
        rs.close();
        return total;
    }

    public Hashtable<Integer, Integer> getInfoClienti(Vector<Integer> idOrders) throws SQLException {
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        String s = "select id_client, id from orders where id in " + Utils.getSqlInSequence(idOrders) + " and not (id_client is null)";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            int idClient = rs.getInt(1);
            int idOrder = rs.getInt(2);
            result.put(idOrder, idClient);
        }
        rs.close();
        return result;
    }

    private ResultSet runSalesReport2(Hashtable criteria, int what, boolean multipleUsersPerOrder) throws SQLException {
        Integer idUser;
        Vector ids;
        Logger.logDebugVerbose(this, "Sales report criteria : " + criteria.toString());
        String s = "select sum(quantity_float) as quantity, products.id as p_id, products.label as p_label, products.cod_bare as cod_bare, products.cod_sync as cod_sync, categories.label as c_label, subcategories.label as s_label, sales.ppu as ppu, sales.ppu_original, sales.id_promotion as promo_id, sales.discount as discount, promotions.label as promo, orders.cod_fiscal as cui, tva.cota as cotaTva";
        String g = (String)criteria.get(Constants.GRUPARE_KEY);
        if (g != null) {
            if (g.equalsIgnoreCase("Dupa data")) {
                s = s + ", date(saledate) as grupare";
            } else if (g.equalsIgnoreCase("Dupa ora")) {
                s = s + ", date_part('hour',saledate) || '-' || (date_part('hour',saledate)+1) as grupare";
            } else if (g.equalsIgnoreCase("Dupa comanda")) {
                s = s + ", id_order as grupare";
            } else if (g.equalsIgnoreCase("Dupa id sale")) {
                s = s + ", sales.id as grupare";
            }
        } else {
            s = s + ", '' as grupare";
        }
        s = s + " from sales  INNER JOIN products on sales.id_product = products.id  INNER JOIN subcategories on products.id_subcategory = subcategories.id INNER JOIN categories on subcategories.id_category = categories.id INNER JOIN orders on sales.id_order = orders.id INNER JOIN tva on subcategories.id_tva = tva.id";
        String tipProdus = (String)criteria.get("tip_produs_key");
        if (tipProdus != null) {
            if (tipProdus.equals("Produs finit")) {
                s = s + " INNER JOIN produse_finite on products.id = produse_finite.id_product";
            } else if (tipProdus.equals("Produs reteta")) {
                s = s + " INNER JOIN produse_reteta on products.id = produse_reteta.id_product";
            }
        }
        s = s + " LEFT JOIN promotions on sales.id_promotion = promotions.id ";
        int tipNota = 2;
        Integer tn = (Integer)criteria.get("StatusNota");
        if (tn != null) {
            tipNota = tn;
        }
        if ((ids = this.getOrders(criteria, what, tipNota, multipleUsersPerOrder)).size() == 0 || ids.size() > VpConfig.getInstance().ordersReportingLimit) {
            return null;
        }
        String s2 = Utils.getSqlInSequence(ids);
        s = s + " where id_order in " + s2;
        if (multipleUsersPerOrder && (idUser = (Integer)criteria.get(Constants.WAITER_KEY)) != null) {
            s = s + " and sales.id_user2 = " + idUser;
        }
        if (criteria.get("category") != null) {
            Sectie cat = (Sectie)criteria.get("category");
            s = s + " and categories.id = " + cat.getId();
        }
        if (criteria.get("subcategory") != null) {
            Categorie subcat = (Categorie)criteria.get("subcategory");
            s = s + " and subcategories.id = " + subcat.getId();
        }
        if (criteria.get("product") != null) {
            Integer product = (Integer)criteria.get("product");
            s = s + " and products.id = " + product;
        }
        if (criteria.get(LangRoAll.tva) != null) {
            Tva tva = (Tva)criteria.get(LangRoAll.tva);
            s = s + " and subcategories.id_tva = " + tva.getId();
        }
        java.util.Date d1 = (java.util.Date)criteria.get(Constants.START_KEY);
        java.util.Date d2 = (java.util.Date)criteria.get(Constants.STOP_KEY);
        if (tipNota == 3 || tipNota == 1) {
            s = s + " and sales.saledate >= '" + new Timestamp(d1.getTime()) + "'";
            s = s + " and sales.saledate < '" + new Timestamp(d2.getTime()) + "'";
        }
        s = s + " group by products.id, categories.label, subcategories.label, sales.ppu,  sales.ppu_original, sales.id_promotion, promotions.label, sales.discount, products.label, products.cod_bare, products.cod_sync, orders.cod_fiscal, tva.cota";
        if (g != null) {
            if (g.equalsIgnoreCase("Dupa data")) {
                s = s + ", date(saledate)";
            } else if (g.equalsIgnoreCase("Dupa ora")) {
                s = s + ", date_part('hour',saledate)";
            } else if (g.equalsIgnoreCase("Dupa comanda")) {
                s = s + ", id_order";
            } else if (g.equalsIgnoreCase("Dupa id sale")) {
                s = s + ", sales.id";
            }
        }
        s = s + " order by";
        if (g != null) {
            if (g.equalsIgnoreCase("Dupa data")) {
                s = s + " date(saledate),";
            } else if (g.equalsIgnoreCase("Dupa ora")) {
                s = s + " date_part('hour',saledate),";
            } else if (g.equalsIgnoreCase("Dupa comanda")) {
                s = s + " id_order,";
            }
        }
        s = s + " categories.label, subcategories.label, products.label";
        System.out.println("executing query : " + s);
        Logger.logDebugVerbose(this, "executing query : " + s);
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        return rs;
    }

    private Vector getOrders(Hashtable criteria, int what, int tipNota, boolean multipleUsersPerOrder) throws SQLException {
        int tp;
        Integer idOrder;
        Integer idUser;
        String type1;
        String s2 = "select orders.id from orders";
        if (criteria.get(Constants.LOCATIE_KEY) != null) {
            s2 = s2 + " INNER JOIN tables on orders.id_table = tables.id";
        }
        if (criteria.get("Tip plata") != null) {
            s2 = s2 + " INNER JOIN rest_incasari on orders.id = rest_incasari.id_order";
        }
        String orderStatus = "";
        switch (tipNota) {
            case 1: {
                orderStatus = "(orders.status = 1 or orders.status = 5)";
                break;
            }
            case 2: {
                orderStatus = "(orders.status = 4 or orders.status = 3)";
                break;
            }
            case 3: {
                orderStatus = "(orders.status = 4 or orders.status = 3 or orders.status = 1 or orders.status = 5)";
            }
        }
        s2 = s2 + " where " + orderStatus;
        Order.TIP_ORDER tipOrder = (Order.TIP_ORDER)((Object)criteria.get("Tip_Order"));
        if (tipOrder != null) {
            if (!tipOrder.equals((Object)Order.TIP_ORDER.ALL)) {
                s2 = s2 + " and orders.tip_order = " + tipOrder.getTip();
            }
        } else {
            s2 = s2 + " and orders.tip_order = " + Order.TIP_ORDER.VANZARE.getTip();
        }
        if ((type1 = (String)criteria.get("Tip protocol")) != null) {
            s2 = s2 + " and protocol = '" + type1 + "'";
        }
        java.util.Date d1 = (java.util.Date)criteria.get(Constants.START_KEY);
        java.util.Date d2 = (java.util.Date)criteria.get(Constants.STOP_KEY);
        if (d1 != null || d2 != null) {
            if (tipNota == 1 || tipNota == 3) {
                s2 = s2 + " and (orders.closedate >= '" + new Timestamp(d1.getTime()) + "' or closedate is null)";
                s2 = s2 + " and (orders.closedate < '" + new Timestamp(d2.getTime()) + "' or closedate is null)";
            } else {
                s2 = s2 + " and orders.closedate >= '" + new Timestamp(d1.getTime()) + "'";
                s2 = s2 + " and orders.closedate < '" + new Timestamp(d2.getTime()) + "'";
            }
        }
        if (!multipleUsersPerOrder && (idUser = (Integer)criteria.get(Constants.WAITER_KEY)) != null) {
            s2 = s2 + " and orders.id_user = " + idUser;
        }
        if ((idOrder = (Integer)criteria.get("id_order_key")) != null) {
            s2 = s2 + " and orders.id = " + idOrder;
        }
        switch (what) {
            case 2: {
                if (tipNota == 1 || tipNota == 3) {
                    s2 = s2 + " and (fiscal='true' or fiscal is null)";
                    break;
                }
                s2 = s2 + " and fiscal='true' ";
                break;
            }
            case 3: {
                s2 = s2 + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        if (criteria.get("Tip plata") != null) {
            tp = (Integer)criteria.get("Tip plata");
            s2 = s2 + " and rest_incasari.id_tip_plata = " + tp;
        }
        if (criteria.get(Constants.LOCATIE_KEY) != null) {
            tp = (Integer)criteria.get(Constants.LOCATIE_KEY);
            s2 = s2 + " and tables.id_locatie = " + tp;
        }
        System.out.println("executing query : " + s2);
        Logger.logDebugVerbose(this, "executing query : " + s2);
        ResultSet rs = SqlUtils.executeQuery(s2, this.connection);
        Vector<Integer> result = new Vector<Integer>();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        return result;
    }

    public Vector<SalesEntry> getSalesReport2(Hashtable criteria, int what, boolean multipleUsersPerOrder) throws SQLException {
        Vector<SalesEntry> result = new Vector<SalesEntry>();
        Object grupare_key = criteria.get(Constants.GRUPARE_KEY);
        ResultSet rs = this.runSalesReport2(criteria, what, multipleUsersPerOrder);
        if (rs != null) {
            while (rs.next()) {
                int idProduct = rs.getInt("p_id");
                int idPromotion = rs.getInt("promo_id");
                double ppu = rs.getDouble("ppu");
                SalesEntry entry = new SalesEntry();
                double q = rs.getDouble("quantity");
                String g = rs.getString("grupare");
                if (g == null) {
                    g = "";
                }
                entry.setQuantity(q);
                entry.setDataOra(g);
                entry.setCategory(rs.getString("c_label"));
                entry.setSubcategory(rs.getString("s_label"));
                String pLabel = rs.getString("p_label");
                entry.setProduct(pLabel);
                entry.setProductCodBare(rs.getString("cod_bare"));
                entry.setCodSync(rs.getString("cod_sync"));
                entry.setPrice(ppu);
                entry.setOriginalPrice(rs.getDouble("ppu_original"));
                entry.setIdProduct(idProduct);
                entry.setIdPromotion(idPromotion);
                entry.setPromotion(rs.getString("promo"));
                entry.setDiscount(rs.getDouble("discount"));
                entry.setCui(rs.getString("cui"));
                entry.setCotaTva(rs.getDouble("cotaTva"));
                if (grupare_key != null && grupare_key.equals("Dupa id sale")) {
                    entry.setIdSale(rs.getInt("grupare"));
                }
                entry.computeTotal();
                result.add(entry);
            }
            rs.close();
        }
        return result;
    }

    public int getNrOrders(Hashtable criteria, int idLocatie) throws SQLException {
        java.util.Date stop;
        String s = "select count(distinct orders.id)  from sales inner join orders on sales.id_order = orders.id inner join tables on orders.id_table = tables.id where (orders.status = 4 or orders.status = 3)";
        java.util.Date start = (java.util.Date)criteria.get(Constants.START_KEY);
        if (start != null) {
            s = s + " and orders.closedate >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (java.util.Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and orders.closedate <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if (idLocatie > 0) {
            s = s + " and tables.id_locatie = " + idLocatie;
        }
        System.out.println("S: " + s);
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        int result = -1;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Vector<SimpleMonetarView> getZMonetar(Hashtable criteria, int what, int idLocatie) throws SQLException {
        java.util.Date stop;
        java.util.Date start;
        String s = "select sum(rest_incasari.suma) as suma, coalesce(tip_plata.name, '') as modPlata, coalesce(tip_plata.document_de_plata, 0) as documentDePlata from orders inner join users on orders.id_user = users.id inner join rest_incasari on orders.id = rest_incasari.id_order inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id inner join tables on orders.id_table = tables.id where (orders.status = 4 or orders.status = 3)";
        Integer waiter = (Integer)criteria.get("user_fo");
        if (waiter != null) {
            s = s + " and users.id = " + waiter;
        }
        if ((start = (java.util.Date)criteria.get(Constants.START_KEY)) != null) {
            s = s + " and orders.closedate >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (java.util.Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and orders.closedate <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if (idLocatie > 0) {
            s = s + " and tables.id_locatie = " + idLocatie;
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        s = s + " group by tip_plata.name, tip_plata.document_de_plata";
        System.out.println("S: " + s);
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<SimpleMonetarView> result = new Vector<SimpleMonetarView>();
        while (rs.next()) {
            SimpleMonetarView nv = new SimpleMonetarView();
            nv.setSuma(rs.getDouble("suma"));
            nv.setTipPlata(rs.getString("modPlata"));
            nv.setDocumentPlata(rs.getInt("documentDePlata") == 1);
            result.add(nv);
        }
        rs.close();
        return result;
    }

    public Vector getMonetar(Hashtable criteria, int what) throws SQLException {
        Client c;
        Table t;
        TipPlata tp;
        java.util.Date stop;
        java.util.Date start;
        User waiter;
        String s = "select users.name as waiter, tables.label || ' ' || locations.name as masa, orders.closedate, orders.opendate, orders.id as id_order, orders.id_client as id_client, tables.id as id_table, sum(rest_incasari.suma) as suma, rest_incasari.dateadd as dataincasarii, coalesce(rest_incasari.comment, '') as detalii, locations.id as id_location, locations.tip as tip_locatie, tip_plata.name as modPlata from orders inner join users on orders.id_user = users.id inner join tables on orders.id_table = tables.id inner join rest_incasari on orders.id = rest_incasari.id_order inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id inner join locations on tables.id_locatie = locations.id where 1 = 1";
        Location location = (Location)criteria.get(Constants.LOCATIE_KEY);
        if (location != null) {
            s = s + " and locations.id = " + location.getId();
        }
        if ((waiter = (User)criteria.get("user_fo")) != null) {
            s = s + " and users.id = " + waiter.getId();
        }
        if ((start = (java.util.Date)criteria.get(Constants.START_KEY)) != null) {
            s = s + " and (rest_incasari.dateadd >= '" + new Timestamp(start.getTime()) + "')";
        }
        if ((stop = (java.util.Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and (rest_incasari.dateadd <= '" + new Timestamp(stop.getTime()) + "')";
        }
        if ((tp = (TipPlata)criteria.get("Tip plata")) != null) {
            s = s + " and tip_plata.id = " + tp.getId();
        }
        if ((t = (Table)criteria.get(Constants.TABLE_KEY)) != null) {
            s = s + " and tables.id = " + t.getId();
        }
        if ((c = (Client)criteria.get(Constants.CLIENT_KEY)) != null) {
            s = s + " and orders.id_client = " + c.getId();
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        s = s + " group by users.name, tables.label, orders.closedate, orders.id, orders.id_client, tables.id, rest_incasari.suma, tip_plata.id, tip_plata.name, locations.id, locations.name, rest_incasari.comment, rest_incasari.dateadd, locations.tip, orders.opendate order by closedate,dataincasarii desc";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<MonetarView> result = new Vector<MonetarView>();
        String lastTable = "";
        Timestamp lastCloseDate = null;
        while (rs.next()) {
            MonetarView nv = new MonetarView();
            String newTable = rs.getString("waiter") + " " + rs.getString("masa");
            int tipLocatie = rs.getInt("tip_locatie");
            Timestamp t1 = rs.getTimestamp("closedate");
            if (tipLocatie == 2) {
                t1 = rs.getTimestamp("dataincasarii");
            }
            if (!lastTable.equalsIgnoreCase(newTable) || !lastCloseDate.equals(t1)) {
                nv.setOspatarMasa(newTable);
                lastTable = newTable;
                lastCloseDate = t1;
                nv.setData(t1);
            }
            nv.setIdOrder(rs.getInt("id_order"));
            nv.setIdClient(rs.getInt("id_client"));
            nv.setSuma(rs.getDouble("suma"));
            nv.setModPlata(rs.getString("modPlata"));
            nv.setDetalii(rs.getString("detalii"));
            result.add(nv);
        }
        rs.close();
        return result;
    }

    private Vector getOrdersForNote(Hashtable criteria, int what, boolean siNoteDeschise) throws SQLException {
        return this.getOrdersForNoteGeneric(criteria, what, siNoteDeschise, false);
    }

    private Vector getOrdersForNoteGeneric(Hashtable criteria, int what, boolean siNoteDeschise, boolean siProcessing) throws SQLException {
        int idPf;
        ClientPersFizica pf;
        Order.TIP_ORDER tipOrder;
        String type2;
        String type1;
        java.util.Date stop;
        java.util.Date start;
        String s = " select orders.id from orders";
        TipPlata tp = (TipPlata)criteria.get("Tip plata");
        if (tp != null) {
            s = s + " inner join rest_incasari on orders.id = rest_incasari.id_order";
        }
        s = s + " where (status = 4 or status = 3";
        if (siNoteDeschise) {
            s = s + " or status = 5 or status = 1";
            if (siProcessing) {
                s = s + " or status = 6";
            }
        }
        s = s + ")";
        User waiter = (User)criteria.get("user_fo");
        if (waiter != null) {
            s = s + " and id_user = " + waiter.getId();
        }
        if ((start = (java.util.Date)criteria.get(Constants.START_KEY)) != null) {
            s = s + " and closedate >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (java.util.Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and closedate <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if ((type1 = (String)criteria.get("Tip protocol")) != null) {
            s = s + " and protocol = '" + type1 + "'";
        }
        if (tp != null) {
            s = s + " and rest_incasari.id_tip_plata = " + tp.getId();
        }
        if (Validators.correctString(type2 = (String)criteria.get(LangRoAll.detalii))) {
            s = s + " and detalii like '%" + type2 + "%'";
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        Table t = (Table)criteria.get(Constants.TABLE_KEY);
        if (t != null) {
            s = s + " and id_table = " + t.getId();
        }
        s = (tipOrder = (Order.TIP_ORDER)((Object)criteria.get("Tip_Order"))) != null ? s + " and orders.tip_order = " + tipOrder.getTip() : s + " and orders.tip_order = " + Order.TIP_ORDER.VANZARE.getTip();
        String clientWhere = "";
        ClientPersJuridica pj = (ClientPersJuridica)criteria.get("client_pj");
        if (pj != null) {
            int idPj = pj.getId();
            pf = (ClientPersFizica)criteria.get("client_pf");
            if (pf != null) {
                idPf = pf.getId();
                clientWhere = " and id_client = " + idPf;
            } else {
                int idPersoanaJuridica = pj.getIdPersJuridica();
                clientWhere = " and  ( id_client in ( select clienti.id from clienti inner join persoane_Fizice on clienti.idPersFizica = persoane_fizice.id where persoane_fizice.id_pers_juridica = " + idPersoanaJuridica + ")" + " or id_client = " + idPj + " )";
            }
        } else {
            pf = (ClientPersFizica)criteria.get("client_pf");
            if (pf != null) {
                idPf = pf.getId();
                clientWhere = " and id_client = " + idPf;
            }
        }
        s = s + clientWhere;
        Integer idOrder = (Integer)criteria.get("id_order_key");
        if (idOrder != null) {
            s = s + " and orders.id = " + idOrder;
        }
        System.out.println("executing query : " + s);
        Logger.logDebugVerbose(this, "executing query : " + s);
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<Integer> result = new Vector<Integer>();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        return result;
    }

    public Vector<NoteView> getNote(Hashtable criteria, boolean siNoteDeschise, int what) throws SQLException {
        if (criteria.get(6) != null) {
            return this.getNoteGeneric(criteria, siNoteDeschise, what, true);
        }
        return this.getNoteGeneric(criteria, siNoteDeschise, what, false);
    }

    public Vector<NoteView> getNoteGeneric(Hashtable criteria, boolean siNoteDeschise, int what, boolean siProcessing) throws SQLException {
        Vector ids = this.getOrdersForNoteGeneric(criteria, what, siNoteDeschise, siProcessing);
        if (ids.size() == 0 || ids.size() > 48000) {
            return new Vector<NoteView>();
        }
        String s = "select users.name as waiter, users.id as waiter_id, sum(sales.quantity_float) as cantitate, sum(sales.quantity_float) * sales.ppu as suma, sum(sales.quantity_float) * sales.discount as discount_suma, tables.label || ' ' || locations.name as masa, products.label as nume_produs, sales.id_product as id_product, sales.mod_preparare, orders.closedate, orders.opendate, orders.id as id_order, orders.id_client as id_client, orders.fiscal as fiscal, tables.id as id_table, locations.id as id_location, orders.detalii as detalii from orders inner join sales on orders.id = sales.id_order inner join products on sales.id_product = products.id inner join users on orders.id_user = users.id inner join tables on orders.id_table = tables.id inner join locations on tables.id_locatie = locations.id";
        String s2 = Utils.getSqlInSequence(ids);
        s = s + " where id_order in " + s2;
        s = s + " group by users.name, users.id, sales.ppu, sales.discount, tables.label, products.label, orders.closedate, orders.opendate, orders.id, orders.id_client, orders.fiscal, tables.id, sales.id_product, locations.id, locations.name,orders.detalii, sales.mod_preparare order by closedate desc";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<NoteView> result = new Vector<NoteView>();
        String lastTable = "";
        Timestamp lastCloseDate = null;
        NoteView currentNota = null;
        while (rs.next()) {
            NoteView nv = new NoteView();
            nv.setCantitate(rs.getDouble("cantitate"));
            int idProduct = rs.getInt("id_product");
            String produs = rs.getString("nume_produs");
            nv.setIdProdus(idProduct);
            nv.setProdus(produs);
            String newTable = rs.getString("waiter") + "," + rs.getString("masa");
            String detalii = rs.getString("detalii");
            Timestamp t1 = rs.getTimestamp("closedate");
            if (t1 == null) {
                t1 = rs.getTimestamp("opendate");
            }
            if (!lastTable.equalsIgnoreCase(newTable) || !lastCloseDate.equals(t1)) {
                nv.setOspatarMasa(newTable);
                nv.setOspatar(rs.getString("waiter"));
                nv.setDetalii(detalii);
                lastTable = newTable;
                lastCloseDate = t1;
                nv.setData(t1);
                currentNota = nv;
            }
            double suma = rs.getDouble("suma");
            nv.setSuma(suma);
            nv.setDiscount(rs.getDouble("discount_suma"));
            nv.setIdOrder(rs.getInt("id_order"));
            nv.setIdTable(rs.getInt("id_table"));
            nv.setIdWaiter(rs.getInt("waiter_id"));
            nv.setIdClient(rs.getInt("id_client"));
            nv.setModPreparare(rs.getString("mod_preparare"));
            boolean fiscal = false;
            String s1 = rs.getString("fiscal");
            if (Validators.correctString(s1) && s1.equalsIgnoreCase("true")) {
                fiscal = true;
            }
            nv.setFiscal(fiscal);
            currentNota.setTotalNota(currentNota.getTotalNota() + suma);
            result.add(nv);
        }
        rs.close();
        return result;
    }

    public Vector getCorrections(Hashtable criteria) throws SQLException {
        Integer type1;
        java.util.Date stop;
        java.util.Date start;
        User superviz;
        String s = "select users.name as waiter, id_supervizor, ppu * quantity as suma, quantity, ppu, product, explanation as explanation, date as date, type from corrections inner join users on corrections.id_waiter = users.id where ( corrections.status = 1 or corrections.status = 3) ";
        User waiter = (User)criteria.get("user_fo");
        if (waiter != null) {
            s = s + " and users.id = " + waiter.getId();
        }
        if ((superviz = (User)criteria.get("user_bo")) != null) {
            s = s + " and corrections.id_supervizor = " + superviz.getId();
        }
        if ((start = (java.util.Date)criteria.get(Constants.START_KEY)) != null) {
            s = s + " and corrections.date >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (java.util.Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and corrections.date <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if ((type1 = (Integer)criteria.get("retur_cancel")) != null) {
            s = s + " and corrections.type = " + type1;
        }
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<CorrectionsEntry> result = new Vector<CorrectionsEntry>();
        while (rs.next()) {
            User supervizor = UsersLogic.getInstance().getUserById(rs.getInt("id_supervizor"));
            CorrectionsEntry entry = new CorrectionsEntry(rs.getString("waiter"), supervizor.getLogin(), rs.getDouble("suma"), rs.getString("explanation"), Formatters.DATE_AND_TIME_FORMAT.format(rs.getTimestamp("date")), rs.getString("product"), rs.getDouble("quantity"), rs.getDouble("ppu"));
            result.add(entry);
        }
        rs.close();
        return result;
    }

    public Collection getProtocol(User u, int idLocatie) throws SQLException {
        String s = "select users.name as username, sum(sales.quantity_float) as cant, products.label as p_label, sales.discount as discount, sales.id_product from sales inner join orders on sales.id_order = orders.id inner join users on orders.id_user = users.id inner join products on sales.id_product = products.id inner JOIN tables ON orders.id_table = tables.id where orders.protocol = 'true' and orders.status = 4";
        if (u != null) {
            s = s + " and orders.id_user = " + u.getId();
        }
        if (idLocatie > 0) {
            s = s + " and tables.id_locatie = " + idLocatie;
        }
        s = s + " group by users.name, id_product, products.label, sales.discount order by user";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<ProtocolEntry> result = new Vector<ProtocolEntry>();
        while (rs.next()) {
            String product = rs.getString("p_label");
            ProtocolEntry entry = new ProtocolEntry(rs.getString("username"), product, rs.getDouble("cant"), rs.getDouble("discount"));
            result.add(entry);
        }
        rs.close();
        return result;
    }

    public Collection getIncasari(int what, int idLocatie) throws SQLException {
        String s = "select users.name as name, sum(sales.ppu * sales.quantity_float) as suma  from users inner join orders on users.id = orders.id_user inner join sales on orders.id = sales.id_order inner JOIN tables ON orders.id_table = tables.id where orders.status = 4";
        if (idLocatie > 0) {
            s = s + " and tables.id_locatie = " + idLocatie;
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        s = s + " group by users.name, orders.fiscal";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<SimpleIncasariEntry> result = new Vector<SimpleIncasariEntry>();
        while (rs.next()) {
            SimpleIncasariEntry entry = new SimpleIncasariEntry(rs.getString("name"), "", rs.getDouble("suma"));
            result.add(entry);
        }
        rs.close();
        return result;
    }

    public Vector getIncasariReport2(Hashtable criteria, int what) throws SQLException {
        Vector<IncasariEntry> result = new Vector<IncasariEntry>();
        String s = "select sum(sales.quantity_float) as quantity, products.id as p_id, products.label as p_label, sales.ppu as ppu, users.login as w_firstname, categories.label as category, sales.id_promotion as promo_id, promotions.label as promo from sales  inner JOIN products on sales.id_product = products.id  inner JOIN orders on sales.id_order = orders.id  inner JOIN users on orders.id_user = users.id  inner JOIN subcategories on products.id_subcategory = subcategories.id inner JOIN categories on subcategories.id_category = categories.id  LEFT outer JOIN promotions on sales.id_promotion = promotions.id  where orders.status = 4";
        if (criteria.get("date") != null) {
            s = s + " and saledate = '" + (String)criteria.get("date") + "'";
        }
        if (criteria.get(LangRoAll.operator) != null) {
            s = s + " and users.login = '" + (String)criteria.get(LangRoAll.operator) + "'";
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        Order.TIP_ORDER tipOrder = (Order.TIP_ORDER)((Object)criteria.get("Tip_Order"));
        s = tipOrder != null ? s + " and orders.tip_order = " + tipOrder.getTip() : s + " and orders.tip_order = " + Order.TIP_ORDER.VANZARE.getTip();
        s = s + " group by products.id, sales.ppu, users.login, categories.label, sales.id_promotion, promotions.label, products.label order by w_firstname, category, p_label";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            int idProduct = rs.getInt("p_id");
            String pLabel = rs.getString("p_label");
            String waiter = rs.getString("w_firstname");
            int idPromotion = rs.getInt("promo_id");
            double newPpu = rs.getDouble("ppu");
            IncasariEntry entry = new IncasariEntry();
            entry.setProduct(pLabel);
            double q = rs.getDouble("quantity");
            entry.setQuantity(q);
            entry.setPpu(newPpu);
            entry.computeTotal();
            entry.setWaiter(waiter);
            entry.setIdProduct(idProduct);
            entry.setCategory(rs.getString("category"));
            entry.setIdPromotion(idPromotion);
            entry.setPromotion(rs.getString("promo"));
            result.add(entry);
        }
        rs.close();
        return result;
    }

    public StringBuffer getOrdersImportStatements() throws SQLException {
        return this.getImportStatements("orders");
    }

    public StringBuffer getSalesImportStatements() throws SQLException {
        return this.getImportStatements("sales");
    }

    private StringBuffer getImportStatements(String tableName) throws SQLException {
        StringBuffer result = new StringBuffer();
        String s = "select * from " + tableName;
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        String[] columnNames = new String[columns];
        for (int i = 1; i <= columns; ++i) {
            columnNames[i - 1] = meta.getColumnName(i);
        }
        StringBuffer colString = this.getColumnNames(columnNames);
        while (rs.next()) {
            result.append("insert into " + tableName + " ( ");
            result.append(colString);
            result.append(" ) values ( ");
            for (int i = 1; i <= columns; ++i) {
                if (columnNames[i - 1].indexOf("date".toUpperCase()) != -1) {
                    result.append('\'');
                }
                result.append(rs.getObject(i));
                if (columnNames[i - 1].indexOf("date".toUpperCase()) != -1) {
                    result.append('\'');
                }
                if (i < columns) {
                    result.append(',');
                }
                result.append(' ');
            }
            result.append(' ');
            result.append(')');
            result.append('\n');
        }
        rs.close();
        return result;
    }

    private StringBuffer getColumnNames(String[] columnNames) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < columnNames.length; ++i) {
            result.append(columnNames[i]);
            result.append(' ');
            if (i >= columnNames.length - 1) continue;
            result.append(',');
        }
        return result;
    }

    public void addDocumentFactura(int factura, Timestamp data, String numar, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        this.addDocumentFactura.setTimestamp(1, data);
        this.addDocumentFactura.setString(2, numar);
        this.addDocumentFactura.setInt(3, factura);
        this.addDocumentFactura.setInt(4, fiscal ? 1 : 0);
        this.addDocumentFactura.setInt(5, comandaType.getIdTip());
        this.addDocumentFactura.execute();
    }

    public void addModificarePret(int idModificarePret, Timestamp data, String numar, boolean fiscal) throws SQLException {
        this.addDocumentModificarePret.setTimestamp(1, data);
        this.addDocumentModificarePret.setString(2, numar);
        this.addDocumentModificarePret.setInt(3, idModificarePret);
        this.addDocumentModificarePret.setInt(4, fiscal ? 1 : 0);
        this.addDocumentModificarePret.execute();
    }

    public void addDocumentOrder(int nir, Timestamp data, String numar, boolean fiscal) throws SQLException {
        this.addDocumentOrder.setTimestamp(1, data);
        this.addDocumentOrder.setString(2, numar);
        this.addDocumentOrder.setInt(3, nir);
        this.addDocumentOrder.setInt(4, fiscal ? 1 : 0);
        this.addDocumentOrder.setInt(5, StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip());
        this.addDocumentOrder.execute();
    }

    public void addDocumentFacturaEmisa(int idFactura, Timestamp data, String numar, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        this.addDocumentFacturaEmisa.setTimestamp(1, data);
        this.addDocumentFacturaEmisa.setString(2, numar);
        this.addDocumentFacturaEmisa.setInt(3, idFactura);
        this.addDocumentFacturaEmisa.setInt(4, fiscal ? 1 : 0);
        this.addDocumentFacturaEmisa.setInt(5, comandaType.getIdTip());
        this.addDocumentFacturaEmisa.execute();
    }

    public void addDocumentConsum(int nir, Timestamp data, String numar, boolean fiscal) throws SQLException {
        this.addDocumentConsum.setTimestamp(1, data);
        this.addDocumentConsum.setString(2, numar);
        this.addDocumentConsum.setInt(3, nir);
        this.addDocumentConsum.setInt(4, fiscal ? 1 : 0);
        this.addDocumentConsum.execute();
    }

    public void addDocumentCorectie(int nir, Timestamp data, String numar, boolean fiscal) throws SQLException {
        this.addDocumentCorectie.setTimestamp(1, data);
        this.addDocumentCorectie.setString(2, numar);
        this.addDocumentCorectie.setInt(3, nir);
        this.addDocumentCorectie.setInt(4, fiscal ? 1 : 0);
        this.addDocumentCorectie.execute();
    }

    public void addDocumentAlterarePret(int id, Timestamp data, String numar) throws SQLException {
        this.addDocumentAlterarePret.setTimestamp(1, data);
        this.addDocumentAlterarePret.setString(2, numar);
        this.addDocumentAlterarePret.setInt(3, id);
        this.addDocumentAlterarePret.execute();
    }

    public void addDocumentTransfer(int nir, Timestamp data, String numar) throws SQLException {
        this.addDocumentTransfer.setTimestamp(1, data);
        this.addDocumentTransfer.setString(2, numar);
        this.addDocumentTransfer.setInt(3, nir);
        this.addDocumentTransfer.execute();
    }

    public void updateDocument(int idDocument, Timestamp data, String numeDocument, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        this.updateDocument.setTimestamp(1, data);
        this.updateDocument.setString(2, numeDocument);
        this.updateDocument.setInt(3, fiscal ? 1 : 0);
        this.updateDocument.setInt(4, comandaType.getIdTip());
        this.updateDocument.setInt(5, idDocument);
        this.updateDocument.execute();
    }

    public void addDocumentFabricare(int nir, Timestamp data, String numar) throws SQLException {
        this.addDocumentFabricare.setTimestamp(1, data);
        this.addDocumentFabricare.setString(2, numar);
        this.addDocumentFabricare.setInt(3, nir);
        this.addDocumentFabricare.execute();
    }

    public void setDocumenteUlterioareNeprocesate(Timestamp time) throws SQLException {
        this.setStatusAfterTimestamp.setInt(1, 1);
        this.setStatusAfterTimestamp.setTimestamp(2, time);
        this.setStatusAfterTimestamp.execute();
    }

    public int[] getStatusForDocumentAndTip(int tipDocument, int value) throws SQLException {
        String key = "";
        switch (tipDocument) {
            case 2: {
                key = "id_factura";
                break;
            }
            case 3: 
            case 13: {
                key = "id_order";
                break;
            }
            case 7: {
                key = "id_transfer";
                break;
            }
            case 4: {
                key = "id_consum";
                break;
            }
            case 9: {
                key = "id_corectie";
                break;
            }
            case 5: {
                key = "id_fabricare";
                break;
            }
            case 8: {
                key = "id_factura_emisa";
                break;
            }
            case 6: {
                key = "id_modif_pret";
                break;
            }
            default: {
                key = "";
            }
        }
        String s = "select status, id from documente where " + key + " = " + value;
        int[] result = new int[]{1, -1};
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        if (rs.next()) {
            result[0] = rs.getInt("status");
            result[1] = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public Vector<ClientiPeZileBean> getClientiPeZileReport(Hashtable criteria) throws SQLException {
        java.util.Date start = (java.util.Date)criteria.get(Constants.START_KEY);
        java.util.Date stop = (java.util.Date)criteria.get(Constants.STOP_KEY);
        String grupare = (String)criteria.get(LangRoAll.grupare);
        String toInsertIntoQuery = "date(saledate), ";
        boolean groupAll = true;
        if (grupare != null && grupare.equals("Dupa client")) {
            toInsertIntoQuery = "";
            groupAll = false;
        }
        String s = "select " + toInsertIntoQuery + "promotii_clienti.card, persoane_fizice.nume, clienti.id as id_client, " + "count(DISTINCT orders.id) as nr_mese, sum(quantity_float*ppu) as plata_client, sum(quantity_float*discount) as discount from orders " + "inner join sales on sales.id_order = orders.id " + "inner join clienti on orders.id_client = clienti.id " + "inner join persoane_fizice on clienti.idpersfizica = persoane_fizice.id " + "inner join promotii_clienti on clienti.id = promotii_clienti.id_client " + "where orders.closedate is not null " + " and orders.closedate >= '" + new Timestamp(start.getTime()) + "'" + " and orders.closedate <= '" + new Timestamp(stop.getTime()) + "'";
        Object promoO = criteria.get(LangRoAll.promotie);
        if (promoO != null) {
            Promotion p = (Promotion)promoO;
            s = s + " and sales.id_promotion = " + p.getId();
        }
        s = s + " group by " + toInsertIntoQuery + " promotii_clienti.card, persoane_fizice.nume, clienti.id";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<ClientiPeZileBean> result = new Vector<ClientiPeZileBean>();
        while (rs.next()) {
            ClientiPeZileBean toAdd = new ClientiPeZileBean();
            toAdd.setCard(rs.getString("card"));
            if (groupAll) {
                toAdd.setData(rs.getDate("date"));
            }
            toAdd.setClient(rs.getString("nume"));
            toAdd.setDiscount(rs.getDouble("discount"));
            toAdd.setPlatit(rs.getDouble("plata_client"));
            toAdd.setNrComenzi(rs.getInt("nr_mese"));
            toAdd.setIdClient(rs.getInt("id_client"));
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<IncasareClientView> getIncasariClienti(Hashtable criteria, int what) throws SQLException {
        ClientPersFizica pf;
        int idPf = -1;
        int idPj = -1;
        java.util.Date start = (java.util.Date)criteria.get(Constants.START_KEY);
        java.util.Date stop = (java.util.Date)criteria.get(Constants.STOP_KEY);
        String s = "select sum(sales.quantity_float * sales.ppu) as total, sum(sales.quantity_float * sales.discount) as discount, orders.closedate, orders.id as id_order, orders.id_client from orders inner join sales on orders.id = sales.id_order where (orders.status = 4 or orders.status = 3)";
        String clientWhere = "";
        ClientPersJuridica pj = (ClientPersJuridica)criteria.get("client_pj");
        if (pj != null) {
            idPj = pj.getId();
            pf = (ClientPersFizica)criteria.get("client_pf");
            if (pf != null) {
                idPf = pf.getId();
                clientWhere = " and id_client = " + idPf;
            } else {
                clientWhere = " and ( id_client in ( select clienti.id from clienti inner join persoane_Fizice on clienti.idPersFizica = persoane_fizice.id where id_pers_juridica = " + idPj + ")" + " or id_client = " + idPj + ")";
            }
        } else {
            pf = (ClientPersFizica)criteria.get("client_pf");
            if (pf != null) {
                idPf = pf.getId();
                clientWhere = " and id_client = " + idPf;
            }
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        Order.TIP_ORDER tipOrder = (Order.TIP_ORDER)((Object)criteria.get("Tip_Order"));
        s = tipOrder != null ? s + " and orders.tip_order = " + tipOrder.getTip() : s + " and orders.tip_order = " + Order.TIP_ORDER.VANZARE.getTip();
        s = s + clientWhere + " and orders.closedate >= '" + new Timestamp(start.getTime()) + "'" + " and orders.closedate <= '" + new Timestamp(stop.getTime()) + "'" + " group by orders.closedate, orders.id, orders.id_client" + " order by id_client, closedate desc";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<IncasareClientView> result = new Vector<IncasareClientView>();
        while (rs.next()) {
            IncasareClientView v = new IncasareClientView();
            Timestamp t1 = rs.getTimestamp("closedate");
            v.setData(Formatters.DATE_AND_TIME_FORMAT.format(t1));
            v.setTotal(rs.getDouble("total"));
            v.setDiscount(rs.getDouble("discount"));
            v.setIdOrder(rs.getInt("id_order"));
            int idClient = rs.getInt("id_client");
            v.setIdClient(idClient);
            Client c = ClientLogic.getInstance().getClientById(idClient);
            if (c != null) {
                String cName = c.toString();
                v.setClient(cName);
            } else {
                v.setClient("Anonim");
            }
            result.add(v);
        }
        rs.close();
        return result;
    }

    public Vector getVanzariPeZile(Timestamp start, Timestamp stop) throws SQLException {
        Vector<VanzariPeZileEntry> result = new Vector<VanzariPeZileEntry>();
        String s = "select  sum(sales.ppu * sales.quantity_float) as total, date(sales.saledate) as zi, categories.label as sectie from categories inner join subcategories on categories.id = subcategories.id_category inner join products on subcategories.id = products.id_subcategory left outer join sales on products.id = sales.id_product where saledate >= '" + start + "' and saledate < '" + stop + "'" + " group by date(sales.saledate), categories.label" + " order by zi ";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Date oldDay = null;
        VanzariPeZileEntry vze = null;
        double total = 0.0;
        while (rs.next()) {
            Date currentDay = rs.getDate("zi");
            if (!currentDay.equals(oldDay)) {
                oldDay = currentDay;
                if (vze != null) {
                    vze.setTotal(total);
                }
                total = 0.0;
                vze = new VanzariPeZileEntry();
                vze.setData(Formatters.DATE_FORMAT_RO.format(currentDay));
                total += rs.getDouble("total");
                vze.getTotalPeSectii().add(rs.getDouble("total"));
                result.add(vze);
                continue;
            }
            vze.getTotalPeSectii().add(rs.getDouble("total"));
            total += rs.getDouble("total");
        }
        if (vze != null) {
            vze.setTotal(total);
        }
        rs.close();
        return result;
    }

    public void deleteAllDocumentsNF(Connection conn) throws SQLException {
        String s = "delete from documente where id_order in ( select id from orders where (fiscal is null or fiscal = 'false') and (orders.status = 3 or orders.status = 4) ) ";
        SqlUtils.executeUpdate(s, conn);
    }

    public void deleteOrdersByOrdersIds(Connection conn, Vector<Integer> ids) throws SQLException {
        String s = "delete from documente where id_order in " + Utils.getSqlInSequence(ids);
        SqlUtils.executeUpdate(s, conn);
        s = "delete from sales where id_order in " + Utils.getSqlInSequence(ids);
        SqlUtils.executeUpdate(s, conn);
        s = "delete from rest_incasari where id_order in " + Utils.getSqlInSequence(ids);
        SqlUtils.executeUpdate(s, conn);
        s = "delete from orders where id in " + Utils.getSqlInSequence(ids);
        SqlUtils.executeUpdate(s, conn);
    }

    public void deleteRestIncasariByOrdersIds(Connection conn, Vector<Integer> ids) throws SQLException {
    }

    public void replaceIngredient(Connection conn, int idTarget, String inSource) throws SQLException {
        String s = "update recipes set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update preparate set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update bonuri_consum_items set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update corectii_items set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update faptic set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update transfer_items set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update factura_entries set id_ingredient = " + idTarget + " where id_ingredient in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update modificari_pret set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "update sales set id_product = (select id_product from produse_finite where id_stock = " + idTarget + " and status = " + 1 + ")" + " where" + " id_product in (select id_product from produse_finite where id_stock in " + inSource + " )";
        SqlUtils.executeUpdate(s, conn);
        s = "update products set status = 100 where id in ( select id_product from produse_finite where id_stock in " + inSource + " )";
        SqlUtils.executeUpdate(s, conn);
        s = "delete from produse_finite where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "delete from products where status = 100";
        SqlUtils.executeUpdate(s, conn);
        s = "update fisa_magazie set id_stock = " + idTarget + " where id_stock in " + inSource;
        SqlUtils.executeUpdate(s, conn);
        s = "delete from stocks where id in " + inSource;
        SqlUtils.executeUpdate(s, conn);
    }

    public Vector<Integer> getOrdersForTipPlataCont(int idClient, Connection conn) throws SQLException {
        Vector<Integer> idTipContCLient = new Vector<Integer>();
        Vector<TipCont> conturi = ClientLogic.getInstance().getAllConturiNoCommit();
        for (TipCont tipCont : conturi) {
            idTipContCLient.add(tipCont.getId());
        }
        Vector<Integer> result = new Vector<Integer>();
        String s = "select orders.id from orders inner join rest_incasari on rest_incasari.id_order = orders.id inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id where orders.id_client = " + idClient + " and tip_plata.tip_cont in " + Utils.getSqlInSequence(idTipContCLient);
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public Vector<OptiuneProduseMeniu> getAllOptiuniProduse() throws SQLException {
        Vector<OptiuneProduseMeniu> result = new Vector<OptiuneProduseMeniu>();
        ResultSet rs = this.getAllOptiuniProduse.executeQuery();
        while (rs.next()) {
            OptiuneProduseMeniu op = new OptiuneProduseMeniu();
            op.setIdProduct(rs.getInt("id_product"));
            op.setIdOptiune(rs.getInt("id_optiune"));
            op.setIdMeniu(rs.getInt("id_meniu"));
            op.setPret(rs.getDouble("pret"));
            op.setCantitate(rs.getDouble("cantitate"));
            op.setIdSubcategory(rs.getInt("id_subcategory"));
            result.add(op);
        }
        return result;
    }

    public int getIdMeniuFromLabel(String label) throws SQLException {
        int result = -1;
        this.getIdMeniuFromLabel.setString(1, label);
        ResultSet rs = this.getIdMeniuFromLabel.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        return result;
    }

    public int getIdOptiuneFromLabel(String label) throws SQLException {
        int result = -1;
        this.getIdOptiuneFromLabel.setString(1, label);
        ResultSet rs = this.getIdOptiuneFromLabel.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        return result;
    }

    public void deleteAllOptiuniProduse(int idMeniu) throws SQLException {
        this.deleteAllOptiuniProduse.setInt(1, idMeniu);
        this.deleteAllOptiuniProduse.setInt(2, idMeniu);
        this.deleteAllOptiuniProduse.execute();
    }

    public int getIdMeniuFromCodsync(String codsync) throws SQLException {
        int result = -1;
        this.getIdMeniuFromCodsync.setString(1, codsync);
        ResultSet rs = this.getIdMeniuFromCodsync.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        return result;
    }

    public void setCodsyncForMeniu(int idMeniu, String codsync) throws SQLException {
        this.setCodsyncForMeniu.setString(1, codsync);
        this.setCodsyncForMeniu.setInt(2, idMeniu);
        this.setCodsyncForMeniu.execute();
    }

    public Vector<RaportPeCategoriiSiCoteTva> getRaportPeCategoriiSiCoteTva(Vector<Integer> idCategorii, Timestamp start, Timestamp stop) throws SQLException {
        Vector<RaportPeCategoriiSiCoteTva> result = new Vector<RaportPeCategoriiSiCoteTva>();
        if (idCategorii.size() <= 0) {
            return result;
        }
        String s = "select sum(quantity_float*ppu) as total_brut, tva.cota, subcategories.label from sales inner join products on sales.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id inner join tva on subcategories.id_Tva = tva.id  where subcategories.id in " + Utils.getSqlInSequence(idCategorii) + " and saledate >= '" + start + "' and saledate <= '" + stop + "'" + " group by tva.cota, subcategories.label ";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            RaportPeCategoriiSiCoteTva toAdd = new RaportPeCategoriiSiCoteTva();
            toAdd.setTotalBrut(rs.getDouble("total_brut"));
            toAdd.setCotaTva(rs.getDouble("cota"));
            toAdd.setCategorie(rs.getString("label"));
            toAdd.compute();
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<ArticolBean> getArticole(Hashtable criteria) throws SQLException {
        Vector<ArticolBean> result = new Vector<ArticolBean>();
        String selectMare = "";
        boolean first = true;
        Vector<ArticolBean.ARTICOL_TYPE> types = (Vector<ArticolBean.ARTICOL_TYPE>)criteria.get("tip_produs_key");
        Vector cats = (Vector)criteria.get("Categorie");
        Vector sectii = (Vector)criteria.get(Constants.SECTIE_KEY);
        ArticolBean articolBean = (ArticolBean)criteria.get("Articol");
        Vector tvas = (Vector)criteria.get("TVA");
        Vector tags = (Vector)criteria.get("");
        String catsInSql = UtilsNoarch.getSqlInSequenceForIdFields(cats);
        String sectiiInSql = UtilsNoarch.getSqlInSequenceForIdFields(sectii);
        String tvaInSql = UtilsNoarch.getSqlInSequenceForIdFields(tvas);
        String tagInSql = UtilsNoarch.getSqlInSequenceForIdFields(tags);
        if (types == null) {
            types = new Vector<ArticolBean.ARTICOL_TYPE>();
            types.add(ArticolBean.ARTICOL_TYPE.TOATE);
        } else if (types.contains((Object)ArticolBean.ARTICOL_TYPE.TOATE)) {
            types.clear();
            types.add(ArticolBean.ARTICOL_TYPE.TOATE);
        }
        for (ArticolBean.ARTICOL_TYPE type : types) {
            String selectCurrent1 = "";
            String selectCurrent2 = "";
            String selectCurrent3 = "";
            if (type == ArticolBean.ARTICOL_TYPE.RETETA_SAU_SERVICIU || type == ArticolBean.ARTICOL_TYPE.TOATE) {
                selectCurrent1 = "select subcategories.id_category as id_sectie_,  products.id as id_produs_, subcategories.id as id_categorie_, -1 as id_stock_, products.label as nume_, categories.label as sectie_, subcategories.label as categorie_, produse_reteta.sell_price as pret_vz_, tva.cota as cotatva_, produse_reteta.productie as productie_, products.uz_intern as uzintern_, '" + ArticolBean.ARTICOL_TYPE.RETETA_SAU_SERVICIU.name() + "' as type_," + " '-' as taguri_" + " from produse_Reteta " + " inner join products on produse_reteta.id_product = products.id" + " inner join subcategories on products.id_subcategory = subcategories.id" + " inner join categories on subcategories.id_category = categories.id" + " inner join tva on subcategories.id_tva = tva.id" + " where 1=1 and products.status = " + 1;
                if (articolBean != null) {
                    selectCurrent1 = selectCurrent1 + " and products.id = " + articolBean.getIdProdus();
                } else {
                    if (catsInSql.length() >= 3) {
                        selectCurrent1 = selectCurrent1 + " and subcategories.id in " + catsInSql;
                    }
                    if (sectiiInSql.length() >= 3) {
                        selectCurrent1 = selectCurrent1 + " and categories.id in " + sectiiInSql;
                    }
                    if (tvaInSql.length() >= 3) {
                        selectCurrent1 = selectCurrent1 + " and tva.id in " + tvaInSql;
                    }
                }
            }
            if (type == ArticolBean.ARTICOL_TYPE.MARFA || type == ArticolBean.ARTICOL_TYPE.TOATE) {
                selectCurrent2 = "select subcategories.id_category as id_sectie_,  products.id as id_produs_, subcategories.id as id_categorie_, stocks.id as id_stock_, products.label as nume_, categories.label as sectie_, subcategories.label as categorie_, stocks.sell_price as pret_vz_, tva.cota as cotatva_, -1 as productie_, products.uz_intern as uzintern_, '" + ArticolBean.ARTICOL_TYPE.MARFA.name() + "' as type_," + " string_agg(tags.label, ', ' order by tags.label) as taguri_" + " from produse_finite " + " inner join stocks on produse_finite.id_stock = stocks.id" + " inner join products on produse_finite.id_product = products.id" + " inner join subcategories on products.id_subcategory = subcategories.id" + " inner join categories on subcategories.id_category = categories.id" + " inner join tva on subcategories.id_tva = tva.id" + " left outer join stocks_tags on (stocks.id = stocks_tags.id_stock )" + " left outer join tags on stocks_Tags.id_tag = tags.id" + " where 1=1 and stocks.status = " + 1;
                if (articolBean != null) {
                    selectCurrent2 = selectCurrent2 + " and products.id = " + articolBean.getIdProdus();
                } else {
                    if (catsInSql.length() >= 3) {
                        selectCurrent2 = selectCurrent2 + " and subcategories.id in " + catsInSql;
                    }
                    if (sectiiInSql.length() >= 3) {
                        selectCurrent2 = selectCurrent2 + " and categories.id in " + sectiiInSql;
                    }
                    if (tvaInSql.length() >= 3) {
                        selectCurrent2 = selectCurrent2 + " and tva.id in " + tvaInSql;
                    }
                    if (tagInSql.length() >= 3) {
                        selectCurrent2 = selectCurrent2 + " and stocks_tags.id_tag in " + tagInSql;
                    }
                }
                selectCurrent2 = selectCurrent2 + " group by subcategories.id_category ,  products.id , subcategories.id, stocks.id , products.label , categories.label , subcategories.label , stocks.sell_price , tva.cota , products.uz_intern ";
            }
            if (type == ArticolBean.ARTICOL_TYPE.MATERIE_PRIMA || type == ArticolBean.ARTICOL_TYPE.TOATE) {
                selectCurrent3 = "select -1 as id_sectie_,  -1 id_produs_, -1 as id_categorie_, stocks.id as id_stock_, stocks.label as nume_, 'N/A' as sectie_, 'N/A' as categorie_, -1 as pret_vz_, -1 as cotatva_, -1 as productie_, 0 as uzintern_, '" + ArticolBean.ARTICOL_TYPE.MATERIE_PRIMA.name() + "' as type_," + " string_agg(tags.label, ', ' order by tags.label) as taguri_" + " from stocks " + " left outer join stocks_tags on stocks.id = stocks_tags.id_stock" + " left outer join tags on stocks_Tags.id_tag = tags.id" + " where 1=1 and stocks.status = " + 1 + " and stocks.id not in (select id_stock from produse_finite) ";
                if (articolBean != null) {
                    selectCurrent3 = selectCurrent3 + " and stocks.id = " + articolBean.getIdStock();
                } else if (tagInSql.length() >= 3) {
                    selectCurrent3 = selectCurrent3 + " and stocks_tags.id_tag in " + tagInSql;
                }
                selectCurrent3 = selectCurrent3 + " group by stocks.id , stocks.label ";
            }
            String currentInterSql = "";
            if (selectCurrent1.length() > 0) {
                currentInterSql = currentInterSql + (!first ? " UNION " : "") + selectCurrent1;
                if (first) {
                    first = false;
                }
            }
            if (selectCurrent2.length() > 0) {
                currentInterSql = currentInterSql + (!first ? " UNION " : "") + selectCurrent2;
                if (first) {
                    first = false;
                }
            }
            if (selectCurrent3.length() > 0) {
                currentInterSql = currentInterSql + (!first ? " UNION " : "") + selectCurrent3;
                if (first) {
                    first = false;
                }
            }
            selectMare = selectMare + currentInterSql;
        }
        selectMare = selectMare + " order by sectie_, categorie_, nume_";
        ResultSet rs = SqlUtils.executeQuery(selectMare, this.connection);
        while (rs.next()) {
            ArticolBean add = new ArticolBean();
            add.setIdSectie(rs.getInt("id_sectie_"));
            add.setIdProdus(rs.getInt("id_produs_"));
            add.setIdCategorie(rs.getInt("id_categorie_"));
            add.setIdStock(rs.getInt("id_stock_"));
            add.setNume(rs.getString("nume_"));
            add.setSectie(rs.getString("sectie_"));
            add.setCategorie(rs.getString("categorie_"));
            add.setPretVanzare(rs.getDouble("pret_vz_"));
            add.setCotaTva(rs.getDouble("cotatva_"));
            add.setProductie(rs.getInt("productie_") > 0);
            add.setUzIntern(rs.getInt("uzintern_") > 0);
            add.setType(ArticolBean.ARTICOL_TYPE.valueOf(rs.getString("type_")));
            result.add(add);
        }
        rs.close();
        return result;
    }
}

