/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import ro.atreides.restaurant.base.Correction;
import ro.atreides.utils.db.DaoInterface;

public class CorrectionsImpl
implements DaoInterface {
    private PreparedStatement addCorrection;
    private PreparedStatement processCorrection;
    private PreparedStatement deleteAll;
    private Connection conn;

    public CorrectionsImpl(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addCorrection = this.conn.prepareStatement("insert into corrections ( id_waiter, id_supervizor, product, ppu, explanation, status, quantity ) values ( ?, ?, ?, ?, ?, 1, ?)");
        this.processCorrection = this.conn.prepareStatement("update corrections set status = 3 where status = 1");
        this.deleteAll = this.conn.prepareStatement("delete from corrections");
    }

    public void addCorrection(Correction corr) throws SQLException {
        this.addCorrection.setInt(1, corr.getIdWaiter());
        this.addCorrection.setInt(2, corr.getIdUser());
        this.addCorrection.setString(3, corr.getProduct());
        this.addCorrection.setDouble(4, corr.getPpu());
        this.addCorrection.setString(5, corr.getExplanation());
        this.addCorrection.setDouble(6, corr.getQuantity());
        this.addCorrection.execute();
    }

    public void processCorrections() throws SQLException {
        this.processCorrection.execute();
    }

    public void deleteCorrectionsIntreDate(Timestamp start, Timestamp stop) throws SQLException {
    }

    public void deleteCorrections() throws SQLException {
        this.deleteAll.execute();
    }
}

