/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.restaurant.gui.festive.FestiveDate;
import ro.atreides.restaurant.gui.festive.FestiveEntry;
import ro.atreides.restaurant.gui.festive.Servire;
import ro.atreides.utils.db.DaoInterface;

public class FestiveDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addFestive;
    private PreparedStatement addFestivePret;
    private PreparedStatement addFestiveIntrari;
    private PreparedStatement getFestiveFeluri;
    private PreparedStatement updateFestive;
    private PreparedStatement updateFestiveDatePret;
    private PreparedStatement updateFestiveIntrari;
    private PreparedStatement deleteFromFestiveDate;
    private PreparedStatement getFestive;
    private PreparedStatement getTabel1Beans;
    private PreparedStatement deleteFromFestiveIntrari;
    private PreparedStatement getFestiveDate;
    private PreparedStatement updateFestiveDateQuantity;

    public FestiveDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addFestive = this.connection.prepareStatement("insert into festive (id_client, eventdate, total, profit, aprovizionare) values ( ?, ?, ?, ?, ? ) ");
        this.addFestivePret = this.connection.prepareStatement("insert into festive_date (id_festive, id_product, pret_festiv ) values ( ?, ?, ? ) ");
        this.addFestiveIntrari = this.connection.prepareStatement("insert into festive_intrari ( id_fel, id_date, cantitate ) values ( ?, ?, ? ) ");
        this.updateFestive = this.connection.prepareStatement("update festive set id_client = ?, eventdate = ?, total = ?, profit = ?, aprovizionare = ? where id = ?");
        this.updateFestiveDatePret = this.connection.prepareStatement("update festive_date set pret_festiv = ? where id = ?");
        this.updateFestiveIntrari = this.connection.prepareStatement("update festive_intrari set cantitate = ? where id = ?");
        this.deleteFromFestiveDate = this.connection.prepareStatement("delete from festive_date where id = ?");
        this.getFestiveFeluri = this.connection.prepareStatement("select * from festive_feluri");
        this.getFestive = this.connection.prepareStatement("select festive.* from festive where (id_client = ? or ? = -1) and eventdate >= ? and eventdate < ?");
        this.getTabel1Beans = this.connection.prepareStatement("select festive_intrari.cantitate from festive_date inner join festive_intrari on festive_date.id = festive_intrari.id_date where id_product = ? and id_festive = ? and id_fel = ?");
        this.deleteFromFestiveIntrari = this.connection.prepareStatement("delete from festive_intrari where id_date = ? and id_fel = ?");
        this.getFestiveDate = this.connection.prepareStatement("select * from festive_date where id_product = ? and id_festive = ?");
        this.updateFestiveDatePret = this.connection.prepareStatement("update festive_date set pret_festiv = ? where id = ?");
        this.updateFestiveDateQuantity = this.connection.prepareStatement("update festive_date set cant_efectiva = ? where id = ?");
    }

    public void updateFestiveQuantity(int id, double newQ) throws SQLException {
        this.updateFestiveDateQuantity.setDouble(1, newQ);
        this.updateFestiveDateQuantity.setInt(2, id);
        this.updateFestiveDateQuantity.execute();
    }

    public void updateFestiveDate(int id, double newPrice) throws SQLException {
        this.updateFestiveDatePret.setDouble(1, newPrice);
        this.updateFestiveDatePret.setInt(2, id);
        this.updateFestiveDatePret.execute();
    }

    public FestiveDate getFestiveDate(int idProduct, int idEvent) throws SQLException {
        FestiveDate result = null;
        this.getFestiveDate.setInt(1, idProduct);
        this.getFestiveDate.setInt(2, idEvent);
        ResultSet rs = this.getFestiveDate.executeQuery();
        if (rs.next()) {
            result = new FestiveDate();
            result.setId(rs.getInt("id"));
            result.setIdFestive(rs.getInt("id_festive"));
            result.setIdProdus(rs.getInt("id_product"));
            result.setPret(rs.getDouble("pret_festiv"));
            result.setCantEfectiva(rs.getDouble("cant_efectiva"));
        }
        rs.close();
        return result;
    }

    public void deleteFestiveIntrare(int idDate, int idFel) throws SQLException {
        this.deleteFromFestiveIntrari.setInt(1, idDate);
        this.deleteFromFestiveIntrari.setInt(2, idFel);
        this.deleteFromFestiveIntrari.execute();
    }

    public double getTabel1Beans(int idProduct, int idEvent, int idFel) throws SQLException {
        double result = 0.0;
        this.getTabel1Beans.setInt(1, idProduct);
        this.getTabel1Beans.setInt(2, idEvent);
        this.getTabel1Beans.setInt(3, idFel);
        ResultSet rs = this.getTabel1Beans.executeQuery();
        if (rs.next()) {
            result = rs.getDouble("cantitate");
        }
        rs.close();
        return result;
    }

    public Vector getFestive(int clientId, Timestamp start, Timestamp stop) throws SQLException {
        Vector<FestiveEntry> result = new Vector<FestiveEntry>();
        this.getFestive.setInt(1, clientId);
        this.getFestive.setInt(2, clientId);
        this.getFestive.setTimestamp(3, start);
        this.getFestive.setTimestamp(4, stop);
        ResultSet rs = this.getFestive.executeQuery();
        while (rs.next()) {
            FestiveEntry fe = new FestiveEntry();
            fe.setCost(rs.getDouble("aprovizionare"));
            fe.setData(rs.getTimestamp("eventdate"));
            fe.setProfit(rs.getDouble("profit"));
            fe.setTotal(rs.getDouble("total"));
            fe.setIdClient(rs.getInt("id_client"));
            fe.setIdEvent(rs.getInt("id"));
            result.add(fe);
        }
        rs.close();
        return result;
    }

    public void addFestive(int idClient, Timestamp eventDate, double total, double profit, double aprovizionare) throws SQLException {
        this.addFestive.setInt(1, idClient);
        this.addFestive.setTimestamp(2, eventDate);
        this.addFestive.setDouble(3, total);
        this.addFestive.setDouble(4, profit);
        this.addFestive.setDouble(5, aprovizionare);
        this.addFestive.execute();
    }

    public void addFestiveDate(int idFestive, int idProduct, double pretFestiv) throws SQLException {
        this.addFestivePret.setInt(1, idFestive);
        this.addFestivePret.setInt(2, idProduct);
        this.addFestivePret.setDouble(3, pretFestiv);
        this.addFestivePret.execute();
    }

    public void addFestiveIntrari(int idFel, double cantitate, int idFestiveDate) throws SQLException {
        this.addFestiveIntrari.setInt(1, idFel);
        this.addFestiveIntrari.setInt(2, idFestiveDate);
        this.addFestiveIntrari.setDouble(3, cantitate);
        this.addFestiveIntrari.execute();
    }

    public Vector getFeluri() throws SQLException {
        Vector<Servire> result = new Vector<Servire>();
        ResultSet rs = this.getFestiveFeluri.executeQuery();
        while (rs.next()) {
            Servire s = new Servire();
            s.setLabel(rs.getString("label"));
            s.setId(rs.getInt("id"));
            result.add(s);
        }
        rs.close();
        return result;
    }
}

