/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import ro.atreides.utils.Location;
import ro.atreides.utils.db.DaoInterface;

public class LocationsImpl
implements DaoInterface {
    private PreparedStatement selectAll;
    private PreparedStatement update;
    private PreparedStatement add;
    private PreparedStatement getById;
    private PreparedStatement getByName;
    private PreparedStatement getByCod;
    private Connection connection;

    public LocationsImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.selectAll = this.connection.prepareStatement("select * from locations where status = 1 and (tip = ? or ? = -1)");
        this.update = this.connection.prepareStatement("update locations set name = ? where id= ?");
        this.add = this.connection.prepareStatement("insert into locations (name, tip, status, cod) values ( ? , ? , 1, ? )");
        this.getById = this.connection.prepareStatement("select * from locations where id = ?");
        this.getByName = this.connection.prepareStatement("select * from locations where name = ?");
        this.getByCod = this.connection.prepareStatement("select * from locations where cod = ?");
    }

    public void add(Location user) throws SQLException {
        this.add.setString(1, user.getName());
        this.add.setInt(2, user.getTip());
        this.add.setString(3, user.getCod());
        this.add.execute();
    }

    private Location getLocationFromResultSet(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        String name = rs.getString("name");
        String cod = rs.getString("cod");
        int tip = rs.getInt("tip");
        boolean allowHH = rs.getInt("allow_happyhour") == 1;
        boolean active = rs.getInt("status") == 1;
        Location result = new Location(id, name, tip, allowHH, cod, active);
        return result;
    }

    public void update(String newName, int id) throws SQLException {
        this.update.setString(1, newName);
        this.update.setInt(2, id);
        this.update.execute();
    }

    public Collection getAll(int tip) throws SQLException {
        Vector<Location> result = new Vector<Location>();
        this.selectAll.setInt(1, tip);
        this.selectAll.setInt(2, tip);
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            Location u = this.getLocationFromResultSet(rs);
            result.add(u);
        }
        rs.close();
        return result;
    }

    public Location getLocationById(int id) throws SQLException {
        Location result = null;
        this.getById.setInt(1, id);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            result = this.getLocationFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Location getLocationByName(String name) throws SQLException {
        Location result = null;
        this.getByName.setString(1, name);
        ResultSet rs = this.getByName.executeQuery();
        if (rs.next()) {
            result = this.getLocationFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Location getLocationByCod(String cod) throws SQLException {
        Location result = null;
        this.getByCod.setString(1, cod);
        ResultSet rs = this.getByCod.executeQuery();
        if (rs.next()) {
            result = this.getLocationFromResultSet(rs);
        }
        rs.close();
        return result;
    }
}

