/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.restaurant.base.BonFiscalNumber;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.SearchSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.users.User;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.plati.TipPlataValue;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.users.db.UsersImpl;

public class OrdersImpl
implements DaoInterface {
    private PreparedStatement selectOrdersByStatus;
    private PreparedStatement selectOrdersByStatusAndTime;
    private PreparedStatement selectOrdersById;
    private PreparedStatement selectOpenOrders;
    private PreparedStatement selectOpenOrderAtTable;
    private PreparedStatement selectOpenOrderByUser;
    private PreparedStatement addOrder;
    private PreparedStatement deleteOrder;
    private PreparedStatement closeOrder;
    private PreparedStatement laPlata;
    private PreparedStatement processAllOrders;
    private PreparedStatement transferOrder;
    private PreparedStatement setFiscal;
    private PreparedStatement selectWaiterByOrderId;
    private PreparedStatement deleteAllSalesFromOrder;
    private PreparedStatement getLastPlatouForOrderId;
    private PreparedStatement getRecentOrders;
    private PreparedStatement setClient;
    private PreparedStatement setPromotion;
    private PreparedStatement setProtocol;
    private PreparedStatement deleteAllOrders;
    private PreparedStatement setDetaliiForOrder;
    private PreparedStatement setBarcodeForOrder;
    private PreparedStatement setUserToOrder;
    private PreparedStatement setNrPersoaneToOrder;
    private PreparedStatement getNrPersoaneForOrder;
    private PreparedStatement setCloseTimeForOrder;
    private PreparedStatement getCloseTimeForOrder;
    private PreparedStatement deleteAllOrdersNF;
    private PreparedStatement setExternalIdForOrder;
    private PreparedStatement getOrderByExternalId;
    private PreparedStatement setAdresaLivrareForOrder;
    private PreparedStatement getMaxClientIndexForOrder;
    private PreparedStatement getOrderIdsByTipPlata;
    private PreparedStatement setOpendateForOrder;
    private PreparedStatement getClientIndexesForOrder;
    private PreparedStatement setTableForOrder;
    private PreparedStatement setTipOrderForOrderId;
    private PreparedStatement getBonFiscalNumberForIdOrder;
    private PreparedStatement setReducereValoricaForOrder;
    private PreparedStatement setCodFiscalToOrder;
    private Connection connection;
    private static final String selectSalesQuery = "select sales.id as id, sales.id_product as id_product, sales.id_promotion as id_promotion, sales.quantity_float as quantity_float, sales.saledate as saledate, sales.ppu as ppu, sales.ppu_original as ppu_original, sales.discount as discount, sales.printed, sales.facturata, sales.mod_preparare as mod_preparare, sales.id_platou as id_platou, sales.freeS1, sales.freeS2, sales.freeD1, sales.freeD2, sales.freeI1, products.label as nume_produs, products.sectie_label as nume_sectie, coalesce(sales.id_servire, -1) as id_servire, sales.ignore_promo,  subcategories.id as subcategoryId, subcategories.id_category as categoryId, coalesce(sales.id_lot, -1) as id_lot, id_order from sales inner join products on sales.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id where 1 = 1 ";

    public OrdersImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public void updateTableForOrder(int idTable, int idOrder) throws SQLException {
        this.setTableForOrder.setInt(1, idTable);
        this.setTableForOrder.setInt(2, idOrder);
        this.setTableForOrder.execute();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getBonFiscalNumberForIdOrder = this.connection.prepareStatement("select * from bonfiscal_numbers where id_order = ?");
        this.setTipOrderForOrderId = this.connection.prepareStatement("update orders set tip_order = ? where id = ?");
        this.setTableForOrder = this.connection.prepareStatement("update orders set id_table = ? where id = ?");
        this.setExternalIdForOrder = this.connection.prepareStatement("update orders set external_id = ? where id = ?");
        this.getOrderByExternalId = this.connection.prepareStatement("select * from orders where external_id = ?");
        this.setNrPersoaneToOrder = this.connection.prepareStatement("update orders set nr_persoane = ? where id = ?");
        this.setUserToOrder = this.connection.prepareStatement("update orders set id_user = ? where id = ?");
        this.selectOrdersByStatus = this.connection.prepareStatement("select * from orders where status = ? order by closedate desc");
        this.selectOrdersByStatusAndTime = this.connection.prepareStatement("select * from orders where status = ? and opendate >= ? and closedate <= ?");
        this.selectOpenOrders = this.connection.prepareStatement("select * from orders inner join tables on orders.id_table = tables.id inner join locations on tables.id_locatie = locations.id where locations.tip = 1 and (orders.status in (1,5) ) and (orders.id_client = ? or ? = -1) and (orders.id_user = ? or ? = -1) and (tables.id_locatie = ? or ? = -1)");
        this.selectOpenOrderAtTable = this.connection.prepareStatement("select * from orders where (status = 1 OR status = 5) AND id_table = ? order by opendate");
        this.setOpendateForOrder = this.connection.prepareStatement("update orders set opendate = ? where id = ?");
        this.selectOpenOrderByUser = this.connection.prepareStatement("select * from orders where (status = 1 OR status = 5) AND id_user = ?");
        this.selectOrdersById = this.connection.prepareStatement("select * from orders where id = ?");
        this.addOrder = this.connection.prepareStatement("insert into orders (id_table, id_user, persoane, opendate, protocol, detalii, status ) values ( ? , ? , ? , CURRENT_TIMESTAMP, ?, ?, 1)");
        this.deleteOrder = this.connection.prepareStatement("delete from orders where id = ?");
        this.setCloseTimeForOrder = this.connection.prepareStatement("update orders set closedate = ? where id = ?");
        this.getCloseTimeForOrder = this.connection.prepareStatement("select closedate from orders where id = ?");
        this.closeOrder = this.connection.prepareStatement("update orders set closedate = current_timestamp, status = 4, barcode = ?  where id = ?");
        this.laPlata = this.connection.prepareStatement("update orders set status = 5 where id = ?");
        this.processAllOrders = this.connection.prepareStatement("update orders set status = 3 where status = 4");
        this.transferOrder = this.connection.prepareStatement("update orders set id_table = ? where id = ? ");
        this.setDetaliiForOrder = this.connection.prepareStatement("update orders set detalii = ? where id = ?");
        this.setBarcodeForOrder = this.connection.prepareStatement("update orders set barcode = ? where id = ?");
        this.setFiscal = this.connection.prepareStatement("update orders set fiscal = ? where id = ? ");
        this.deleteAllSalesFromOrder = this.connection.prepareStatement("delete from sales where id_order = ?");
        this.selectWaiterByOrderId = this.connection.prepareStatement("select users.id as id, users.name as name, users.login as login, users.password as password, users.id_language as id_language, users.cod_autentificare as cod_autentificare, users.cod_unic, users.is_god, users.virtual from users JOIN orders on users.id = orders.id_user where orders.id = ?");
        this.getLastPlatouForOrderId = this.connection.prepareStatement("select max(id_platou) from sales where id_order = ?");
        this.getRecentOrders = this.connection.prepareStatement("select * from orders where closedate > ? ");
        this.setClient = this.connection.prepareStatement("update orders set id_client = ? where id = ?");
        this.setPromotion = this.connection.prepareStatement("update orders set id_promotie = ? where id = ?");
        this.setProtocol = this.connection.prepareStatement("update orders set protocol = ? where id = ?");
        this.deleteAllOrders = this.connection.prepareStatement("delete from orders");
        this.deleteAllOrdersNF = this.connection.prepareStatement("delete from orders where (fiscal is null or fiscal = 'false') and (orders.status = 3 or orders.status = 4) ");
        this.getNrPersoaneForOrder = this.connection.prepareStatement("select nr_persoane from orders where id = ?");
        this.setAdresaLivrareForOrder = this.connection.prepareStatement("update orders set adresa_livrare = ? where id = ?");
        this.getMaxClientIndexForOrder = this.connection.prepareStatement("select max(client_index) from sales where id_order = ?");
        this.getOrderIdsByTipPlata = this.connection.prepareStatement("select orders.id from orders inner join rest_incasari on orders.id = rest_incasari.id_order inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id where (orders.status = 3 or orders.status = 4 ) and tip_plata.name = ?");
        this.getClientIndexesForOrder = this.connection.prepareStatement("select distinct client_index from sales where id_order = ?");
        this.setReducereValoricaForOrder = this.connection.prepareStatement("update orders set reducere_valorica = ? where id = ?");
        this.setCodFiscalToOrder = this.connection.prepareStatement("update orders set cod_fiscal = ? where id = ?");
    }

    public BonFiscalNumber getBonFiscalNumberForIdOrder(int idOrder) throws SQLException {
        BonFiscalNumber result = null;
        this.getBonFiscalNumberForIdOrder.setInt(1, idOrder);
        ResultSet rs = this.getBonFiscalNumberForIdOrder.executeQuery();
        if (rs.next()) {
            result = new BonFiscalNumber();
            result.setIdOrder(rs.getInt("id_order"));
            result.setNrCasa(rs.getInt("nr_casa"));
            result.setNrZ(rs.getInt("nr_z"));
            result.setNrBon(rs.getInt("nr_bon"));
            result.setCodOper(rs.getInt("cod_oper"));
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, TipPlataValue> getTipPlataForSale(Vector<Integer> idSales, Connection connection) throws SQLException {
        Hashtable<Integer, TipPlataValue> result = new Hashtable<Integer, TipPlataValue>();
        String inS = Utils.getSqlInSequence(idSales);
        String s = "select sales.id as id_sale, tip_plata.name as nume_tip_plata, tip_plata.id as id_tip_plata, (sales.ppu * sales.quantity_float) as suma from tip_plata inner join rest_incasari on tip_plata.id = rest_incasari.id_tip_plata inner join sales on sales.id_plata = rest_incasari.id where sales.id in " + inS;
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        while (rs.next()) {
            TipPlataValue tpv = new TipPlataValue();
            String tipPlata2 = rs.getString("nume_tip_plata");
            tpv.setTipPlata(tipPlata2);
            int idTip = rs.getInt("id_tip_plata");
            tpv.setIdTipPlata(idTip);
            double suma = rs.getDouble("suma");
            tpv.setSuma(suma);
            int idSale = rs.getInt("id_sale");
            tpv.setIdSale(idSale);
            result.put(idSale, tpv);
        }
        rs.close();
        return result;
    }

    public Vector<Integer> getClientIndexesForOrder(int idOrder) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getClientIndexesForOrder.setInt(1, idOrder);
        ResultSet rs = this.getClientIndexesForOrder.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public Vector<Integer> getOrderIdsByTipPlata(String tipPlata2) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getOrderIdsByTipPlata.setString(1, tipPlata2);
        ResultSet rs = this.getOrderIdsByTipPlata.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            result.add(id);
        }
        rs.close();
        return result;
    }

    public int getNrPersoaneForOrder(int idOrder) throws SQLException {
        int result = -1;
        this.getNrPersoaneForOrder.setInt(1, idOrder);
        ResultSet rs = this.getNrPersoaneForOrder.executeQuery();
        if (rs.next()) {
            result = rs.getInt("nr_persoane");
        }
        rs.close();
        return result;
    }

    public int getMaxClientIndexForOrder(int idOrder) throws SQLException {
        int result = -1;
        this.getMaxClientIndexForOrder.setInt(1, idOrder);
        ResultSet rs = this.getMaxClientIndexForOrder.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void setNrPersoaneToOrder(int nrPersoane, int id) throws SQLException {
        this.setNrPersoaneToOrder.setInt(1, nrPersoane);
        this.setNrPersoaneToOrder.setInt(2, id);
        this.setNrPersoaneToOrder.execute();
    }

    public void setDetaliiForOrder(int idOrder, String detalii) throws SQLException {
        this.setDetaliiForOrder.setString(1, detalii);
        this.setDetaliiForOrder.setInt(2, idOrder);
        this.setDetaliiForOrder.execute();
    }

    public void setBarcodeForOrder(int idOrder, String barcode) throws SQLException {
        this.setBarcodeForOrder.setString(1, barcode);
        this.setBarcodeForOrder.setInt(2, idOrder);
        this.setBarcodeForOrder.execute();
    }

    public void deleteAllOrders() throws SQLException {
        this.deleteAllOrders.execute();
    }

    public void deleteAllOrdersNF() throws SQLException {
        this.deleteAllOrdersNF.execute();
    }

    public void deleteAllOrdersIntreDate(Timestamp start, Timestamp stop) throws SQLException {
    }

    public void setProtocol(boolean protocol, int idOrder) throws SQLException {
        this.setProtocol.setString(1, "" + protocol);
        this.setProtocol.setInt(2, idOrder);
        this.setProtocol.execute();
    }

    public void setIdPromotion(int idPromotion, int idOrder) throws SQLException {
        this.setPromotion.setInt(1, idPromotion);
        this.setPromotion.setInt(2, idOrder);
        this.setPromotion.execute();
    }

    public void setIdClient(int idClient, int idOrder) throws SQLException {
        this.setClient.setInt(1, idClient);
        this.setClient.setInt(2, idOrder);
        this.setClient.execute();
    }

    public void setTipOrderForId(Order.TIP_ORDER newTip, int idOrder) throws SQLException {
        this.setTipOrderForOrderId.setInt(1, newTip.getTip());
        this.setTipOrderForOrderId.setInt(2, idOrder);
        this.setTipOrderForOrderId.execute();
    }

    public void setAdresaLivrare(String adresa, int idOrder) throws SQLException {
        this.setAdresaLivrareForOrder.setString(1, adresa);
        this.setAdresaLivrareForOrder.setInt(2, idOrder);
        this.setAdresaLivrareForOrder.execute();
    }

    public Order getOrderById(int id) throws SQLException {
        Order o = null;
        this.selectOrdersById.setInt(1, id);
        ResultSet rs = this.selectOrdersById.executeQuery();
        if (rs.next()) {
            o = this.getOrderFromResultSet(rs);
        }
        rs.close();
        return o;
    }

    public void transferOrder(Order order, Table toTable) throws SQLException {
        this.transferOrder.setInt(1, toTable.getId());
        this.transferOrder.setInt(2, order.getId());
        this.transferOrder.execute();
    }

    public int getLastPlatouForOrderId(int idOrder) throws SQLException {
        int result = 0;
        this.getLastPlatouForOrderId.setInt(1, idOrder);
        ResultSet rs = this.getLastPlatouForOrderId.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addOrder(Order order) throws SQLException {
        this.addOrder.setInt(1, order.getTable());
        this.addOrder.setInt(2, order.getUser());
        this.addOrder.setInt(3, order.getNrClienti());
        this.addOrder.setString(4, order.isProtocol() + "");
        this.addOrder.setString(5, order.getDetalii());
        this.addOrder.execute();
    }

    public void setOpendateForOrder(int idOrder, Timestamp opendate) throws SQLException {
        this.setOpendateForOrder.setTimestamp(1, opendate);
        this.setOpendateForOrder.setInt(2, idOrder);
        this.setOpendateForOrder.execute();
    }

    public void closeOrder(Order order, String barcode) throws SQLException {
        this.closeOrder.setString(1, barcode);
        this.closeOrder.setInt(2, order.getId());
        this.closeOrder.execute();
    }

    public Timestamp getCloseTimeForOrder(int idOrder) throws SQLException {
        Timestamp result = null;
        this.getCloseTimeForOrder.setInt(1, idOrder);
        ResultSet rs = this.getCloseTimeForOrder.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public void updateCloseTimeForOrder(int idOrder, Timestamp stop) throws SQLException {
        this.setCloseTimeForOrder.setTimestamp(1, stop);
        this.setCloseTimeForOrder.setInt(2, idOrder);
        this.setCloseTimeForOrder.execute();
    }

    public void laPlata(Order order) throws SQLException {
        this.laPlata.setInt(1, order.getId());
        this.laPlata.execute();
    }

    public void setFiscal(Order order) throws SQLException {
        this.setFiscal.setString(1, "" + order.isFiscal());
        this.setFiscal.setInt(2, order.getId());
        this.setFiscal.execute();
    }

    public void processAllOrders() throws SQLException {
        this.processAllOrders.execute();
    }

    public Vector<Order> getOpenOrders(int idClient, int idUser, int idLocatie) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        this.selectOpenOrders.setInt(1, idClient);
        this.selectOpenOrders.setInt(2, idClient);
        this.selectOpenOrders.setInt(3, idUser);
        this.selectOpenOrders.setInt(4, idUser);
        this.selectOpenOrders.setInt(5, idLocatie);
        this.selectOpenOrders.setInt(6, idLocatie);
        ResultSet rs = this.selectOpenOrders.executeQuery();
        while (rs.next()) {
            Order toAdd = this.getOrderFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<Order> getOpenOrderAtTable(int idTable) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        this.selectOpenOrderAtTable.setInt(1, idTable);
        ResultSet rs = this.selectOpenOrderAtTable.executeQuery();
        while (rs.next()) {
            Order toAdd = this.getOrderFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector getOpenOrdersByUser(int idUser) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        this.selectOpenOrderByUser.setInt(1, idUser);
        ResultSet rs = this.selectOpenOrderByUser.executeQuery();
        while (rs.next()) {
            Order o = this.getOrderFromResultSet(rs);
            result.add(o);
        }
        rs.close();
        return result;
    }

    public Collection getClosedOrders() throws SQLException {
        Vector<Order> result = new Vector<Order>();
        this.selectOrdersByStatus.setInt(1, 4);
        ResultSet rs = this.selectOrdersByStatus.executeQuery();
        while (rs.next()) {
            Order toAdd = this.getOrderFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Collection getClosedOrdersForPeriod(Date start, Date stop) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        if (start != null && stop != null) {
            this.selectOrdersByStatusAndTime.setInt(1, 3);
            this.selectOrdersByStatusAndTime.setTimestamp(2, new Timestamp(start.getTime()));
            this.selectOrdersByStatusAndTime.setTimestamp(3, new Timestamp(stop.getTime()));
            ResultSet rs = this.selectOrdersByStatusAndTime.executeQuery();
            while (rs.next()) {
                Order toAdd = this.getOrderFromResultSet(rs);
                result.add(toAdd);
            }
            rs.close();
        }
        return result;
    }

    public Vector getRecentOrders(Timestamp t) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        this.getRecentOrders.setTimestamp(1, t);
        ResultSet rs = this.getRecentOrders.executeQuery();
        while (rs.next()) {
            Order o = this.getOrderFromResultSet(rs);
            result.add(o);
        }
        rs.close();
        return result;
    }

    private Order getOrderFromResultSet(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        int tableId = rs.getInt("id_table");
        int idWaiter = rs.getInt("id_user");
        int status = rs.getInt("status");
        int nrClienti = rs.getInt("persoane");
        boolean fiscal = Boolean.valueOf(rs.getString("fiscal"));
        boolean protocol = Boolean.valueOf(rs.getString("protocol"));
        int idClient = rs.getInt("id_client");
        int idPromo = rs.getInt("id_promotie");
        Timestamp t = rs.getTimestamp("opendate");
        Order o = new Order(new Integer(id), new Integer(tableId), new Integer(idWaiter));
        o.setStartTime(t.getTime());
        o.setStopTime(t.getTime());
        o.setStatus(status);
        o.setFiscal(fiscal);
        o.setNrClienti(nrClienti);
        o.setProtocol(protocol);
        o.setIdClient(idClient);
        o.setIdPromotie(idPromo);
        o.setDetalii(rs.getString("detalii"));
        o.setBarcode(rs.getString("barcode"));
        o.setExternalId(rs.getString("external_id"));
        o.setAdresaLivrare(rs.getString("adresa_livrare"));
        o.setReducereValorica(rs.getDouble("reducere_valorica"));
        o.setCodFiscal(rs.getString("cod_fiscal"));
        t = rs.getTimestamp("closedate");
        if (t != null) {
            long closeDate = t.getTime();
            o.setStopTime(closeDate);
        }
        o.setTipOrder(Order.getTipOrderByTip(rs.getInt("tip_order")));
        return o;
    }

    public void setExternalIdForOrder(String externalIdForOrder, int idOrder) throws SQLException {
        this.setExternalIdForOrder.setString(1, externalIdForOrder);
        this.setExternalIdForOrder.setInt(2, idOrder);
        this.setExternalIdForOrder.execute();
    }

    public void deleteOrder(int idOrder) throws SQLException {
        this.deleteAllSalesFromOrder.setInt(1, idOrder);
        this.deleteAllSalesFromOrder.execute();
        this.deleteOrder.setInt(1, idOrder);
        this.deleteOrder.execute();
    }

    public void deleteSalesForOrder(Order o) throws SQLException {
        this.deleteAllSalesFromOrder.setInt(1, o.getId());
        this.deleteAllSalesFromOrder.execute();
    }

    public Sale getSaleById(int idSale, int idOrder, Connection conn) throws SQLException {
        Sale result = null;
        String s = selectSalesQuery + (idOrder > 0 ? " and id_order = " + idOrder : "") + (idSale > 0 ? " and sales.id = " + idSale : "") + " order by subcategories.id_category";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        if (rs.next()) {
            result = this.getSaleFromResultSet(rs, idOrder);
        }
        rs.close();
        return result;
    }

    public Vector<Sale> getSales(Vector<Integer> orders, Connection conn) throws SQLException {
        String s = "select sales.id as id, sales.id_product as id_product, sales.id_promotion as id_promotion, sales.quantity_float as quantity_float, sales.saledate as saledate, sales.ppu as ppu, sales.ppu_original as ppu_original, sales.discount as discount, sales.printed, sales.facturata, sales.mod_preparare as mod_preparare, sales.id_platou as id_platou, sales.freeS1, sales.freeS2, sales.freeD1, sales.freeD2, sales.freeI1, products.label as nume_produs, products.sectie_label as nume_sectie, coalesce(sales.id_servire, -1) as id_servire, sales.ignore_promo,  subcategories.id as subcategoryId, subcategories.id_category as categoryId, coalesce(sales.id_lot, -1) as id_lot, id_order from sales inner join products on sales.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id where 1 = 1  and id_order in " + Utils.getSqlInSequence(orders);
        Vector<Sale> result = new Vector<Sale>();
        if (orders.size() == 0) {
            return result;
        }
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            Sale toAdd = this.getSaleFromResultSet(rs, rs.getInt("id_order"));
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<Sale> getSalesNoSort(int idOrder, boolean cumulate, int printedStatus, Connection conn, SearchSaleInterface search) throws SQLException {
        String s = selectSalesQuery + (idOrder > 0 ? " and id_order = " + idOrder : "") + (printedStatus >= 0 ? " and (sales.printed = " + printedStatus + ")" : "");
        Vector<Sale> result = new Vector<Sale>();
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            Sale toAdd = this.getSaleFromResultSet(rs, idOrder);
            if (cumulate) {
                int index = search.getIndexForSale(toAdd, result);
                if (index != -1) {
                    Sale existing = result.elementAt(index);
                    existing.setCantitateMarcata(existing.getCantitateMarcata() + toAdd.getCantitateMarcata());
                    existing.setCantitateNoua(existing.getCantitateNoua() + toAdd.getCantitateNoua());
                    existing.addIdSale(toAdd.getFirstIdSale());
                    continue;
                }
                result.add(toAdd);
                continue;
            }
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<Sale> getSales(int idOrder, boolean cumulate, int printedStatus, int clientIndex, Connection conn, SearchSaleInterface search) throws SQLException {
        String s = selectSalesQuery + (idOrder > 0 ? " and id_order = " + idOrder : "") + (printedStatus >= 0 ? " and (sales.printed = " + printedStatus + ")" : "");
        String clientIndexWhere = "";
        switch (clientIndex) {
            case -1: {
                clientIndexWhere = "";
                break;
            }
            default: {
                clientIndexWhere = " and sales.client_index = " + clientIndex;
            }
        }
        s = s + clientIndexWhere;
        s = s + " order by subcategories.id_category";
        Vector<Sale> result = new Vector<Sale>();
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            Sale toAdd = this.getSaleFromResultSet(rs, idOrder);
            if (cumulate) {
                int index = search.getIndexForSale(toAdd, result);
                if (index != -1) {
                    Sale existing = result.elementAt(index);
                    existing.setCantitateMarcata(existing.getCantitateMarcata() + toAdd.getCantitateMarcata());
                    existing.setCantitateNoua(existing.getCantitateNoua() + toAdd.getCantitateNoua());
                    existing.addIdSale(toAdd.getFirstIdSale());
                    continue;
                }
                result.add(toAdd);
                continue;
            }
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private Sale getSaleFromResultSet(ResultSet rs, int idOrder) throws SQLException {
        int id = rs.getInt("id");
        int pId = rs.getInt("id_product");
        int promotionId = rs.getInt("id_promotion");
        int idPlatou = rs.getInt("id_platou");
        Sale s = new Sale();
        s.addIdSale(id);
        s.setIdProduct(pId);
        s.setIdOrder(idOrder);
        s.setCantitateMarcata(rs.getDouble("quantity_float"));
        s.setSaledate(rs.getTimestamp("saledate").getTime());
        s.setPrice(rs.getDouble("ppu"));
        s.setPpuOriginal(rs.getDouble("ppu_original"));
        s.setIdPromotie(promotionId);
        s.setModPreparare(rs.getString("mod_preparare"));
        s.setIdPlatou(idPlatou);
        s.setDiscount(rs.getDouble("discount"));
        s.setIdCategorie(rs.getInt("subcategoryId"));
        s.setIdSectie(rs.getInt("categoryId"));
        s.setIdServire(rs.getInt("id_servire"));
        s.setProductName(rs.getString("nume_produs"));
        s.setSectieName(rs.getString("nume_sectie"));
        s.setPrinted(rs.getInt("printed") == 1);
        s.setFacturata(rs.getInt("facturata") == 1);
        s.setFreeS1(rs.getString("freeS1"));
        s.setFreeS2(rs.getString("freeS2"));
        s.setFreeD1(rs.getDouble("freeD1"));
        s.setFreeD2(rs.getDouble("freeD2"));
        s.setFreeI1(rs.getInt("freeI1"));
        int idLot = rs.getInt("id_lot");
        s.setIdLot(idLot);
        int ignore_promo = rs.getInt("ignore_promo");
        s.setIgnorePromotion(ignore_promo != 0);
        return s;
    }

    public User getUserByOrderId(int id) throws SQLException {
        User result = null;
        this.selectWaiterByOrderId.setInt(1, id);
        ResultSet rs = this.selectWaiterByOrderId.executeQuery();
        if (rs.next()) {
            result = UsersImpl.getUserFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void setUserToOrder(int idOrder, int idUser) throws SQLException {
        this.setUserToOrder.setInt(1, idUser);
        this.setUserToOrder.setInt(2, idOrder);
        this.setUserToOrder.execute();
    }

    public int getOrderByExternalId(String externalOrderId) throws SQLException {
        int result = -1;
        this.getOrderByExternalId.setString(1, externalOrderId);
        ResultSet rs = this.getOrderByExternalId.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public void setReducereValoricaForOrder(int idOrder, double reducereValorica) throws SQLException {
        this.setReducereValoricaForOrder.setDouble(1, reducereValorica);
        this.setReducereValoricaForOrder.setInt(2, idOrder);
        this.setReducereValoricaForOrder.executeUpdate();
    }

    public void setCodFiscalToOrder(int idOrder, String codFiscal) throws SQLException {
        this.setCodFiscalToOrder.setString(1, codFiscal);
        this.setCodFiscalToOrder.setInt(2, idOrder);
        this.setCodFiscalToOrder.executeUpdate();
    }

    public Vector<Order> getFilteredOrders(int status, int idClient, int idUser, Vector<Integer> idTables) throws SQLException {
        Vector<Order> result = new Vector<Order>();
        String allStatuses = "1,5,6";
        String query = "select * from orders inner join tables on orders.id_table = tables.id inner join locations on tables.id_locatie = locations.id where locations.tip = 1 and orders.status in (" + (status == -1 ? allStatuses : Integer.valueOf(status)) + ")";
        StringBuffer queryS = new StringBuffer(query);
        if (idClient != -1) {
            queryS.append(" and (orders.id_client = " + idClient + ")");
        }
        if (idUser != -1) {
            queryS.append(" and (orders.id_user = " + idUser + ")");
        }
        if (idTables != null) {
            queryS.append(" and (tables.id_locatie in (" + idTables.get(0));
            if (idTables.size() > 1) {
                for (int i = 1; i < idTables.size(); ++i) {
                    queryS.append("," + idTables.get(i));
                }
            }
            queryS.append(")");
        }
        queryS.append(" order by orders.id desc");
        query = queryS.toString();
        ResultSet rs = SqlUtils.executeQuery(query, this.connection);
        while (rs.next()) {
            Order order = this.getOrderFromResultSet(rs);
            result.add(order);
        }
        return result;
    }

    public void setStatusForOrder(Order o, int status) throws SQLException {
        String query = "update orders set status = " + status + " where id = " + o.getId();
        SqlUtils.executeUpdate(query, this.connection);
    }
}

