/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.simplestocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.simplestocks.gui.SimpleStocksReport;
import ro.atreides.stocks.gui.StockInput;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;

public class SimpleStocksPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private StockInput _stockInputPanel = null;
    private SimpleStocksReport _fisaStoc;

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    private void init() {
        this._tabbedPane = new JTabbedPane();
        this._fisaStoc = new SimpleStocksReport();
        this._fisaStoc.doStuff();
        this._tabbedPane.add(this._fisaStoc.getName(), this._fisaStoc);
        this._stockInputPanel = new StockInput();
        this._tabbedPane.add("Definire stoc", this._stockInputPanel);
        this._stockInputPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                SimpleStocksPanel.this._fisaStoc.raport();
                SimpleStocksPanel.this._tabbedPane.setSelectedComponent(SimpleStocksPanel.this._fisaStoc);
            }
        });
        this._fisaStoc.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                SimpleStocksPanel.this._stockInputPanel.setObjectToEdit(o, entry, selRow);
                SimpleStocksPanel.this._tabbedPane.setSelectedComponent(SimpleStocksPanel.this._stockInputPanel);
            }
        });
        GuiUtilsRest.addPiratGuiMouseListenerForReports(this._tabbedPane);
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
    }

    @Override
    public void cleanup() {
        this._stockInputPanel.cleanup();
        this._fisaStoc.cleanup();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }
}

