/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.simplestocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.simplestocks.SimpleStockEntry;
import ro.atreides.simplestocks.SimpleStockLogic;
import ro.atreides.simplestocks.gui.IncarcaStocChooserDialog;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class SimpleStocksReport
extends AbstractReportPanel
implements CleanupRequired {
    private JComboBox magazii;
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private ReportInterface asciiReportInterface;
    private SimpleStockLogic simpleLogic;
    private StockLogic stockLogic = StockLogic.getInstance();
    private DoubleClicked action;
    public static final String[] columns = new String[]{LangRoAll.produs, "Magazie", "Initial", "Intrare", "Intrare partiala", "Consum", "Scriptic", "Faptic", "Diferenta"};
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SimpleStockEntry)o1).getNume();
            String c2 = ((SimpleStockEntry)o2).getNume();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator initial_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getInitial();
            double c2 = ((SimpleStockEntry)o2).getInitial();
            return (int)(c1 - c2);
        }
    };
    private static Comparator magazie_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SimpleStockEntry)o1).getMagazie();
            String c2 = ((SimpleStockEntry)o2).getMagazie();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator intrare_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getIntrare();
            double c2 = ((SimpleStockEntry)o2).getIntrare();
            return (int)(c1 - c2);
        }
    };
    private static Comparator intrarePartiala_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getIntrarePartiala();
            double c2 = ((SimpleStockEntry)o2).getIntrarePartiala();
            return (int)(c1 - c2);
        }
    };
    private static Comparator consum_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getIesire();
            double c2 = ((SimpleStockEntry)o2).getIesire();
            return (int)(c1 - c2);
        }
    };
    private static Comparator scriptic_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getScriptic();
            double c2 = ((SimpleStockEntry)o2).getScriptic();
            return (int)(c1 - c2);
        }
    };
    private static Comparator faptic_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getFaptic();
            double c2 = ((SimpleStockEntry)o2).getFaptic();
            return (int)(c1 - c2);
        }
    };
    private static Comparator diferenta_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((SimpleStockEntry)o1).getDiferenta();
            double c2 = ((SimpleStockEntry)o2).getDiferenta();
            return (int)(c1 - c2);
        }
    };

    public final void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Integer> result = new Hashtable<String, Integer>();
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", m.getId());
            this.printCriteria.put("Magazie", m.getLabel());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        return result;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Integer idMagazie = (Integer)criteria.get("id_magazie");
        return this.simpleLogic.getStocks(idMagazie, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    SimpleStockEntry se = (SimpleStockEntry)o;
                    try {
                        Label label = new Label(0, row, se.getNume());
                        sheet.addCell((WritableCell)label);
                        Label label1 = new Label(1, row, se.getMagazie());
                        sheet.addCell((WritableCell)label1);
                        sheet.addCell((WritableCell)new Number(2, row, se.getInitial()));
                        sheet.addCell((WritableCell)new Number(3, row, se.getIntrare()));
                        sheet.addCell((WritableCell)new Number(4, row, se.getIntrarePartiala()));
                        sheet.addCell((WritableCell)new Number(5, row, se.getIesire()));
                        sheet.addCell((WritableCell)new Number(6, row, se.getScriptic()));
                        sheet.addCell((WritableCell)new Number(7, row, se.getFaptic()));
                        sheet.addCell((WritableCell)new Number(8, row, se.getDiferenta()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return SimpleStocksReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Fisa stoc";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                double value = Utils.parseDouble((String)aValue);
                SimpleStockEntry se = (SimpleStockEntry)data.elementAt(rowIndex);
                if (columnIndex == 3) {
                    SimpleStocksReport.this.simpleLogic.setIntrare(se.getIdStock(), se.getIdMagazie(), value);
                    se.setIntrare(value);
                } else if (columnIndex == 4) {
                    SimpleStocksReport.this.simpleLogic.setIntrarePartiala(se.getIdStock(), se.getIdMagazie(), value);
                    se.setIntrarePartiala(value);
                } else if (columnIndex == 7) {
                    SimpleStocksReport.this.simpleLogic.setFaptic(se.getIdStock(), se.getIdMagazie(), value);
                    se.setFaptic(value);
                }
                se.compute();
                SimpleStocksReport.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 3 || columnIndex == 4 || columnIndex == 7;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                SimpleStockEntry se = (SimpleStockEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return se.getNume();
                    }
                    case 1: {
                        return se.getMagazie();
                    }
                    case 2: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getInitial());
                    }
                    case 3: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIntrare());
                    }
                    case 4: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIntrarePartiala());
                    }
                    case 5: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIesire());
                    }
                    case 6: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getScriptic());
                    }
                    case 7: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getFaptic());
                    }
                    case 8: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getDiferenta());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        final SimpleStocksReport parent = this;
        JButton salveaza = new JButton("Proceseaza intrari partiale");
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Procesam intrarile partiale pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.proceseazaIntrariPartiale(idMagazie);
                    SimpleStocksReport.this.raport();
                }
            }
        });
        salveaza.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)salveaza, c);
        ++c.gridx;
        JButton proceseazaStoc = new JButton("Proceseaza stoc");
        proceseazaStoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String m2 = " toate magaziile";
                if (DialogUtils.confirmDialog(parent, "Procesam stocurile pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.closeDay();
                    SimpleStocksReport.this.raport();
                }
            }
        });
        proceseazaStoc.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)proceseazaStoc, c);
        c.weightx = 0.3;
        ++c.gridx;
        JButton golireInitial = new JButton("Golire initial");
        golireInitial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Golim stocul initial pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.golesteInitial(idMagazie);
                    SimpleStocksReport.this.raport();
                }
            }
        });
        golireInitial.setMargin(new Insets(1, 1, 1, 1));
        result.add(golireInitial);
        ++c.gridx;
        JButton golireIntrari = new JButton("Golire intrari");
        golireIntrari.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Golim intrarile pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.golesteIntrari(idMagazie);
                    SimpleStocksReport.this.raport();
                }
            }
        });
        golireIntrari.setMargin(new Insets(1, 1, 1, 1));
        result.add(golireIntrari);
        ++c.gridx;
        JButton golireConsum = new JButton("Golire consum");
        golireConsum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Golim consumul pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.golesteConsum(idMagazie);
                    SimpleStocksReport.this.raport();
                }
            }
        });
        golireConsum.setMargin(new Insets(1, 1, 1, 1));
        result.add(golireConsum);
        ++c.gridx;
        JButton golireFaptic = new JButton("Golire faptic");
        golireFaptic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Golim faptic pentru " + m2, LangRoAll.confirmare)) {
                    SimpleStocksReport.this.simpleLogic.golesteFaptic(idMagazie);
                    SimpleStocksReport.this.raport();
                }
            }
        });
        golireFaptic.setMargin(new Insets(1, 1, 1, 1));
        result.add(golireFaptic);
        ++c.gridx;
        JButton incarcaInitial = new JButton("Incarca initial");
        incarcaInitial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String inputFile;
                Object m1 = SimpleStocksReport.this.magazii.getSelectedItem();
                int idMagazie = -1;
                String m2 = " toate magaziile";
                if (m1 instanceof Magazie) {
                    Magazie m = (Magazie)m1;
                    idMagazie = m.getId();
                    m2 = m.getLabel();
                }
                if (DialogUtils.confirmDialog(parent, "Incarcam stocul initial pentru " + m2, LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(parent, "Selectati fisierul de import", "xml")) != null) {
                    Vector<String> elems = new Vector<String>();
                    elems.add("initial");
                    elems.add("scriptic");
                    elems.add("faptic");
                    IncarcaStocChooserDialog dialog = new IncarcaStocChooserDialog(4, elems);
                    String selection = dialog.getSelected();
                    boolean ok = SimpleStocksReport.this.simpleLogic.incarcaInitialFromXML(inputFile, idMagazie, selection);
                    if (ok) {
                        DialogUtils.okDialog(parent, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.okDialog(parent, "Operatie anulata", LangRoAll.eroare);
                    }
                    SimpleStocksReport.this.raport();
                }
            }
        });
        incarcaInitial.setMargin(new Insets(1, 1, 1, 1));
        result.add(incarcaInitial);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.simpleLogic = SimpleStockLogic.getInstance();
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii());
        final SimpleStocksReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JMenuItem toIngredient;
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final SimpleStockEntry sourceVe = (SimpleStockEntry)SimpleStocksReport.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Stock s = SimpleStocksReport.this.stockLogic.getStockById(sourceVe.getIdStock());
                        SimpleStocksReport.this.action.doubleClicked(s, sourceVe, selRow);
                        popup.setVisible(false);
                    }
                });
                if (!SimpleStocksReport.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                    JMenuItem toFinit = new JMenuItem(LangRoAll.transformaInMarfa);
                    popup.add(toFinit);
                    toFinit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(parent, "Transformam in produs finit", LangRoAll.confirmare)) {
                                Product existingProduct = NomeclaturaLogic.getInstance().getProductByName(sourceVe.getNume());
                                boolean allowProduseDuplicate = Config.getInstance().getBoolean("allowProduseDuplicate");
                                if (existingProduct != null && !allowProduseDuplicate) {
                                    DialogUtils.errorDialog(parent, "Exista deja un produs cu acest nume", LangRoAll.nuPotContinua);
                                } else {
                                    SimpleStocksReport.this.stockLogic.toProdusFinit(sourceVe.getIdStock(), sourceVe.getNume());
                                    Stock s = SimpleStocksReport.this.stockLogic.getStockById(sourceVe.getIdStock());
                                    SimpleStocksReport.this.action.doubleClicked(s, sourceVe, selRow);
                                }
                                popup.setVisible(false);
                            }
                        }
                    });
                }
                if (SimpleStocksReport.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                    toIngredient = new JMenuItem("Transforma in materie prima");
                    popup.add(toIngredient);
                    toIngredient.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(parent, "Transformam in materie prima", LangRoAll.confirmare)) {
                                SimpleStocksReport.this.stockLogic.toIngredient(sourceVe.getIdStock());
                                SimpleStocksReport.this.raport();
                            }
                            popup.setVisible(false);
                        }
                    });
                }
                if (LicenseManager.getInstance().isFunctionLicensed("simplestocks_show_retetar_items")) {
                    if (SimpleStocksReport.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                        toIngredient = new JMenuItem("Transforma in reteta");
                        popup.add(toIngredient);
                        toIngredient.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (DialogUtils.confirmDialog(parent, "Transformam in reteta", LangRoAll.confirmare)) {
                                    boolean adaugaReteta = DialogUtils.confirmDialog(parent, "Adaugam stocul in reteta", LangRoAll.confirmare);
                                    boolean stergeStoc = false;
                                    if (!adaugaReteta) {
                                        stergeStoc = DialogUtils.confirmDialog(parent, "Stergem stocul", LangRoAll.confirmare);
                                    }
                                    int idStoc = sourceVe.getIdStock();
                                    Product p = SimpleStocksReport.this.stockLogic.getProductForStock(idStoc);
                                    double price = SimpleStocksReport.this.stockLogic.getCatalogPriceForStock(idStoc);
                                    boolean ok = SimpleStocksReport.this.stockLogic.getStockInterface().transformaProdusFinitInReteta(sourceVe.getIdStock(), p.getId(), price, stergeStoc, adaugaReteta, parent);
                                    if (ok) {
                                        SimpleStocksReport.this.raport();
                                    }
                                }
                                popup.setVisible(false);
                            }
                        });
                    }
                    JMenuItem folosireStock = new JMenuItem("Folosire in retete");
                    popup.add(folosireStock);
                    folosireStock.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String folosit = SimpleStocksReport.this.stockLogic.getDeleteImpedimentsString(SimpleStocksReport.this.stockLogic.getDeleteImpediments(sourceVe.getIdStock()));
                            DialogUtils.okDialog(parent, folosit, sourceVe.getNume() + " : folosire in retete");
                            popup.setVisible(false);
                        }
                    });
                }
                JMenuItem stergeStock = new JMenuItem("Sterge stoc");
                popup.add(stergeStock);
                stergeStock.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean action = false;
                        if (DialogUtils.confirmDialog(parent, "Stergem stocul", LangRoAll.confirmare)) {
                            action = SimpleStocksReport.this.stockLogic.deleteStock(sourceVe.getIdStock(), parent);
                        }
                        popup.setVisible(false);
                        if (action) {
                            SimpleStocksReport.this.raport();
                        }
                    }
                });
                popup.setInvoker(SimpleStocksReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    default: 
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return "Raport fisa stoc";
            }

            @Override
            public Hashtable getCriteria() {
                return SimpleStocksReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SimpleStockEntry se = (SimpleStockEntry)row;
                switch (column) {
                    case 0: {
                        return se.getNume();
                    }
                    case 1: {
                        return se.getMagazie();
                    }
                    case 2: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getInitial());
                    }
                    case 3: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIntrare());
                    }
                    case 4: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIntrarePartiala());
                    }
                    case 5: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getIesire());
                    }
                    case 6: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getScriptic());
                    }
                    case 7: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getFaptic());
                    }
                    case 8: {
                        return Utils.getFloatStringOrEmpty3Decimals(se.getDiferenta());
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                String magazie = " | ";
                String s1 = (String)SimpleStocksReport.this.printCriteria.get("Magazie");
                if (!Validators.correctString(s1)) {
                    magazie = " | Magazie | ";
                }
                return "Produs" + magazie + "Scriptic";
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return SimpleStocksReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return SimpleStocksReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SimpleStockEntry se = (SimpleStockEntry)row;
                String magazie = " | ";
                String s1 = (String)SimpleStocksReport.this.printCriteria.get("Magazie");
                if (!Validators.correctString(s1)) {
                    magazie = " | " + se.getMagazie() + " | ";
                }
                return se.getNume() + magazie + Utils.getFloatStringOrEmpty3Decimals(se.getScriptic());
            }
        };
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return product_sorter;
            }
            case 1: {
                return magazie_sorter;
            }
            case 2: {
                return initial_sorter;
            }
            case 3: {
                return intrare_sorter;
            }
            case 4: {
                return intrarePartiala_sorter;
            }
            case 5: {
                return consum_sorter;
            }
            case 6: {
                return scriptic_sorter;
            }
            case 7: {
                return faptic_sorter;
            }
            case 8: {
                return diferenta_sorter;
            }
        }
        return null;
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            this.simpleLogic.exportStockToXml(this.printCriteria, this.tm.getData(), inputFile);
            DialogUtils.okDialog(this, "Operatie efectuata", LangRoAll.succes);
        }
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }
}

