/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.sms.notifier;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import jxl.read.biff.BiffException;
import ro.atreides.sms.SmsdSender;
import ro.atreides.sms.notifier.NotifierMessage;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;

public class NotifierMain {
    public static final void main(String[] args) {
        String host = Utils.getCmdlineValue("-host", args, "127.0.0.1");
        String portS = Utils.getCmdlineValue("-port", args, "3306");
        int port = Integer.parseInt(portS);
        String db = Utils.getCmdlineValue("-db", args, "smsd");
        String user = Utils.getCmdlineValue("-user", args, "smsd");
        String pass = Utils.getCmdlineValue("-password", args, "smsd");
        String file = Utils.getCmdlineValue("-file", args, "file.xls");
        Logger.getInstance(6, "sms_log.txt");
        SmsdSender sender = SmsdSender.getInstance(host, port, db, user, pass);
        long sleepTime = 5000L;
        while (true) {
            final Vector toSend = new Vector();
            final long now = System.currentTimeMillis();
            final long lastTime = now - sleepTime;
            try {
                ExcelUtils.readExcel(new File(file), new ExcelImportInterface(){
                    String destinatii;
                    String text;
                    String calendar;

                    @Override
                    public void valueRead(int row, int column, String value) {
                        switch (column) {
                            case 1: {
                                this.destinatii = value;
                                break;
                            }
                            case 2: {
                                this.text = value;
                                break;
                            }
                            case 3: {
                                this.calendar = value;
                                break;
                            }
                        }
                    }

                    @Override
                    public void sheetEnd(String sheetName) {
                    }

                    @Override
                    public void lineEnd() {
                        NotifierMessage nm = new NotifierMessage();
                        if (this.calendar.startsWith("W")) {
                            Vector s = Utils.splitString(this.calendar, ';');
                            for (int i = 1; i < s.size(); ++i) {
                                int minute;
                                String time;
                                Vector timeV;
                                int hour;
                                String period = (String)s.elementAt(i);
                                Vector comp = Utils.splitString(period, '-');
                                int dayInWeek = Integer.parseInt((String)comp.elementAt(0));
                                Date d = DateUtils.getDayInWeek(dayInWeek + 1, hour = Integer.parseInt((String)(timeV = Utils.splitString(time = (String)comp.elementAt(1), ':')).elementAt(0)), minute = Integer.parseInt((String)timeV.elementAt(1)));
                                if (d.getTime() < lastTime || d.getTime() >= now) continue;
                                Vector numbers = Utils.splitString(this.destinatii, ',');
                                for (int j = 0; j < numbers.size(); ++j) {
                                    String o = (String)numbers.elementAt(j);
                                    nm.addNumber(o);
                                }
                                nm.setText(this.text);
                                Logger.logDebug(this, " Sending \"" + this.text + "\" to " + this.destinatii);
                            }
                        }
                        toSend.add(nm);
                    }

                    @Override
                    public void lineStart() {
                        this.destinatii = "";
                        this.text = "";
                        this.calendar = "";
                    }

                    @Override
                    public void sheetStart(String sheetName) {
                    }
                });
            }
            catch (IOException e) {
                Logger.logException(NotifierMain.class, (Exception)e);
            }
            catch (BiffException e) {
                Logger.logException(NotifierMain.class, (Exception)((Object)e));
            }
            for (int i = 0; i < toSend.size(); ++i) {
                NotifierMessage o = (NotifierMessage)toSend.elementAt(i);
                sender.sendSms(o.getText(), o.getNumbers());
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
            }
        }
    }
}

