/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks;

import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;

public class BalantaExcelProcessor
implements ExcelProcessor {
    private String name;
    private String[] columns;
    private int tipP;

    private double tip(double acz, double vz) {
        return this.tipP == 2 ? acz : vz;
    }

    public BalantaExcelProcessor(String name, String[] columns, int tip) {
        this.name = name;
        this.columns = columns;
        this.tipP = tip;
    }

    @Override
    public void processLine(Object o, WritableSheet sheet, int row) {
        RaportGestiuneEntry e = (RaportGestiuneEntry)o;
        try {
            int column = 0;
            sheet.addCell((WritableCell)new Label(column, row, e.getProdus() + e.getProdusLine2Full()));
            sheet.addCell((WritableCell)new Label(++column, row, e.getUm()));
            sheet.addCell((WritableCell)new Number(++column, row, e.getCantInitiala()));
            sheet.addCell((WritableCell)new Number(++column, row, this.tip(e.getValInitialaAcz(), e.getValInitialaVz())));
            sheet.addCell((WritableCell)new Number(++column, row, e.getCantIntrata()));
            sheet.addCell((WritableCell)new Number(++column, row, this.tip(e.getValIntrataAcz(), e.getValIntrataVz())));
            sheet.addCell((WritableCell)new Number(++column, row, e.getCantIesita()));
            sheet.addCell((WritableCell)new Number(++column, row, this.tip(e.getValIesitaAcz(), e.getValIesitaVz())));
            sheet.addCell((WritableCell)new Number(++column, row, e.getCantFinala()));
            sheet.addCell((WritableCell)new Number(++column, row, this.tip(e.getValFinalaAcz(), e.getValFinalaVz())));
            ++column;
        }
        catch (RowsExceededException ex) {
            Logger.logException(this, (Exception)((Object)ex));
        }
        catch (WriteException ex) {
            Logger.logException(this, (Exception)((Object)ex));
        }
    }

    @Override
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public String getSheetName() {
        return this.name;
    }

    @Override
    public int buildHeader(WritableSheet sheet, int startRow) {
        return 0;
    }

    @Override
    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
    }
}

