/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks;

import java.awt.Component;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ReceptieFromStockInterface;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.units.UnitsLogic;

public class BalantaXmlHandler
extends DefaultHandler {
    private Magazie magazie;
    private int idStock;
    private int idTva = 1;
    private double stoc;
    private double valAchizitie;
    private double valoareVanzare;
    private Date dataBalanta;
    private ReceptieFromStockInterface receptieInterface;
    private StockLogic logic;
    private Component parent;
    private boolean magazieSet = false;

    public BalantaXmlHandler(ReceptieFromStockInterface receptieInterface, StockLogic logic, Component parent) {
        this.receptieInterface = receptieInterface;
        this.logic = logic;
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.magazieSet && this.magazie == null) {
            return;
        }
        if (qName.equalsIgnoreCase("magazie")) {
            int idMagazie = Integer.parseInt(attributes.getValue("id"));
            this.magazie = this.logic.getMagazieById(idMagazie);
            if (this.magazie == null) {
                DialogUtils.errorDialog(this.parent, "Magazie inexistenta. Toate produsele vor fi ignorate", LangRoAll.nuPotContinua);
                return;
            }
        }
        if (qName.equalsIgnoreCase("stock")) {
            this.idStock = Integer.parseInt(attributes.getValue("id"));
            this.stoc = Utils.parseDouble(attributes.getValue("stoc"));
            this.valAchizitie = Utils.parseDouble(attributes.getValue("valoareAchizitie"));
            this.valoareVanzare = Utils.parseDouble(attributes.getValue("valoareVanzare"));
        }
        if (qName.equalsIgnoreCase("magazii")) {
            String d = attributes.getValue("data");
            try {
                this.dataBalanta = Formatters.DATE_TIME_AND_SECONDS_FORMAT.parse(d);
            }
            catch (ParseException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("magazie")) {
            this.magazieSet = false;
        }
        if (this.magazieSet && this.magazie == null) {
            return;
        }
        if (qName.equalsIgnoreCase("stock")) {
            Stock s = this.logic.getStockById(this.idStock);
            int idUnit = s.getIdUnit();
            Unit u = UnitsLogic.getInstance().getUnitById(idUnit);
            double pretVanzare = this.valoareVanzare / this.stoc;
            if (!this.logic.isProdusFinit(s.getId())) {
                pretVanzare = -1.0;
            }
            if (this.stoc < 0.001) {
                return;
            }
            double pretAchizitie = this.valAchizitie / this.stoc;
            this.receptieInterface.addNirItem(this.idStock, s.getLabel(), u.getLabel(), this.stoc, pretAchizitie, pretVanzare, idUnit, this.magazie.getId(), this.magazie.getLabel(), true, -1.0, this.idTva);
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }
}

