/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.stocks.ConsumTransferInterface;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.multilang.LangRoAll;

public class StocksPrint {
    public static int tipP;

    private static String getGestiuneEmptyLine(String lineFile) throws IOException {
        String linie = FileUtils.readFileToString(lineFile);
        linie = linie.replaceAll("%%Articol%%", " ");
        linie = linie.replaceAll("%%CantitateInitiala%%", "");
        linie = linie.replaceAll("%%ValoareInitiala%%", "");
        linie = linie.replaceAll("%%CantitateIntrata%%", "");
        linie = linie.replaceAll("%%ValoareIntrata%%", "");
        linie = linie.replaceAll("%%CantitateIesita%%", "");
        linie = linie.replaceAll("%%ValoareIesita%%", "");
        linie = linie.replaceAll("%%CantitateFinala%%", "");
        linie = linie.replaceAll("%%ValoareFinala%%", "");
        linie = linie.replaceAll("%%UM%%", "");
        return linie;
    }

    private static double tip(double acz, double vz) {
        return tipP == 2 ? acz : vz;
    }

    public static String makeRaportGestiuneFoFile(Vector entries, Hashtable printCriteria, String numeMagazie, Config config, double valInitiala, double valIntrata, double valIesita, double valFinala) throws IOException {
        String startDate = (String)printCriteria.get(LangRoAll.start);
        String stopDate = (String)printCriteria.get(LangRoAll.stop);
        String tipDocumente = (String)printCriteria.get("tip_document");
        String perioada = startDate + " - " + stopDate + "\n" + tipDocumente;
        String modelFile = "conf" + File.separator + config.getString("balantaFile");
        String lineFile = "conf" + File.separator + config.getString("balantaLine");
        int balantaLiniiPerPage = config.getInt("balantaLiniiPerPage");
        String foFile = FileUtils.readFileToString(modelFile);
        String date = "";
        int i = 1;
        for (RaportGestiuneEntry e : entries) {
            String linie = FileUtils.readFileToString(lineFile);
            String productEscaped = TextUtils.escapeForXML(e.getProdus() + e.getProdusLine2Full());
            linie = linie.replaceAll("%%Articol%%", productEscaped);
            linie = linie.replaceAll("%%UM%%", e.getUm());
            linie = linie.replaceAll("%%CantitateInitiala%%", Utils.getString3Decimals(e.getCantInitiala()));
            linie = linie.replaceAll("%%ValoareInitiala%%", Utils.getString2Decimals(StocksPrint.tip(e.getValInitialaAcz(), e.getValInitialaVz())));
            linie = linie.replaceAll("%%CantitateIntrata%%", Utils.getString3Decimals(e.getCantIntrata()));
            linie = linie.replaceAll("%%ValoareIntrata%%", Utils.getString2Decimals(StocksPrint.tip(e.getValIntrataAcz(), e.getValIntrataVz())));
            linie = linie.replaceAll("%%CantitateIesita%%", Utils.getString3Decimals(e.getCantIesita()));
            linie = linie.replaceAll("%%ValoareIesita%%", Utils.getString2Decimals(StocksPrint.tip(e.getValIesitaAcz(), e.getValIesitaVz())));
            linie = linie.replaceAll("%%CantitateFinala%%", Utils.getString3Decimals(e.getCantFinala()));
            linie = linie.replaceAll("%%ValoareFinala%%", Utils.getString2Decimals(StocksPrint.tip(e.getValFinalaAcz(), e.getValFinalaVz())));
            date = date + linie + "\n";
            ++i;
        }
        String socEscaped = TextUtils.escapeForXML(config.getString("societate"));
        foFile = foFile.replaceAll("%%societatea%%", socEscaped);
        String addressEscaped = TextUtils.escapeForXML(config.getString("address"));
        foFile = foFile.replaceAll("%%adresa%%", addressEscaped);
        String cuiEscaped = TextUtils.escapeForXML(config.getString("cui"));
        foFile = foFile.replaceAll("%%cui%%", cuiEscaped);
        String magazieEscaped = TextUtils.escapeForXML(numeMagazie);
        foFile = foFile.replaceAll("%%magazia%%", magazieEscaped);
        String perioadaEscaped = TextUtils.escapeForXML(perioada);
        foFile = foFile.replaceAll("%%perioada%%", perioadaEscaped);
        foFile = foFile.replaceAll("%%entries%%", date);
        foFile = foFile.replaceAll("%%initiala%%", Utils.getString2Decimals(valInitiala));
        foFile = foFile.replaceAll("%%intrata%%", Utils.getString2Decimals(valIntrata));
        foFile = foFile.replaceAll("%%iesita%%", Utils.getString2Decimals(valIesita));
        foFile = foFile.replaceAll("%%finala%%", Utils.getString2Decimals(valFinala));
        String filename = FileUtils.getTempDir() + File.separator + "balanta.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }

    public static String makeBonFoFile(Vector<ConsumTransferInterface> items, String magazieIn, String magazieOut, String societate, String d, String nrBon, int tipPret) throws IOException {
        String modelFile = "conf" + File.separator + "bonConsum.txt";
        String lineFile = "conf" + File.separator + "linieBonConsum.txt";
        String foFile = FileUtils.readFileToString(modelFile);
        String date = "";
        int i = 1;
        double valoareAcz = 0.0;
        double valoareVz = 0.0;
        for (ConsumTransferInterface e : items) {
            String linie = FileUtils.readFileToString(lineFile);
            String productEscaped = TextUtils.escapeForXML(e.getDenumire());
            linie = linie.replaceAll("%%Nr%%", i + "");
            linie = linie.replaceAll("%%Denumirea%%", productEscaped);
            linie = linie.replaceAll("%%UM%%", TextUtils.escapeForXML(e.getUm()));
            linie = linie.replaceAll("%%Cantitate%%", Utils.getString3Decimals(e.getCantitate()));
            String pret = "";
            String val = "";
            switch (tipPret) {
                case 2: {
                    pret = Utils.getString2Decimals(e.getPretAcz());
                    val = Utils.getString2Decimals(e.getValoareAchizitie());
                    break;
                }
                case 1: {
                    pret = Utils.getString2Decimals(e.getPretVz());
                    val = Utils.getString2Decimals(e.getValoareVanzare());
                    break;
                }
                case 3: {
                    pret = Utils.getString2Decimals(e.getPretAcz()) + "|" + Utils.getString2Decimals(e.getPretVz());
                    val = Utils.getString2Decimals(e.getValoareAchizitie()) + "|" + Utils.getString2Decimals(e.getValoareVanzare());
                }
            }
            linie = linie.replaceAll("%%Pret%%", pret);
            linie = linie.replaceAll("%%Valoare%%", val);
            date = date + linie + "\n";
            valoareAcz += e.getValoareAchizitie();
            valoareVz += e.getValoareVanzare();
            ++i;
        }
        foFile = foFile.replaceAll("%%data%%", TextUtils.escapeForXML(d));
        foFile = foFile.replaceAll("%%predator%%", TextUtils.escapeForXML(magazieOut));
        foFile = foFile.replaceAll("%%primitor%%", TextUtils.escapeForXML(magazieIn));
        foFile = foFile.replaceAll("%%societatea%%", TextUtils.escapeForXML(societate));
        foFile = foFile.replaceAll("%%entries%%", date);
        foFile = foFile.replaceAll("%%nrBon%%", nrBon);
        String val = "";
        switch (tipPret) {
            case 2: {
                val = Utils.getString2Decimals(valoareAcz);
                break;
            }
            case 1: {
                val = Utils.getString2Decimals(valoareVz);
                break;
            }
            case 3: {
                val = Utils.getString2Decimals(valoareAcz) + "|" + Utils.getString2Decimals(valoareVz);
            }
        }
        foFile = foFile.replaceAll("%%valoare%%", val);
        String filename = FileUtils.getTempDir() + File.separator + "bonConsum.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }
}

