/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.PowerSearchStock;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.registre.RegistreLogic;

public class AddBonConsumPanel
extends ReflectedJPanel {
    private JPanel parent;
    private StockLogic stockLogic;
    private JComboBox magazie;
    private XComboBox produse;
    private FilterableComboBoxModel xStocksComboModel;
    private JTextField time;
    private JTextField cantitate;
    private JTextField nrDocInput;
    private JLabel detaliiLot;
    private JTextField codbareField;
    private JTextArea observatii;
    private JButton adauga;
    private MDateEntryField data;
    private JLabel totalFacturaCuTva;
    private AbstractTM itemsTm;
    private double totalGeneral;
    private SwitchToList action;
    private BonConsum bonConsum;
    private boolean fiscal = true;
    private int idLot = -1;
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.pret + "**", LangRoAll.valoare + "*"};

    @Override
    public void doStuff() {
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddBonConsumPanel.this.xStocksComboModel.refresh(AddBonConsumPanel.this.stockLogic.getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "AddBonConsumPanel_stocks";
            }
        }, 26);
        this.codbareField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AddBonConsumPanel.this.handleKey(e.getKeyCode(), AddBonConsumPanel.this.codbareField);
            }
        });
    }

    protected void handleKey(int keyCode, JTextField codBareField) {
        switch (keyCode) {
            case 10: {
                this.detaliiLot.setText("");
                String barcode = codBareField.getText().trim();
                if (Validators.correctString(barcode)) {
                    if (Utils.isCodLot(barcode)) {
                        Lot lot = StockLogic.getInstance().getLotByIdCodbareCommit(barcode);
                        if (lot == null) {
                            DialogUtils.errorDialog(this, "Lot negasit", LangRoAll.nuPotContinua);
                        } else {
                            this.idLot = lot.getId();
                            this.detaliiLot.setText(lot.getNr() + " ; Expira la " + Formatters.DATE_FORMAT_RO.format(lot.getExpirare()));
                            int idStock = lot.getIdStock();
                            Stock stock = this.stockLogic.getStockById(idStock);
                            Product produsFinit = this.stockLogic.getProductForStock(idStock);
                            if (produsFinit != null) {
                                Vector<String> allCodesForProduct = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(produsFinit.getId());
                                PowerSearchStock pss = new PowerSearchStock(stock, allCodesForProduct);
                                this.produse.setSelectedItem(pss);
                            } else {
                                this.produse.setSelectedItem(stock);
                            }
                        }
                    } else {
                        int idStock;
                        Product produsFinit = NomeclaturaLogic.getInstance().getProductByCodBare(barcode);
                        if (produsFinit == null) {
                            String message = Utils.getTranslation(LangRoAll.produsNegasit, new String[0]) + " " + barcode;
                            DialogUtils.errorDialog(this, message, LangRoAll.atentie);
                            codBareField.setText("");
                            codBareField.requestFocus();
                        } else if (produsFinit != null && (idStock = this.stockLogic.getIdStockForProductId(produsFinit.getId())) > 0) {
                            Stock stock = this.stockLogic.getStockById(idStock);
                            if (stock != null) {
                                Vector<String> allCodesForProduct = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(produsFinit.getId());
                                PowerSearchStock pss = new PowerSearchStock(stock, allCodesForProduct);
                                this.produse.setSelectedItem(pss);
                            } else {
                                String message = Utils.getTranslation(LangRoAll.produsNegasit, new String[0]) + " " + barcode;
                                DialogUtils.errorDialog(this, message, LangRoAll.atentie);
                            }
                        }
                    }
                }
                codBareField.setText("");
                codBareField.requestFocus();
                break;
            }
        }
    }

    public void setBonToEdit(BonConsum toEdit) {
        this.bonConsum = toEdit;
        this.magazie.setSelectedItem(this.stockLogic.getMagazieById(toEdit.getIdMagazie()));
        this.data.setValue((Date)toEdit.getDateadd());
        this.time.setText(DateUtils.getTimeFromDate(toEdit.getDateadd()));
        Vector items = this.stockLogic.getBonConsumItems(toEdit.getId());
        this.itemsTm.getData().removeAllElements();
        this.itemsTm.getData().addAll(items);
        this.itemsTm.fireTableDataChanged();
        this.totalGeneral = toEdit.getTotal();
        this.observatii.setText(toEdit.getObservatii());
        this.nrDocInput.setText(toEdit.getNrBonConsum() + "");
        this.updateTotals();
    }

    public SwitchToList getAction() {
        return this.action;
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    public AddBonConsumPanel(JPanel parent) {
        this.parent = parent;
        this.stockLogic = StockLogic.getInstance();
        this.init();
    }

    private void init() {
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.produse = new XComboBox(this.xStocksComboModel);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        JPanel dateFactura = this.getFacturaPanel();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)dateFactura, c);
        c.weightx = 1.0;
        JPanel dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        JPanel nirTable = this.getTablePanel();
        result.add((Component)nirTable, c);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddBonConsumPanel.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "AddTransferPanel_magazii";
            }
        }, 27);
        this.refreshMagaziiCombo();
        return result;
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.codBare), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.codbareField = new JTextField(13);
        result.add((Component)this.codbareField, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.detalii), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.detaliiLot = new JLabel();
        result.add((Component)this.detaliiLot, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.produse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        c.gridy += 2;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddBonConsumPanel.this.addEntry();
            }
        });
        result.add((Component)this.adauga, c);
        this.initFields();
        return result;
    }

    private void refreshMagaziiCombo() {
        AddBonConsumPanel addBonConsumPanel = this;
        Vector<Magazie> magazii = addBonConsumPanel.stockLogic.getInstance().getMagazii();
        ComboUtils.replaceItemsForCombo(this.magazie, magazii, false);
    }

    private void initFields() {
        this.cantitate.setText("");
        this.detaliiLot.setText("");
        this.idLot = -1;
    }

    private JPanel getFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date bon consum"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        this.magazie = new JComboBox();
        c.gridwidth = 2;
        result.add((Component)this.magazie, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        this.data = new MDateEntryField();
        this.data.setValue(new Date());
        this.data.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Alege data");
        result.add((Component)this.data, c);
        ++c.gridx;
        this.time = new JTextField();
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        this.nrDocInput = new JTextField();
        if (VpConfig.getInstance().bonConsumNrDocManual) {
            ++c.gridy;
            c.gridx = 0;
            result.add((Component)new JLabel(LangRoAll.nrDoc), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            result.add((Component)this.nrDocInput, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.observatii), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.observatii = new JTextArea();
        this.observatii.setMaximumSize(new Dimension(this.magazie.getSize().width, result.getHeight()));
        this.observatii.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (AddBonConsumPanel.this.observatii.getText().length() > 50) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Ati atins numarul maxim de caractere permise pentru observatii!", LangRoAll.eroare);
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.observatii.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        result.add((Component)this.observatii, c);
        return result;
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalFacturaCuTva = new JLabel("0");
        result.add((Component)this.totalFacturaCuTva, c);
        ++c.gridy;
        result.add((Component)new JLabel("* : reprezinta suma din loturi multiple"), c);
        ++c.gridy;
        result.add((Component)new JLabel("** : reprezinta calcul pe baza sumelor (*) din loturi multiple"), c);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        final AddBonConsumPanel parent = this;
        ++c.gridx;
        JButton tipareste = new JButton("Tipareste");
        tipareste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddBonConsumPanel.this.bonConsum == null || AddBonConsumPanel.this.bonConsum.getNrBonConsum() == null) {
                    DialogUtils.errorDialog(parent, "Intai salvati, apoi tipariti", LangRoAll.nuPotContinua);
                    return;
                }
                if (DialogUtils.confirmDialog(parent, "Verificati valorile de pe bonurile de consum inainte de a inchide luna ", "Atentie!!")) {
                    Date d = DateUtils.setTimeToDate(parent, AddBonConsumPanel.this.data, AddBonConsumPanel.this.time);
                    if (d == null) {
                        return;
                    }
                    Magazie m = (Magazie)AddBonConsumPanel.this.magazie.getSelectedItem();
                    AddBonConsumPanel.this.stockLogic.printBonConsum(AddBonConsumPanel.this.itemsTm.getData(), "CONSUM", m.getLabel(), Config.getInstance().getString("societate"), d, "" + AddBonConsumPanel.this.bonConsum.getNrBonConsum(), 2);
                }
            }
        });
        result.add((Component)tipareste, c);
        final AddBonConsumPanel panel = this;
        ++c.gridx;
        JButton proceseaza = new JButton("Salveaza");
        proceseaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Date d = DateUtils.setTimeToDate(parent, AddBonConsumPanel.this.data, AddBonConsumPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie m = (Magazie)AddBonConsumPanel.this.magazie.getSelectedItem();
                String obs = AddBonConsumPanel.this.observatii.getText();
                if (AddBonConsumPanel.this.bonConsum == null) {
                    int nrDoc = -1;
                    if (VpConfig.getInstance().bonConsumNrDocManual) {
                        String nrDocInputText = AddBonConsumPanel.this.nrDocInput.getText();
                        if (!Validators.correctInteger(nrDocInputText)) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu ati introldus numarul de document", LangRoAll.eroare);
                            return;
                        }
                        nrDoc = Integer.valueOf(nrDocInputText);
                    } else {
                        nrDoc = RegistreLogic.getInstance().getNewNumberForRegistru(RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
                    }
                    int idDocument = AddBonConsumPanel.this.stockLogic.adaugaBonConsum(m.getId(), new Timestamp(d.getTime()), AddBonConsumPanel.this.itemsTm.getData(), "Bon consum", AddBonConsumPanel.this.fiscal, AddBonConsumPanel.this.totalGeneral, nrDoc, obs);
                    if (idDocument <= 0) {
                        DialogUtils.htmlOKDialog(parent, "Adaugare neefectuata", LangRoAll.operatieEsuata);
                        return;
                    }
                    AddBonConsumPanel.this.resetFields();
                } else {
                    int nrdoc = AddBonConsumPanel.this.bonConsum.getNrBonConsum();
                    AddBonConsumPanel.this.stockLogic.updateBonConsum(AddBonConsumPanel.this.bonConsum.getDateadd(), AddBonConsumPanel.this.bonConsum.getId(), m.getId(), new Timestamp(d.getTime()), AddBonConsumPanel.this.itemsTm.getData(), panel, AddBonConsumPanel.this.fiscal, nrdoc, AddBonConsumPanel.this.totalGeneral, obs);
                    AddBonConsumPanel.this.resetFields();
                    AddBonConsumPanel.this.bonConsum = null;
                    AddBonConsumPanel.this.action.doAction();
                }
            }
        });
        result.add((Component)proceseaza, c);
        ++c.gridx;
        JButton renunta = new JButton("Renunta");
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddBonConsumPanel.this.resetFields();
                if (AddBonConsumPanel.this.bonConsum != null) {
                    AddBonConsumPanel.this.bonConsum = null;
                    AddBonConsumPanel.this.action.doAction();
                }
            }
        });
        result.add((Component)renunta, c);
        return result;
    }

    private void resetFields() {
        this.initFields();
        Vector data = this.itemsTm.getData();
        if (data != null) {
            data.removeAllElements();
        }
        this.itemsTm.fireTableDataChanged();
        this.totalGeneral = 0.0;
        this.nrDocInput.setText("");
        this.observatii.setText("");
        this.updateTotals();
    }

    private void addEntry() {
        double cant = 0.0;
        Stock stock = (Stock)this.produse.getSelectedItem();
        String cantS = this.cantitate.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this.parent, "Cantitatea trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        cant = Utils.parseDouble(cantS);
        if (cant <= 0.0) {
            DialogUtils.errorDialog(this.parent, "Cantitatea trebuie sa fie > 0", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        BonConsumItem sti = new BonConsumItem();
        sti.setCantitate(cant);
        sti.setIdStock(stock.getId());
        sti.setIdLot(this.idLot);
        String denumire = stock.getLabel();
        sti.setDenumire(denumire);
        Vector entries = this.itemsTm.getData();
        entries.add(sti);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    private void updateTotals() {
        this.totalGeneral = 0.0;
        for (int i = 0; i < this.itemsTm.getData().size(); ++i) {
            BonConsumItem bonConsumItem = (BonConsumItem)this.itemsTm.getData().elementAt(i);
            this.totalGeneral += bonConsumItem.getValoareAchizitie();
        }
        this.totalFacturaCuTva.setText(Utils.getString2Decimals(this.totalGeneral));
    }

    private JPanel getTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date bon consum"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                BonConsumItem e = (BonConsumItem)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getDenumire();
                    }
                    case 1: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getPretAcz());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getValoareAchizitie());
                    }
                }
                return null;
            }
        });
        JTable table = new JTable(this.itemsTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(AddBonConsumPanel.this.parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                    AddBonConsumPanel.this.eraseEntry(selRow);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }

    public void addBonEntries(Vector bce) {
        this.itemsTm.getData().addAll(bce);
        this.itemsTm.fireTableDataChanged();
    }

    public void cleanup() {
        this.magazie.removeAllItems();
    }

    public void setDate(Date d) {
        this.data.setValue(d);
    }

    public void setTime(String s) {
        this.time.setText(s);
    }
}

