/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.CerereAprovizionareEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.AprovizionareCellRenderer;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.XComboSelectDialog;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AprovizionareReport
extends AbstractReportPanel
implements CleanupRequired {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JComboBox _productsComboBox;
    private JComboBox statusCombo;
    private JComboBox furnizori;
    private JComboBox operator;
    private JComboBox supervizor;
    private Vector selectedItems = new Vector();
    private JLabel numarLabel;
    private JLabel selectateLabel;
    private JButton stergeSelectia;
    private JButton invertSelection;
    private JButton asociazaFurnizor;
    private JButton aproba;
    private JButton creareComanda;
    private static final String[] columns = new String[]{Utils.getTranslation(LangRoAll.magazie, new String[0]), Utils.getTranslation(LangRoAll.furnizor, new String[0]), LangRoAll.produs, Utils.getTranslation(LangRoAll.aprovizionareComandaAcum, new String[0]), Utils.getTranslation(LangRoAll.stocActualMagazie, new String[0]), Utils.getTranslation(LangRoAll.stocActualTotal, new String[0]), Utils.getTranslation(LangRoAll.pret), Utils.getTranslation(LangRoAll.status), Utils.getTranslation(LangRoAll.nrZileAprovizionare, new String[0]), Utils.getTranslation(LangRoAll.aprovizionareConsumReferinta, new String[0]), Utils.getTranslation(LangRoAll.aprovizionareMedieComanda, new String[0]), Utils.getTranslation(LangRoAll.aprovizionareDejaComandat, new String[0]), LangRoAll.operator, LangRoAll.supervizor, LangRoAll.data};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, Double.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object admin;
        Object s3;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.statusCombo)) {
            s3 = (StockLogic.APROVIZIONARE_STATUS)((Object)this.statusCombo.getSelectedItem());
            result.put(Constants.STATUS, s3);
            this.printCriteria.put(Constants.STATUS, s3);
        } else {
            this.printCriteria.remove(Constants.STATUS);
        }
        if (ComboUtils.anythingButAllSelected(this.operator)) {
            s3 = (User)this.operator.getSelectedItem();
            result.put("user", s3);
            this.printCriteria.put(LangRoAll.operator, ((User)s3).getName());
        } else {
            this.printCriteria.remove(LangRoAll.operator);
        }
        if (ComboUtils.anythingButAllSelected(this.supervizor)) {
            admin = (User)this.supervizor.getSelectedItem();
            result.put("user_bo", admin);
            this.printCriteria.put(LangRoAll.supervizor, admin);
        } else {
            this.printCriteria.remove(LangRoAll.supervizor);
        }
        if (ComboUtils.anythingButAllSelected(this.furnizori)) {
            admin = (Client)this.furnizori.getSelectedItem();
            result.put("Furnizor", admin);
            this.printCriteria.put("Furnizor", admin);
        } else {
            this.printCriteria.remove("Furnizor");
        }
        return result;
    }

    @Override
    public void printReport() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printPreview() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().getReportCerereAprovizionare(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return "Raport aprovizionare";
    }

    @Override
    public AbstractTM buildTableModel() {
        final Hashtable magaziiCache = new Hashtable();
        final Hashtable usersCache = new Hashtable();
        final Hashtable stocksCache = new Hashtable();
        final Hashtable clientsCache = new Hashtable();
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                CerereAprovizionareEntry se = (CerereAprovizionareEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 3: {
                        Double toSet = (Double)aValue;
                        se.setCantitateCeruta(toSet);
                        StockLogic.getInstance().updateCerereAprovizionare(se);
                        AprovizionareReport.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                CerereAprovizionareEntry se = (CerereAprovizionareEntry)AprovizionareReport.this.data.elementAt(rowIndex);
                if (columnIndex == 3) {
                    return se.getStatus() == StockLogic.APROVIZIONARE_STATUS.NOUA || se.getStatus() == StockLogic.APROVIZIONARE_STATUS.ALES_FURNIZOR;
                }
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                CerereAprovizionareEntry se = (CerereAprovizionareEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                int idOperator = se.getOperator();
                User operator = (User)usersCache.get(idOperator);
                if (operator == null) {
                    operator = UsersLogic.getInstance().getUserById(idOperator);
                    usersCache.put(idOperator, operator);
                }
                String supers = "";
                int idSupervizor = se.getSupervizor();
                if (idSupervizor > 0) {
                    User supervizor = (User)usersCache.get(idSupervizor);
                    if (supervizor == null) {
                        supervizor = UsersLogic.getInstance().getUserById(idSupervizor);
                        usersCache.put(idSupervizor, supervizor);
                    }
                    supers = supervizor.getLogin();
                }
                int idMagazie = se.getIdMagazie();
                String mag = LangRoAll.toate;
                if (idMagazie > 0) {
                    Magazie m = (Magazie)magaziiCache.get(idMagazie);
                    if (m == null) {
                        m = StockLogic.getInstance().getMagazieById(idMagazie);
                        magaziiCache.put(m.getId(), m);
                    }
                    mag = m.getLabel();
                }
                int idClient = se.getIdFurnizor();
                String client = "";
                if (idClient > 0) {
                    Client c = (Client)clientsCache.get(idClient);
                    if (c == null) {
                        c = ClientLogic.getInstance().getClientById(idClient);
                        clientsCache.put(idClient, c);
                    }
                    client = c.toString();
                }
                int idStock = se.getIdStock();
                String produs = "";
                Stock stock = (Stock)stocksCache.get(idStock);
                if (stock == null) {
                    stock = StockLogic.getInstance().getStockById(idStock);
                    stocksCache.put(idStock, stock);
                }
                produs = stock.getLabel();
                switch (columnIndex) {
                    case 0: {
                        return mag;
                    }
                    case 1: {
                        return client;
                    }
                    case 2: {
                        return produs;
                    }
                    case 3: {
                        return se.getCantitateCeruta();
                    }
                    case 4: {
                        return se.getCantitateExistentaMagazie();
                    }
                    case 5: {
                        return se.getCantitateExistentaTotal();
                    }
                    case 6: {
                        return se.getPretNegociat();
                    }
                    case 7: {
                        return se.getStatus().toString();
                    }
                    case 8: {
                        return se.getNrZileComanda();
                    }
                    case 9: {
                        return se.getCantitateIesitaReferinta();
                    }
                    case 10: {
                        return se.getCantitateIntrataMediePerComandaReferinta();
                    }
                    case 11: {
                        return se.getCantitateDejaComandata();
                    }
                    case 12: {
                        return operator;
                    }
                    case 13: {
                        return supers;
                    }
                    case 14: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(se.getDataCerere());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    private void clearSelection() {
        this.selectedItems.clear();
        this.selectateLabel.setText("0");
        for (int i = 0; i < this.data.size(); ++i) {
            CerereAprovizionareEntry analizeReportEntry = (CerereAprovizionareEntry)this.data.elementAt(i);
            analizeReportEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.add(new JLabel("Nr linii"));
        this.numarLabel = new JLabel("");
        result.add(this.numarLabel);
        result.add(new JLabel("Selectate"));
        this.selectateLabel = new JLabel("");
        result.add(this.selectateLabel);
        final AprovizionareReport parent = this;
        this.invertSelection = new JButton("Invert selection");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected = 0;
                for (int i = 0; i < AprovizionareReport.this.data.size(); ++i) {
                    CerereAprovizionareEntry pve = (CerereAprovizionareEntry)AprovizionareReport.this.data.elementAt(i);
                    if (pve.isSelected()) {
                        pve.setSelected(false);
                        AprovizionareReport.this.selectedItems.remove(pve);
                    } else {
                        AprovizionareReport.this.selectedItems.add(pve);
                        pve.setSelected(true);
                    }
                    if (!pve.isSelected()) continue;
                    ++selected;
                }
                AprovizionareReport.this.selectateLabel.setText(selected + "");
                AprovizionareReport.this.tm.fireTableDataChanged();
            }
        });
        result.add(this.invertSelection);
        this.stergeSelectia = new JButton("Sterge selectia");
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AprovizionareReport.this.clearSelection();
            }
        });
        result.add(this.stergeSelectia);
        this.asociazaFurnizor = new JButton("1. Asociaza furnizor");
        this.asociazaFurnizor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_manager_aprovizionare")) {
                    Vector<CerereAprovizionareEntry> deAprobat = new Vector<CerereAprovizionareEntry>();
                    for (int i = 0; i < AprovizionareReport.this.selectedItems.size(); ++i) {
                        CerereAprovizionareEntry analizeReportEntry = (CerereAprovizionareEntry)AprovizionareReport.this.selectedItems.elementAt(i);
                        if (!analizeReportEntry.getStatus().equals((Object)StockLogic.APROVIZIONARE_STATUS.NOUA)) continue;
                        deAprobat.add(analizeReportEntry);
                    }
                    String text = "Asociem furnizorul la  " + deAprobat.size() + " cereri";
                    if (DialogUtils.confirmDialog(parent, text, LangRoAll.confirmare)) {
                        XComboSelectDialog dia = new XComboSelectDialog(GuiUtils.currentFrame, "", Utils.getTranslation(LangRoAll.furnizor, new String[0]), ClientPersJuridica.class.getName(), ContaLogic.getInstance().getFurnizori(1));
                        ClientPersJuridica selected = (ClientPersJuridica)dia.getSelected();
                        if (selected != null) {
                            CerereAprovizionareEntry cerere;
                            int i;
                            Vector<Integer> stocuriDeCerutPret = new Vector<Integer>();
                            for (i = 0; i < deAprobat.size(); ++i) {
                                cerere = (CerereAprovizionareEntry)deAprobat.elementAt(i);
                                stocuriDeCerutPret.add(cerere.getIdStock());
                            }
                            for (i = 0; i < deAprobat.size(); ++i) {
                                cerere = (CerereAprovizionareEntry)deAprobat.elementAt(i);
                                cerere.setIdFurnizor(selected.getId());
                                Double pret = 1.0;
                                if (pret == null) continue;
                                cerere.setPretNegociat(pret);
                                cerere.setStatus(StockLogic.APROVIZIONARE_STATUS.ALES_FURNIZOR);
                                cerere.setSupervizor(AdministrationPanel.loggedUser.getId());
                                StockLogic.getInstance().updateCerereAprovizionare(cerere);
                            }
                            DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                        } else {
                            DialogUtils.errorDialog(parent, "Nu ati ales un furnizor", LangRoAll.nuPotContinua);
                        }
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Nu aveti acces la aceasta functie", LangRoAll.nuPotContinua);
                }
                AprovizionareReport.this.stergeSelectia.doClick();
            }
        });
        result.add(this.asociazaFurnizor);
        this.aproba = new JButton("2. Aproba ");
        this.aproba.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_manager_aprovizionare")) {
                    Vector<CerereAprovizionareEntry> deAprobat = new Vector<CerereAprovizionareEntry>();
                    for (int i = 0; i < AprovizionareReport.this.selectedItems.size(); ++i) {
                        CerereAprovizionareEntry analizeReportEntry = (CerereAprovizionareEntry)AprovizionareReport.this.selectedItems.elementAt(i);
                        if (!analizeReportEntry.getStatus().equals((Object)StockLogic.APROVIZIONARE_STATUS.ALES_FURNIZOR)) continue;
                        deAprobat.add(analizeReportEntry);
                    }
                    String text = "Aprobam " + deAprobat.size() + " cereri";
                    if (DialogUtils.confirmDialog(parent, text, LangRoAll.confirmare)) {
                        for (int i = 0; i < deAprobat.size(); ++i) {
                            CerereAprovizionareEntry cerere = (CerereAprovizionareEntry)deAprobat.elementAt(i);
                            cerere.setStatus(StockLogic.APROVIZIONARE_STATUS.APROBATA);
                            cerere.setSupervizor(AdministrationPanel.loggedUser.getId());
                            StockLogic.getInstance().updateCerereAprovizionare(cerere);
                        }
                        DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Nu aveti acces la aceasta functie", LangRoAll.nuPotContinua);
                }
                AprovizionareReport.this.stergeSelectia.doClick();
            }
        });
        result.add(this.aproba);
        this.creareComanda = new JButton("3. Creare comanda");
        this.creareComanda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_manager_aprovizionare")) {
                    Vector<CerereAprovizionareEntry> deComandat = new Vector<CerereAprovizionareEntry>();
                    for (int i = 0; i < AprovizionareReport.this.selectedItems.size(); ++i) {
                        CerereAprovizionareEntry analizeReportEntry = (CerereAprovizionareEntry)AprovizionareReport.this.selectedItems.elementAt(i);
                        if (!analizeReportEntry.getStatus().equals((Object)StockLogic.APROVIZIONARE_STATUS.APROBATA)) continue;
                        deComandat.add(analizeReportEntry);
                    }
                    String text = "Creem comanda pentru " + deComandat.size() + " cereri";
                    if (DialogUtils.confirmDialog(parent, text, LangRoAll.confirmare)) {
                        Hashtable<Integer, Vector<CerereAprovizionareEntry>> peFurnizori = new Hashtable<Integer, Vector<CerereAprovizionareEntry>>();
                        for (int i = 0; i < deComandat.size(); ++i) {
                            CerereAprovizionareEntry cerere = (CerereAprovizionareEntry)deComandat.elementAt(i);
                            Integer idFurnizor = cerere.getIdFurnizor();
                            Vector<CerereAprovizionareEntry> comandaLaFurnizorulCurent = (Vector<CerereAprovizionareEntry>)peFurnizori.get(idFurnizor);
                            if (comandaLaFurnizorulCurent == null) {
                                comandaLaFurnizorulCurent = new Vector<CerereAprovizionareEntry>();
                                peFurnizori.put(idFurnizor, comandaLaFurnizorulCurent);
                            }
                            comandaLaFurnizorulCurent.add(cerere);
                        }
                        Iterator keys = peFurnizori.keySet().iterator();
                        if (keys.hasNext()) {
                            Integer idFurnizor = (Integer)keys.next();
                            Client furnizor = ClientLogic.getInstance().getClientById(idFurnizor);
                            Vector cereri = (Vector)peFurnizori.get(idFurnizor);
                            StockLogic.getInstance().doCerereAprovizionare(cereri, furnizor);
                            DialogUtils.okDialog(parent, "Comanda a fost adaugata in Adaugare NIR . NU TRECETI MAI DEPARTE PANA NU FINALIZATI COMANDA !!", LangRoAll.atentie);
                            for (int i = 0; i < deComandat.size(); ++i) {
                                CerereAprovizionareEntry cerere = (CerereAprovizionareEntry)deComandat.elementAt(i);
                                cerere.setStatus(StockLogic.APROVIZIONARE_STATUS.COMANDATA);
                                cerere.setSupervizor(AdministrationPanel.loggedUser.getId());
                                StockLogic.getInstance().updateCerereAprovizionare(cerere);
                            }
                        }
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Nu aveti acces la aceasta functie", LangRoAll.nuPotContinua);
                }
                AprovizionareReport.this.stergeSelectia.doClick();
            }
        });
        result.add(this.creareComanda);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.furnizor, new String[0])), c);
        ++c.gridx;
        this.furnizori = new JComboBox();
        result.add((Component)this.furnizori, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.operator)), c);
        ++c.gridx;
        this.operator = new JComboBox();
        result.add((Component)this.operator, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.supervizor)), c);
        ++c.gridx;
        this.supervizor = new JComboBox();
        result.add((Component)this.supervizor, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel statusLabel = new JLabel(LangRoAll.status);
        result.add((Component)statusLabel, c);
        ++c.gridx;
        this.statusCombo = new JComboBox();
        result.add((Component)this.statusCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.numarLabel.setText(this.data.size() + "");
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        GuiUtils.updateJTableColumns(this.table, new AprovizionareCellRenderer(this.tm));
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                CerereAprovizionareEntry pve = (CerereAprovizionareEntry)AprovizionareReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!pve.isSelected()) {
                        AprovizionareReport.this.selectedItems.add(pve);
                        AprovizionareReport.this.selectateLabel.setText(AprovizionareReport.this.selectedItems.size() + "");
                    } else {
                        AprovizionareReport.this.selectedItems.remove(pve);
                        AprovizionareReport.this.selectateLabel.setText(AprovizionareReport.this.selectedItems.size() + "");
                    }
                    pve.setSelected(!pve.isSelected());
                    AprovizionareReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.statusCombo.addItem("All");
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.NOUA);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.ALES_FURNIZOR);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.APROBATA);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.COMANDATA);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.RECEPTIONATA);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.RECEPTIONATA_PARTIAL);
        this.statusCombo.addItem(StockLogic.APROVIZIONARE_STATUS.ANULATA);
        ComboUtils.replaceItemsForCombo(this.operator, (Collection)UsersLogic.getInstance().getAllUsers(), true);
        ComboUtils.replaceItemsForCombo(this.supervizor, UsersLogic.getInstance().getUsersInGroup("group_manager_aprovizionare"), true);
        ComboUtils.replaceItemsForCombo(this.furnizori, ContaLogic.getInstance().getFurnizori(1), true);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

