/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class BonConsumReport
extends AbstractReportPanel
implements CleanupRequired {
    private StockLogic logic;
    private double totalPv;
    private JLabel totalPvLabel;
    private JComboBox magazie;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    protected DoubleClicked action;
    public static final String[] columns = new String[]{"Nr doc", "Magazie", LangRoAll.data, LangRoAll.total, LangRoAll.observatii};

    public BonConsumReport() {
        this.logic = StockLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.magazie)) {
            Magazie sursa = (Magazie)this.magazie.getSelectedItem();
            result.put("id_magazie", Integer.valueOf(sursa.getId()));
        } else {
            result.put("id_magazie", Integer.valueOf(-1));
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazie = new JComboBox();
        result.add((Component)this.magazie, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                BonConsum st = (BonConsum)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return st.getNrBonConsum() + "";
                    }
                    case 1: {
                        return st.getMagazie();
                    }
                    case 2: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(st.getDateadd());
                    }
                    case 3: {
                        return Utils.getString2Decimals(st.getTotal());
                    }
                    case 4: {
                        return st.getObservatii();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Total pret achizitie"), c);
        ++c.gridx;
        this.totalPvLabel = new JLabel("");
        result.add((Component)this.totalPvLabel, c);
        return result;
    }

    @Override
    public String getName() {
        return "Bonuri consum";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getBonuriConsum(criteria);
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalPvLabel.setText(Utils.getString2Decimals(this.totalPv));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    BonConsum entry = (BonConsum)o;
                    try {
                        int column = 0;
                        sheet.addCell((WritableCell)new Number(column, row, (double)entry.getNrBonConsum().intValue()));
                        Label label = new Label(++column, row, entry.getMagazie());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, Formatters.DATE_AND_TIME_FORMAT.format(entry.getDateadd()));
                        sheet.addCell((WritableCell)label);
                        int n = ++column;
                        sheet.addCell((WritableCell)new Number(n, row, entry.getTotal()));
                        int n2 = ++column;
                        ++column;
                        label = new Label(n2, row, entry.getObservatii());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return BonConsumReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.refreshMagaziiCombo();
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return "Bonuri consum";
            }

            @Override
            public Hashtable getCriteria() {
                return BonConsumReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                BonConsum st = (BonConsum)row;
                switch (column) {
                    case 0: {
                        return st.getNrBonConsum() + "";
                    }
                    case 1: {
                        return st.getMagazie();
                    }
                    case 2: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(st.getDateadd());
                    }
                    case 3: {
                        return Utils.getString2Decimals(st.getTotal());
                    }
                    case 4: {
                        return st.getObservatii();
                    }
                }
                return null;
            }
        };
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                BonConsumReport.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "TransferReport_magaziiChanged";
            }
        }, 27);
        final BonConsumReport panel = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final BonConsum bc = (BonConsum)BonConsumReport.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        BonConsumReport.this.action.doubleClicked(bc);
                        popup.setVisible(false);
                    }
                });
                popup.add(modifica);
                JMenuItem sterge = new JMenuItem("Sterge bon consum");
                sterge.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        boolean ok = DialogUtils.confirmDialog(panel, "Doriti sa stergeti acest bon consum", LangRoAll.confirmare);
                        if (ok) {
                            BonConsumReport.this.logic.deleteBonConsum(bc.getId(), panel, bc.getDateadd());
                        }
                        popup.setVisible(false);
                        BonConsumReport.this.raport();
                    }
                });
                popup.add(sterge);
                popup.setInvoker(BonConsumReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void refreshMagaziiCombo() {
        BonConsumReport bonConsumReport = this;
        Vector<Magazie> magazii = bonConsumReport.logic.getInstance().getMagazii();
        ComboUtils.replaceItemsForCombo(this.magazie, magazii, true);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void computeTotals(Vector items) {
        this.totalPv = 0.0;
        for (BonConsum element : items) {
            this.totalPv += element.getTotal();
        }
    }

    @Override
    public void cleanup() {
        this.magazie.removeAllItems();
    }
}

