/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.ConsumEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class ConsumReport
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{"Articol", LangRoAll.pret, LangRoAll.cantitate, "Valoare achizitie"};
    private JLabel totalAchizitie;
    private double totalAchizitieValue;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JComboBox magazii;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", Integer.valueOf(m.getId()));
            this.printCriteria.put("Magazie", m.getLabel());
        } else {
            result.put("id_magazie", Integer.valueOf(-1));
            this.printCriteria.remove("Magazie");
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, c);
        return buttonsPanel;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        AbstractTM tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ConsumEntry e = (ConsumEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getDenumire();
                    }
                    case 1: {
                        return Utils.getString2Decimals(e.getPretAchizitie());
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getValoareAchizitie());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total p. achizitie"), c);
        ++c.gridx;
        this.totalAchizitie = new JLabel("");
        result.add((Component)this.totalAchizitie, c);
        return result;
    }

    @Override
    public String getName() {
        return "Raport consum";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().getConsum(criteria, AdministrationPanel.loggedUser.getLanguage());
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ConsumEntry entry = (ConsumEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, entry.getDenumire());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getPretAchizitie()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getCantitate()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getValoareAchizitie()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ConsumReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void updateTotals(Vector items) {
        this.totalAchizitieValue = 0.0;
        for (ConsumEntry element : items) {
            this.totalAchizitieValue += element.getValoareAchizitie();
        }
        this.totalAchizitie.setText(Utils.getString2Decimals(this.totalAchizitieValue));
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii());
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ConsumReport.this.magazii, StockLogic.getInstance().getMagazii());
            }

            @Override
            public String getName() {
                return "ConsumReport_magazii";
            }
        }, 27);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 3: {
                        return ConsumReport.this.totalAchizitie.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return ConsumReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ConsumReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ConsumEntry sqv = (ConsumEntry)row;
                switch (column) {
                    case 0: {
                        return sqv.getDenumire();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sqv.getPretAchizitie());
                    }
                    case 2: {
                        return Utils.getString3Decimals(sqv.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(sqv.getValoareAchizitie());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
    }
}

