/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.WriteException;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.ConsumuriExcelProcessor;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ConsumuriPanel
extends AbstractReportPanel {
    private JComboBox tip;
    private JComboBox magazii;
    private JComboBox tipPret;
    private JLabel valIesita;
    private double iesitaAcz;
    private double iesitaVz;
    private Hashtable printCriteria = new Hashtable();
    private int tipP = 2;
    public static final String[] columns = new String[]{LangRoAll.produs, "UM", "Cant iesita", "Val iesita"};
    private MultiboxList tipConsum;
    private JCheckBox produseSterse;
    private JCheckBox produseFaraTranzactii;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        result.put("id_magazie", m.getId());
        this.printCriteria.put("Magazie", m.getId());
        String tipValue = (String)this.tip.getSelectedItem();
        if (tipValue.equalsIgnoreCase("Finit")) {
            result.put("finit_ingredient", 2);
        } else if (tipValue.equalsIgnoreCase("Ingredient")) {
            result.put("finit_ingredient", 1);
        } else {
            result.put("finit_ingredient", -1);
        }
        String priceType = (String)this.tipPret.getSelectedItem();
        if (priceType.equalsIgnoreCase("Achizitie")) {
            result.put("vanzare_achizitie", 2);
            this.tipP = 2;
        } else {
            result.put("vanzare_achizitie", 1);
            this.tipP = 1;
        }
        Vector selected = this.tipConsum.getSelectedItems();
        String printString = "";
        String dbString = "";
        for (int i = 0; i < selected.size(); ++i) {
            TipDocument tipDocument = (TipDocument)selected.elementAt(i);
            printString = printString + tipDocument;
            dbString = dbString + tipDocument.getTip();
            if (i >= selected.size() - 1) continue;
            printString = printString + ",";
            dbString = dbString + ",";
        }
        this.printCriteria.put("tip_document", printString);
        result.put("tip_document", dbString);
        boolean faraTranzactii = this.produseFaraTranzactii.isSelected();
        if (faraTranzactii) {
            result.put("Include produse fara tranzactii", 1);
            this.printCriteria.put("Include produse fara tranzactii", "");
        } else {
            this.printCriteria.remove("Include produse fara tranzactii");
        }
        boolean sterse = this.produseSterse.isSelected();
        if (sterse) {
            result.put("Include produse sterse", 1);
            this.printCriteria.put("Include produse sterse", "");
        } else {
            this.printCriteria.remove("Include produse sterse");
        }
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportGestiuneEntry e = (RaportGestiuneEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getProdus();
                    }
                    case 1: {
                        return e.getUm();
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantIesita());
                    }
                    case 3: {
                        return Utils.getString2Decimals(ConsumuriPanel.this.tip(e.getValIesitaAcz(), e.getValIesitaVz()));
                    }
                }
                return null;
            }
        });
        return tm;
    }

    private double tip(double acz, double vz) {
        return this.tipP == 2 ? acz : vz;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare iesita"), c);
        ++c.gridx;
        this.valIesita = new JLabel("");
        result.add((Component)this.valIesita, c);
        return result;
    }

    @Override
    public String getName() {
        return "Consumuri";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().generateRaportConsumuri(criteria, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        String preview = StockLogic.getInstance().generateConsumuriFoFile(this.data, m.getLabel(), this.getDataString(), this.tipP);
        PrintLogic.getInstance().printPreview(preview);
    }

    @Override
    public void printReport() {
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        String preview = StockLogic.getInstance().generateConsumuriFoFile(this.data, m.getLabel(), this.getDataString(), this.tipP);
        PrintLogic.getInstance().printPdf(preview, 1);
    }

    private String getDataString() {
        String start = (String)this.printCriteria.get(LangRoAll.start);
        String stop = (String)this.printCriteria.get(LangRoAll.stop);
        return "Data ________ , aferent " + start + " - " + stop;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.valIesita.setText(Utils.getString2Decimals(this.tip(this.iesitaAcz, this.iesitaVz)));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ConsumuriExcelProcessor(this.getName(), columns, this.tipP), this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii(), false);
        this.tip.addItem("All");
        this.tip.addItem("Finit");
        this.tip.addItem("Ingredient");
        this.tipPret.addItem("Achizitie");
        this.tipPret.addItem("Vanzare");
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ConsumuriPanel.this.magazii, StockLogic.getInstance().getMagazii(), false);
            }

            @Override
            public String getName() {
                return "ConsumuriReport_magaziiChanged";
            }
        }, 27);
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip document"), c);
        ++c.gridx;
        c.weightx = 1.0;
        Vector allItems = StockLogic.getInstance().getDocumentInterface().getTipDocumentConsum();
        this.tipConsum = new MultiboxList(allItems, 10);
        this.tipConsum.setSelectedItems(allItems, true);
        result.add((Component)this.tipConsum, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        result.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Finit/ingredient"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tip = new JComboBox();
        result.add((Component)this.tip, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret vanzare/achizitie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipPret = new JComboBox();
        result.add((Component)this.tipPret, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse sterse"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseSterse = new JCheckBox();
        result.add((Component)this.produseSterse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse fara tranzactii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseFaraTranzactii = new JCheckBox();
        result.add((Component)this.produseFaraTranzactii, c);
        return result;
    }

    private void computeTotals(Vector items) {
        this.iesitaAcz = 0.0;
        this.iesitaVz = 0.0;
        for (RaportGestiuneEntry element : items) {
            this.iesitaAcz += element.getValIesitaAcz();
            this.iesitaVz += element.getValIesitaVz();
        }
    }
}

