/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.FisaMagazieEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FisaMagaziePanel
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.data, Utils.getTranslation(LangRoAll.document, new String[0]), LangRoAll.pret, Utils.getTranslation(LangRoAll.intrare, new String[0]), Utils.getTranslation(LangRoAll.valoareIntrare, new String[0]), Utils.getTranslation(LangRoAll.iesire, new String[0]), Utils.getTranslation(LangRoAll.valoareIesire, new String[0]), Utils.getTranslation(LangRoAll.stoc, new String[0]), Utils.getTranslation(LangRoAll.valoareStoc, new String[0])};
    private StockLogic stockLogic;
    private JComboBox magazii;
    private JComboBox tipPret;
    private JComboBox tipComanda;
    private XComboBox stocks;
    private FilterableComboBoxModel xStocksComboModel;
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private double totalIntrare;
    private double totalValIntrarePa;
    private double totalValIntrarePv;
    private double totalIesire;
    private double totalValIesirePa;
    private double totalValIesirePv;
    private double totalStoc;
    private double totalValStocPa;
    private double totalValStocPv;
    private JLabel intrareField;
    private JLabel valIntrareField;
    private JLabel iesireField;
    private JLabel valIesireField;
    private JLabel stocField;
    private JLabel valStocField;

    public FisaMagaziePanel() {
        this.stockLogic = StockLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", m.getId());
            this.printCriteria.put("Magazie", m.getLabel());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        Stock s = (Stock)this.stocks.getSelectedItem();
        if (s == null) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.alegetiUnProdus, new String[0]), LangRoAll.nuPotContinua);
            return result;
        }
        result.put("id_stock_key", s.getId());
        this.printCriteria.put("Stoc", s.getLabel());
        String priceType = (String)this.tipPret.getSelectedItem();
        if (priceType.equalsIgnoreCase("Achizitie")) {
            result.put("vanzare_achizitie", 2);
            this.printCriteria.put("Tip pret", "Achizitie");
        } else {
            result.put("vanzare_achizitie", 1);
            this.printCriteria.put("Tip pret", "Vanzare");
        }
        if (this.tipComanda != null && ComboUtils.anythingButAllSelected(this.tipComanda)) {
            StockLogic.COMANDA_TYPE ct = (StockLogic.COMANDA_TYPE)((Object)this.tipComanda.getSelectedItem());
            result.put("Comanda Type", (Object)ct);
            this.printCriteria.put("Comanda Type", ct);
        } else {
            this.printCriteria.remove("Comanda Type");
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.stockLogic.getFisaMagazie(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        final String priceType = (String)this.tipPret.getSelectedItem();
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FisaMagazieEntry entry = (FisaMagazieEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getDocument());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(3, row, entry.getPretAchizitie()));
                        sheet.addCell((WritableCell)new Number(4, row, entry.getIntrata()));
                        if (priceType.equalsIgnoreCase("Achizitie")) {
                            sheet.addCell((WritableCell)new Number(5, row, entry.getValIntrataPa()));
                        } else {
                            sheet.addCell((WritableCell)new Number(5, row, entry.getValIntrataPv()));
                        }
                        sheet.addCell((WritableCell)new Number(6, row, entry.getIesita()));
                        if (priceType.equalsIgnoreCase("Achizitie")) {
                            sheet.addCell((WritableCell)new Number(7, row, entry.getValIesitaPa()));
                        } else {
                            sheet.addCell((WritableCell)new Number(7, row, entry.getValIesitaPv()));
                        }
                        sheet.addCell((WritableCell)new Number(8, row, entry.getStoc()));
                        if (priceType.equalsIgnoreCase("Achizitie")) {
                            sheet.addCell((WritableCell)new Number(9, row, entry.getValStocPa()));
                        } else {
                            sheet.addCell((WritableCell)new Number(9, row, entry.getValStocPv()));
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FisaMagaziePanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.fisaMagazie, new String[0]);
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FisaMagazieEntry sqv = (FisaMagazieEntry)data.elementAt(rowIndex);
                double valIntrata = 0.0;
                double valIesita = 0.0;
                double valStoc = 0.0;
                double pret = 0.0;
                String tipPret = (String)FisaMagaziePanel.this.printCriteria.get("Tip pret");
                if (tipPret.equals("Achizitie")) {
                    valIntrata = sqv.getValIntrataPa();
                    valIesita = sqv.getValIesitaPa();
                    valStoc = sqv.getValStocPa();
                    pret = sqv.getPretAchizitie();
                } else {
                    valIntrata = sqv.getValIntrataPv();
                    valIesita = sqv.getValIesitaPv();
                    valStoc = sqv.getValStocPv();
                    if (sqv.getIntrata() > 0.0) {
                        pret = valIntrata / sqv.getIntrata();
                    } else if (sqv.getIesita() > 0.0) {
                        pret = valIesita / sqv.getIesita();
                    } else if (valIntrata > 0.0) {
                        pret = 0.0;
                    }
                }
                switch (columnIndex) {
                    case 0: {
                        return sqv.getProdus();
                    }
                    case 1: {
                        return sqv.getData();
                    }
                    case 2: {
                        return sqv.getDocument();
                    }
                    case 3: {
                        return Utils.getFloatStringOrEmpty2Decimals(pret);
                    }
                    case 4: {
                        return Utils.getFloatStringOrEmpty3Decimals(sqv.getIntrata());
                    }
                    case 5: {
                        return Utils.getFloatStringOrEmpty2Decimals(valIntrata);
                    }
                    case 6: {
                        return Utils.getFloatStringOrEmpty3Decimals(sqv.getIesita());
                    }
                    case 7: {
                        return Utils.getFloatStringOrEmpty2Decimals(valIesita);
                    }
                    case 8: {
                        return Utils.getFloatStringOrEmpty3Decimals(sqv.getStoc());
                    }
                    case 9: {
                        return Utils.getFloatStringOrEmpty2Decimals(valStoc);
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.intrare, new String[0])), c);
        ++c.gridx;
        this.intrareField = new JLabel("");
        result.add((Component)this.intrareField, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.valoareIntrare, new String[0])), c);
        ++c.gridx;
        this.valIntrareField = new JLabel("");
        result.add((Component)this.valIntrareField, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.iesire, new String[0])), c);
        ++c.gridx;
        this.iesireField = new JLabel("");
        result.add((Component)this.iesireField, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.valoareIesire, new String[0])), c);
        ++c.gridx;
        this.valIesireField = new JLabel("");
        result.add((Component)this.valIesireField, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.stoc, new String[0])), c);
        ++c.gridx;
        this.stocField = new JLabel("");
        result.add((Component)this.stocField, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.valoareStoc, new String[0])), c);
        ++c.gridx;
        this.valStocField = new JLabel("");
        result.add((Component)this.valStocField, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel(Utils.getTranslation(LangRoAll.magazie, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        buttonsPanel.add((Component)new JLabel(Utils.getTranslation(LangRoAll.stoc, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.stocks = new XComboBox(this.xStocksComboModel);
        this.stocks.setPrototypeDisplayValue("111111111111111111111111111111111");
        buttonsPanel.add((Component)this.stocks, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel(Utils.getTranslation(LangRoAll.pretVanzareAchizitie, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipPret = new JComboBox();
        buttonsPanel.add((Component)this.tipPret, c);
        if (VpConfig.getInstance().futureStocksEnabled) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            buttonsPanel.add((Component)new JLabel(LangRoAll.tipComanda), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.tipComanda = new JComboBox();
            buttonsPanel.add((Component)this.tipComanda, c);
        }
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        String tipPret = (String)this.printCriteria.get("Tip pret");
        if (tipPret.equals("Achizitie")) {
            this.valIntrareField.setText(Utils.getString2Decimals(this.totalValIntrarePa));
            this.valIesireField.setText(Utils.getString2Decimals(this.totalValIesirePa));
            this.valStocField.setText(Utils.getString2Decimals(this.totalValStocPa));
        } else {
            this.valIntrareField.setText(Utils.getString2Decimals(this.totalValIntrarePv));
            this.valIesireField.setText(Utils.getString2Decimals(this.totalValIesirePv));
            this.valStocField.setText(Utils.getString2Decimals(this.totalValStocPv));
        }
        if (this.printCriteria.get("Stoc") != null) {
            this.stocField.setText(Utils.getString2Decimals(this.totalStoc));
            this.intrareField.setText(Utils.getString2Decimals(this.totalIntrare));
            this.iesireField.setText(Utils.getString2Decimals(this.totalIesire));
        } else {
            this.stocField.setText("-");
            this.intrareField.setText("-");
            this.iesireField.setText("-");
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, this.stockLogic.getMagazii());
        if (VpConfig.getInstance().futureStocksEnabled) {
            this.refreshTipComandaItems(true);
        }
        this.tipPret.addItem("Achizitie");
        this.tipPret.addItem("Vanzare");
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FisaMagaziePanel.this.xStocksComboModel.refresh(FisaMagaziePanel.this.stockLogic.getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "FisaMagaziePanel_stocks";
            }
        }, 26);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(FisaMagaziePanel.this.magazii, FisaMagaziePanel.this.stockLogic.getMagazii());
            }

            @Override
            public String getName() {
                return "StockViewPanel_magazii";
            }
        }, 27);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 2;
                    }
                    case 8: {
                        return 1;
                    }
                    case 9: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return FisaMagaziePanel.this.intrareField.getText();
                    }
                    case 5: {
                        return FisaMagaziePanel.this.valIntrareField.getText();
                    }
                    case 6: {
                        return FisaMagaziePanel.this.iesireField.getText();
                    }
                    case 7: {
                        return FisaMagaziePanel.this.valIesireField.getText();
                    }
                    case 8: {
                        return FisaMagaziePanel.this.stocField.getText();
                    }
                    case 9: {
                        return FisaMagaziePanel.this.valStocField.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return Utils.getTranslation(LangRoAll.fisaMagazie, new String[0]);
            }

            @Override
            public Hashtable getCriteria() {
                return FisaMagaziePanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FisaMagazieEntry sqv = (FisaMagazieEntry)row;
                double valIntrata = 0.0;
                double valIesita = 0.0;
                double valStoc = 0.0;
                double pret = 0.0;
                String tipPret = (String)FisaMagaziePanel.this.printCriteria.get("Tip pret");
                if (tipPret.equals("Achizitie")) {
                    valIntrata = sqv.getValIntrataPa();
                    valIesita = sqv.getValIesitaPa();
                    valStoc = sqv.getValStocPa();
                    pret = sqv.getPretAchizitie();
                } else {
                    valIntrata = sqv.getValIntrataPv();
                    valIesita = sqv.getValIesitaPv();
                    valStoc = sqv.getValStocPv();
                    pret = valIntrata / sqv.getIntrata();
                }
                switch (column) {
                    case 0: {
                        return sqv.getProdus();
                    }
                    case 1: {
                        return sqv.getData();
                    }
                    case 2: {
                        return sqv.getDocument();
                    }
                    case 3: {
                        return Utils.getString2Decimals(pret);
                    }
                    case 4: {
                        return Utils.getString3Decimals(sqv.getIntrata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(valIntrata);
                    }
                    case 6: {
                        return Utils.getString3Decimals(sqv.getIesita());
                    }
                    case 7: {
                        return Utils.getString2Decimals(valIesita);
                    }
                    case 8: {
                        return Utils.getString3Decimals(sqv.getStoc());
                    }
                    case 9: {
                        return Utils.getString2Decimals(valStoc);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void computeTotals(Vector items) {
        this.totalIntrare = 0.0;
        this.totalValIntrarePa = 0.0;
        this.totalValIntrarePv = 0.0;
        this.totalIesire = 0.0;
        this.totalValIesirePa = 0.0;
        this.totalValIesirePv = 0.0;
        this.totalStoc = 0.0;
        this.totalValStocPa = 0.0;
        this.totalValStocPv = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            FisaMagazieEntry o = (FisaMagazieEntry)items.elementAt(i);
            this.totalIntrare += o.getIntrata();
            this.totalIesire += o.getIesita();
            this.totalValIntrarePa += o.getValIntrataPa();
            this.totalValIntrarePv += o.getValIntrataPv();
            this.totalValIesirePa += o.getValIesitaPa();
            this.totalValIesirePv += o.getValIesitaPv();
            if (i != items.size() - 1) continue;
            this.totalStoc = o.getStoc();
            this.totalValStocPa = o.getValStocPa();
            this.totalValStocPv = o.getValStocPv();
        }
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
        this.tipPret.removeAllItems();
    }

    private void refreshTipComandaItems(boolean allValue) {
        this.tipComanda.removeAllItems();
        if (allValue) {
            this.tipComanda.addItem("All");
        }
        for (StockLogic.COMANDA_TYPE comandaType : StockLogic.COMANDA_TYPE.values()) {
            this.tipComanda.addItem(comandaType);
        }
    }
}

