/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.LoturiReportCellRenderer;
import ro.atreides.stocks.gui.LoturiReportEntry;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class LoturiReport
extends AbstractReportPanel
implements CleanupRequired {
    private JComboBox magazii;
    private JComboBox categorii;
    private JComboBox furnizori;
    private JComboBox grupareCombo;
    private JTextField codbareLot;
    private JTextField nrLotFurnizor;
    private XComboBox xStocks;
    private FilterableComboBoxModel xStocksComboModel;
    private Hashtable printCriteria = new Hashtable();
    public static final String[] columns = new String[]{Utils.getTranslation(LangRoAll.produs), Utils.getTranslation(LangRoAll.magazie, new String[0]), Utils.getTranslation(LangRoAll.stoc, new String[0]), "NrLotFurnizor", "DataExpirare", "DataReceptie", Utils.getTranslation(LangRoAll.furnizor, new String[0]), LangRoAll.codLot, "NrLotIntern", "Receptie"};
    private ReportInterface pdfReportInterface;
    private LoturiReportCellRenderer cellRenderer;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object m;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.printCriteria.put(LangRoAll.data, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date()));
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", ((Magazie)m).getId());
            this.printCriteria.put(LangRoAll.magazie, ((Magazie)m).getLabel());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove(LangRoAll.magazie);
        }
        if (ComboUtils.anythingButAllSelected(this.xStocks)) {
            m = (Stock)this.xStocks.getSelectedItem();
            result.put("id_stock_key", ((Stock)m).getId());
            this.printCriteria.put(LangRoAll.stoc, ((Stock)m).getLabel());
        } else {
            result.put("id_stock_key", -1);
            this.printCriteria.remove(LangRoAll.stoc);
        }
        if (ComboUtils.anythingButAllSelected(this.categorii)) {
            m = (Categorie)this.categorii.getSelectedItem();
            result.put("id_subcategory_key", ((Categorie)m).getId());
            this.printCriteria.put(LangRoAll.categorie, ((Categorie)m).getName());
        } else {
            result.put("id_subcategory_key", -1);
            this.printCriteria.remove(LangRoAll.categorie);
        }
        if (ComboUtils.anythingButAllSelected(this.furnizori)) {
            m = (Client)this.furnizori.getSelectedItem();
            result.put("Furnizor", ((Client)m).getId());
            this.printCriteria.put("Furnizor", m.toString());
        } else {
            result.put("Furnizor", -1);
            this.printCriteria.remove("Furnizor");
        }
        if (ComboUtils.anythingButAllSelected(this.grupareCombo)) {
            String g = (String)this.grupareCombo.getSelectedItem();
            result.put(Constants.GRUPARE_KEY, g);
            this.printCriteria.put(Constants.GRUPARE_KEY, g);
        } else {
            this.printCriteria.remove(Constants.GRUPARE_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().loturiReport(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    LoturiReportEntry sve = (LoturiReportEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column++, row, sve.getDenumireProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getMagazie()));
                        sheet.addCell((WritableCell)new Number(column++, row, sve.getStocExistent()));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getNrLotFurnizor()));
                        sheet.addCell((WritableCell)new Label(column++, row, Formatters.DATE_FORMAT_RO.format(sve.getDataExpirare())));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getDataReceptie() != null ? Formatters.DATE_FORMAT_RO.format(sve.getDataReceptie()) : "-"));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getNumeFurnizor()));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getCodbareLot()));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getIdLot() > 0 ? sve.getIdLot() + "" : "-"));
                        sheet.addCell((WritableCell)new Label(column++, row, sve.getDetaliiReceptie()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return LoturiReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Raport Loturi";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                LoturiReportEntry sve = (LoturiReportEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sve.getDenumireProdus();
                    }
                    case 1: {
                        return sve.getMagazie();
                    }
                    case 2: {
                        return Utils.getString3Decimals(sve.getStocExistent());
                    }
                    case 3: {
                        return sve.getNrLotFurnizor();
                    }
                    case 4: {
                        return Formatters.DATE_FORMAT_RO.format(sve.getDataExpirare());
                    }
                    case 5: {
                        return sve.getDataReceptie() != null ? Formatters.DATE_FORMAT_RO.format(sve.getDataReceptie()) : "-";
                    }
                    case 6: {
                        return sve.getNumeFurnizor();
                    }
                    case 7: {
                        return sve.getCodbareLot();
                    }
                    case 8: {
                        return sve.getIdLot() > 0 ? sve.getIdLot() + "" : "-";
                    }
                    case 9: {
                        return sve.getDetaliiReceptie();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][][grow]"));
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.stoc, new String[0])));
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.xStocks = new XComboBox(this.xStocksComboModel);
        buttonsPanel.add((Component)this.xStocks, "growx, span, wrap");
        this.categorii = new JComboBox();
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.furnizor, new String[0])));
        this.furnizori = new JComboBox();
        buttonsPanel.add((Component)this.furnizori, "growx, span, wrap");
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.magazie, new String[0])));
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, "growx, span 1");
        buttonsPanel.add(new JLabel(LangRoAll.grupare));
        this.grupareCombo = new JComboBox();
        buttonsPanel.add((Component)this.grupareCombo, "growx, span 1, wrap");
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        this.cellRenderer = new LoturiReportCellRenderer(this.tm);
        GuiUtils.updateJTableColumnSize(this.table, new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                return 1;
            }
        });
        TableColumnModel colModel = this.table.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(this.cellRenderer);
        }
        this.grupareCombo.addItem("Dupa lot furnizor");
        this.grupareCombo.addItem("Dupa lot intern");
        this.grupareCombo.addItem("Dupa lot furnizor si magazie");
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii());
        ComboUtils.replaceItemsForCombo(this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
        ComboUtils.replaceItemsForCombo(this.furnizori, StockLogic.getInstance().getStockInterface().getFurnizori(-1));
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 14;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                    case 6: {
                        return 5;
                    }
                    case 7: {
                        return 5;
                    }
                    case 8: {
                        return 4;
                    }
                    case 9: {
                        return 4;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return Utils.getTranslation(LangRoAll.raportStocuri, new String[0]);
            }

            @Override
            public Hashtable getCriteria() {
                return LoturiReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                LoturiReportEntry sve = (LoturiReportEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getDenumireProdus();
                    }
                    case 1: {
                        return sve.getMagazie();
                    }
                    case 2: {
                        return Utils.getString3Decimals(sve.getStocExistent());
                    }
                    case 3: {
                        return sve.getNrLotFurnizor();
                    }
                    case 4: {
                        return Formatters.DATE_FORMAT_RO.format(sve.getDataExpirare());
                    }
                    case 5: {
                        return sve.getDataReceptie() != null ? Formatters.DATE_FORMAT_RO.format(sve.getDataReceptie()) : "-";
                    }
                    case 6: {
                        return sve.getNumeFurnizor();
                    }
                    case 7: {
                        return sve.getCodbareLot();
                    }
                    case 8: {
                        return sve.getIdLot() > 0 ? sve.getIdLot() + "" : "-";
                    }
                    case 9: {
                        return sve.getDetaliiReceptie();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

