/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class MagaziiPanel
extends AbstractListPanel {
    private Magazie toEdit;
    private JTextField mpText;
    private JTextField contMP;
    private JTextField contMarfuri;
    private JTextField contTvaNeex;
    private JTextField contAdaos;
    private JCheckBox marfaCheck;
    private boolean showConturiFields = true;
    private boolean marfaDefault = false;

    public MagaziiPanel() {
    }

    public MagaziiPanel(boolean showConturiFields, boolean marfaDefault) {
        this.showConturiFields = showConturiFields;
        this.marfaDefault = marfaDefault;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Magazie", "Cont MP", "Cont Marfuri", "Cont TVA neex", "Cont Adaos", "Marfa"};
    }

    @Override
    public Class[] buildTypes() {
        Class[] result = new Class[7];
        result[0] = String.class;
        result[1] = String.class;
        result[2] = String.class;
        result[3] = String.class;
        result[4] = String.class;
        result[5] = Boolean.class;
        return result;
    }

    @Override
    public Vector buildData() {
        return StockLogic.getInstance().getMagazii();
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Magazie mp = (Magazie)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getLabel();
                    }
                    case 1: {
                        return mp.getContMateriiPrime();
                    }
                    case 2: {
                        return mp.getContMarfuri();
                    }
                    case 3: {
                        return mp.getContTvaNeexigibil();
                    }
                    case 4: {
                        return mp.getContAdaos();
                    }
                    case 5: {
                        return new Boolean(mp.isMagazieMarfa());
                    }
                }
                return null;
            }
        });
        return tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.mpText = new JTextField(10);
        result.add((Component)this.mpText, c);
        this.contMP = new JTextField(5);
        this.contMarfuri = new JTextField(5);
        this.contTvaNeex = new JTextField(5);
        this.contAdaos = new JTextField(5);
        if (this.showConturiFields) {
            ++c.gridx;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Cont MP"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.contMP, c);
            ++c.gridx;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Cont Marfuri"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.contMarfuri, c);
            ++c.gridx;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Cont TVA neex"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.contTvaNeex, c);
            ++c.gridx;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Cont Adaos"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.contAdaos, c);
        }
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Marfa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.marfaCheck = new JCheckBox();
        result.add((Component)this.marfaCheck, c);
        final MagaziiPanel parent = this;
        ++c.gridx;
        c.weightx = 0.0;
        JButton adaugare = new JButton(LangRoAll.salveaza);
        adaugare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = MagaziiPanel.this.mpText.getText();
                if (Validators.correctString(toAdd)) {
                    if (MagaziiPanel.this.toEdit == null) {
                        StockLogic.getInstance().addMagazie(toAdd, MagaziiPanel.this.contMP.getText(), MagaziiPanel.this.contMarfuri.getText(), MagaziiPanel.this.contTvaNeex.getText(), MagaziiPanel.this.contAdaos.getText(), MagaziiPanel.this.marfaCheck.isSelected());
                    } else {
                        StockLogic.getInstance().updateMagazie(MagaziiPanel.this.toEdit.getId(), toAdd, MagaziiPanel.this.contMP.getText(), MagaziiPanel.this.contMarfuri.getText(), MagaziiPanel.this.contTvaNeex.getText(), MagaziiPanel.this.contAdaos.getText(), MagaziiPanel.this.marfaCheck.isSelected());
                        MagaziiPanel.this.toEdit = null;
                    }
                    MagaziiPanel.this.refreshTable();
                    MagaziiPanel.this.setObjectToEdit(null);
                    MagaziiPanel.this.mpText.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, "Completati numele magaziei", LangRoAll.nuPotContinua);
                    MagaziiPanel.this.mpText.requestFocus();
                }
            }
        });
        result.add((Component)adaugare, c);
        ++c.gridx;
        c.weightx = 0.0;
        final MagaziiPanel panel = this;
        JButton deleteButton = new JButton(LangRoAll.sterge);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MagaziiPanel.this.toEdit == null) {
                    return;
                }
                if (DialogUtils.confirmDialog(panel, "Aceasta magazie si toate cantitatile asociate ei vor fi sterse.\nContinuati", LangRoAll.confirmare)) {
                    StockLogic.getInstance().deleteMagazie(MagaziiPanel.this.toEdit.getId());
                    MagaziiPanel.this.tm.refresh(MagaziiPanel.this.buildData());
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    MagaziiPanel.this.setObjectToEdit(null);
                }
            }
        });
        result.add((Component)deleteButton, c);
        result.setBorder(new TitledBorder("Adaugare magazie"));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final Magazie sc = (Magazie)MagaziiPanel.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MagaziiPanel.this.setObjectToEdit(sc);
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        TableColumnModel colModel = this.table.getColumnModel();
        if (!this.showConturiFields) {
            colModel.getColumn(1).setMaxWidth(0);
            colModel.getColumn(2).setMaxWidth(0);
            colModel.getColumn(3).setMaxWidth(0);
            colModel.getColumn(4).setMaxWidth(0);
            colModel.getColumn(5).setMaxWidth(0);
        }
    }

    private void setObjectToEdit(Magazie sub) {
        this.toEdit = sub;
        if (this.toEdit != null) {
            this.mpText.setText(this.toEdit.getLabel());
            this.contMP.setText(this.toEdit.getContMateriiPrime());
            this.contMarfuri.setText(this.toEdit.getContMarfuri());
            this.contTvaNeex.setText(this.toEdit.getContTvaNeexigibil());
            this.contAdaos.setText(this.toEdit.getContAdaos());
            this.marfaCheck.setSelected(this.toEdit.isMagazieMarfa());
        } else {
            this.mpText.setText("");
            this.contMP.setText("");
            this.contMarfuri.setText("");
            this.contTvaNeex.setText("");
            this.contAdaos.setText("");
            this.marfaCheck.setSelected(this.marfaDefault);
        }
    }
}

