/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.WriteException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.BalantaExcelProcessor;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.StockComparativEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;

public class RaportGestiunePanel
extends AbstractReportPanel {
    private JComboBox tip;
    private JComboBox magazii;
    private JComboBox tipPret;
    private JComboBox taguri;
    private JCheckBox produseSterse;
    private JCheckBox produseFaraTranzactii;
    private JLabel valInitiala;
    private JLabel valIntrata;
    private JLabel valIesita;
    private JLabel valFinala;
    private JLabel ctInitiala;
    private JLabel ctIntrata;
    private JLabel ctIesita;
    private JLabel ctFinala;
    private double initialaAcz;
    private double initialaVz;
    private double intrataAcz;
    private double intrataVz;
    private double iesitaAcz;
    private double iesitaVz;
    private double finalaAcz;
    private double finalaVz;
    private double cantitateInitiala;
    private double cantitateIntrata;
    private double cantitateIesita;
    private double cantitateFinala;
    private Hashtable printCriteria = new Hashtable();
    private Hashtable searchCriteria;
    private int tipP = 2;
    public static final String[] columns = new String[]{LangRoAll.produs, "UM", "Cant initiala", "Val initiala", "Cant intrata", "Val intrata", "Cant iesita", "Val iesita", "Cant finala", "Val finala"};
    private MultiboxList multiBoxTipDauna;
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportGestiuneEntry e1 = (RaportGestiuneEntry)o1;
            RaportGestiuneEntry e2 = (RaportGestiuneEntry)o2;
            String cod1 = this.extractCodIntern(e1.getProdusLine2Full());
            String cod2 = this.extractCodIntern(e2.getProdusLine2Full());
            int res = cod1.compareToIgnoreCase(cod2);
            System.out.println("Compar " + cod1 + " cu " + cod2 + " result = " + res);
            return res;
        }

        private String extractCodIntern(String codBare) {
            String cod2 = codBare.replace("(", "");
            cod2 = cod2.replace(")", "");
            cod2 = cod2.trim();
            Vector cods = Utils.splitString(cod2, ',');
            for (String cod : cods) {
                if (!cod.trim().toLowerCase().startsWith("int")) continue;
                return cod.trim();
            }
            return "";
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        this.searchCriteria = new Hashtable();
        this.searchCriteria.put(Constants.START_KEY, startDate);
        this.searchCriteria.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        this.searchCriteria.put("id_magazie", m.getId());
        this.printCriteria.put("Magazie", m.getLabel());
        String tipValue = (String)this.tip.getSelectedItem();
        if (tipValue.equalsIgnoreCase("Finit")) {
            this.searchCriteria.put("finit_ingredient", 2);
        } else if (tipValue.equalsIgnoreCase("Ingredient")) {
            this.searchCriteria.put("finit_ingredient", 1);
        } else {
            this.searchCriteria.put("finit_ingredient", -1);
        }
        String priceType = (String)this.tipPret.getSelectedItem();
        if (priceType.equalsIgnoreCase("Achizitie")) {
            this.searchCriteria.put("vanzare_achizitie", 2);
            this.tipP = 2;
        } else {
            this.searchCriteria.put("vanzare_achizitie", 1);
            this.tipP = 1;
        }
        Vector selected = this.multiBoxTipDauna.getSelectedItems();
        String printString = "";
        String dbString = "";
        for (int i = 0; i < selected.size(); ++i) {
            TipDocument tipDocument = (TipDocument)selected.elementAt(i);
            printString = printString + tipDocument;
            dbString = dbString + tipDocument.getTip();
            if (i >= selected.size() - 1) continue;
            printString = printString + ",";
            dbString = dbString + ",";
        }
        this.printCriteria.put("tip_document", printString);
        this.searchCriteria.put("tip_document", dbString);
        boolean faraTranzactii = this.produseFaraTranzactii.isSelected();
        if (faraTranzactii) {
            this.searchCriteria.put("Include produse fara tranzactii", 1);
            this.printCriteria.put("Include produse fara tranzactii", "");
        } else {
            this.printCriteria.remove("Include produse fara tranzactii");
        }
        boolean sterse = this.produseSterse.isSelected();
        if (sterse) {
            this.searchCriteria.put("Include produse sterse", 1);
            this.printCriteria.put("Include produse sterse", "");
        } else {
            this.printCriteria.remove("Include produse sterse");
        }
        if (this.taguri != null && ComboUtils.anythingButAllSelected(this.taguri)) {
            Tag tag = (Tag)this.taguri.getSelectedItem();
            this.searchCriteria.put("", tag);
            this.printCriteria.put("", "");
        } else {
            this.printCriteria.remove("");
        }
        return this.searchCriteria;
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            Integer idMagazie = (Integer)this.searchCriteria.get("id_magazie");
            Date stopDate = (Date)this.searchCriteria.get(Constants.STOP_KEY);
            String result = StockLogic.getInstance().printBalantaXML(inputFile, stopDate, this.data, idMagazie);
            DialogUtils.okDialog(this, "Fisierul a fost salvat la: " + result, LangRoAll.succes);
        }
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportGestiuneEntry e = (RaportGestiuneEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return "<html><b>" + e.getProdus() + "</b><br/><i>" + e.getProdusLine2Full() + "</i></html>";
                    }
                    case 1: {
                        return e.getUm();
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantInitiala());
                    }
                    case 3: {
                        return Utils.getString2Decimals(RaportGestiunePanel.this.tip(e.getValInitialaAcz(), e.getValInitialaVz()));
                    }
                    case 4: {
                        return Utils.getString3Decimals(e.getCantIntrata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(RaportGestiunePanel.this.tip(e.getValIntrataAcz(), e.getValIntrataVz()));
                    }
                    case 6: {
                        return Utils.getString3Decimals(e.getCantIesita());
                    }
                    case 7: {
                        return Utils.getString2Decimals(RaportGestiunePanel.this.tip(e.getValIesitaAcz(), e.getValIesitaVz()));
                    }
                    case 8: {
                        return Utils.getString3Decimals(e.getCantFinala());
                    }
                    case 9: {
                        return Utils.getString2Decimals(RaportGestiunePanel.this.tip(e.getValFinalaAcz(), e.getValFinalaVz()));
                    }
                }
                return null;
            }
        });
        return tm;
    }

    private double tip(double acz, double vz) {
        return this.tipP == 2 ? acz : vz;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Cantitate initiala"), c);
        ++c.gridx;
        this.ctInitiala = new JLabel("");
        result.add((Component)this.ctInitiala, c);
        ++c.gridx;
        result.add((Component)new JLabel("Cantitate intrata"), c);
        ++c.gridx;
        this.ctIntrata = new JLabel("");
        result.add((Component)this.ctIntrata, c);
        ++c.gridx;
        result.add((Component)new JLabel("Cantitate iesita"), c);
        ++c.gridx;
        this.ctIesita = new JLabel("");
        result.add((Component)this.ctIesita, c);
        ++c.gridx;
        result.add((Component)new JLabel("Cantitate finala"), c);
        ++c.gridx;
        this.ctFinala = new JLabel("");
        result.add((Component)this.ctFinala, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare Initiala"), c);
        ++c.gridx;
        this.valInitiala = new JLabel("");
        result.add((Component)this.valInitiala, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare intrata"), c);
        ++c.gridx;
        this.valIntrata = new JLabel("");
        result.add((Component)this.valIntrata, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare iesita"), c);
        ++c.gridx;
        this.valIesita = new JLabel("");
        result.add((Component)this.valIesita, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare finala"), c);
        ++c.gridx;
        this.valFinala = new JLabel("");
        result.add((Component)this.valFinala, c);
        final RaportGestiunePanel parent = this;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        JButton transferCuMinusuri = new JButton("Bon transfer pt minusuri");
        transferCuMinusuri.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)transferCuMinusuri, c);
        transferCuMinusuri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(parent, "Cream bon transfer cu minusurile", LangRoAll.confirmare)) {
                    return;
                }
                Vector<StockTransferItem> toAdd = new Vector<StockTransferItem>();
                for (int i = 0; i < RaportGestiunePanel.this.data.size(); ++i) {
                    RaportGestiuneEntry raportGestiuneEntry = (RaportGestiuneEntry)RaportGestiunePanel.this.data.elementAt(i);
                    double cant = raportGestiuneEntry.getCantFinala();
                    if (!(cant < 0.0)) continue;
                    StockTransferItem bci = new StockTransferItem();
                    bci.setQuantity(-cant);
                    bci.setDenumire(raportGestiuneEntry.getProdus());
                    bci.setIdStock(raportGestiuneEntry.getIdStoc());
                    double pretIesire = StockLogic.getInstance().getCatalogPriceForStock(raportGestiuneEntry.getIdStoc());
                    if (pretIesire < 0.0) {
                        pretIesire = 0.0;
                    }
                    bci.setSellPrice(pretIesire);
                    bci.setBuyPrice(0.0);
                    toAdd.add(bci);
                }
                StockLogic.getInstance().getAddTransferPanel().addEntries(toAdd);
                DialogUtils.okDialog(parent, "Minusurile au fost adaugate in ecranul \"Adauga transfer\"", LangRoAll.succes);
            }
        });
        c.gridx += 2;
        JButton bonConsumCuMinusuri = new JButton("Bon consum pt minusuri");
        bonConsumCuMinusuri.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)bonConsumCuMinusuri, c);
        bonConsumCuMinusuri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(parent, "Cream bon consum cu minusurile", LangRoAll.confirmare)) {
                    return;
                }
                Vector<BonConsumItem> toAdd = new Vector<BonConsumItem>();
                for (int i = 0; i < RaportGestiunePanel.this.data.size(); ++i) {
                    RaportGestiuneEntry raportGestiuneEntry = (RaportGestiuneEntry)RaportGestiunePanel.this.data.elementAt(i);
                    double cant = raportGestiuneEntry.getCantFinala();
                    if (!(cant < 0.0)) continue;
                    BonConsumItem bci = new BonConsumItem();
                    bci.setCantitate(-cant);
                    bci.setDenumire(raportGestiuneEntry.getProdus());
                    bci.setIdStock(raportGestiuneEntry.getIdStoc());
                    toAdd.add(bci);
                }
                StockLogic.getInstance().getAddConsumPanel().addBonEntries(toAdd);
                DialogUtils.okDialog(parent, "Minusurile au fost adaugate in ecranul \"Adauga bon consum\"", LangRoAll.succes);
            }
        });
        c.gridx += 2;
        JButton zeroMinusuri = new JButton("Corecteaza minusuri");
        zeroMinusuri.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)zeroMinusuri, c);
        zeroMinusuri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(parent, "Corectam minusurile", LangRoAll.confirmare)) {
                    return;
                }
                if (Config.getInstance().getBoolean("piratMode") && RaportGestiunePanel.this.whatToPrint != 2) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila pt aceasta gestiune", LangRoAll.nuPotContinua);
                    return;
                }
                int idMagazie = (Integer)RaportGestiunePanel.this.searchCriteria.get("id_magazie");
                Date stopDate = (Date)RaportGestiunePanel.this.searchCriteria.get(Constants.STOP_KEY);
                Vector<StockComparativEntry> items = new Vector<StockComparativEntry>();
                for (int i = 0; i < RaportGestiunePanel.this.data.size(); ++i) {
                    RaportGestiuneEntry raportGestiuneEntry = (RaportGestiuneEntry)RaportGestiunePanel.this.data.elementAt(i);
                    double cantCurenta = raportGestiuneEntry.getCantFinala();
                    if (!(cantCurenta < 0.0)) continue;
                    StockComparativEntry sce = new StockComparativEntry();
                    sce.setFaptic(0.0);
                    sce.setIdStock(raportGestiuneEntry.getIdStoc());
                    items.add(sce);
                }
                Timestamp time = new Timestamp(stopDate.getTime());
                StockLogic.getInstance().corecteazaCuFaptic(idMagazie, items, time, true, 2);
                DialogUtils.okDialog(parent, "Corectie efectuata, asteptati cateva secunde si apoi apasati \"Raport\"", LangRoAll.succes);
            }
        });
        return result;
    }

    @Override
    public String getName() {
        return "Balanta";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().generateRaportGestiune(criteria, false, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        String preview = StockLogic.getInstance().printRaportGestiune(this.printCriteria, this.data, m.getLabel(), this.tip(this.initialaAcz, this.initialaVz), this.tip(this.intrataAcz, this.intrataVz), this.tip(this.iesitaAcz, this.iesitaVz), this.tip(this.finalaAcz, this.finalaVz), this.tipP);
        PrintLogic.getInstance().printPreview(preview);
    }

    @Override
    public void printReport() {
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        String foFile = StockLogic.getInstance().printRaportGestiune(this.printCriteria, this.data, m.getLabel(), this.tip(this.initialaAcz, this.initialaVz), this.tip(this.intrataAcz, this.intrataVz), this.tip(this.iesitaAcz, this.iesitaVz), this.tip(this.finalaAcz, this.finalaVz), this.tipP);
        PrintLogic.getInstance().printPdf(foFile, 1);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.valInitiala.setText(Utils.getString2Decimals(this.tip(this.initialaAcz, this.initialaVz)));
        this.valIntrata.setText(Utils.getString2Decimals(this.tip(this.intrataAcz, this.intrataVz)));
        this.valIesita.setText(Utils.getString2Decimals(this.tip(this.iesitaAcz, this.iesitaVz)));
        this.valFinala.setText(Utils.getString2Decimals(this.tip(this.finalaAcz, this.finalaVz)));
        this.ctInitiala.setText(Utils.getString2Decimals(this.cantitateInitiala));
        this.ctIntrata.setText(Utils.getString2Decimals(this.cantitateIntrata));
        this.ctIesita.setText(Utils.getString2Decimals(this.cantitateIesita));
        this.ctFinala.setText(Utils.getString2Decimals(this.cantitateFinala));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new BalantaExcelProcessor(this.getName(), columns, this.tipP), this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return product_sorter;
            }
        }
        return null;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii(), false);
        this.tip.addItem("All");
        this.tip.addItem("Finit");
        this.tip.addItem("Ingredient");
        this.tipPret.addItem("Achizitie");
        this.tipPret.addItem("Vanzare");
        ComboUtils.replaceItemsForCombo(this.taguri, TagsLogic.getInstance().getAllTags(), true);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(RaportGestiunePanel.this.magazii, StockLogic.getInstance().getMagazii(), false);
            }

            @Override
            public String getName() {
                return "RaportGestiuneReport_magaziiChanged";
            }
        }, 27);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(RaportGestiunePanel.this.taguri, TagsLogic.getInstance().getAllTags(), true);
            }

            @Override
            public String getName() {
                return "RaportGestiuneReport_tags";
            }
        }, Constants.TAGS_CHANGED);
        GuiUtils.updateJTableRowSize(this.table, VpConfig.getInstance().touchTableFontSize);
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip document"), c);
        ++c.gridx;
        c.weightx = 1.0;
        Vector<TipDocument> allItems = StockLogic.getInstance().getDocumentInterface().getAllTipDocument();
        this.multiBoxTipDauna = new MultiboxList(allItems, 10);
        this.multiBoxTipDauna.setSelectedItems(allItems, true);
        result.add((Component)this.multiBoxTipDauna, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        result.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Finit/ingredient"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tip = new JComboBox();
        result.add((Component)this.tip, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret vanzare/achizitie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipPret = new JComboBox();
        result.add((Component)this.tipPret, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Taguri"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.taguri = new JComboBox();
        result.add((Component)this.taguri, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse sterse"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseSterse = new JCheckBox();
        result.add((Component)this.produseSterse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse fara tranzactii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseFaraTranzactii = new JCheckBox();
        result.add((Component)this.produseFaraTranzactii, c);
        return result;
    }

    private void computeTotals(Vector items) {
        this.initialaAcz = 0.0;
        this.initialaVz = 0.0;
        this.intrataAcz = 0.0;
        this.intrataVz = 0.0;
        this.iesitaAcz = 0.0;
        this.iesitaVz = 0.0;
        this.finalaAcz = 0.0;
        this.finalaVz = 0.0;
        this.cantitateInitiala = 0.0;
        this.cantitateIntrata = 0.0;
        this.cantitateIesita = 0.0;
        this.cantitateFinala = 0.0;
        for (RaportGestiuneEntry element : items) {
            this.initialaAcz += element.getValInitialaAcz();
            this.initialaVz += element.getValInitialaVz();
            this.intrataAcz += element.getValIntrataAcz();
            this.intrataVz += element.getValIntrataVz();
            this.iesitaAcz += element.getValIesitaAcz();
            this.iesitaVz += element.getValIesitaVz();
            this.finalaAcz += element.getValFinalaAcz();
            this.finalaVz += element.getValFinalaVz();
            this.cantitateInitiala += element.getCantInitiala();
            this.cantitateIntrata += element.getCantIntrata();
            this.cantitateIesita += element.getCantIesita();
            this.cantitateFinala += element.getCantFinala();
        }
    }
}

