/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.RaportGestiuneValoricaEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportGestiuneValoricPanel
extends AbstractReportPanel {
    private JComboBox tip;
    private JComboBox magazii;
    private JComboBox tipPret;
    private JCheckBox produseSterse;
    private JCheckBox produseFaraTranzactii;
    private Hashtable printCriteria = new Hashtable();
    private Hashtable searchCriteria;
    private int tipP = 2;
    public static final String[] columns = new String[]{LangRoAll.data, LangRoAll.tip, "Intrari", "Iesiri", "Sold"};
    private MultiboxList multiBoxTipDauna;
    private JLabel valInitiala;
    private JLabel valIntrata;
    private JLabel valIesita;
    private JLabel valFinala;
    private double initialaAcz;
    private double initialaVz;
    private double intrataAcz;
    private double intrataVz;
    private double iesitaAcz;
    private double iesitaVz;
    private double finalaAcz;
    private double finalaVz;
    private ReportInterface pdfReportInterface;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        this.searchCriteria = new Hashtable();
        this.searchCriteria.put(Constants.START_KEY, startDate);
        this.searchCriteria.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        this.searchCriteria.put("id_magazie", m.getId());
        this.printCriteria.put("Magazie", m.getLabel());
        String tipValue = (String)this.tip.getSelectedItem();
        if (tipValue.equalsIgnoreCase("Finit")) {
            this.searchCriteria.put("finit_ingredient", 2);
        } else if (tipValue.equalsIgnoreCase("Ingredient")) {
            this.searchCriteria.put("finit_ingredient", 1);
        } else {
            this.searchCriteria.put("finit_ingredient", -1);
        }
        String priceType = (String)this.tipPret.getSelectedItem();
        if (priceType.equalsIgnoreCase("Achizitie")) {
            this.searchCriteria.put("vanzare_achizitie", 2);
            this.tipP = 2;
        } else {
            this.searchCriteria.put("vanzare_achizitie", 1);
            this.tipP = 1;
        }
        Vector selected = this.multiBoxTipDauna.getSelectedItems();
        String printString = "";
        String dbString = "";
        for (int i = 0; i < selected.size(); ++i) {
            TipDocument tipDocument = (TipDocument)selected.elementAt(i);
            printString = printString + tipDocument;
            dbString = dbString + tipDocument.getTip();
            if (i >= selected.size() - 1) continue;
            printString = printString + ",";
            dbString = dbString + ",";
        }
        this.printCriteria.put("tip_document", printString);
        this.searchCriteria.put("tip_document", dbString);
        boolean faraTranzactii = this.produseFaraTranzactii.isSelected();
        if (faraTranzactii) {
            this.searchCriteria.put("Include produse fara tranzactii", 1);
            this.printCriteria.put("Include produse fara tranzactii", "");
        } else {
            this.printCriteria.remove("Include produse fara tranzactii");
        }
        boolean sterse = this.produseSterse.isSelected();
        if (sterse) {
            this.searchCriteria.put("Include produse sterse", 1);
            this.printCriteria.put("Include produse sterse", "");
        } else {
            this.printCriteria.remove("Include produse sterse");
        }
        return this.searchCriteria;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportGestiuneValoricaEntry e = (RaportGestiuneValoricaEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(e.getDate());
                    }
                    case 1: {
                        return e.getTipOperatie();
                    }
                    case 2: {
                        return RaportGestiuneValoricPanel.this.tip(e.getIntrataPa(), e.getIntrataPv());
                    }
                    case 3: {
                        return RaportGestiuneValoricPanel.this.tip(e.getIesitaPa(), e.getIesitaPv());
                    }
                    case 4: {
                        return RaportGestiuneValoricPanel.this.tip(e.getSoldPa(), e.getSoldPv());
                    }
                }
                return null;
            }
        });
        return tm;
    }

    private String tip(double acz, double vz) {
        double f1 = this.tipP == 2 ? acz : vz;
        return Utils.getString2Decimals(f1);
    }

    private double tipFloat(double acz, double vz) {
        double f1 = this.tipP == 2 ? acz : vz;
        return f1;
    }

    @Override
    public String getName() {
        return "Raport gestiune";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().generateRaportGestiuneValorica(criteria, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.valInitiala.setText(this.tip(this.initialaAcz, this.initialaVz));
        this.valIntrata.setText(this.tip(this.intrataAcz, this.intrataVz));
        this.valIesita.setText(this.tip(this.iesitaAcz, this.iesitaVz));
        this.valFinala.setText(this.tip(this.finalaAcz, this.finalaVz));
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare Initiala"), c);
        ++c.gridx;
        this.valInitiala = new JLabel("");
        result.add((Component)this.valInitiala, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare intrata"), c);
        ++c.gridx;
        this.valIntrata = new JLabel("");
        result.add((Component)this.valIntrata, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare iesita"), c);
        ++c.gridx;
        this.valIesita = new JLabel("");
        result.add((Component)this.valIesita, c);
        ++c.gridx;
        result.add((Component)new JLabel("Valoare finala"), c);
        ++c.gridx;
        this.valFinala = new JLabel("");
        result.add((Component)this.valFinala, c);
        return result;
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    try {
                        RaportGestiuneValoricaEntry e = (RaportGestiuneValoricaEntry)o;
                        Label data = new Label(0, row, Formatters.DATE_FORMAT_RO.format(e.getDate()));
                        sheet.addCell((WritableCell)data);
                        Label categ = new Label(1, row, e.getTipOperatie());
                        sheet.addCell((WritableCell)categ);
                        Number valUnit = new Number(2, row, RaportGestiuneValoricPanel.this.tipFloat(e.getIntrataPa(), e.getIntrataPv()));
                        sheet.addCell((WritableCell)valUnit);
                        valUnit = new Number(3, row, RaportGestiuneValoricPanel.this.tipFloat(e.getIesitaPa(), e.getIesitaPv()));
                        sheet.addCell((WritableCell)valUnit);
                        valUnit = new Number(4, row, RaportGestiuneValoricPanel.this.tipFloat(e.getSoldPa(), e.getSoldPv()));
                        sheet.addCell((WritableCell)valUnit);
                    }
                    catch (WriteException e1) {
                        Logger.logException(this, (Exception)((Object)e1));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportGestiuneValoricPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii(), false);
        this.tip.addItem("All");
        this.tip.addItem("Finit");
        this.tip.addItem("Ingredient");
        this.tipPret.addItem("Achizitie");
        this.tipPret.addItem("Vanzare");
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(RaportGestiuneValoricPanel.this.magazii, StockLogic.getInstance().getMagazii(), false);
            }

            @Override
            public String getName() {
                return "RaportGestiuneValoricReport_magaziiChanged";
            }
        }, 27);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "Sold: " + RaportGestiuneValoricPanel.this.tip(RaportGestiuneValoricPanel.this.initialaAcz, RaportGestiuneValoricPanel.this.initialaVz);
                    }
                    case 2: {
                        return RaportGestiuneValoricPanel.this.tip(RaportGestiuneValoricPanel.this.intrataAcz, RaportGestiuneValoricPanel.this.intrataVz);
                    }
                    case 3: {
                        return RaportGestiuneValoricPanel.this.tip(RaportGestiuneValoricPanel.this.iesitaAcz, RaportGestiuneValoricPanel.this.iesitaVz);
                    }
                    case 4: {
                        return RaportGestiuneValoricPanel.this.tip(RaportGestiuneValoricPanel.this.finalaAcz, RaportGestiuneValoricPanel.this.finalaVz);
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return RaportGestiuneValoricPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return RaportGestiuneValoricPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                RaportGestiuneValoricaEntry e = (RaportGestiuneValoricaEntry)row;
                if (e == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(e.getDate());
                    }
                    case 1: {
                        return e.getTipOperatie();
                    }
                    case 2: {
                        return RaportGestiuneValoricPanel.this.tip(e.getIntrataPa(), e.getIntrataPv());
                    }
                    case 3: {
                        return RaportGestiuneValoricPanel.this.tip(e.getIesitaPa(), e.getIesitaPv());
                    }
                    case 4: {
                        return RaportGestiuneValoricPanel.this.tip(e.getSoldPa(), e.getSoldPv());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip document"), c);
        ++c.gridx;
        c.weightx = 1.0;
        Vector<TipDocument> allItems = StockLogic.getInstance().getDocumentInterface().getAllTipDocument();
        this.multiBoxTipDauna = new MultiboxList(allItems, 10);
        this.multiBoxTipDauna.setSelectedItems(allItems, true);
        result.add((Component)this.multiBoxTipDauna, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.magazii = new JComboBox();
        result.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Finit/ingredient"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tip = new JComboBox();
        result.add((Component)this.tip, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret vanzare/achizitie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipPret = new JComboBox();
        result.add((Component)this.tipPret, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse sterse"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseSterse = new JCheckBox();
        result.add((Component)this.produseSterse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Produse fara tranzactii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseFaraTranzactii = new JCheckBox();
        result.add((Component)this.produseFaraTranzactii, c);
        return result;
    }

    private void computeTotals(Vector items) {
        this.initialaAcz = 0.0;
        this.initialaVz = 0.0;
        this.intrataAcz = 0.0;
        this.intrataVz = 0.0;
        this.iesitaAcz = 0.0;
        this.iesitaVz = 0.0;
        this.finalaAcz = 0.0;
        this.finalaVz = 0.0;
        int i = 0;
        for (RaportGestiuneValoricaEntry element : items) {
            this.iesitaAcz += element.getIesitaPa();
            this.iesitaVz += element.getIesitaPv();
            if (i == 0) {
                this.initialaAcz = element.getIntrataPa();
                this.initialaVz = element.getIntrataPv();
            } else {
                this.intrataAcz += element.getIntrataPa();
                this.intrataVz += element.getIntrataPv();
            }
            if (i == items.size() - 1) {
                this.finalaAcz = element.getSoldPa();
                this.finalaVz = element.getSoldPv();
            }
            ++i;
        }
    }
}

