/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.gui.ProductPicturePanel;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.TipArticol;
import ro.atreides.stocks.gui.StockModifiedInterface;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.BarCodesPanel;
import ro.atreides.utils.gui.BarCodesPanelInterface;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;
import ro.atreides.utils.tags.gui.TagsMiniPanel;
import ro.atreides.utils.units.UnitsLogic;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class StockInput
extends ReflectedJPanel {
    private JButton inapoiButton;
    private JButton saveButton;
    private StockLogic stockLogic;
    private JComboBox subcategoriesCombo;
    private JComboBox unitatiCombo;
    private JComboBox tipArticolCombo;
    private JComboBox valuteCombo;
    private JTextField produs;
    private JTextField warningLevel;
    private JTextField criticalLevel;
    private JTextField codProdus;
    private JTextField pret;
    private JRadioButton finit;
    private JRadioButton ingredient;
    private ButtonGroup group;
    private Stock stock;
    private SwitchToList action;
    private double pretVechi;
    private boolean finitSelected = false;
    private Object toEditEntry;
    private int selRow;
    private JCheckBox exportCantar;
    private JCheckBox descarcaStoc;
    private StockModifiedInterface modifiedInterface;
    private ProductPicturePanel ppp = new ProductPicturePanel(100);
    private BarCodesPanel barCodesPanel;
    private TagsMiniPanel tagsPanel;
    private boolean showMateriiPrime;

    public StockInput() {
        this(true);
    }

    public StockInput(boolean showMateriiPrime) {
        this.stockLogic = StockLogic.getInstance();
        this.showMateriiPrime = showMateriiPrime;
        this.init();
        this.display();
    }

    public void setViewPanel(StockModifiedInterface modifiedInterface) {
        this.modifiedInterface = modifiedInterface;
    }

    @Override
    public void doStuff() {
        EventListener valuteListenerInStock = new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(StockInput.this.valuteCombo, ValuteLogic.getInstance().getAllValute(), true);
            }

            @Override
            public String getName() {
                return LangRoAll.valute;
            }
        };
        NomeclaturaLogic.getInstance().addListener(valuteListenerInStock, 456);
    }

    private JPanel getProductPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel l41 = new JLabel(LangRoAll.produs);
        p.add((Component)l41, c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)this.produs, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel umLabel = new JLabel(Utils.getTranslation(LangRoAll.unitateMasura, new String[0]));
        p.add((Component)umLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)this.unitatiCombo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(Utils.getTranslation(LangRoAll.nivelAlerta, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)this.warningLevel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(Utils.getTranslation(LangRoAll.nivelCritic, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)this.criticalLevel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(Utils.getTranslation(LangRoAll.proceseazaStoc, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)this.descarcaStoc, c);
        p.setBorder(new TitledBorder(LangRoAll.produs));
        return p;
    }

    private void switchTipElements(boolean finit) {
        this.subcategoriesCombo.setEnabled(finit);
        this.codProdus.setEditable(finit);
        this.pret.setEnabled(finit);
        this.exportCantar.setEnabled(finit);
        this.finitSelected = finit;
        this.barCodesPanel.editable(finit);
    }

    private void init() {
        this.barCodesPanel = new BarCodesPanel();
        this.barCodesPanel.setInter(new BarCodesPanelInterface(){

            @Override
            public String getDefaultCodBare() {
                return "Int" + StockInput.this.codProdus.getText();
            }
        });
        this.group = new ButtonGroup();
        this.finit = new JRadioButton(Utils.getTranslation(LangRoAll.marfaDetaliat, new String[0]));
        this.finit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockInput.this.switchTipElements(true);
            }
        });
        this.group.add(this.finit);
        this.ingredient = new JRadioButton(Utils.getTranslation(LangRoAll.materiePrimaDetaliat, new String[0]));
        this.ingredient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockInput.this.switchTipElements(false);
            }
        });
        this.group.add(this.ingredient);
        this.subcategoriesCombo = new JComboBox();
        this.tipArticolCombo = new JComboBox();
        this.valuteCombo = new JComboBox();
        this.pret = new JTextField(10);
        this.unitatiCombo = new JComboBox();
        this.rebuildUnitatiCombo();
        this.produs = new JTextField(10);
        this.criticalLevel = new JTextField(10);
        this.warningLevel = new JTextField(10);
        this.codProdus = new JTextField(10);
        this.saveButton = new JButton(LangRoAll.salveaza);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object temp = StockInput.this.toEditEntry;
                boolean mustReturn = false;
                if (StockInput.this.stock != null) {
                    mustReturn = true;
                }
                if (StockInput.this.saveData(StockInput.this.stock)) {
                    StockInput.this.stock = null;
                    StockInput.this.setComponents(StockInput.this.stock);
                    StockInput.this.produs.requestFocus();
                } else {
                    mustReturn = false;
                }
                if (mustReturn) {
                    if (StockInput.this.modifiedInterface != null) {
                        StockInput.this.modifiedInterface.stockModified(temp, StockInput.this.selRow);
                    }
                    StockInput.this.action.doAction();
                }
            }
        });
        this.saveButton.setMnemonic(65);
        this.inapoiButton = new JButton(LangRoAll.inapoi);
        this.inapoiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockInput.this.stock = null;
                boolean mustReturn = false;
                if (StockInput.this.toEditEntry != null) {
                    mustReturn = true;
                }
                StockInput.this.setComponents(null);
                StockInput.this.barCodesPanel.setProduct(null);
                StockInput.this.tagsPanel.setStock(null);
                if (mustReturn) {
                    StockInput.this.action.doAction();
                }
            }
        });
        this.exportCantar = new JCheckBox();
        this.exportCantar.setSelected(false);
        this.descarcaStoc = new JCheckBox();
        this.descarcaStoc.setSelected(true);
        this.setComponents(null);
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "StockInput_category";
            }

            @Override
            public void dataChanged() {
                StockInput.this.rebuildSubcategoriesCombo();
            }
        }, 1);
        UnitsLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StockInput.this.rebuildUnitatiCombo();
            }

            @Override
            public String getName() {
                return "StockInput_unitati";
            }
        }, 12);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StockInput.this.tagsPanel.updateTags();
            }

            @Override
            public String getName() {
                return "StockInput_tags";
            }
        }, Constants.TAGS_CHANGED);
    }

    private void rebuildUnitatiCombo() {
        ComboUtils.replaceItemsForCombo(this.unitatiCombo, (Collection)UnitsLogic.getInstance().getUnitati(), false);
    }

    private void rebuildSubcategoriesCombo() {
        ComboUtils.replaceItemsForCombo(this.subcategoriesCombo, (Collection)NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(), false);
    }

    private void rebuildTipArticolCombo() {
        ComboUtils.replaceItemsForCombo(this.tipArticolCombo, this.stockLogic.getTipuriArticole(), false);
    }

    private void rebuildValuteCombo() {
        ComboUtils.replaceItemsForCombo(this.valuteCombo, ValuteLogic.getInstance().getAllValute(), true);
    }

    public final void setAction(SwitchToList action) {
        this.action = action;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)this.getProductPanel(), c);
        c.gridx += 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        this.add((Component)this.getTipPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        final StockInput parent = this;
        this.ppp.setDx(Config.getInstance().getInt("productPictureDx", 100));
        this.add((Component)this.ppp, c);
        this.ppp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.incarcamAltaPoza, new String[0]), LangRoAll.confirmare)) {
                    if (StockInput.this.finit.isSelected()) {
                        String inputFile = FileDialog.getLoadDialogLocation(parent, Utils.getTranslation(LangRoAll.selectatiPoza, new String[0]) + " jpg/png/gif", "gif,jpg,jpeg,png");
                        if (inputFile != null) {
                            StockInput.this.ppp.reload(inputFile);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.materiilePrimeNuAuPoza, new String[0]), Utils.getTranslation(LangRoAll.nuPotContinua));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        c.gridx += 2;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.tagsPanel = new TagsMiniPanel();
        this.add((Component)this.tagsPanel, c);
        c.gridx += 2;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.add((Component)this.barCodesPanel, c);
        c.gridwidth = 6;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.getButtonsPanel(), c);
        this.rebuildSubcategoriesCombo();
        this.rebuildTipArticolCombo();
        this.rebuildValuteCombo();
        if (Config.getInstance().getBoolean("stocuriDefinireStocProdusFinitByDefault")) {
            this.finit.doClick();
        } else {
            this.ingredient.doClick();
        }
        if (!this.showMateriiPrime) {
            this.ingredient.setEnabled(false);
            this.finit.doClick();
        }
    }

    private void setComponents(Stock s) {
        if (s == null) {
            this.produs.setText("");
            this.warningLevel.setText("0");
            this.criticalLevel.setText("0");
            this.codProdus.setText(NomeclaturaLogic.getInstance().getNextProductCode() + "");
            this.pret.setText("");
            this.exportCantar.setSelected(false);
            this.toEditEntry = null;
            this.finit.setEnabled(true);
            this.ingredient.setEnabled(true);
            if (!this.showMateriiPrime) {
                this.ingredient.setEnabled(false);
                this.finit.doClick();
            }
            this.ppp.reload(-1);
            this.descarcaStoc.setSelected(true);
            int size = this.valuteCombo.getModel().getSize();
            if (size > 0) {
                this.valuteCombo.setSelectedIndex(0);
            }
        } else {
            TipArticol ta = this.stockLogic.getTipArticolById(this.stock.getIdTipArticol());
            this.tipArticolCombo.setSelectedItem(ta);
            this.produs.setText(s.getLabel());
            this.warningLevel.setText(Utils.getString3Decimals(s.getWarningLevel()));
            this.criticalLevel.setText(Utils.getString3Decimals(s.getCriticalLevel()));
            this.descarcaStoc.setSelected(s.isDescarcaStoc());
            Product p = this.stockLogic.getProductForStock(this.stock.getId());
            if (p != null) {
                this.codProdus.setText(p.getCod() + "");
                this.finit.doClick();
                Categorie sc = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                this.subcategoriesCombo.setSelectedItem(sc);
                double pret1 = this.stockLogic.getCatalogPriceForStock(this.stock.getId());
                this.pret.setText(Utils.getString2Decimals(pret1));
                this.pretVechi = pret1;
                this.exportCantar.setSelected(p.isExportCantar());
                this.ppp.reload(p.getId());
                this.barCodesPanel.setProduct(p);
                this.tagsPanel.setStock(this.stock);
            } else {
                this.ingredient.doClick();
                this.ppp.reload(-1);
            }
            Unit u = UnitsLogic.getInstance().getUnitById(this.stock.getIdUnit());
            this.unitatiCombo.setSelectedItem(u);
            Integer idValuta = this.stockLogic.getIdValutaForStock(s.getId());
            if (idValuta != Valuta.mostenitaDinCategorie) {
                Valuta valuta = ValuteLogic.getInstance().getValutaById(idValuta);
                this.valuteCombo.setSelectedItem(valuta);
            } else {
                this.valuteCombo.setSelectedItem("All");
            }
            this.finit.setEnabled(false);
            this.ingredient.setEnabled(false);
        }
    }

    private boolean saveData(Stock stock) {
        try {
            int code = -1;
            String sCode = this.codProdus.getText();
            if (!Validators.correctInteger(sCode)) {
                this.codProdus.requestFocus();
                return false;
            }
            code = Integer.parseInt(sCode);
            String name = this.produs.getText();
            if (!Validators.correctString(name)) {
                this.produs.requestFocus();
                return false;
            }
            Stock existing = this.stockLogic.getStockByName(name);
            if (stock == null) {
                if (existing != null) {
                    DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.existaUnProdusCuAcestNume), LangRoAll.nuPotContinua);
                    return false;
                }
            } else if (existing != null && existing.getId() != stock.getId()) {
                DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.existaUnProdusCuAcestNume), LangRoAll.nuPotContinua);
                return false;
            }
            Unit u = (Unit)this.unitatiCombo.getSelectedItem();
            String warning = this.warningLevel.getText();
            if (!Validators.correctDouble(warning)) {
                this.warningLevel.requestFocus();
                return false;
            }
            String critical = this.criticalLevel.getText();
            if (!Validators.correctDouble(critical)) {
                this.criticalLevel.requestFocus();
                return false;
            }
            double fWarning = Utils.parseDouble(warning);
            double fCritical = Utils.parseDouble(critical);
            TipArticol selectedTa = (TipArticol)this.tipArticolCombo.getSelectedItem();
            int tipArticol = selectedTa.getId();
            if (tipArticol == 1) {
                DialogUtils.errorDialog(this, "Setati tipul stocului", LangRoAll.nuPotContinua);
                return false;
            }
            Vector<Tag> tags = this.tagsPanel.getTagsToSave();
            if (this.finitSelected) {
                Categorie subcat = (Categorie)this.subcategoriesCombo.getSelectedItem();
                if (subcat == null) {
                    DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.categorieNedefinita, new String[0]), LangRoAll.nuPotContinua);
                    return false;
                }
                String p = this.pret.getText();
                if (!Validators.correctDouble(p)) {
                    DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.completatiPretulDeVanzare, new String[0]), LangRoAll.nuPotContinua);
                    this.pret.requestFocus();
                    return false;
                }
                int valutaId = Valuta.mostenitaDinCategorie;
                if (ComboUtils.anythingButAllSelected(this.valuteCombo)) {
                    Valuta valuta = (Valuta)this.valuteCombo.getSelectedItem();
                    valutaId = valuta.getId();
                }
                Product existingProduct = NomeclaturaLogic.getInstance().getProductByName(name);
                boolean allowProduseDuplicate = Config.getInstance().getBoolean("allowProduseDuplicate");
                double p1 = Utils.parseDouble(p);
                int idStock = 0;
                Vector<String> codes = this.barCodesPanel.getModifiedBarcodes();
                if (stock == null) {
                    if (existingProduct != null && !allowProduseDuplicate) {
                        DialogUtils.errorDialog(this, LangRoAll.existaUnProdusCuAcestNume, LangRoAll.nuPotContinua);
                        return false;
                    }
                    idStock = this.stockLogic.addProdusFinitWithTip(name, u.getId(), subcat.getId(), code, fWarning, fCritical, p1, this.exportCantar.isSelected(), this.ppp.getNewPictureFile(), this.descarcaStoc.isSelected(), tipArticol, codes);
                    this.stockLogic.setValutaForStock(idStock, valutaId);
                    TagsLogic.getInstance().updateTagsToStock(idStock, tags);
                    this.barCodesPanel.setProduct(this.stockLogic.getProductForStock(idStock));
                } else {
                    Product modifiedProduct = this.stockLogic.getProductForStock(stock.getId());
                    if (existingProduct != null && existingProduct.getId() != modifiedProduct.getId() && !allowProduseDuplicate) {
                        DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.existaUnProdusCuAcestNume), LangRoAll.nuPotContinua);
                        return false;
                    }
                    boolean modifyOldStuff = false;
                    if (this.pretVechi != p1) {
                        modifyOldStuff = true;
                    }
                    this.stockLogic.updateProdusFinit(stock.getId(), name, u.getId(), subcat.getId(), code, fWarning, fCritical, p1, modifyOldStuff, this.exportCantar.isSelected(), this.ppp.getNewPictureFile(), this.descarcaStoc.isSelected(), DateUtils.getCurrentTimestamp(), codes);
                    this.stockLogic.setTipArticol(stock.getId(), tipArticol);
                    idStock = stock.getId();
                    TagsLogic.getInstance().updateTagsToStock(idStock, tags);
                    this.stockLogic.setValutaForStock(idStock, valutaId);
                    stock = null;
                }
            } else if (stock == null) {
                int idStock = this.stockLogic.addStock(name, u.getId(), fWarning, fCritical, -1.0, this.descarcaStoc.isSelected());
                TagsLogic.getInstance().updateTagsToStock(idStock, tags);
                this.stockLogic.setTipArticol(idStock, tipArticol);
            } else {
                this.stockLogic.updateStock(stock.getId(), name, u.getId(), fWarning, fCritical, this.descarcaStoc.isSelected());
                this.stockLogic.setTipArticol(stock.getId(), tipArticol);
                TagsLogic.getInstance().updateTagsToStock(stock.getId(), tags);
                stock = null;
            }
            this.barCodesPanel.setProduct(null);
            return true;
        }
        catch (NumberFormatException e) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.completatiCorectCampurile), LangRoAll.nuPotContinua);
            return false;
        }
    }

    private JPanel getTipPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        Enumeration<AbstractButton> enum1 = this.group.getElements();
        int i = 0;
        while (enum1.hasMoreElements()) {
            JRadioButton b = (JRadioButton)enum1.nextElement();
            c.gridx = i++;
            result.add((Component)b, c);
        }
        ++c.gridy;
        c.gridx = 0;
        JLabel tipArticolL = new JLabel(Utils.getTranslation(LangRoAll.tipStoc, new String[0]));
        result.add((Component)tipArticolL, c);
        ++c.gridx;
        result.add((Component)this.tipArticolCombo, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel subcatLabel = new JLabel(Utils.getTranslation(LangRoAll.categorie));
        result.add((Component)subcatLabel, c);
        ++c.gridx;
        result.add((Component)this.subcategoriesCombo, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.valute), c);
        ++c.gridx;
        result.add((Component)this.valuteCombo, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.pretVz, new String[0])), c);
        ++c.gridx;
        result.add((Component)this.pret, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.cod, new String[0])), c);
        ++c.gridx;
        result.add((Component)this.codProdus, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.exportCantar, new String[0])), c);
        ++c.gridx;
        result.add((Component)this.exportCantar, c);
        result.setBorder(new TitledBorder(LangRoAll.tip));
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)this.saveButton, c);
        ++c.gridx;
        result.add((Component)this.inapoiButton, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    public void setObjectToEdit(Object o, Object entry, int selRow) {
        if (o != null) {
            this.stock = (Stock)o;
            this.toEditEntry = entry;
            this.selRow = selRow;
            this.setComponents(this.stock);
        } else {
            this.stock = null;
        }
    }

    public void cleanup() {
        this.subcategoriesCombo.removeAllItems();
    }

    public Valuta getValutaInCombo(Valuta v) {
        int x = this.valuteCombo.getItemCount();
        for (int i = 0; i < x; ++i) {
            Valuta z;
            Object y = this.valuteCombo.getItemAt(i);
            if (!(y instanceof Valuta) || !v.equals(z = (Valuta)y)) continue;
            return z;
        }
        return null;
    }
}

