/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.WriteException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockExcelProcessor;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.AddCerereAprovizionarePanel;
import ro.atreides.stocks.gui.ModificaPretDialog;
import ro.atreides.stocks.gui.StockModifiedInterface;
import ro.atreides.stocks.gui.StockViewCellRenderer;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class StockViewPanel
extends AbstractReportPanel
implements CleanupRequired,
StockModifiedInterface {
    private StockLogic stockLogic;
    private StockViewCellRenderer cellRenderer;
    private AbstractTM model;
    private JComboBox magazii;
    private JComboBox categorii;
    private JComboBox furnizori;
    private JComboBox tip;
    private JComboBox tipComanda;
    private XComboBox xStocks;
    private FilterableComboBoxModel xStocksComboModel;
    private DoubleClicked action;
    private Hashtable printCriteria = new Hashtable();
    private JButton stergeSelectia;
    private Vector selectedStocks = new Vector();
    private static boolean showPretAczColumn = false;
    private String[] newColumns;
    public static final String[] columns;
    private double totalAchizitie;
    private double totalVanzare;
    private double totalProfit;
    private JLabel totalAczLabel;
    private JLabel totalVzLabel;
    private JLabel totalProfitLabel;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private StockExcelProcessor excelProcessor;

    public StockViewPanel() {
        this.stockLogic = StockLogic.getInstance();
        this.excelProcessor = new StockExcelProcessor(this.getName(), this.newColumns);
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object m;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.printCriteria.put(LangRoAll.data, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date()));
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", ((Magazie)m).getId());
            this.printCriteria.put("Magazie", ((Magazie)m).getLabel());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        if (ComboUtils.anythingButAllSelected(this.xStocks)) {
            m = (Stock)this.xStocks.getSelectedItem();
            result.put("id_stock_key", ((Stock)m).getId());
            this.printCriteria.put("Stoc", ((Stock)m).getLabel());
        } else {
            result.put("id_stock_key", -1);
            this.printCriteria.remove("Stoc");
        }
        if (ComboUtils.anythingButAllSelected(this.categorii)) {
            m = (Categorie)this.categorii.getSelectedItem();
            result.put("id_subcategory_key", ((Categorie)m).getId());
            this.printCriteria.put(LangRoAll.categorie, ((Categorie)m).getName());
        } else {
            result.put("id_subcategory_key", -1);
            this.printCriteria.remove(LangRoAll.categorie);
        }
        if (ComboUtils.anythingButAllSelected(this.furnizori)) {
            m = (Client)this.furnizori.getSelectedItem();
            result.put("Furnizor", ((Client)m).getId());
            this.printCriteria.put("Furnizor", m.toString());
        } else {
            result.put("Furnizor", -1);
            this.printCriteria.remove("Furnizor");
        }
        String tipValue = (String)this.tip.getSelectedItem();
        if (tipValue.equalsIgnoreCase("Finit")) {
            this.printCriteria.put("finit_ingredient", "Finit");
            result.put("finit_ingredient", 2);
        } else if (tipValue.equalsIgnoreCase("Ingredient")) {
            this.printCriteria.put("finit_ingredient", "Ingredient");
            result.put("finit_ingredient", 1);
        } else if (tipValue.equalsIgnoreCase("Productie")) {
            this.printCriteria.put("finit_ingredient", "Productie");
            result.put("finit_ingredient", 3);
        } else {
            this.printCriteria.remove("finit_ingredient");
            result.put("finit_ingredient", -1);
        }
        if (this.tipComanda != null) {
            String selectedItem;
            switch (selectedItem = (String)this.tipComanda.getSelectedItem()) {
                case "Efectuate": {
                    result.put("Comanda Type", "(" + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip() + ")");
                    break;
                }
                case "Comenzi ferme": {
                    result.put("Comanda Type", "(" + StockLogic.COMANDA_TYPE.COMANDA_FERMA.getIdTip() + ")");
                    break;
                }
                case "Efectuate si comenzi ferme": {
                    result.put("Comanda Type", "(" + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip() + "," + StockLogic.COMANDA_TYPE.COMANDA_FERMA.getIdTip() + ")");
                    break;
                }
                case "Comenzi neconfirmate": {
                    result.put("Comanda Type", "(" + StockLogic.COMANDA_TYPE.TEMPORARA.getIdTip() + ")");
                    break;
                }
                default: {
                    result.put("Comanda Type", "");
                }
            }
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Integer idMagazie = (Integer)criteria.get("id_magazie");
        Integer idStock = (Integer)criteria.get("id_stock_key");
        Integer idCategorie = (Integer)criteria.get("id_subcategory_key");
        Integer idFurnizor = (Integer)criteria.get("Furnizor");
        Integer tipStock = (Integer)criteria.get("finit_ingredient");
        String tipComanda = (String)criteria.get("Comanda Type");
        return this.stockLogic.getStocksViewsForMagazie(idMagazie, idStock, idCategorie, idFurnizor, false, tipStock, this.whatToPrint, tipComanda);
    }

    private StockViewEntry getStockViewEntry(int idMagazie, int idStock) {
        Vector<StockViewEntry> stockViews = this.stockLogic.getStocksViewsForMagazie(idMagazie, idStock, -1, -1, false, -1, this.whatToPrint);
        if (stockViews.size() > 0) {
            return stockViews.get(0);
        }
        return null;
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, this.excelProcessor, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.raportStocuri, new String[0]);
    }

    @Override
    public AbstractTM buildTableModel() {
        this.newColumns = new String[showPretAczColumn ? columns.length : columns.length - 1];
        System.arraycopy(columns, 0, this.newColumns, 0, this.newColumns.length);
        this.model = new AbstractTM(this.newColumns, Utils.getStringClass(this.newColumns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                StockViewEntry sve = (StockViewEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sve.getNume() + " (" + sve.getUmName() + ")";
                    }
                    case 1: {
                        return sve.getMagazie();
                    }
                    case 2: {
                        return sve.getCodBare();
                    }
                    case 3: {
                        return Utils.getString3Decimals(sve.getStocActual());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sve.getPretPv());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sve.getValoarePa());
                    }
                    case 6: {
                        return sve.getValVzString();
                    }
                    case 7: {
                        return Utils.getString2Decimals(sve.getProfit());
                    }
                    case 8: {
                        return Utils.getString2Decimals(sve.getAdaosProcent());
                    }
                    case 9: {
                        return Utils.getString2Decimals(sve.getValoarePa() / sve.getStocActual());
                    }
                }
                return null;
            }
        });
        return this.model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        final StockViewPanel parent = this;
        result.add(new JLabel(Utils.getTranslation(LangRoAll.valAcz, new String[0])));
        this.totalAczLabel = new JLabel("");
        result.add(this.totalAczLabel);
        result.add(new JLabel(Utils.getTranslation(LangRoAll.valVz, new String[0])));
        this.totalVzLabel = new JLabel("");
        result.add(this.totalVzLabel);
        result.add(new JLabel(Utils.getTranslation(LangRoAll.valoareAdaos, new String[0])));
        this.totalProfitLabel = new JLabel("");
        result.add((Component)this.totalProfitLabel, "wrap");
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.sumaDinLoturiMultiple, new String[0])), "span 4");
        this.stergeSelectia = new JButton(Utils.getTranslation(LangRoAll.stergeSelectia));
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                StockViewPanel.this.clearSelection();
            }
        });
        result.add(this.stergeSelectia);
        JButton searchByCodBare = new JButton(Utils.getTranslation(LangRoAll.codBare));
        searchByCodBare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String cod = DialogUtils.inputDialog(parent, "", Utils.getTranslation(LangRoAll.codBare));
                Product p = NomeclaturaLogic.getInstance().getProductByCodBare(cod);
                if (p != null) {
                    int idStock = StockViewPanel.this.stockLogic.getStockInterface().getIdStock(p.getId());
                    if (idStock > 0) {
                        int position = StockViewPanel.this.findStock(idStock);
                        if (position > 0) {
                            StockViewPanel.this.table.scrollRectToVisible(StockViewPanel.this.table.getCellRect(position, 1, false));
                            ListSelectionModel selectionModel = StockViewPanel.this.table.getSelectionModel();
                            selectionModel.setSelectionInterval(position, position);
                        } else {
                            DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.produsulNegasitInTabel, new String[0]), LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.produsNestocabil, new String[0]), LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.codBareNegasitInBaza, new String[0]), LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)searchByCodBare, "wrap");
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.calculDinLoturiMultiple, new String[0])), "span 5");
        JButton avansate = new JButton("Avansate");
        avansate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem comaseazaProduse = new JMenuItem(Utils.getTranslation(LangRoAll.comaseazaProduse, new String[0]));
                    comaseazaProduse.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (StockViewPanel.this.selectedStocks.size() < 2) {
                                DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.selectatiCelPutin2Produse, new String[0]), LangRoAll.nuPotContinua);
                                popup.setVisible(false);
                                return;
                            }
                            Integer targetId = (Integer)StockViewPanel.this.selectedStocks.elementAt(0);
                            Stock s = StockViewPanel.this.stockLogic.getStockById(targetId);
                            if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.comasareConfirm, s.getLabel()), LangRoAll.confirmare)) {
                                StockViewPanel.this.selectedStocks.removeElementAt(0);
                                StockViewPanel.this.stockLogic.comaseazaProduse(StockViewPanel.this.selectedStocks, targetId);
                                StockViewPanel.this.clearSelection();
                                StockViewPanel.this.raport();
                            }
                            popup.setVisible(false);
                        }
                    });
                    popup.add(comaseazaProduse);
                    JMenuItem reincarcaStocuri = new JMenuItem(Utils.getTranslation(LangRoAll.refresh, new String[0]));
                    reincarcaStocuri.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            StockLogic.getInstance().refreshStocks();
                            popup.setVisible(false);
                        }
                    });
                    popup.add(reincarcaStocuri);
                    if (VpConfig.getInstance().futureStocksEnabled) {
                        JMenuItem comandaFurnizori = new JMenuItem("Comanda furnizori");
                        comandaFurnizori.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                StockViewPanel.this.doComandaFurnizori();
                                popup.setVisible(false);
                            }
                        });
                        popup.add(comandaFurnizori);
                    }
                    JMenuItem cerereAprovizionare = new JMenuItem(Utils.getTranslation(LangRoAll.cerereAprovizionare, new String[0]));
                    cerereAprovizionare.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            for (Object o : StockViewPanel.this.tm.getData()) {
                                Magazie magazie;
                                StockViewEntry sve = (StockViewEntry)o;
                                if (!sve.isSelected() || (magazie = StockViewPanel.this.stockLogic.getMagazieById(sve.getIdMagazie())) == null) continue;
                                AddCerereAprovizionarePanel acap = new AddCerereAprovizionarePanel(sve.getIdStock(), magazie);
                                JDialog dialog = DialogUtils.getJDialog(acap, GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.cerereAprovizionare, new String[0]) + " \"" + sve.getNume() + "\"", 1.5);
                                acap.setDialog(dialog);
                                dialog.setVisible(true);
                            }
                            DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                        }
                    });
                    popup.add(cerereAprovizionare);
                    JMenuItem exportaExcel = new JMenuItem("Exporta Excel");
                    exportaExcel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String outputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "xls");
                            if (outputFile != null) {
                                File f = new File(outputFile);
                                StockViewPanel.this.exportFisaWarningCritic(f);
                                DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                            }
                            popup.setVisible(false);
                        }
                    });
                    popup.add(exportaExcel);
                    JMenuItem importaExcelModLevel = new JMenuItem("Importa stoc minim/maxim");
                    popup.add(importaExcelModLevel);
                    importaExcelModLevel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String inputFile = FileDialog.getLoadDialogLocation(parent, LangRoAll.alegetiFisierulSursa, "xls");
                            if (inputFile != null) {
                                boolean b = StockViewPanel.this.stockLogic.importFisaWarningCriticForStocks(inputFile);
                                if (b) {
                                    DialogUtils.okDialog(parent, "Import efectuat", LangRoAll.succes);
                                } else {
                                    DialogUtils.errorDialog(parent, "A avut log o eroare la import", LangRoAll.eroare);
                                }
                            }
                            popup.setVisible(false);
                        }
                    });
                    popup.setInvoker(StockViewPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        result.add((Component)avansate, "wrap");
        return result;
    }

    private int findStock(int idStock) {
        for (int i = 0; i < this.data.size(); ++i) {
            StockViewEntry stockViewEntry = (StockViewEntry)this.data.elementAt(i);
            if (stockViewEntry.getIdStock() != idStock) continue;
            return i;
        }
        return -1;
    }

    private void clearSelection() {
        this.selectedStocks.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            StockViewEntry stockViewEntry = (StockViewEntry)this.data.elementAt(i);
            stockViewEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][][grow]"));
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.magazie, new String[0])));
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, "growx, span, wrap");
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.stoc, new String[0])));
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.xStocks = new XComboBox(this.xStocksComboModel);
        buttonsPanel.add((Component)this.xStocks, "growx, span, wrap");
        buttonsPanel.add(new JLabel(LangRoAll.categorie));
        this.categorii = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            buttonsPanel.add((Component)this.categorii, "growx");
        } else {
            buttonsPanel.add((Component)this.categorii, "growx, span, wrap");
        }
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.furnizor, new String[0])));
        this.furnizori = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            buttonsPanel.add((Component)this.furnizori, "growx, wrap");
        } else {
            buttonsPanel.add((Component)this.furnizori, "growx, span, wrap");
        }
        buttonsPanel.add(new JLabel(Utils.getTranslation(LangRoAll.tipStoc, new String[0])));
        this.tip = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            buttonsPanel.add((Component)this.tip, "growx");
        } else {
            buttonsPanel.add((Component)this.tip, "growx, span, wrap");
        }
        if (VpConfig.getInstance().futureStocksEnabled) {
            buttonsPanel.add(new JLabel(LangRoAll.tipComanda));
            this.tipComanda = new JComboBox();
            buttonsPanel.add((Component)this.tipComanda, "growx");
        }
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.updateTotalLabels();
    }

    private void updateTotalLabels() {
        this.totalAczLabel.setText(Utils.getString2Decimals(this.totalAchizitie));
        this.totalVzLabel.setText(Utils.getString2Decimals(this.totalVanzare));
        this.totalProfitLabel.setText(Utils.getString2Decimals(this.totalProfit));
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public void stockModified(Object sourceVe1, int selRow) {
        StockViewEntry sourceVe = (StockViewEntry)sourceVe1;
        int idMagazie = sourceVe.getIdMagazie();
        if (idMagazie <= 0) {
            idMagazie = -1;
        }
        this.totalAchizitie -= sourceVe.getValoarePa();
        this.totalVanzare -= sourceVe.getValoarePv();
        StockViewEntry newObject = this.getStockViewEntry(idMagazie, sourceVe.getIdStock());
        this.tm.setObjectAt(selRow, newObject);
        this.totalAchizitie += newObject.getValoarePa();
        this.totalVanzare += newObject.getValoarePv();
        this.updateTotalLabels();
        this.tm.fireTableRowsUpdated(selRow, selRow);
    }

    private void stockDeleted(StockViewEntry sourceVe, int selRow) {
        this.totalAchizitie -= sourceVe.getValoarePa();
        this.totalVanzare -= sourceVe.getValoarePv();
        this.updateTotalLabels();
        this.tm.getData().remove(sourceVe);
        this.tm.fireTableRowsDeleted(selRow, selRow);
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, this.stockLogic.getMagazii());
        ComboUtils.replaceItemsForCombo(this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
        ComboUtils.replaceItemsForCombo(this.furnizori, this.stockLogic.getStockInterface().getFurnizori(-1));
        if (VpConfig.getInstance().futureStocksEnabled) {
            this.refreshTipComandaItems();
        }
        this.tip.addItem("All");
        this.tip.addItem("Finit");
        this.tip.addItem("Ingredient");
        this.tip.addItem("Productie");
        this.cellRenderer = new StockViewCellRenderer(this.model);
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
        final StockViewPanel parent = this;
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StockViewPanel.this.xStocksComboModel.refresh(StockViewPanel.this.stockLogic.getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "StockViewPanel_stocks";
            }
        }, 26);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final StockViewEntry sourceVe = (StockViewEntry)StockViewPanel.this.model.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!sourceVe.isSelected()) {
                        StockViewPanel.this.selectedStocks.add(new Integer(sourceVe.getIdStock()));
                    } else {
                        StockViewPanel.this.selectedStocks.remove(new Integer(sourceVe.getIdStock()));
                    }
                    sourceVe.setSelected(!sourceVe.isSelected());
                    StockViewPanel.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else {
                    JMenuItem toIngredient;
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                    popup.add(edit);
                    edit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Stock s = StockViewPanel.this.stockLogic.getStockById(sourceVe.getIdStock());
                            StockViewPanel.this.action.doubleClicked(s, sourceVe, selRow);
                            popup.setVisible(false);
                        }
                    });
                    JMenuItem modificaPret = new JMenuItem(Utils.getTranslation(LangRoAll.corectieStocPret, new String[0]));
                    popup.add(modificaPret);
                    modificaPret.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int idStock = sourceVe.getIdStock();
                            double oldPrice = StockViewPanel.this.stockLogic.getCatalogPriceForStock(idStock);
                            double cantitate = sourceVe.getStocActual();
                            Magazie m = StockViewPanel.this.stockLogic.getMagazieById(sourceVe.getIdMagazie());
                            boolean fiscal = true;
                            if (Config.getInstance().getBoolean("piratMode")) {
                                switch (StockViewPanel.this.whatToPrint) {
                                    case 1: 
                                    case 3: {
                                        fiscal = false;
                                    }
                                }
                            }
                            ModificaPretDialog modPrice = new ModificaPretDialog(StockViewPanel.this.stockLogic.getMagazii(), m, parent, cantitate, oldPrice, sourceVe.getNume());
                            popup.setVisible(false);
                            if (modPrice.isSalvat()) {
                                double newPrice = modPrice.getPret();
                                double newCantitate = modPrice.getCantitate();
                                Magazie selected = modPrice.getChosenMagazie();
                                int idMagazie = selected.getId();
                                Date d = modPrice.getChosenDate();
                                StockViewPanel.this.stockLogic.corecteazaCuFaptic(idStock, idMagazie, newCantitate, new Timestamp(d.getTime()), cantitate, fiscal, StockViewPanel.this.whatToPrint);
                                if (StockViewPanel.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                                    StockViewPanel.this.stockLogic.modificaPretPtMagazia(idStock, newPrice, new Timestamp(d.getTime()));
                                }
                                StockViewPanel.this.stockModified(sourceVe, selRow);
                            }
                        }
                    });
                    if (!StockViewPanel.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                        JMenuItem toFinit = new JMenuItem(LangRoAll.transformaInMarfa);
                        popup.add(toFinit);
                        toFinit.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInMarfa, new String[0]), LangRoAll.confirmare)) {
                                    Product existingProduct = NomeclaturaLogic.getInstance().getProductByName(sourceVe.getNume());
                                    boolean allowProduseDuplicate = Config.getInstance().getBoolean("allowProduseDuplicate");
                                    if (existingProduct != null && !allowProduseDuplicate) {
                                        DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.existaUnProdusCuAcestNume), LangRoAll.nuPotContinua);
                                    } else {
                                        StockViewPanel.this.stockLogic.toProdusFinit(sourceVe.getIdStock(), sourceVe.getNume());
                                        Stock s = StockViewPanel.this.stockLogic.getStockById(sourceVe.getIdStock());
                                        StockViewPanel.this.action.doubleClicked(s, sourceVe, selRow);
                                    }
                                    popup.setVisible(false);
                                }
                            }
                        });
                    }
                    if (StockViewPanel.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                        toIngredient = new JMenuItem(Utils.getTranslation(LangRoAll.transformaInMateriePrima, new String[0]));
                        popup.add(toIngredient);
                        toIngredient.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInMateriePrima, new String[0]), LangRoAll.confirmare)) {
                                    StockViewPanel.this.stockLogic.toIngredient(sourceVe.getIdStock());
                                    StockViewPanel.this.stockModified(sourceVe, selRow);
                                }
                                popup.setVisible(false);
                            }
                        });
                    }
                    if (StockViewPanel.this.stockLogic.isProdusFinit(sourceVe.getIdStock())) {
                        toIngredient = new JMenuItem(Utils.getTranslation(LangRoAll.transformaInReteta, new String[0]));
                        popup.add(toIngredient);
                        toIngredient.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInReteta, new String[0]), LangRoAll.confirmare)) {
                                    boolean adaugaReteta = DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.adaugamStoculInReteta, new String[0]), LangRoAll.confirmare);
                                    boolean stergeStoc = false;
                                    if (!adaugaReteta) {
                                        stergeStoc = DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.stergemStocul, new String[0]), LangRoAll.confirmare);
                                    }
                                    int idStoc = sourceVe.getIdStock();
                                    Product p = StockViewPanel.this.stockLogic.getProductForStock(idStoc);
                                    double price = StockViewPanel.this.stockLogic.getCatalogPriceForStock(idStoc);
                                    boolean ok = StockViewPanel.this.stockLogic.getStockInterface().transformaProdusFinitInReteta(sourceVe.getIdStock(), p.getId(), price, stergeStoc, adaugaReteta, parent);
                                    if (ok) {
                                        if (stergeStoc) {
                                            StockViewPanel.this.stockDeleted(sourceVe, selRow);
                                        } else {
                                            StockViewPanel.this.stockModified(sourceVe, selRow);
                                        }
                                    }
                                }
                                popup.setVisible(false);
                            }
                        });
                    }
                    JMenuItem folosireStock = new JMenuItem(Utils.getTranslation(LangRoAll.folosireInRetete, new String[0]));
                    popup.add(folosireStock);
                    folosireStock.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String folosit = StockViewPanel.this.stockLogic.getDeleteImpedimentsString(StockViewPanel.this.stockLogic.getDeleteImpediments(sourceVe.getIdStock()));
                            DialogUtils.okDialog(parent, folosit, sourceVe.getNume() + " : " + Utils.getTranslation(LangRoAll.folosireInRetete, new String[0]));
                            popup.setVisible(false);
                        }
                    });
                    JMenuItem stergeStock = new JMenuItem(Utils.getTranslation(LangRoAll.stergeStoc, new String[0]));
                    popup.add(stergeStock);
                    stergeStock.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean action = false;
                            if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.stergemStocul, new String[0]), LangRoAll.confirmare)) {
                                action = StockViewPanel.this.stockLogic.deleteStock(sourceVe.getIdStock(), parent);
                            }
                            popup.setVisible(false);
                            if (action) {
                                StockViewPanel.this.stockDeleted(sourceVe, selRow);
                                StockViewPanel.this.selectedStocks.remove(new Integer(sourceVe.getIdStock()));
                                StockLogic.getInstance().updatePowerSearchStocks(sourceVe.getIdStock(), new Vector<String>());
                            }
                        }
                    });
                    popup.setInvoker(StockViewPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(StockViewPanel.this.magazii, StockViewPanel.this.stockLogic.getMagazii());
            }

            @Override
            public String getName() {
                return "StockViewPanel_magazii";
            }
        }, 27);
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(StockViewPanel.this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
            }

            @Override
            public String getName() {
                return "StockViewPanel_categorii";
            }
        }, 1);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return StockViewPanel.this.newColumns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 14;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                    case 6: {
                        return 5;
                    }
                    case 7: {
                        return 5;
                    }
                    case 8: {
                        return 4;
                    }
                    case 9: {
                        return 4;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return StockViewPanel.this.newColumns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return StockViewPanel.this.totalAczLabel.getText();
                    }
                    case 6: {
                        return StockViewPanel.this.totalVzLabel.getText();
                    }
                    case 7: {
                        return StockViewPanel.this.totalProfitLabel.getText();
                    }
                    case 8: {
                        return "";
                    }
                    case 9: {
                        return "";
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return Utils.getTranslation(LangRoAll.raportStocuri, new String[0]);
            }

            @Override
            public Hashtable getCriteria() {
                return StockViewPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                StockViewEntry sve = (StockViewEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getNume() + " (" + sve.getUmName() + ")";
                    }
                    case 1: {
                        return sve.getMagazie();
                    }
                    case 2: {
                        return sve.getCodBare();
                    }
                    case 3: {
                        return Utils.getString3Decimals(sve.getStocActual());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sve.getPretPv());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sve.getValoarePa());
                    }
                    case 6: {
                        return Utils.getString2Decimals(sve.getValoarePv());
                    }
                    case 7: {
                        return Utils.getString2Decimals(sve.getProfit());
                    }
                    case 8: {
                        return Utils.getString2Decimals(sve.getAdaosProcent());
                    }
                    case 9: {
                        return Utils.getString2Decimals(sve.getValoarePa() / sve.getStocActual());
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs;
                    }
                    case 1: {
                        return LangRoAll.cantitate;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return Utils.getTranslation(LangRoAll.totalPretAchizitie, StockViewPanel.this.totalAczLabel.getText());
                    }
                    case 1: {
                        return Utils.getTranslation(LangRoAll.totalPretVanzare, StockViewPanel.this.totalVzLabel.getText());
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return StockViewPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return StockViewPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                StockViewEntry sve = (StockViewEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getNume();
                    }
                    case 1: {
                        return Utils.getString3Decimals(sve.getStocActual());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(this.cellRenderer);
        }
    }

    public final void setAction(DoubleClicked action) {
        this.action = action;
    }

    private void computeTotals(Vector items) {
        this.totalAchizitie = 0.0;
        this.totalVanzare = 0.0;
        this.totalProfit = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            StockViewEntry o = (StockViewEntry)items.elementAt(i);
            if (o.getValoarePv() > 1.0E-4) {
                this.totalVanzare += o.getValoarePv();
                this.totalProfit += o.getProfit();
            }
            this.totalAchizitie += o.getValoarePa();
        }
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
        this.categorii.removeAllItems();
    }

    public void exportFisaWarningCritic(File file) {
        this.stockLogic.exportFisaWarningCriticExcel(file, this.data);
    }

    private void refreshTipComandaItems() {
        this.tipComanda.removeAllItems();
        this.tipComanda.addItem("All");
        this.tipComanda.addItem("Efectuate");
        this.tipComanda.addItem("Comenzi ferme");
        this.tipComanda.addItem("Efectuate si comenzi ferme");
        this.tipComanda.addItem("Comenzi neconfirmate");
    }

    private void doComandaFurnizori() {
        Vector data = this.model.getData();
        if (!ComboUtils.anythingButAllSelected(this.furnizori)) {
            DialogUtils.errorDialog(this.getParent(), "Alegeti furnizor!", LangRoAll.nuPotContinua);
            return;
        }
        Client m = (Client)this.furnizori.getSelectedItem();
        this.stockLogic.doAprovizionare(data, m);
        DialogUtils.okDialog(this.getParent(), "Am completat ecranul cu niruri", LangRoAll.operatieExecutata);
    }

    static {
        showPretAczColumn = Config.getInstance().getBoolean("stockPanelShowPretAchzColumn");
        columns = new String[]{Utils.getTranslation(LangRoAll.name, new String[0]), Utils.getTranslation(LangRoAll.magazie, new String[0]), LangRoAll.codBare, Utils.getTranslation(LangRoAll.stoc, new String[0]) + " *", Utils.getTranslation(LangRoAll.pretVz, new String[0]), Utils.getTranslation(LangRoAll.valIntr, new String[0]) + " *", Utils.getTranslation(LangRoAll.valVz, new String[0]) + " *", Utils.getTranslation(LangRoAll.adaos, new String[0]) + " *", Utils.getTranslation(LangRoAll.adaos, new String[0]) + " % **", Utils.getTranslation(LangRoAll.pretAcz, new String[0]) + " **"};
    }
}

