/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.stocks.gui.AddBonConsumPanel;
import ro.atreides.stocks.gui.AddTransferPanel;
import ro.atreides.stocks.gui.AprovizionareReport;
import ro.atreides.stocks.gui.BonConsumReport;
import ro.atreides.stocks.gui.ConsumuriPanel;
import ro.atreides.stocks.gui.FisaMagaziePanel;
import ro.atreides.stocks.gui.LoturiReport;
import ro.atreides.stocks.gui.RaportGestiunePanel;
import ro.atreides.stocks.gui.RaportGestiuneValoricPanel;
import ro.atreides.stocks.gui.RaportModificariPretPanel;
import ro.atreides.stocks.gui.StocFapticPanel;
import ro.atreides.stocks.gui.StockInput;
import ro.atreides.stocks.gui.StockViewPanel;
import ro.atreides.stocks.gui.TransferReport;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;

public class StocuriPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private StockViewPanel _stockViewPanel = null;
    private StockInput _stockInputPanel = null;
    private FisaMagaziePanel fisaPanel;
    private StocFapticPanel fapticPanel;
    private AddBonConsumPanel abc;
    private BonConsumReport bcr;
    private RaportGestiunePanel gestiune;
    private RaportGestiuneValoricPanel gestiuneValorica;
    private ConsumuriPanel consumuri;
    private AddTransferPanel atr;
    private TransferReport tr;
    private RaportModificariPretPanel raportModPretPan;
    private AprovizionareReport aprovizionareReport;

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    private void init() {
        this._tabbedPane = new JTabbedPane();
        this._stockViewPanel = new StockViewPanel();
        this._stockViewPanel.doStuff();
        this._tabbedPane.add("Stocuri", this._stockViewPanel);
        this._stockViewPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                StocuriPanel.this._stockInputPanel.setObjectToEdit(o, entry, selRow);
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this._stockInputPanel);
            }
        });
        this._stockInputPanel = new StockInput();
        this._stockInputPanel.setViewPanel(this._stockViewPanel);
        this._stockInputPanel.doStuff();
        this._tabbedPane.add("Definire stoc", this._stockInputPanel);
        this._stockInputPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this._stockViewPanel);
            }
        });
        this.fisaPanel = new FisaMagaziePanel();
        this._tabbedPane.add("Fise magazie", this.fisaPanel);
        this.fisaPanel.doStuff();
        this.fapticPanel = new StocFapticPanel();
        this._tabbedPane.add(this.fapticPanel.getName(), this.fapticPanel);
        this.fapticPanel.doStuff();
        this.gestiune = new RaportGestiunePanel();
        this.gestiune.doStuff();
        this._tabbedPane.add((Component)this.gestiune, this.gestiune.getName());
        this.consumuri = new ConsumuriPanel();
        this.consumuri.doStuff();
        this._tabbedPane.add((Component)this.consumuri, this.consumuri.getName());
        this.gestiuneValorica = new RaportGestiuneValoricPanel();
        this.gestiuneValorica.doStuff();
        this._tabbedPane.add((Component)this.gestiuneValorica, this.gestiuneValorica.getName());
        this.tr = new TransferReport();
        this.tr.doStuff();
        this._tabbedPane.add((Component)this.tr, this.tr.getName());
        this.atr = new AddTransferPanel(this);
        this.atr.doStuff();
        this._tabbedPane.add((Component)this.atr, "Adauga transfer");
        StockLogic.getInstance().setAddTransferPanel(this.atr);
        this.tr.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                StocuriPanel.this.atr.setTransferToEdit((StockTransfer)o);
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this.atr);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this.atr.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this.tr);
            }
        });
        this.bcr = new BonConsumReport();
        this.bcr.doStuff();
        this._tabbedPane.add((Component)this.bcr, this.bcr.getName());
        this.abc = new AddBonConsumPanel(this);
        this.abc.doStuff();
        this._tabbedPane.add((Component)this.abc, "Adauga bon consum");
        StockLogic.getInstance().setAddConsumPanel(this.abc);
        this.bcr.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                StocuriPanel.this.abc.setBonToEdit((BonConsum)o);
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this.abc);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this.abc.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                StocuriPanel.this._tabbedPane.setSelectedComponent(StocuriPanel.this.bcr);
            }
        });
        this.raportModPretPan = new RaportModificariPretPanel();
        this.raportModPretPan.doStuff();
        this._tabbedPane.add((Component)this.raportModPretPan, LangRoAll.raportModificariPreturi);
        this.aprovizionareReport = new AprovizionareReport();
        this.aprovizionareReport.doStuff();
        this._tabbedPane.add((Component)this.aprovizionareReport, this.aprovizionareReport.getName());
        if (LicenseManager.getInstance().isFunctionLicensed("ALLOW_LOT_CHOOSING_BY_USER")) {
            LoturiReport report = new LoturiReport();
            report.doStuff();
            this._tabbedPane.add((Component)report, report.getName());
        }
        GuiUtilsRest.addPiratGuiMouseListenerForReports(this._tabbedPane);
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
    }

    @Override
    public void cleanup() {
        this.abc.cleanup();
        this.fisaPanel.cleanup();
        this.fapticPanel.cleanup();
        this.bcr.cleanup();
        this.atr.cleanup();
        this.tr.cleanup();
        this._stockInputPanel.cleanup();
        this._stockViewPanel.cleanup();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }
}

