/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class TransferReport
extends AbstractReportPanel
implements CleanupRequired {
    private StockLogic logic;
    private double totalPv;
    private double totalPa;
    private JLabel totalPvLabel;
    private JLabel totalPaLabel;
    private JComboBox magazieSursa;
    private JComboBox magazieDestinatie;
    private JComboBox tipTransfer;
    private ReportInterface reportInterface;
    protected DoubleClicked action;
    private Hashtable printCriteria = new Hashtable();
    public static final String[] columns = new String[]{"Nr doc", "Magazie sursa", "Magazie destinatie", LangRoAll.data, "Total pa", "Total pv", "Pret acz fix"};
    public static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};

    public TransferReport() {
        this.logic = StockLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.magazieSursa)) {
            Magazie sursa = (Magazie)this.magazieSursa.getSelectedItem();
            result.put("id_magazie", Integer.valueOf(sursa.getId()));
        } else {
            result.put("id_magazie", Integer.valueOf(-1));
        }
        if (ComboUtils.anythingButAllSelected(this.magazieDestinatie)) {
            Magazie dest = (Magazie)this.magazieDestinatie.getSelectedItem();
            result.put("id_magazie_destinatie", Integer.valueOf(dest.getId()));
        } else {
            result.put("id_magazie_destinatie", Integer.valueOf(-1));
        }
        String tip = (String)this.tipTransfer.getSelectedItem();
        int tipTransfer = this.logic.getTransferTip(tip);
        result.put("Tip transfer", Integer.valueOf(tipTransfer));
        this.printCriteria.put("Tip transfer", tip);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridx;
        c.weightx = 1.0;
        this.magazieSursa = new JComboBox();
        result.add((Component)this.magazieSursa, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie destinatie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazieDestinatie = new JComboBox();
        result.add((Component)this.magazieDestinatie, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip transfer"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipTransfer = new JComboBox();
        result.add((Component)this.tipTransfer, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                StockTransfer st = (StockTransfer)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return st.getNrBon();
                    }
                    case 1: {
                        return st.getSursa();
                    }
                    case 2: {
                        return st.getDestinatie();
                    }
                    case 3: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(st.getTimp().getTime());
                    }
                    case 4: {
                        return Utils.getString2Decimals(st.getValPa());
                    }
                    case 5: {
                        return Utils.getString2Decimals(st.getValPv());
                    }
                    case 6: {
                        return new Boolean(st.isPretAczFix());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Total pret achizitie"), c);
        ++c.gridx;
        this.totalPaLabel = new JLabel("");
        result.add((Component)this.totalPaLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total pret vanzare"), c);
        ++c.gridx;
        this.totalPvLabel = new JLabel("");
        result.add((Component)this.totalPvLabel, c);
        return result;
    }

    @Override
    public String getName() {
        return "Transferuri";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getTransferuri(criteria);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalPvLabel.setText(Utils.getString2Decimals(this.totalPv));
        this.totalPaLabel.setText(Utils.getString2Decimals(this.totalPa));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    StockTransfer entry = (StockTransfer)o;
                    try {
                        int column = 0;
                        sheet.addCell((WritableCell)new Number(column, row, (double)entry.getNrBon().intValue()));
                        Label label = new Label(++column, row, entry.getSursa());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getDestinatie());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, Formatters.DATE_AND_TIME_FORMAT.format(entry.getTimp().getTime()));
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getValPa()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getValPv()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return TransferReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public DoubleClicked getAction() {
        return this.action;
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public void doStuff() {
        this.refreshMagaziiCombo();
        final TransferReport panel = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final StockTransfer st = (StockTransfer)TransferReport.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem factura = new JMenuItem(LangRoAll.trimiteLaFacturare);
                factura.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        boolean retur = DialogUtils.confirmDialog(panel, "Factura de retur", "Tipul facturii");
                        TransferReport.this.logic.transferLaFacturare(st, retur);
                        popup.setVisible(false);
                    }
                });
                popup.add(factura);
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        TransferReport.this.action.doubleClicked(st);
                        popup.setVisible(false);
                    }
                });
                popup.add(modifica);
                JMenuItem receptie = new JMenuItem("Trimite la receptie");
                receptie.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        DialogUtils.errorDialog(panel, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
                        popup.setVisible(false);
                    }
                });
                popup.add(receptie);
                JMenuItem sterge = new JMenuItem("Sterge transfer");
                sterge.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        boolean ok = DialogUtils.confirmDialog(panel, "Doriti sa stergeti acest transfer", LangRoAll.confirmare);
                        if (ok) {
                            TransferReport.this.logic.deleteTransfer(st.getId(), panel, st.getTimp());
                        }
                        popup.setVisible(false);
                        TransferReport.this.raport();
                    }
                });
                popup.add(sterge);
                popup.setInvoker(TransferReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                TransferReport.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "TransferReport_magaziiChanged";
            }
        }, 27);
        this.logic.fillTipTransferCombo(this.tipTransfer, true);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return TransferReport.this.totalPaLabel.getText();
                    }
                    case 5: {
                        return TransferReport.this.totalPvLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return "Transferuri";
            }

            @Override
            public Hashtable getCriteria() {
                return TransferReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                StockTransfer sqv = (StockTransfer)row;
                switch (column) {
                    case 0: {
                        return sqv.getNrBon() + "";
                    }
                    case 1: {
                        return sqv.getSursa();
                    }
                    case 2: {
                        return sqv.getDestinatie();
                    }
                    case 3: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(sqv.getTimp());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sqv.getValPa());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sqv.getValPv());
                    }
                }
                return null;
            }
        };
    }

    private void refreshMagaziiCombo() {
        TransferReport transferReport = this;
        Vector<Magazie> magazii = transferReport.logic.getInstance().getMagazii();
        ComboUtils.replaceItemsForCombo(this.magazieSursa, magazii, true);
        ComboUtils.replaceItemsForCombo(this.magazieDestinatie, magazii, true);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void computeTotals(Vector items) {
        this.totalPv = 0.0;
        this.totalPa = 0.0;
        for (StockTransfer element : items) {
            this.totalPv += element.getValPv();
            this.totalPa += element.getValPa();
        }
    }

    @Override
    public void cleanup() {
        this.magazieSursa.removeAllItems();
        this.magazieDestinatie.removeAllItems();
        this.tipTransfer.removeAllItems();
    }
}

