/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.terminal.TerminalInMessage;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public abstract class AbstractTerminal
extends Thread {
    Vector receivedMessages = new Vector();
    Vector toSend = new Vector();
    private String portName;
    private InputStream inS;
    private OutputStream outS;
    private Object outLock = new Object();
    private Object inLock = new Object();

    public AbstractTerminal(String port) {
        this.portName = port;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getReceivedMessages() {
        Object object = this.inLock;
        synchronized (object) {
            Vector result = (Vector)this.receivedMessages.clone();
            this.receivedMessages.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Integer i) {
        Object object = this.outLock;
        synchronized (object) {
            this.toSend.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block27: {
            serialPort = null;
            if (!Validators.correctString(this.portName)) break block27;
            portFound = false;
            portId = null;
            Logger.logDebug(this, "initializing port: " + this.portName);
            portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                shortPortName = this.portName.replace("/dev/", "");
                curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(this.portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + this.portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                Logger.logDebug(this, "Port incorect: " + this.portName);
                DialogUtils.errorDialog(GuiUtils.currentFrame, "AbstractTerminal: port incorect : \"" + this.portName + "\"", LangRoAll.nuPotContinua);
                return;
            }
            try {
                serialPort = (SerialPort)portId.open("AbstractTerminal", 2000);
                this.inS = serialPort.getInputStream();
                this.outS = serialPort.getOutputStream();
                lastSent = System.currentTimeMillis();
                lastRead = System.currentTimeMillis();
                readTimeout = 40000L;
                writeTimeout = 30000L;
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        while (true) {
                            toRead = this.inS.available();
                            somethingDone = false;
                            if (toRead > 0) {
                                r = this.inS.read();
                                lastRead = System.currentTimeMillis();
                                var16_20 = this.inLock;
                                synchronized (var16_20) {
                                    m = new TerminalInMessage();
                                    m.setTimestamp(lastRead);
                                    m.setValue(r);
                                    this.receivedMessages.add(m);
                                    Logger.logDebug(this, "Am citit: " + (char)r);
                                }
                                somethingDone = true;
                            } else if (lastRead + readTimeout < System.currentTimeMillis()) {
                                Logger.logWarning(this, "Read timeout. Verificati conexiunea cu terminalul.");
                                lastRead = System.currentTimeMillis();
                            }
                            if (this.toSend.size() > 0) {
                                var15_19 = this.outLock;
                                synchronized (var15_19) {
                                    c = (Integer)this.toSend.get(0);
                                    i = c;
                                    try {
                                        this.outS.write(i);
                                        Logger.logDebug(this, "Am scris: " + (char)i);
                                    }
                                    catch (IOException e) {
                                        Logger.logException(this, (Exception)e);
                                    }
                                    this.toSend.remove(0);
                                }
                                somethingDone = true;
                            }
                            if (lastSent + writeTimeout < System.currentTimeMillis()) {
                                this.outS.write(200);
                                Logger.logDebug(this, "Am scris: \u00c8");
                                this.outS.write(201);
                                Logger.logDebug(this, "Am scris: \u00c9");
                                lastSent = System.currentTimeMillis();
                            }
                            if (somethingDone) continue;
                            Thread.sleep(200L);
                        }
                    }
                    catch (IOException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, th);
                        continue;
                    }
                    break;
                }
            }
            catch (PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "AbstractTerminal: port ocupat : \"" + this.portName + "\"", LangRoAll.nuPotContinua);
                serialPort.close();
                Logger.logDebug(this, "Am inchis portul: " + this.portName);
            }
            catch (Exception e) {
                try {
                    Logger.logException(this, e);
                }
                catch (Throwable var20_26) {
                    throw var20_26;
                }
                finally {
                    serialPort.close();
                    Logger.logDebug(this, "Am inchis portul: " + this.portName);
                }
            }
            ** GOTO lbl-1000
        }
    }
}

