/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.update;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.SAXParser;
import ro.atreides.update.Version;
import ro.atreides.update.VersionHandler;
import ro.atreides.update.VersionInstall;
import ro.atreides.update.files.FileHandler;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.sql.SqlUtils;

public class UpdateMain {
    public static String updateURL;
    public static String launchCommand;
    public static int updateType;
    public static int stability;

    public static void startClient() {
        new Thread(){

            @Override
            public void run() {
                String changeLog = UpdateMain.installUpdates();
                if (changeLog != null) {
                    Utils.restartVirtualMachine(launchCommand);
                }
            }
        }.start();
    }

    public static void startServer() {
    }

    public static String installUpdates() {
        try {
            int installedOK = UpdateMain.searchForUpdates(GuiUtils.currentVersion, updateURL, "versions.xml", FileUtils.getCurrentDir(), stability);
            DatabaseManager db = DatabaseManager.getInstance();
            if (installedOK > 0 && updateType == 1) {
                String versionsDir = UpdateMain.getVersionsDir(FileUtils.getCurrentDir());
                String updateString = FileUtils.readFileToString(UpdateMain.getDbUpdateFile(versionsDir));
                StringTokenizer token = new StringTokenizer(updateString, ";");
                while (token.hasMoreTokens()) {
                    String command = token.nextToken().trim();
                    if ((command = command.replaceAll("\n", "")).length() <= 0) continue;
                    SqlUtils.executeUpdate(command, db.getFirstConnection());
                }
                String changeLog = FileUtils.readFileToString(UpdateMain.getChangeLogFile(versionsDir));
                return changeLog;
            }
        }
        catch (SQLException e) {
            Logger.logException("UpdateMain", (Exception)e);
        }
        catch (IOException e) {
            Logger.logException("UpdateMain", (Exception)e);
        }
        return null;
    }

    public static String getVersionsDir(String applicationRoot) {
        return applicationRoot + File.separator + "versions";
    }

    public static String getVersionsXmlFile(String versionsDir) {
        return versionsDir + File.separatorChar + "versions.xml";
    }

    public static String getDbUpdateFile(String versionsDir) {
        return versionsDir + File.separator + "db_update.txt";
    }

    public static String getChangeLogFile(String versionsDir) {
        return versionsDir + File.separator + "changelog.txt";
    }

    public static int searchForUpdates(String currentVersion, String repository, String versionsFile, String applicationRoot, int requiredStability) {
        SAXParser r = new SAXParser();
        VersionHandler versionHandler = new VersionHandler();
        r.setContentHandler(versionHandler);
        r.setErrorHandler(versionHandler);
        Logger.logDebug("UpdateMain", "Current Version: " + currentVersion);
        int installedOK = 0;
        try {
            String versionsDir = UpdateMain.getVersionsDir(applicationRoot);
            if (!FileHandler.downloadURL(repository + versionsFile, versionsDir)) {
                return 0;
            }
            versionHandler.setVariables(currentVersion, applicationRoot, repository);
            r.parse(UpdateMain.getVersionsXmlFile(versionsDir));
            List vList = versionHandler.getVersions();
            int noUpd = vList.size();
            if (noUpd == 0) {
                Logger.logDebug("UpdateMain", "No updates available for install");
            } else {
                Logger.logDebug("UpdateMain", "Updates available for install: " + noUpd);
                if (!FileHandler.createEmptyFile(UpdateMain.getDbUpdateFile(versionsDir))) {
                    return 0;
                }
                if (!FileHandler.createEmptyFile(UpdateMain.getChangeLogFile(versionsDir))) {
                    return 0;
                }
                for (int i = 0; i < vList.size(); ++i) {
                    Version v = (Version)vList.get(i);
                    if (v.stability >= requiredStability) {
                        VersionInstall vi = new VersionInstall();
                        boolean succes = vi.install(v, applicationRoot);
                        if (succes) {
                            currentVersion = v.getVersionStop();
                            ++installedOK;
                            Logger.logDebug("UpdateMain", "Installation of " + v.toString() + ": OK");
                            continue;
                        }
                        Logger.logDebug("UpdateMain", "Installation of " + v.toString() + ": NOK");
                        continue;
                    }
                    Logger.logDebug("UpdateMain", "Installation of " + v.toString() + ": required stability : " + requiredStability + " but got : " + v.stability);
                }
            }
        }
        catch (Exception e) {
            Logger.logException("UpdateMain", e);
        }
        return installedOK;
    }
}

