/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.update;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.update.Code;
import ro.atreides.update.Version;
import ro.atreides.update.files.FileHandler;

public class VersionHandler
extends DefaultHandler {
    List versionList = new ArrayList();
    private String tempVal;
    private Version tempVers;
    private Code codeVers;
    String currentVersion;
    String appPath;
    String repository;

    public List getVersions() {
        return this.versionList;
    }

    public void setVariables(String version, String path, String repository) {
        this.currentVersion = version;
        this.appPath = path;
        this.repository = repository;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (qName.equalsIgnoreCase("version")) {
            this.tempVers = new Version();
            this.tempVers.setVersionStart(attributes.getValue("versionStart"));
            this.tempVers.setVersionStop(attributes.getValue("versionStop"));
            this.tempVers.setMd5(attributes.getValue("md5"));
            this.tempVers.setArchive(attributes.getValue("archive"));
            int stab = Integer.parseInt(attributes.getValue("stability"));
            this.tempVers.setStability(stab);
        }
        if (qName.equalsIgnoreCase("code")) {
            this.codeVers = new Code();
            this.codeVers.setPath(attributes.getValue("path"));
            this.codeVers.setToAdd(attributes.getValue("toAdd"));
            this.codeVers.setToRemove(attributes.getValue("toRemove"));
            this.tempVers.addCode(this.codeVers);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tempVal != null) {
            String value = new String(ch, start, length);
            this.tempVal = this.tempVal + value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("version")) {
            if (!this.currentVersion.equals(this.tempVers.getVersionStart())) {
                return;
            }
            String zipURL = this.repository + this.tempVers.getArchive();
            String zipPath = this.appPath + File.separator + "versions" + File.separator + this.tempVers.getArchive();
            if (!FileHandler.downloadURL(zipURL, this.appPath + File.separator + "versions")) return;
            if (FileHandler.md5check(zipPath, this.tempVers.getMd5())) {
                this.currentVersion = this.tempVers.getVersionStop();
                this.versionList.add(this.tempVers);
                return;
            }
            try {
                new File(zipPath).delete();
                return;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            return;
        }
        if (qName.equalsIgnoreCase("db")) {
            this.tempVers.setDb(this.tempVal.trim());
            return;
        } else {
            if (!qName.equalsIgnoreCase("docs")) return;
            this.tempVers.setDocs(this.tempVal.trim());
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }
}

