/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.users;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import ro.atreides.users.Group;
import ro.atreides.users.GuiPanel;
import ro.atreides.users.PermissionEntry;
import ro.atreides.users.User;
import ro.atreides.users.UserDeleteInterface;
import ro.atreides.users.UserEntry;
import ro.atreides.users.UserLogListener;
import ro.atreides.utils.CancelException;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.UserLogInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.LoginDialog;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.tricky.TrickyInterface;
import ro.atreides.utils.users.db.UsersImpl;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class UsersLogic
extends EventGenerator
implements UserLogInterface {
    private static UsersLogic instance;
    private UserDeleteInterface userInterface;
    private ConnectionPool pool;
    public static final int VIRTUAL_USER = 1;
    public static final int REAL_USER = 0;
    private Vector<UserLogListener> foListeners = new Vector();

    private UsersLogic() {
        this.pool = ConnectionPool.getInstance();
    }

    public static synchronized UsersLogic getInstance() {
        if (instance == null) {
            instance = new UsersLogic();
        }
        return instance;
    }

    private synchronized UsersImpl getUsersImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        UsersImpl dao = null;
        while (dao == null) {
            dao = (UsersImpl)this.pool.getDao(UsersImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(UsersImpl.class.getName(), connection);
        }
        return dao;
    }

    public UserDeleteInterface getUserInterface() {
        return this.userInterface;
    }

    public void addFrontOfficeListener(UserLogListener listener) {
        this.foListeners.add(listener);
    }

    private void notifyFrontOfficeListeners(int idUser, String text) throws SQLException {
        for (UserLogListener listener : this.foListeners) {
            listener.log(idUser, text);
        }
    }

    public void setUserInterface(UserDeleteInterface userInterface) {
        this.userInterface = userInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserEntry addUser(String userName, String passwd, String login, int language, Vector groups, Vector permissions, String codAutentificare, String codUnic) {
        try {
            UserEntry user = new UserEntry(-1, login, passwd, userName, language, codAutentificare, codUnic);
            user.setGroups(groups);
            this.getUsersImpl().addUser(user);
            int id = this.pool.requestConnection().getIndentityLocal();
            this.addUserToGroups(id, groups);
            this.addGuiPermissionsToUser(id, permissions);
            user.setId(id);
            this.pool.commit();
            this.notifyListeners(4);
            UserEntry userEntry = user;
            return userEntry;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            UserEntry userEntry = null;
            return userEntry;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateUser(User u, String newName, String newPass, String login, int language, Vector groups, Vector permissions, String codAutentificare, String codUnic) {
        int userId = u.getId();
        try {
            u.setPassword(newPass);
            u.setLogin(login);
            u.setLanguage(language);
            u.setName(newName);
            u.setCodAutentificare(codAutentificare);
            u.setCodUnic(codUnic);
            this.getUsersImpl().updateUser(u);
            this.getUsersImpl().removeUserFromAllGroups(userId);
            this.addUserToGroups(userId, groups);
            this.getUsersImpl().removeAllGuiPermissionsFromUser(userId);
            this.addGuiPermissionsToUser(userId, permissions);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(4);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void addGuiPermissionsToUser(int userId, Collection permissions) throws SQLException {
        for (PermissionEntry element : permissions) {
            this.getUsersImpl().addGuiPermissionToUser(userId, element.getPanelId(), element.getPermissionId());
        }
    }

    private void addUserToGroups(int userId, Collection groups) throws SQLException {
        for (Group element : groups) {
            this.getUsersImpl().addUserToGroup(userId, element.getId());
        }
    }

    public User getUserByIdNoCommit(int idUser) throws SQLException {
        User result = this.getUsersImpl().getUserById(idUser);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserById(int userId) {
        try {
            User user = this.getUserByIdNoCommit(userId);
            return user;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            User user = null;
            return user;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public User getUserByLoginNoCommit(String userName) throws SQLException {
        User result = this.getUsersImpl().getUserByLogin(userName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByLogin(String userName) {
        try {
            User result;
            User user = result = this.getUserByLoginNoCommit(userName);
            return user;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            User user = null;
            return user;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void updateUser(User user) {
        try {
            this.getUsersImpl().updateUser(user);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllUsers() {
        Vector u = null;
        try {
            Vector vector = u = this.getUsersImpl().getAllUsers(0);
            return vector;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            Vector vector = null;
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<User> getUsersInGroupNoCommit(String groupKey) throws SQLException {
        Vector<User> result = this.getUsersImpl().getUsersInGroup(groupKey);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<User> getUsersInGroup(String groupKey) {
        try {
            Vector<User> result;
            Vector<User> vector = result = this.getUsersInGroupNoCommit(groupKey);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<User> vector = new Vector<User>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean isUserInGroup(int idUser, String groupKey) {
        Vector<User> usersInGroup = this.getUsersInGroup(groupKey);
        for (int i = 0; i < usersInGroup.size(); ++i) {
            User user = usersInGroup.elementAt(i);
            if (user.getId() != idUser) continue;
            return true;
        }
        return false;
    }

    public String deleteUser(User toDelete, User currentUser) {
        try {
            String result = this.userInterface.canDeleteUser(toDelete);
            if (Validators.correctString(result)) {
                return result;
            }
            if (toDelete.equals(currentUser)) {
                return "Nu puteti sterge propriul utilizator";
            }
            this.getUsersImpl().deleteUser(toDelete);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(4);
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private boolean magicCondition(User element, String login, String passwd, String cod, boolean allowPasswords, boolean passwordRequested) {
        boolean sameName = element.getLogin().equals(login);
        boolean samePassword = element.getPassword().equals(passwd);
        boolean sameCodAuth = element.getCodAutentificare().equals(cod);
        boolean codAuthCompleted = cod.length() > 0;
        boolean passwordCompleted = passwd.length() > 0;
        boolean passwordOK = !passwordRequested || allowPasswords && samePassword && passwordCompleted;
        boolean codAuthOK = !passwordRequested && sameName || sameCodAuth && codAuthCompleted;
        boolean result = sameName && passwordOK || codAuthOK;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String login, String passwd, String codAutentificare, boolean allowPasswords, boolean passwordRequested) {
        Vector users = new Vector();
        try {
            users = this.getUsersImpl().getAllUsers(-1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        for (User element : users) {
            if (!this.magicCondition(element, login, passwd, codAutentificare, allowPasswords, passwordRequested)) continue;
            return element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByCodAutentificare(String cod) {
        User result = null;
        try {
            Vector users = this.getUsersImpl().getAllUsers(0);
            for (User element : users) {
                if (!element.getCodAutentificare().equals(cod) || cod.length() == 0) continue;
                result = element;
                break;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getBoLevelOnePanels(User currentUser) {
        try {
            Collection result;
            Collection collection = result = this.getUsersImpl().getPanelsByKey("gui_bo", currentUser.getLanguage());
            return collection;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
            this.pool.releaseConnection();
        }
    }

    public Collection getChildrenForPanelNoCommit(int panelId, int userId, User currentUser) throws SQLException {
        Collection result = this.getUsersImpl().getChildrenForPanel(panelId, userId, currentUser.getLanguage());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getChildrenForPanel(int panelId, int userId, User currentUser) {
        try {
            Collection collection = this.getChildrenForPanelNoCommit(panelId, userId, currentUser);
            return collection;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void buildGui(JTabbedPane container, Collection panels, User user, UserLogInterface userLogInterface, int depth) {
        int j = 0;
        for (GuiPanel uv : panels) {
            String panelClassName = uv.getClassName();
            boolean licenced = LicenseManager.getInstance().isGuiPanelLicenced(panelClassName);
            if (!licenced) continue;
            String panelTitle = uv.getPanelName();
            if (panelClassName.length() == 0) {
                JTabbedPane newContainer = new JTabbedPane();
                Collection children = this.getChildrenForPanel(uv.getId(), user.getId(), user);
                this.buildGui(newContainer, children, user, userLogInterface, depth + 1);
                container.add(panelTitle, newContainer);
                container.setBackgroundAt(j, Constants.BO_TAB_LEVEL_ONE_COLOR);
            } else {
                try {
                    long startTime = System.currentTimeMillis();
                    Component c = (Component)Class.forName(panelClassName).newInstance();
                    ReflectedJPanel rpanel = (ReflectedJPanel)c;
                    rpanel.setUserLogInterface(userLogInterface);
                    rpanel.doStuff();
                    long stopTime = System.currentTimeMillis();
                    Logger.logDebugVerbose(this, "SPEED Class \"" + panelClassName + "\" Took " + Utils.getString2Decimals((stopTime - startTime) / 1000L) + " seconds to load");
                    container.add(panelTitle, c);
                    container.setBackgroundAt(j, Constants.BO_TAB_LEVEL_ONE_COLOR);
                }
                catch (ClassNotFoundException ex) {
                    Logger.logException(this, (Exception)ex);
                }
                catch (Exception ex) {
                    Logger.logException(this, ex);
                }
                catch (Throwable th) {
                    Logger.logError((Object)this, th);
                }
            }
            ++j;
        }
    }

    public String getGroupsAsString(Collection groups) {
        String result = "";
        for (Group element : groups) {
            result = result + element.getName() + " ";
        }
        return result;
    }

    public String getPermissionsAsString(GuiPanel gp) {
        String result = "";
        if (gp.isView()) {
            result = result + "";
        }
        return result;
    }

    public String getLanguageById(int idLang) {
        return LanguageLogic.getInstance().getLanguageById(idLang).getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUserEntries(User currentUser) {
        Vector<UserEntry> result = new Vector<UserEntry>();
        try {
            Vector users = this.getAllUsers();
            for (User element : users) {
                UserEntry toAdd = new UserEntry(element.getId(), element.getLogin(), element.getPassword(), element.getName(), element.getLanguage(), element.getCodAutentificare(), element.getCodUnic());
                Vector permissions = this.getUsersImpl().getPermissionEntriesForUser(toAdd.getId(), currentUser.getLanguage());
                Vector<PermissionEntry> result1 = new Vector<PermissionEntry>();
                for (int i = 0; i < permissions.size(); ++i) {
                    PermissionEntry pe = (PermissionEntry)permissions.elementAt(i);
                    if (!LicenseManager.getInstance().isGuiPanelLicenced(pe.getClassname())) continue;
                    result1.add(pe);
                }
                toAdd.setPermissions(result1);
                Vector groups = this.getUsersImpl().getGroupsForUser(toAdd.getId(), currentUser.getLanguage());
                toAdd.setGroups(groups);
                result.add(toAdd);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public int getIdUserWithLogin(String login) {
        try {
            int result = this.getUsersImpl().selectIdUserByLoginName(login);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllPanels(User currentUser) {
        try {
            Vector result = this.getUsersImpl().getAllPanels(currentUser.getLanguage());
            Vector<GuiPanel> result1 = new Vector<GuiPanel>();
            for (int i = 0; i < result.size(); ++i) {
                GuiPanel guiPanel = (GuiPanel)result.elementAt(i);
                if (!LicenseManager.getInstance().isGuiPanelLicenced(guiPanel.getClassName())) continue;
                result1.add(guiPanel);
            }
            Vector<GuiPanel> i = result1;
            return i;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Collection getAllPermissions(User currentUser) {
        try {
            Collection result = this.getUsersImpl().getAllPermissions(currentUser.getLanguage());
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllGroups(User currentUser) {
        try {
            Collection result;
            Collection collection = result = this.getUsersImpl().getAllGroups(currentUser.getLanguage());
            return collection;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Collection collection = null;
            return collection;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getInferiorUsers(User currentUser) {
        try {
            int idLanguage = currentUser.getLanguage();
            Vector groups = this.getUsersImpl().getGroupsForUser(currentUser.getId(), idLanguage);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return this.getUsersInInferiorGroup(groups, idLanguage);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUsersInInferiorGroup(Vector groups, int idLanguage) {
        Vector result = new Vector();
        Vector inferiorGroups = this.getInferiorGroups(groups, idLanguage);
        try {
            for (int i = 0; i < inferiorGroups.size(); ++i) {
                Group g = (Group)inferiorGroups.elementAt(i);
                Vector v = this.getUsersImpl().getUsersByGroupId(g.getId());
                result.addAll(v);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getInferiorGroups(Vector groups, int idLanguage) {
        try {
            Vector result = this.getUsersImpl().getInferiorGroupsForGroups(groups, idLanguage);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public AdministrationPanel getAdminPanel(TrickyInterface tricky) throws CancelException {
        LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
        if (dialog.isCancel()) {
            throw new CancelException();
        }
        String user = dialog.getUserName();
        String passwd = dialog.getPassword();
        String cod = dialog.getCodAutentificare();
        if (Validators.correctString(cod)) {
            int trickyResult;
            if (tricky.isCardTricky1(cod) && DialogUtils.confirmDialog(GuiUtils.currentFrame, "Cod card prea scurt...I Continuam", LangRoAll.confirmare)) {
                trickyResult = tricky.doActionForCard1(cod);
                switch (trickyResult) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Utilizator sau parola incorecta...I", LangRoAll.eroare);
                        return null;
                    }
                }
            }
            if (tricky.isCardTricky2(cod) && DialogUtils.confirmDialog(GuiUtils.currentFrame, "Cod card prea scurt...II Continuam", LangRoAll.confirmare)) {
                trickyResult = tricky.doActionForCard2(cod);
                switch (trickyResult) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Utilizator sau parola incorecta...II", LangRoAll.eroare);
                        return null;
                    }
                }
            }
        }
        if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
            return null;
        }
        User u = UsersLogic.getInstance().getUser(user, passwd, cod, true, true);
        if (u != null) {
            if (this.isUserInGroup(u.getId(), "group_bo_users")) {
                AdministrationPanel adminPanel = new AdministrationPanel();
                adminPanel.setLoggedUser(u);
                adminPanel.doStuff();
                return adminPanel;
            }
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu aveti acces la aceasta sectiune", LangRoAll.nuPotContinua);
            return null;
        }
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Utilizator sau parola incorecte", LangRoAll.nuPotContinua);
        return null;
    }

    @Override
    public void addBOUserLogNoCommit(String text) throws SQLException {
        User u = AdministrationPanel.loggedUser;
        if (u != null) {
            this.getUsersImpl().addUserLog(u.getId(), text);
        }
    }

    @Override
    public void addUserLogNoCommit(int idUser, String text) throws SQLException {
        this.getUsersImpl().addUserLog(idUser, text);
        this.notifyFrontOfficeListeners(idUser, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUserLogCommit(int idUser, String text) {
        try {
            this.getUsersImpl().addUserLog(idUser, text);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserLogCount() {
        try {
            int n = this.getUsersImpl().getUserLogCount();
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBOUserLogCommit(String text) {
        try {
            User u = AdministrationPanel.loggedUser;
            if (u != null) {
                this.getUsersImpl().addUserLog(u.getId(), text);
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUserActions(Hashtable criteria) {
        try {
            Vector result;
            String prefix;
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            User u = (User)criteria.get(Constants.WAITER_KEY);
            int idUser = -1;
            if (u != null) {
                idUser = u.getId();
            }
            if ((prefix = (String)criteria.get(Constants.USER_LOG_TIP_OPERATIE_KEY)) == null) {
                prefix = "";
            }
            Vector vector = result = this.getUsersImpl().getUserLogReport(new Timestamp(start.getTime()), new Timestamp(stop.getTime()), idUser, prefix);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGroupsForUser(User u) {
        Vector groups = new Vector();
        try {
            groups = this.getUsersImpl().getGroupsForUser(u.getId(), u.getLanguage());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return groups;
    }

    public User requestAdminLogin(JFrame frame, boolean allowPasswords, boolean passwordRequested) {
        User u = this.requestLogin(frame, allowPasswords, passwordRequested);
        if (u != null && this.isUserInGroup(u.getId(), "group_bo_users")) {
            return u;
        }
        return null;
    }

    public User requestLogin(JFrame frame, boolean allowPasswords, boolean passwordRequested) {
        LoginDialog dialog = new LoginDialog((Frame)frame, true);
        String user = dialog.getUserName();
        String passwd = dialog.getPassword();
        String cod = dialog.getCodAutentificare();
        if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
            return null;
        }
        User u = this.getUser(user, passwd, cod, allowPasswords, passwordRequested);
        return u;
    }

    public User requestWaiterLogin(JFrame frame, boolean allowPasswords, boolean passwordRequested) {
        User u = this.requestLogin(frame, allowPasswords, passwordRequested);
        if (u != null && this.isUserInGroup(u.getId(), "group_fo_users")) {
            return u;
        }
        return null;
    }

    public User requestReceptionerLogin(JFrame frame, boolean allowPasswords, boolean passwordRequested) {
        User u = this.requestLogin(frame, allowPasswords, passwordRequested);
        if (u != null && this.isUserInGroup(u.getId(), "group_receptioneri")) {
            return u;
        }
        return null;
    }

    public User verifyWaiterLogin(String user, String password) {
        return this.verifyWaiterLogin(user, password, "", true, true);
    }

    public User verifyWaiterLogin(String user, String password, String codAutentificare, boolean allowPasswords, boolean passwordRequired) {
        User u = this.getUser(user, password, codAutentificare, allowPasswords, passwordRequired);
        if (u != null && this.isUserInGroup(u.getId(), "group_fo_users")) {
            return u;
        }
        return null;
    }

    public User verifyReceptionerLogin(String user, String password, String codAutentificare, boolean allowPasswords, boolean passwordRequired) {
        User u = this.getUser(user, password, codAutentificare, allowPasswords, passwordRequired);
        if (u != null && this.isUserInGroup(u.getId(), "group_receptioneri")) {
            return u;
        }
        return null;
    }

    public User verifyAdminLogin(String user, String password) {
        return this.verifyAdminLogin(user, password, "", true, true);
    }

    public User verifyAdminLogin(String user, String password, String codAutentificare, boolean allowPasswords, boolean passwordRequired) {
        User u = this.getUser(user, password, codAutentificare, allowPasswords, passwordRequired);
        if (this.isUserInGroup(u.getId(), "group_bo_users")) {
            return u;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTeam(int idTeam) {
        try {
            User u = this.getUsersImpl().getUserById(idTeam);
            if (u.isVirtual()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTeam(Vector members) {
        String teamName = "";
        try {
            int n;
            Vector allUsers = this.getUsersImpl().getAllUsers(1);
            for (int j = 0; j < allUsers.size(); ++j) {
                User user = (User)allUsers.elementAt(j);
                String cod = user.getCodUnic();
                boolean allOk = true;
                for (int i = 0; i < members.size() && allOk; ++i) {
                    Integer integer = (Integer)members.elementAt(i);
                    boolean found = Utils.findInt(integer, cod, ',');
                    if (found) continue;
                    allOk = false;
                }
                if (!allOk) continue;
                n = user.getId();
                return n;
            }
            for (int i = 0; i < members.size(); ++i) {
                Integer integer = (Integer)members.elementAt(i);
                User u = this.getUsersImpl().getUserById(integer);
                if (u != null) {
                    teamName = teamName + u.getLogin();
                }
                if (i >= members.size() - 1) continue;
                teamName = teamName + " + ";
            }
            String cod = Utils.getSqlInSequence(members);
            cod = cod.replaceAll("\\(", "");
            cod = cod.replaceAll("\\)", "");
            User team = new User(-1, teamName, "", teamName, 1, "", cod, true);
            this.getUsersImpl().addUser(team);
            int idTeam = this.pool.getIdentityLocal();
            Group g = this.getUsersImpl().getGroupByKey(1, "group_fo_users");
            this.getUsersImpl().addUserToGroup(idTeam, g.getId());
            this.pool.commit();
            n = idTeam;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getTeamMembers(int idTeam) {
        Vector<Integer> result = new Vector<Integer>();
        User u = this.getUserById(idTeam);
        String c = u.getCodUnic();
        Vector items = Utils.splitString(c, ',');
        for (int i = 0; i < items.size(); ++i) {
            String s = (String)items.elementAt(i);
            if (!Validators.correctInteger(s)) continue;
            result.add(Integer.parseInt(s));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTeamMember(int idMember, int idTeam) {
        try {
            User u = this.getUsersImpl().getUserById(idTeam);
            if (!u.isVirtual()) {
                boolean bl = false;
                return bl;
            }
            String cod = u.getCodUnic();
            boolean e = Utils.findInt(idMember, cod, ',');
            return e;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserLog() {
        try {
            this.getUsersImpl().deleteUserLog();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

