/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.users.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.users.WaiterSelection2Interface;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.atreides.utils.gui.keypad.VirtualKeypad;
import ro.atreides.utils.multilang.LangRoAll;

public class WaitersSelection2
extends JPanel {
    private WaiterSelection2Interface parent;
    private JPasswordField password = new JPasswordField(5);
    private JLabel ospatar = new JLabel("");
    private String parola = "";
    private String codAutentificare = "";
    private int retries = 0;
    private JPanel waitersPanel;
    public static final int MAX_RETRIES = 1;
    private Insets insets = new Insets(4, 4, 4, 4);
    private JPanel rightPanel;
    private boolean controllerMode;
    private boolean passwordNeeded;
    private boolean allowPasswords;
    private int tipLocatie;
    private int waitersPerLine;
    private int codAutentificareLength;
    private int fontSize;
    private ObjectEventListener loginWithCardEvent;

    public WaitersSelection2(WaiterSelection2Interface parent, boolean controllerMode, boolean passwordNeeded, boolean allowPasswords, int waitersPerLine, int codAutentificareLength, int fontSize) {
        this.passwordNeeded = passwordNeeded;
        this.allowPasswords = allowPasswords;
        this.waitersPerLine = waitersPerLine;
        this.codAutentificareLength = codAutentificareLength;
        this.fontSize = fontSize;
        this.parent = parent;
        this.controllerMode = controllerMode;
        this.display();
    }

    public void setParent(WaiterSelection2Interface parent) {
        this.parent = parent;
    }

    public int getTipLocatie() {
        return this.tipLocatie;
    }

    public void setTipLocatie(int tipLocatie) {
        this.tipLocatie = tipLocatie;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = this.insets;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        this.add((Component)this.getWaitersPanel(), c);
        c.fill = 3;
        c.weightx = 0.0;
        c.gridx = 1;
        this.rightPanel = this.getRightPanel();
        this.add((Component)this.rightPanel, c);
        this.waitersPanel.requestFocus();
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.selectie));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        c.gridx = 1;
        this.ospatar = new JLabel("");
        c.anchor = 13;
        result.add((Component)this.ospatar, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        result.add((Component)new JLabel(LangRoAll.parola), c);
        c.gridx = 1;
        c.anchor = 13;
        this.password.setEditable(false);
        result.add((Component)this.password, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 10;
        result.add((Component)this.getKeyPad(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 15;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitersSelection2.this.ospatar.setText("");
                WaitersSelection2.this.setParola("");
                WaitersSelection2.this.codAutentificare = "";
                WaitersSelection2.this.unregisterListener(RestLogic.getInstance().getAccesInterface());
                WaitersSelection2.this.parent.waiterSelected(null);
            }
        });
        renunta.setFocusable(false);
        result.add((Component)renunta, c);
        return result;
    }

    public void refreshButtons() {
        this.waitersPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        Vector<User> waiters = this.tipLocatie == 1 ? UsersLogic.getInstance().getUsersInGroup("group_fo_users") : UsersLogic.getInstance().getUsersInGroup("group_receptioneri");
        for (User element : waiters) {
            if (element.isVirtual()) continue;
            JPanel btn = this.getButtonPanel(element);
            this.waitersPanel.add((Component)btn, c);
            ++c.gridx;
            if (c.gridx != this.waitersPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
    }

    private JScrollPane getWaitersPanel() {
        this.waitersPanel = new JPanel(new GridBagLayout());
        this.waitersPanel.setBorder(new TitledBorder(LangRoAll.operator));
        this.refreshButtons();
        this.waitersPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                WaitersSelection2.this.codAutentificare = WaitersSelection2.this.codAutentificare + String.valueOf(e.getKeyChar());
                if (WaitersSelection2.this.codAutentificare.length() == WaitersSelection2.this.codAutentificareLength) {
                    WaitersSelection2.this.tryLogin(true, WaitersSelection2.this.controllerMode);
                    WaitersSelection2.this.codAutentificare = "";
                }
            }
        });
        this.waitersPanel.setFocusable(true);
        return new JScrollPane(this.waitersPanel);
    }

    public void focus() {
        this.waitersPanel.requestFocus();
    }

    private void setWaiter(User element) {
        this.ospatar.setText(element.getLogin());
        if (!this.passwordNeeded || this.controllerMode) {
            this.tryLogin(this.passwordNeeded, this.controllerMode);
        }
    }

    private JPanel getButtonPanel(final User element) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        ImageIcon img = null;
        try {
            img = Utils.getImageFromDisk(element.getLogin() + ".gif");
        }
        catch (MalformedURLException e2) {
            Logger.logException(this, (Exception)e2);
            img = null;
        }
        if (img == null) {
            img = Utils.getImageResource("nobody.gif");
        }
        JButton btn = new JButton(img);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitersSelection2.this.setWaiter(element);
            }
        });
        btn.setFocusable(false);
        result.add((Component)btn, c);
        ++c.gridy;
        result.add((Component)new JLabel(element.getLogin()), c);
        return result;
    }

    private JPanel getKeyPad() {
        VirtualKeypad kp = new VirtualKeypad(this.fontSize);
        kp.addKeypadListener(new KeypadListener(){

            @Override
            public void keypadPressed(int digit) {
                String p = WaitersSelection2.this.parola + digit;
                WaitersSelection2.this.setParola(p);
            }

            @Override
            public void okPressed() {
                WaitersSelection2.this.tryLogin(true, WaitersSelection2.this.controllerMode);
            }

            @Override
            public void backspace() {
                if (WaitersSelection2.this.parola.length() > 0) {
                    String p = WaitersSelection2.this.parola.substring(0, WaitersSelection2.this.parola.length() - 1);
                    WaitersSelection2.this.setParola(p);
                }
            }

            @Override
            public void enterPressed() {
            }

            @Override
            public void decimalPressed() {
            }
        });
        return kp;
    }

    private void tryLogin(boolean passwordRequested, boolean controllerMode) {
        UsersLogic ul = UsersLogic.getInstance();
        String user = this.ospatar.getText();
        if (controllerMode) {
            passwordRequested = false;
            this.allowPasswords = true;
        }
        EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
        User login = ul.getUser(user, this.parola, this.codAutentificare, this.allowPasswords, passwordRequested);
        this.setParola("");
        if (login != null) {
            this.ospatar.setText("");
            this.unregisterListener(backgroundCardReader);
            this.parent.waiterSelected(login);
        } else {
            ++this.retries;
            if (this.retries >= 1) {
                this.retries = 0;
                this.ospatar.setText("");
                this.setParola("");
                this.unregisterListener(backgroundCardReader);
                this.parent.waiterSelected(null);
            }
        }
    }

    private void setParola(String newPass) {
        this.parola = newPass;
        this.password.setText(this.parola);
    }

    public void registerListener() {
        if (this.loginWithCardEvent == null) {
            final StringBuffer card = new StringBuffer();
            EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
            if (backgroundCardReader != null) {
                this.loginWithCardEvent = new ObjectEventListener(){

                    @Override
                    public void dataChanged(Object o) {
                        card.setLength(0);
                        card.append(o);
                        String cardS = card.toString();
                        WaitersSelection2.this.tryLoginWithCard(cardS);
                    }

                    @Override
                    public String getName() {
                        return "WaiterSelectionBackgroundCardRead";
                    }
                };
                backgroundCardReader.addObjectListener(this.loginWithCardEvent, 701);
            }
        }
    }

    private void tryLoginWithCard(String codAutentificare) {
        if (codAutentificare.length() < this.codAutentificareLength) {
            return;
        }
        UsersLogic ul = UsersLogic.getInstance();
        EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
        User login = ul.getUserByCodAutentificare(codAutentificare);
        if (login != null) {
            this.ospatar.setText("");
            this.unregisterListener(backgroundCardReader);
            this.parent.waiterSelected(login);
        } else {
            ++this.retries;
            if (this.retries >= 1) {
                this.retries = 0;
                this.ospatar.setText("");
                this.setParola("");
                this.unregisterListener(backgroundCardReader);
                this.parent.waiterSelected(null);
            }
        }
    }

    private void unregisterListener(EventGenerator backgroundCardReader) {
        if (backgroundCardReader != null) {
            backgroundCardReader.removeObjectListener(this.loginWithCardEvent);
        }
        this.loginWithCardEvent = null;
    }
}

