/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.update.UpdateMain;
import ro.atreides.utils.Backup;
import ro.atreides.utils.DisconnectExceptionListener;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IpAddressBean;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Module;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.PidFileUtil;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.CommonConfig;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.db.Shell;
import ro.atreides.utils.gui.GuiExceptionListener;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.splash.SplashScreenMain;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.tracking.TrackingLogic;

public abstract class AbstractAppInit {
    protected Vector<Module> modules = new Vector();
    protected SplashScreenMain splash;
    public static Vector<IpAddressBean> localAddresses = Utils.getAddressesForLocalhost(true);
    public static String ipAddressesString = Utils.getIpsString(localAddresses);
    public static final Date appStartDate = new Date();

    private static boolean backupLogs(String backupFolder, String machineName) {
        File currentDir = FileUtils.getCurrentDirAsFile();
        File[] logFiles = currentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.equalsIgnoreCase("startup.log")) {
                    return true;
                }
                if (name.equalsIgnoreCase("launcher.log")) {
                    return true;
                }
                String s = name.toLowerCase();
                return s.startsWith("dever_") && s.endsWith(".log");
            }
        });
        SimpleDateFormat DATE_TIME_SECONDS_MILLIS_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
        String backupFolderDest = backupFolder + File.separator + machineName + File.separator + DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date());
        File f = new File(backupFolderDest);
        f.mkdirs();
        boolean allOk = true;
        if (!f.exists()) {
            System.err.println("Directory " + backupFolderDest + " could not be created !!!!! ");
            allOk = false;
        } else if (f.isDirectory()) {
            for (File logFile : logFiles) {
                String dest = backupFolderDest + File.separator + logFile.getName();
                boolean moved = false;
                try {
                    moved = logFile.renameTo(new File(dest));
                    System.out.println("Log file " + logFile.getAbsolutePath() + " MOVED to " + dest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (moved) continue;
                allOk = false;
                System.err.println("Log file " + logFile.getAbsolutePath() + " could not be moved to " + dest);
            }
        } else {
            System.err.println("Directory " + backupFolderDest + " is not a directory !!!!! ");
            allOk = false;
        }
        return allOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractAppInit(String[] args) throws SQLException {
        int maxConnections;
        String name;
        String stopDate = "2018-05-08";
        try {
            Date d = Formatters.DATE_FORMAT.parse(stopDate);
            if (d.before(new Date())) {
                Utils.systemExit();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (!Validators.correctString(name = Utils.getCmdlineValue("-name", args))) {
            DialogUtils.errorDialog(null, "Completati \"-name\" in mod unic !!!!", LangRoAll.nuPotContinua);
            Utils.systemExit();
        }
        String bkFolder = Utils.getCmdlineValue("-bkfolder", args, "logs");
        String grabout = Utils.getCmdlineValue("-graboutput", args, "true");
        String os = Utils.getOperatingSystem();
        if (os.toLowerCase().contains("windows")) {
            grabout = "true";
        }
        Logger.grabOutput = Boolean.parseBoolean(grabout);
        Logger.bootStrap();
        AbstractAppInit.backupLogs(bkFolder, name);
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            String value = env.get(key);
            Logger.logDebug(this, key + "=" + value);
        }
        Logger.logDebug(this, "default charset property:" + System.getProperty("file.encoding"));
        Logger.logDebug(this, "default charset 1.4 :" + new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
        Logger.logDebug(this, "default charset property:" + Charset.defaultCharset().name());
        FileUtils.buildTempDir();
        String section = Utils.getCmdlineValue("-section", args, "fo");
        String logoSuffix = Utils.getCmdlineValue("-logo", args, "");
        GuiUtils.daemon = section.equalsIgnoreCase("db");
        if (!GuiUtils.daemon) {
            GuiUtils.currentFrame = new JFrame();
            String logoPath = "logo" + logoSuffix + ".jpg";
            this.splash = SplashScreenMain.getFirstInstance(Utils.getImageResource(logoPath));
        }
        String host = Utils.getCmdlineValue("-host", args);
        int port = Integer.parseInt(Utils.getCmdlineValue("-port", args, "1527"));
        ConnectionPool.MAX_CONNECTIONS = maxConnections = Integer.parseInt(Utils.getCmdlineValue("-maxConnections", args, ConnectionPool.MAX_CONNECTIONS + ""));
        Logger.getInstance(5, "startup.log");
        String bkMinutes = "-1";
        String databaseName = "dever";
        String pidChecking = Utils.getCmdlineValue("-disablepidcheck", args, "false");
        boolean pidCheckDisabled = Boolean.parseBoolean(pidChecking);
        PidFileUtil.checkForRunningInstances("deverpid", pidCheckDisabled, true);
        String dbname = Utils.getCmdlineValue("-dbName", args, databaseName);
        if (!Validators.correctInteger(bkMinutes)) {
            Logger.logError((Object)this, "parametru -backupminutes nu reprezinta un numar intreg");
            Utils.systemExit();
        }
        Backup.backupMinutesFromLastUpdate = Integer.parseInt(bkMinutes);
        if (!GuiUtils.daemon) {
            GuiExceptionListener g = new GuiExceptionListener();
            Logger.addListener(g);
        }
        Utils.localComputerName = name;
        DatabaseManager db = DatabaseManager.getInstance(port, host, dbname, GuiUtils.daemon);
        TrackingLogic.getInstance().addLicenseTracking("app_start_date", Formatters.FULL_TIMESTAMP.format(appStartDate), ipAddressesString);
        TrackingLogic.getInstance().addLicenseTracking("db_kind", "postgres", ipAddressesString);
        TrackingLogic.getInstance().addLicenseTracking("db_host", host, ipAddressesString);
        TrackingLogic.getInstance().addLicenseTracking("db_port", port + "", ipAddressesString);
        TrackingLogic.getInstance().addLicenseTracking("db_name", dbname, ipAddressesString);
        TrackingLogic.getInstance().addLicenseTracking("db_backup_minutes", bkMinutes + "", ipAddressesString);
        DisconnectExceptionListener disconnectListener = new DisconnectExceptionListener();
        Logger.addListener(disconnectListener);
        try {
            ConnectionPool.getFirstInstance();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        Config conf = Config.getInstance();
        VpConfig.getInstance(conf);
        LicenseManager lm = LicenseManager.getInstance();
        if (!lm.isLicensed()) {
            // empty if block
        }
        lm.verifyLicense();
        LanguageLogic.getInstance();
        CommonConfig commonConfigs = new CommonConfig(conf);
        commonConfigs.readProps();
        int logLevel = conf.getInt("logLevel");
        SimpleDateFormat DATE_TIME_SECONDS_MILLIS_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
        String filename = "dever_" + DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date()) + ".log";
        Logger.getInstance(logLevel, filename);
        UpdateMain.updateURL = Utils.getCmdlineValue("-updateURL", args, commonConfigs.updateURL);
        UpdateMain.updateType = Integer.parseInt(Utils.getCmdlineValue("-updateType", args, "1"));
        UpdateMain.stability = Integer.parseInt(Utils.getCmdlineValue("-stability", args, "3"));
        GuiUtils.currentVersion = commonConfigs.currentVersion;
        UpdateMain.launchCommand = Utils.getCmdlineValue("-launchCommand", args, null);
        String decimalDotForce = Utils.getCmdlineValue("-forceDotAsDecimalPoint", args, "true");
        Boolean forceDecimalDot = Boolean.valueOf(decimalDotForce);
        Utils.forceDotAsDecimalPoint = forceDecimalDot;
        this.doSpecificStuff(args, conf, db);
        if (commonConfigs.startDBShell) {
            new Shell(db).start();
        }
        if (!FileUtils.buildTempDir()) {
            Logger.logWarning(this, "Could not build temp dir");
        }
        if (GuiUtils.daemon) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                }
            }).start();
        }
    }

    protected void instantiateModules(String[] args, String srcBase, String defaultModules, Hashtable runTimeObjects) {
        String moduleLoadTry = "";
        String mString = Utils.getCmdlineValue("-modules", args, defaultModules);
        Vector modules = Config.getInstance().getModules(mString);
        for (String element : modules) {
            if (!Validators.correctString(element)) continue;
            String className = srcBase + element + ".Module";
            try {
                Logger.logDebug(this, "Instantiem : " + className);
                Module module = (Module)Class.forName(className).newInstance();
                module.init(args, runTimeObjects);
                this.modules.add(module);
                moduleLoadTry = moduleLoadTry.concat(element + ",");
                Logger.logDebug(this, "Instantiere reusita");
            }
            catch (ModuleInstantiationException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (InstantiationException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (IllegalAccessException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (ClassNotFoundException e) {}
        }
        TrackingLogic.getInstance().addLicenseTracking("module", moduleLoadTry, ipAddressesString);
    }

    protected abstract void doSpecificStuff(String[] var1, Config var2, DatabaseManager var3) throws SQLException;

    public Vector<Module> getModules() {
        return this.modules;
    }
}

