/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ZipUtils;
import ro.atreides.utils.db.CommonsDao;
import ro.atreides.utils.db.DatabaseManager;

public class Backup {
    public static int backupMinutesFromLastUpdate = 1680;
    public static long programStartTime = System.currentTimeMillis();

    public static void zipBackup(String zipSource, String zipDestination) {
        try {
            String temp = zipDestination + "_";
            ZipUtils.zipCreateRecursive(zipSource, temp);
            File tempFile = new File(temp);
            tempFile.renameTo(new File(zipDestination));
            FileUtils.removeFileRecurse(new File(zipSource));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void avarieOnServer() {
        String primaryPath = "backup";
        String avariePath = primaryPath + File.separator + "avarie.txt";
        String date = Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date());
        try {
            FileUtils.writeTextToFile(avariePath, date);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String isAvarieOnServer() {
        File f = new File(FileUtils.getCurrentDir() + File.separator + "avarie.txt");
        if (f.exists()) {
            return "1";
        }
        return "0";
    }

    private static synchronized void backupDatabase(String root, Connection connection, boolean zip, String tipBackup) throws SQLException {
        String date = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date());
        String name = "db_" + date + "_" + tipBackup;
        CommonsDao.backupDatabase(root, name, connection);
        String fullBkDirPath = FileUtils.getCurrentDir() + File.separator + root;
        String zipSource = fullBkDirPath + File.separator + name;
        if (zip) {
            String zipDestination = root + File.separator + name + ".zip";
            CommonsDao.zipBackup(zipSource, zipDestination, connection);
        }
    }

    public static boolean mustDoBackup() {
        if (backupMinutesFromLastUpdate < 0) {
            return false;
        }
        if (programStartTime + 300000L > System.currentTimeMillis()) {
            return false;
        }
        String primaryPath = "backup";
        File dir = new File(primaryPath);
        dir.mkdirs();
        String[] backups = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                if (f.isDirectory()) {
                    return false;
                }
                return (name = name.toLowerCase()).startsWith("db_") && name.endsWith(".zip");
            }
        });
        Date _24HoursAgo = DateUtils.addMinutesToDate(new Date(), -backupMinutesFromLastUpdate);
        for (String backup : backups) {
            SimpleDateFormat format = Formatters.DATE_TIME_AND_SECONDS_FORMAT;
            String pattern = format.toPattern();
            String d1 = backup.substring(3, pattern.length() + 3);
            try {
                Date date = format.parse(d1);
                if (!date.after(_24HoursAgo)) continue;
                return false;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return true;
    }

    public static synchronized boolean isServerAvariat() {
        try {
            if (backupMinutesFromLastUpdate < 0) {
                return false;
            }
            return CommonsDao.isAvarieOnServer(DatabaseManager.getInstance().getFirstConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static synchronized boolean backup(boolean zip, String tipBackup, boolean guiEnabled, Connection firstConnection) {
        return Backup.backup(zip, tipBackup, guiEnabled, firstConnection, "backup");
    }

    public static synchronized boolean backup(boolean zip, String tipBackup, boolean guiEnabled) {
        return Backup.backup(zip, tipBackup, guiEnabled, "backup");
    }

    public static synchronized boolean backup(boolean zip, String tipBackup, boolean guiEnabled, String primaryPath) {
        DatabaseManager db = DatabaseManager.getInstance();
        Connection firstConnection = db.getFirstConnection();
        return Backup.backup(zip, tipBackup, guiEnabled, firstConnection, primaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean backup(boolean zip, String tipBackup, boolean guiEnabled, Connection firstConnection, String primaryPath) {
        boolean backupOK;
        block51: {
            boolean databaseOK;
            try {
                String avarieMsg = "URGENT !! Contactati suport tehnic : Baza de date avariata ; NU creez backup !";
                if (CommonsDao.isAvarieOnServer(firstConnection)) {
                    if (guiEnabled) {
                        Logger.logError((Object)"Backup", avarieMsg);
                    } else {
                        Logger.logWarning("Backup", avarieMsg);
                    }
                    boolean bl = false;
                    return bl;
                }
                Logger.logInfo("Backup", "VerifyDB started");
                CommonsDao.verifyDatabase(firstConnection);
                databaseOK = true;
            }
            catch (SQLException e) {
                if (guiEnabled) {
                    Logger.logException("BackUp.verifyDB", (Exception)e);
                } else {
                    Logger.logWarning("Backup", e.getMessage());
                }
                databaseOK = false;
            }
            finally {
                try {
                    firstConnection.commit();
                }
                catch (SQLException e) {
                    if (guiEnabled) {
                        Logger.logException("BackUp.verifyDB", (Exception)e);
                    }
                    Logger.logWarning("Backup", e.getMessage());
                }
            }
            if (!databaseOK) {
                block50: {
                    try {
                        CommonsDao.writeAvarieOnServer(firstConnection);
                        firstConnection.commit();
                    }
                    catch (Exception e) {
                        if (guiEnabled) {
                            Logger.logException("BackUp.writeAvarieOnServer", e);
                        } else {
                            Logger.logWarning("BackUp.writeAvarieOnServer", e.getMessage());
                        }
                        try {
                            firstConnection.rollback();
                        }
                        catch (SQLException e1) {
                            if (guiEnabled) {
                                Logger.logException("BackUp.writeAvarieOnServer", (Exception)e1);
                                break block50;
                            }
                            Logger.logWarning("BackUp.writeAvarieOnServer", e1.getMessage());
                        }
                    }
                }
                Logger.logInfo("Backup", "VerifyDB failed");
                return false;
            }
            Logger.logInfo("Backup", "VerifyDB done");
            Logger.logInfo("Backup", "Backup started");
            backupOK = false;
            try {
                Backup.backupDatabase(primaryPath, firstConnection, zip, tipBackup);
                backupOK = true;
            }
            catch (SQLException e) {
                if (guiEnabled) {
                    Logger.logException("Backup.backupDatabase", (Exception)e);
                } else {
                    Logger.logWarning("Backup.backupDatabase", e.getMessage());
                }
                try {
                    firstConnection.rollback();
                }
                catch (SQLException e1) {
                    if (guiEnabled) {
                        Logger.logException("Backup.backupDatabase", (Exception)e1);
                        break block51;
                    }
                    Logger.logWarning("Backup.backupDatabase", e1.getMessage());
                }
            }
            finally {
                try {
                    firstConnection.commit();
                }
                catch (SQLException e) {
                    if (guiEnabled) {
                        Logger.logException("Backup.backupDatabase", (Exception)e);
                    }
                    Logger.logWarning("Backup.backupDatabase", e.getMessage());
                }
            }
        }
        if (backupOK) {
            Logger.logInfo("Backup", "Backup done");
        } else if (guiEnabled) {
            Logger.logError((Object)"Backup", "Backup FAILED. CONTACTATI SUPORTUL TEHNIC !!");
        } else {
            Logger.logWarning("Backup", "Backup FAILED. CONTACTATI SUPORTUL TEHNIC !!");
        }
        return backupOK;
    }
}

