/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JTextField;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class DateUtils
extends LangRoAll {
    public static long yearMillis = 31536000000L;
    public static long monthMillis = 2592000000L;
    public static long dayMillis = 86400000L;
    public static long hoursMillis = 3600000L;
    public static long minutesMillis = 60000L;
    public static long secondsMillis = 1000L;
    public static int SECONDS_IN_A_DAY = 86400;

    public static int getYearFromDate(Date d) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(d);
        return calendar.get(1);
    }

    public static int getMonthFromDate(Date d) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(d);
        return calendar.get(2) + 1;
    }

    public static int getDayFromDate(Date d) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(d);
        return calendar.get(5);
    }

    public static Date getDayInCurrentYear(int month, int dayInMonth) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(2, month - 1);
        calendar.set(5, dayInMonth);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Vector<Date> getDaysInPerioada(Date start, Date stop) {
        Vector<Date> result = new Vector<Date>();
        Date d = start;
        while (d.before(stop)) {
            Date d1 = new Date(d.getTime());
            result.add(d1);
            d = DateUtils.advanceOneDay(d);
        }
        return result;
    }

    public static String getTimeFromDate(Date d) {
        return Formatters.TIME_FORMAT.format(d);
    }

    public static Date setTimeToDate2(Date d, JTextField time) {
        String t1 = time.getText();
        int hours = 0;
        int minutes = 0;
        try {
            StringTokenizer t = new StringTokenizer(t1, ":");
            hours = Integer.parseInt(t.nextToken());
            minutes = Integer.parseInt(t.nextToken());
        }
        catch (NumberFormatException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + t1, LangRoAll.nuPotContinua);
            hours = 0;
            minutes = 0;
            return null;
        }
        catch (NoSuchElementException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + t1, LangRoAll.nuPotContinua);
            hours = 0;
            minutes = 0;
            return null;
        }
        d = DateUtils.setTimeToDate(d, hours, minutes, 0, 0);
        return d;
    }

    public static Date setTimeToDate2(Date d, String t1) {
        int hours = 0;
        int minutes = 0;
        try {
            StringTokenizer t = new StringTokenizer(t1, ":");
            hours = Integer.parseInt(t.nextToken());
            minutes = Integer.parseInt(t.nextToken());
        }
        catch (NumberFormatException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + t1, LangRoAll.nuPotContinua);
            hours = 0;
            minutes = 0;
            return null;
        }
        catch (NoSuchElementException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + t1, LangRoAll.nuPotContinua);
            hours = 0;
            minutes = 0;
            return null;
        }
        d = DateUtils.setTimeToDate(d, hours, minutes, 0, 0);
        return d;
    }

    public static Date setTimeToDate(Component parent, MDateEntryField data, JTextField time) {
        try {
            Date d = data.getValue();
            return DateUtils.setTimeToDate2(d, time);
        }
        catch (ParseException e1) {
            DialogUtils.errorDialog(parent, "Va rugam completati corect data", LangRoAll.nuPotContinua);
            return null;
        }
    }

    public static Date setTimeToDate(Component parent, MDateEntryField data, String time) {
        try {
            Date d = data.getValue();
            return DateUtils.setTimeToDate2(d, time);
        }
        catch (ParseException e1) {
            DialogUtils.errorDialog(parent, "Va rugam completati corect data", LangRoAll.nuPotContinua);
            return null;
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getEndOfDays() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(1, 2000);
        return new Timestamp(calendar.getTime().getTime());
    }

    public static Timestamp getStartOfDays() {
        Calendar calendar = GregorianCalendar.getInstance();
        return new Timestamp(0L);
    }

    public static int getDaysPerMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.set(date.getYear() + 1900, date.getMonth(), date.getDate());
        return cal.getActualMaximum(5);
    }

    public static Date addMinutesToDate(Date startDate, int minutes) {
        long millis = startDate.getTime();
        Date resultDate = new Date(millis += (long)(minutes * 60 * 1000));
        return resultDate;
    }

    public static Date addMinutesToDateConsiderDST(Date startDate, int minutes) {
        Calendar startCalendar = GregorianCalendar.getInstance();
        startCalendar.setTime(startDate);
        TimeZone startTZ = startCalendar.getTimeZone();
        int startDSTMillis = startTZ.getDSTSavings();
        boolean startDateInDST = startTZ.inDaylightTime(startDate);
        long millis = startDate.getTime();
        Date resultDate = new Date(millis += (long)(minutes * 60 * 1000));
        Calendar stopCalendar = GregorianCalendar.getInstance();
        stopCalendar.setTime(resultDate);
        TimeZone stopTZ = stopCalendar.getTimeZone();
        int stopDSTMillis = stopTZ.getDSTSavings();
        boolean stopDateInDST = stopTZ.inDaylightTime(resultDate);
        if (startDateInDST && stopDateInDST || !startDateInDST && !stopDateInDST) {
            return resultDate;
        }
        long diff = (startDateInDST ? startDSTMillis : 0) - (stopDateInDST ? stopDSTMillis : 0);
        if (stopDateInDST) {
            diff = -diff;
        }
        long newTime = resultDate.getTime() + diff;
        resultDate = new Date(newTime);
        return resultDate;
    }

    public static Date getDayInWeek(int day, int hour, int minute) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(7, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addDaysToDate(Date startDate, int days) {
        if (days > 0) {
            Date curr = startDate;
            for (int i = 0; i < days; ++i) {
                curr = DateUtils.advanceOneDay(curr);
            }
            return curr;
        }
        if (days < 0) {
            int dayModulo = -days;
            Date curr = startDate;
            for (int i = 0; i < dayModulo; ++i) {
                curr = DateUtils.substractOneDay(curr);
            }
            return curr;
        }
        return startDate;
    }

    public static Date get12Hour(long start) {
        long millis = start % 1000L;
        millis = start - millis;
        Date result = new Date(millis);
        result.setHours(12);
        result.setMinutes(0);
        result.setSeconds(0);
        return result;
    }

    public static Date getFirstDayOfCurrentYear() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfCurrentMonth() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDay(int month, int year) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDay(int month, int year) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getStartOfWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getStartOfWeek(Date date, int day) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, day);
        return calendar.getTime();
    }

    public static Date getStartOfMonth(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date advanceOneDay(Date date) {
        return DateUtils.addOrSubstractOneDay(date, 1);
    }

    public static Date substractOneDay(Date date) {
        return DateUtils.addOrSubstractOneDay(date, -1);
    }

    public static Date addOrSubstractOneDay(Date date, int sign) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, sign * 1);
        return calendar.getTime();
    }

    public static Date advanceOneWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, 1);
        return calendar.getTime();
    }

    public static Date addMonthsToDate(Date date, int toAdd) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, toAdd);
        return calendar.getTime();
    }

    public static Date advanceOneMonth(Date date) {
        return DateUtils.addMonthsToDate(date, 1);
    }

    public static Date addYearsToDate(Date date, int toAdd) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, toAdd);
        return calendar.getTime();
    }

    public static Date getDate(String sourceText, SimpleDateFormat formatter) {
        Date result = null;
        try {
            result = formatter.parse(sourceText);
        }
        catch (ParseException e) {
            Logger.logException("DateUtils", (Exception)e);
        }
        return result;
    }

    public static Date setTimeToDate(Date d, int hours, int minutes, int second, int millisecond) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(d);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static int getNrOfWeekOfYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getNrOfMonthOfYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getNrOfDayInWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int getNrOfDayInMonth(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getWeekInYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.get(3);
    }

    public static Timestamp setMillis(Timestamp original, int millis) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(original.getTime());
        calendar.set(14, millis);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static boolean sameMinute(Timestamp t1, Timestamp t2) {
        long m2;
        long m1 = t1.getTime() / minutesMillis;
        return m1 == (m2 = t2.getTime() / minutesMillis);
    }

    public static boolean sameDay(Date t1, Date t2) {
        long m2;
        long m1 = t1.getTime() / dayMillis;
        return m1 == (m2 = t2.getTime() / dayMillis);
    }

    public static String getDiferentaIntreOre(long min, long max) {
        long diff = max - min;
        return DateUtils.getStringForDiff(diff);
    }

    public static String getStringForDiff(long diff) {
        int years = (int)(diff / yearMillis);
        int months = (int)((diff -= (long)years * yearMillis) / monthMillis);
        int days = (int)((diff -= (long)months * monthMillis) / dayMillis);
        int hours = (int)((diff -= (long)days * dayMillis) / hoursMillis);
        int minutes = (int)((diff -= (long)hours * hoursMillis) / minutesMillis);
        int seconds = (int)((diff -= (long)minutes * minutesMillis) / secondsMillis);
        diff -= (long)seconds * secondsMillis;
        String result = (years != 0 ? days + " ani," : "") + (months != 0 ? months + " luni," : "") + (days != 0 ? days + " zile," : "") + (hours != 0 ? hours + " ore," : "") + (minutes != 0 ? minutes + " minute," : "") + (seconds != 0 ? seconds + " secunde" : "");
        return result;
    }

    @Deprecated
    public static int getNrZileForDiff(long diff) {
        int days = Math.round(diff / dayMillis);
        return days;
    }

    public static String getHoursForDiff(long diff) {
        long hoursMillis = 3600000L;
        long minutesMillis = 60000L;
        long secondsMillis = 1000L;
        int hours = (int)(diff / hoursMillis);
        int minutes = (int)((diff -= (long)hours * hoursMillis) / minutesMillis);
        int seconds = (int)((diff -= (long)minutes * minutesMillis) / secondsMillis);
        diff -= (long)seconds * secondsMillis;
        String result = (hours != 0 ? hours + " ore," : "") + (minutes != 0 ? minutes + " minute," : "") + (seconds != 0 ? seconds + " secunde" : "");
        return result;
    }

    public static Date getStartOfCentury() {
        Date d = DateUtils.getFirstDay(1, 1900);
        return d;
    }

    public static Date addMillisToDate(Date date, long millis) {
        long ms = date.getTime() + millis;
        return new Date(ms);
    }

    public static Date minusMillis(Date date, long millis) {
        long ms = date.getTime() - millis;
        return new Date(ms);
    }

    public static Timestamp[][] getMonthsInYear(String year) {
        Timestamp[][] result = new Timestamp[12][2];
        int y = Integer.parseInt(year);
        for (int i = 0; i < 12; ++i) {
            Date d1 = DateUtils.getFirstDay(i, y);
            Date d2 = null;
            d2 = i < 11 ? DateUtils.getFirstDay(i + 1, y) : DateUtils.getFirstDay(0, y + 1);
            result[i][0] = new Timestamp(d1.getTime());
            result[i][1] = new Timestamp(d2.getTime());
        }
        return result;
    }

    public static String getHumanDate(int month, int year) {
        Date d = DateUtils.getFirstDay(month, year);
        return Formatters.MONTH_YEAR_HUMAN_FORMAT.format(d);
    }

    public static boolean checkDayOfWeek(String daysInWeek, long dateToCheck) {
        if (daysInWeek.contains("*")) {
            return true;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(dateToCheck);
        int dayOfWeek = calendar.get(7);
        if (calendar.getFirstDayOfWeek() == 1) {
            --dayOfWeek;
        }
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return daysInWeek.contains(dayOfWeek + "");
    }

    public static Date getStartOf2000() {
        Date d = DateUtils.getFirstDay(1, 2000);
        return d;
    }

    public static String getStringTimeUntilDate(Date d) {
        Calendar thatDay = Calendar.getInstance();
        thatDay.setTime(d);
        Calendar today = Calendar.getInstance();
        long diff = thatDay.getTimeInMillis() - today.getTimeInMillis();
        long diffSec = diff / 1000L;
        long days = diffSec / (long)SECONDS_IN_A_DAY;
        long secondsDay = diffSec % (long)SECONDS_IN_A_DAY;
        long seconds = secondsDay % 60L;
        long minutes = secondsDay / 60L % 60L;
        long hours = secondsDay / 3600L;
        if (seconds < 0L) {
            seconds = 0L;
        }
        return (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (minutes < 10L ? "0" + minutes : Long.valueOf(minutes)) + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
    }

    public static Date getDateFromStringMultipleFormats(String date, String format) {
        Date result = new Date();
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        try {
            if (Validators.correctDate(date, format1)) {
                result = format1.parse(date);
            }
        }
        catch (ParseException e) {
            Logger.logException("DateUtils : ", (Exception)e);
        }
        return result;
    }
}

