/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import ro.atreides.utils.ExceptionListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class DisconnectExceptionListener
implements ExceptionListener {
    @Override
    public void processThrowable(Throwable th, String message, long id) {
        String mess;
        if (th != null && (mess = th.getMessage()) != null && (mess.endsWith("The connection has been terminated.") || mess.endsWith("Connection refused."))) {
            int retries;
            boolean ok = false;
            int max_retries = 3;
            for (retries = 1; !ok && retries <= max_retries; ++retries) {
                String errorMessage = "Conexiunea cu baza de date pierduta.<ol><li>Remediati problema</li><li>apasati OK</li><li>repetati operatia</li></ol>";
                DialogUtils.htmlOKDialog(GuiUtils.currentFrame, errorMessage, "Probleme de retea");
                ConnectionPool cp = ConnectionPool.getInstance();
                if (cp == null) continue;
                ok = cp.reconnectAll();
            }
            if (retries > max_retries) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu am realizat conexiunea la baza de date. Aplicatia se va inchide", "Eroare de conexiune");
                Utils.systemExit();
            }
        }
    }
}

