/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;
import ro.atreides.utils.ExceptionListener;
import ro.atreides.utils.Formatters;

public class Logger {
    public static final int PARANOIA = 7;
    public static final int DEBUGVERBOSE = 6;
    public static final int DEBUG = 5;
    public static final int VERBOSE = 4;
    public static final int INFO = 3;
    public static final int WARNING = 2;
    public static final int ERROR = 1;
    public static final int NONE = 0;
    private static int logLevel = 6;
    private static String logFile = "boot.log";
    private static PrintStream writer;
    static Vector listeners;
    static long id;
    public static boolean grabOutput;
    private static Logger instance;

    public static void bootStrap() {
        try {
            FileOutputStream fos = new FileOutputStream(logFile, true);
            writer = new PrintStream(fos);
            if (grabOutput) {
                System.setOut(writer);
                System.setErr(writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized Logger getInstance(int level, String file) {
        instance = new Logger(level, file);
        return instance;
    }

    private Logger(int level, String file) {
        try {
            System.out.println("Logger level : " + level + " logger file : " + file);
            logLevel = level;
            logFile = file;
            FileOutputStream fos = new FileOutputStream(logFile, true);
            writer = new PrintStream(fos);
            if (grabOutput) {
                System.setOut(writer);
                System.setErr(writer);
            }
            id = System.currentTimeMillis() / 1000L;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addListener(ExceptionListener listener) {
        listeners.add(listener);
    }

    private static void processThrowable(Throwable th, String message) {
        if (th != null) {
            for (ExceptionListener element : listeners) {
                element.processThrowable(th, message, id);
            }
            Logger.print(message);
            th.printStackTrace(writer);
            writer.flush();
            ++id;
        }
    }

    public static synchronized void logException(Object o, Exception ex) {
        Logger.logException(o.getClass().getName(), ex);
    }

    public static synchronized void logException(String className, Exception ex) {
        String message = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + " : " + className + " : " + ex.getMessage();
        ex.printStackTrace();
        Logger.processThrowable(ex, message);
    }

    public static synchronized void log(String className, String message, int level) {
        if (level <= logLevel) {
            Logger.print(Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + " : " + className + " : " + message);
        }
    }

    private static void print(String toPrint) {
        writer.print(toPrint);
        writer.print("\n");
        writer.flush();
    }

    public static synchronized void logInfo(String className, String message) {
        Logger.log(className, message, 3);
    }

    public static synchronized void logInfo(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 3);
    }

    public static synchronized void logParanoia(String className, String message) {
        Logger.log(className, message, 7);
    }

    public static synchronized void logParanoia(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 7);
    }

    public static synchronized void logDebugVerbose(String className, String message) {
        Logger.log(className, message, 6);
    }

    public static synchronized void logDebugVerbose(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 6);
    }

    public static synchronized void logDebug(String className, String message) {
        Logger.log(className, message, 5);
    }

    public static synchronized void logDebug(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 5);
    }

    public static synchronized void logVerbose(String className, String message) {
        Logger.log(className, message, 4);
    }

    public static synchronized void logVerbose(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 4);
    }

    public static synchronized void logWarning(String className, String message) {
        Logger.log(className, message, 2);
    }

    public static synchronized void logWarning(Object o, String message) {
        Logger.log(o.getClass().getName(), message, 2);
    }

    public static synchronized void logError(String className, String message, Throwable th) {
        Logger.log(className, message, 1);
        if (th != null) {
            th.printStackTrace();
        }
        Logger.processThrowable(th, message);
    }

    public static synchronized void logError(Object o, String message) {
        Logger.logError(o.getClass().getName(), message, null);
    }

    public static synchronized void logError(Object o, Throwable th) {
        Logger.logError(o.getClass().getName(), th.getMessage(), th);
    }

    public static synchronized void logError(Object o, String message, Throwable th) {
        Logger.logError(o.getClass().getName(), message, th);
    }

    public static PrintStream getWriter() {
        return writer;
    }

    static {
        listeners = new Vector();
        id = 0L;
        grabOutput = false;
    }
}

