/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import ro.atreides.utils.CmdUtils;
import ro.atreides.utils.ConfigUtils;

public class MimeUtils {
    private static final String CONFIG_FILE = "mime.conf";

    public static void open(String file) {
        String extension = MimeUtils.getExtension(file);
        if (extension.length() <= 0) {
            return;
        }
        String value = ConfigUtils.getKey(extension, CONFIG_FILE);
        if (value != null && value.length() > 0) {
            String cmd = value + " " + new File(file).getAbsolutePath();
            CmdUtils.executeDeamon(cmd);
        } else {
            try {
                Desktop.getDesktop().open(new File(file));
            }
            catch (IOException e) {
                System.out.println("failed to auto open file: " + file);
                MimeUtils.openWith(file);
            }
        }
    }

    public static void openWith(String file) {
        String extension = MimeUtils.getExtension(file);
        if (extension.length() <= 0) {
            return;
        }
        String value = ConfigUtils.getKey(extension, CONFIG_FILE);
        String command = JOptionPane.showInputDialog(null, "Open ." + extension + " files with", value);
        if (command != null) {
            if (command.length() > 0) {
                ConfigUtils.setKey(extension, command, CONFIG_FILE);
            } else {
                MimeUtils.setAuto(extension);
            }
            MimeUtils.open(file);
        }
    }

    public static void resetToAuto(String file) {
        String extension = MimeUtils.getExtension(file);
        MimeUtils.setAuto(extension);
    }

    private static void setAuto(String extension) {
        if (extension.length() > 0) {
            ConfigUtils.setKey(extension, "", CONFIG_FILE);
        }
    }

    private static String getExtension(String filename) {
        String result = "";
        int index = filename.lastIndexOf(".");
        if (index != -1) {
            result = filename.substring(index + 1, filename.length());
        }
        return result;
    }
}

