/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class PersistentList {
    private String filename;
    private List products;

    public PersistentList(String filename) {
        this.filename = filename;
        this.products = PersistentList.getProductsFor(filename);
    }

    public Object getAndBlock() {
        Object next;
        while ((next = this.next()) == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return next;
    }

    public Object getNoBlock() {
        return this.next();
    }

    private Object next() {
        return this.products.size() > 0 ? this.products.get(0) : null;
    }

    public synchronized void addBon(Object toAdd) {
        if (toAdd != null) {
            this.products.add(toAdd);
            PersistentList.setProductsFor(this.products, this.filename);
        }
    }

    public synchronized void remove(Object bon) {
        this.products.remove(bon);
        PersistentList.setProductsFor(this.products, this.filename);
    }

    public int size() {
        return this.products.size();
    }

    private static synchronized void setProductsFor(Collection products, String file) {
        if (products == null) {
            products = new Vector();
        }
        PersistentList.writeObjectTo(products, file);
    }

    private static synchronized List getProductsFor(String file) {
        Vector result = new Vector();
        Object list = PersistentList.readObjectFrom(file);
        if (list instanceof Vector) {
            result = (Vector)list;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readObjectFrom(String file) {
        Object result = null;
        ObjectInput input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(file));
            result = input.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeObjectTo(Object o, String file) {
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            output.writeObject(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

