/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import ro.atreides.utils.EnvironmentUtil;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class PidFileUtil {
    public static int getProcessPid() {
        try {
            return PidFileUtil.getPidImplementation1();
        }
        catch (Exception e) {
            Logger.logWarning(PidFileUtil.class, "Retrieving Java Process PID failed with first method, trying second ...");
            try {
                return PidFileUtil.getPidImplementation2();
            }
            catch (Exception e1) {
                return -1;
            }
        }
    }

    public static void createNewPidFile(File pidFile) throws IOException {
        pidFile.delete();
        try (FileWriter pidFileWriter = new FileWriter(pidFile);){
            String pidStr = "" + PidFileUtil.getProcessPid();
            System.out.println("This process's id: " + pidStr);
            Logger.logInfo(PidFileUtil.class, "Writing PID file (for PID " + pidStr + ") to " + pidFile + " ...");
            pidFileWriter.write(pidStr);
            pidFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pidFile.deleteOnExit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPidFromFile(File pidFile) {
        if (!pidFile.exists()) return -1;
        try (BufferedReader pidFileReader = new BufferedReader(new FileReader(pidFile));){
            int pid;
            int n = pid = Integer.parseInt(pidFileReader.readLine());
            return n;
        }
        catch (Exception e) {
            Logger.logWarning(PidFileUtil.class, "Cannot read pidfile from " + pidFile + ". Assuming that the process not running.");
            return -1;
        }
    }

    public static boolean killProcess(int pid) {
        if (EnvironmentUtil.isUnixOperatingSystem()) {
            return PidFileUtil.killUnixProcess(pid);
        }
        if (EnvironmentUtil.isWindows()) {
            return PidFileUtil.killWindowsProcess(pid);
        }
        return false;
    }

    private static boolean killUnixProcess(int pid) {
        Process exec = null;
        try {
            exec = Runtime.getRuntime().exec("kill -9 " + pid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (exec == null) {
            Logger.logWarning(PidFileUtil.class, "Could not kill the process with the id=" + pid);
            System.err.println("Could not kill the process with the id=" + pid);
            return false;
        }
        return true;
    }

    private static boolean killWindowsProcess(int pid) {
        Process exec = null;
        try {
            exec = Runtime.getRuntime().exec("taskkill /F /PID " + pid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (exec == null) {
            Logger.logWarning(PidFileUtil.class, "Could not kill the process with the id=" + pid);
            System.err.println("Could not kill the process with the id=" + pid);
            return false;
        }
        return true;
    }

    static void showTaskList() throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(System.getenv("windir") + "\\system32\\" + "tasklist.exe");
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        System.out.println("Here is the standard output of the command:\n");
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
        }
        System.out.println("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            System.out.println(s);
        }
    }

    public static boolean isProcessRunning(int pid) {
        if (EnvironmentUtil.isUnixOperatingSystem()) {
            return PidFileUtil.isProcessRunningOnUnix(pid);
        }
        if (EnvironmentUtil.isWindows()) {
            return PidFileUtil.isProcessRunningOnWindows(pid);
        }
        return false;
    }

    private static int getPidImplementation1() throws Exception {
        String pidStr = ManagementFactory.getRuntimeMXBean().getName();
        if (pidStr.contains("@")) {
            int processPid = Integer.parseInt(pidStr.split("@")[0]);
            Logger.logInfo(PidFileUtil.class, "Java Process PID is " + processPid);
            return processPid;
        }
        throw new Exception("Cannot find pid from string: " + pidStr);
    }

    private static int getPidImplementation2() throws Exception {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Field jvmField = runtimeMXBean.getClass().getDeclaredField("jvm");
        jvmField.setAccessible(true);
        Object vmManagement = jvmField.get(runtimeMXBean);
        Method getProcessIdMethod = vmManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
        getProcessIdMethod.setAccessible(true);
        int pid = (Integer)getProcessIdMethod.invoke(vmManagement, new Object[0]);
        Logger.logInfo(PidFileUtil.class, "Java Process iD is " + pid);
        return pid;
    }

    private static boolean isProcessRunningOnUnix(int pid) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process killProcess = runtime.exec(new String[]{"kill", "-0", "" + pid});
            int killProcessExitCode = killProcess.waitFor();
            boolean isRunning = killProcessExitCode == 0;
            Logger.logInfo(PidFileUtil.class, "isProcessRunningOnUnix(" + pid + ") returned " + killProcessExitCode + ", process running = " + isRunning);
            return isRunning;
        }
        catch (Exception e) {
            Logger.logParanoia(PidFileUtil.class, "Cannot retrieve status of PID " + pid + ". Assuming that the process not running.");
            return false;
        }
    }

    private static boolean isProcessRunningOnWindows(int pid) {
        try {
            Process tasklistProcess = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "tasklist /FI \"PID eq " + pid + "\" /FI \"imagename eq java*\""});
            BufferedReader tasklistOutputReader = new BufferedReader(new InputStreamReader(tasklistProcess.getInputStream()));
            String line = null;
            boolean processRunning = false;
            while ((line = tasklistOutputReader.readLine()) != null) {
                if (!line.contains(" " + pid + " ")) continue;
                processRunning = true;
                break;
            }
            Logger.logInfo(PidFileUtil.class, "isProcessRunningOnWindows(" + pid + ") returned " + line + ", process running = " + processRunning);
            return processRunning;
        }
        catch (Exception ex) {
            Logger.logParanoia(PidFileUtil.class, "Cannot retrieve status of PID " + pid + "; assuming process not running.");
            return false;
        }
    }

    public static void checkForRunningInstances(String name, boolean pidCheckDisabled, boolean closeOldInstance) {
        if (!pidCheckDisabled) {
            String tempDir = FileUtils.getTempDir();
            String filename = name + "_info";
            File appFile = new File(tempDir, filename);
            appFile.setReadable(true);
            int pidFromFile = PidFileUtil.getPidFromFile(appFile);
            if (pidFromFile != -1 && PidFileUtil.isProcessRunning(pidFromFile)) {
                if (closeOldInstance) {
                    boolean killed = PidFileUtil.killProcess(pidFromFile);
                    if (!killed) {
                        DialogUtils.errorDialog(null, "Masina mai ruleaza o instanta a aplicatiei!", LangRoAll.nuPotContinua);
                        Utils.systemExit();
                    }
                } else {
                    Utils.systemExit();
                }
            }
            try {
                appFile.createNewFile();
                PidFileUtil.createNewPidFile(appFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

