/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.ZipUtils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.sql.SqlUtils;

public class SimpleUpdater
extends LangRoAll {
    private static final String BACKUP_DIR = "update_bk";
    private static final String updateDirPrefix = "export";
    private static final String updateTmpDir = "update_tmp";
    private static final String updateLogFile = "update.log";
    private static final String className = "SimpleUpdater";
    private static final String updateArchiveDir = "versions";
    private static final String updateArchivePrefix = "vpLibs_";
    private static final String updateArchiveExtension = ".zip";
    private static final String changeLog = "changelog.txt";
    private static final String databaseLog = "db_modifications.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        FileUtils.removeFileRecurse(new File(updateLogFile));
        Logger.getInstance(5, updateLogFile);
        boolean gui = Utils.getCmdlineValue("-gui", args, "true").equalsIgnoreCase("true");
        String dbName = Utils.getCmdlineValue("-dbName", args, "dever");
        String host = Utils.getCmdlineValue("-host", args, "localhost");
        Integer port = Integer.parseInt(Utils.getCmdlineValue("-port", args, "1527"));
        boolean auto = Utils.getCmdlineValue("-auto", args, "false").equalsIgnoreCase("true");
        JFrame frame = null;
        if (gui) {
            try {
                frame = new JFrame();
            }
            catch (HeadlessException e) {
                // empty catch block
            }
        }
        boolean continuam = auto;
        if (!auto) {
            if (gui) {
                continuam = DialogUtils.confirmDialog(frame, "Este necesar ca programul sa fie inchis. Continuam", LangRoAll.confirmare);
            } else {
                System.out.println("Este necesar ca programul sa fie inchis. Continuam ? [N/y]");
                String input = Utils.getCmdLineInput();
                if (Validators.correctString(input) && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes"))) {
                    continuam = true;
                }
            }
        }
        if (!continuam) {
            Utils.systemExit();
        }
        boolean backup = auto;
        if (!auto) {
            if (gui) {
                backup = DialogUtils.confirmDialog(frame, "Efectuam backup", "Backup");
            } else {
                System.out.println("Efectuam backup ? [N/y]");
                String input = Utils.getCmdLineInput();
                if (Validators.correctString(input) && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes"))) {
                    backup = true;
                }
            }
        }
        if (backup) {
            FileUtils.buildDir(BACKUP_DIR);
            String backupDir = BACKUP_DIR + File.separator + Formatters.currentDateAndTimeForFileSystem.format(new Date());
            FileUtils.buildDir(backupDir);
            String libBK = backupDir + File.separator + "lib";
            String confBK = backupDir + File.separator + "conf";
            FileUtils.buildDir(libBK);
            FileUtils.buildDir(confBK);
            try {
                FileUtils.copyFiles("lib", libBK);
            }
            catch (IOException e) {
                Logger.logException(className, (Exception)e);
            }
            try {
                FileUtils.copyFiles("conf", confBK);
            }
            catch (IOException e) {
                Logger.logException(className, (Exception)e);
            }
        }
        FileUtils.buildDir(updateArchiveDir);
        String[] updateFile = SimpleUpdater.getUpdateArchive(gui, frame, auto);
        FileUtils.removeFileRecurse(new File(updateTmpDir));
        FileUtils.buildDir(updateTmpDir);
        try {
            ZipUtils.zipUnpack(updateFile[0], updateTmpDir);
        }
        catch (IOException e) {
            Logger.logException(className, (Exception)e);
            Utils.systemExit();
        }
        try {
            DatabaseManager.getInstance(port, host, dbName, !gui);
            ConnectionPool.getFirstInstance();
        }
        catch (SQLException e) {
            Logger.logException(className, (Exception)e);
            Utils.systemExit();
        }
        int currentVersion = Config.getInstance().getInt("currentVersion");
        String s1 = updateTmpDir + File.separator + updateDirPrefix + File.separator + changeLog;
        String changeLogStartText = "== versiunea " + currentVersion;
        if (!SimpleUpdater.checkExistingStart(s1, changeLogStartText, gui, frame, auto)) {
            return;
        }
        String changeLog = TextUtils.getLinesBetween(s1, changeLogStartText, "== versiunea " + updateFile[1], false, true);
        String s11 = updateTmpDir + File.separator + "1.txt";
        try {
            FileUtils.writeTextToFile(s11, changeLog);
        }
        catch (IOException e) {
            Logger.logException(className, (Exception)e);
        }
        if (!auto && gui && !DialogUtils.bigConfirmDialog(frame, "Confirmarea reprezinta acceptul dumneavoastra asupra modificarilor", changeLog, LangRoAll.confirmare)) {
            DialogUtils.okDialog(frame, "Update anulat", "Anulat");
            Utils.systemExit();
        }
        String s2 = updateTmpDir + File.separator + updateDirPrefix + File.separator + databaseLog;
        String startText = "update configs set value = '" + currentVersion + "' where id_key = ( select min(id) from keys where label = 'currentVersion' );";
        String stopText = "update configs set value = '" + updateFile[1] + "' where id_key = ( select min(id) from keys where label = 'currentVersion' );";
        if (!SimpleUpdater.checkExistingStart(s2, startText, gui, frame, auto)) {
            return;
        }
        String dbModif = TextUtils.getLinesBetween(s2, startText, stopText, true, true);
        String s21 = updateTmpDir + File.separator + "2.txt";
        try {
            FileUtils.writeTextToFile(s21, dbModif);
        }
        catch (IOException e) {
            Logger.logException(className, (Exception)e);
        }
        boolean updateDb = auto;
        if (!auto) {
            if (gui) {
                updateDb = DialogUtils.confirmDialog(frame, "Updatam baza de date", "DB Update");
            } else {
                System.out.println("Updatam baza de date ? [N/y]");
                String input = Utils.getCmdLineInput();
                if (Validators.correctString(input) && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes"))) {
                    updateDb = true;
                }
            }
        }
        if (updateDb) {
            try {
                SqlUtils.executeSQLFromFile(s21, ConnectionPool.getInstance().requestConnection().getConnection());
                ConnectionPool.getInstance().commit();
            }
            catch (SQLException e) {
                Logger.logException(className, (Exception)e);
                try {
                    ConnectionPool.getInstance().rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(className, (Exception)e1);
                }
                Utils.systemExit();
            }
            finally {
                ConnectionPool.getInstance().releaseConnection();
            }
        }
        boolean updateLib = auto;
        if (!auto) {
            if (gui) {
                updateLib = DialogUtils.confirmDialog(frame, "Updatam librariile", "Lib Update");
            } else {
                System.out.println("Updatam librariile ? [N/y]");
                String input = Utils.getCmdLineInput();
                if (Validators.correctString(input) && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes"))) {
                    updateLib = true;
                }
            }
        }
        if (updateLib) {
            try {
                FileUtils.copyFiles(updateTmpDir + File.separator + updateDirPrefix + File.separator + "lib", "lib");
            }
            catch (IOException e) {
                Logger.logException(className, (Exception)e);
            }
        }
        if (gui && !auto) {
            DialogUtils.okDialog(frame, "Update efectuat ", LangRoAll.succes);
        } else {
            System.out.println("Update efectuat");
        }
        Utils.systemExit();
    }

    private static boolean checkExistingStart(String file, String textToFile, boolean gui, JFrame frame, boolean auto) {
        boolean startTextFound = TextUtils.isTextContainedInFile(file, textToFile);
        if (!startTextFound) {
            boolean ok = auto;
            if (!auto) {
                String mess = "Versiunea de start negasita in fisierul " + file + " !! Continuam";
                if (gui) {
                    ok = DialogUtils.confirmDialog(frame, mess, LangRoAll.confirmare);
                } else {
                    System.out.println(mess + " ? [N/y]");
                    String input = Utils.getCmdLineInput();
                    if (Validators.correctString(input) && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes"))) {
                        ok = true;
                    }
                }
            }
            if (!ok) {
                return false;
            }
        }
        return true;
    }

    private static int getVersionForString(String s) {
        int start = s.lastIndexOf(updateArchivePrefix);
        String s1 = s.substring(start, s.length());
        s1 = s1.substring(updateArchivePrefix.length());
        int dot = s1.indexOf(updateArchiveExtension);
        String s2 = s1.substring(0, dot);
        int version = Integer.parseInt(s2);
        return version;
    }

    private static String[] getUpdateArchive(boolean gui, JFrame frame, boolean auto) {
        File dir = new File(updateArchiveDir);
        String[] updates = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f1 = new File(dir, name);
                if (!f1.isFile()) {
                    return false;
                }
                return name.startsWith(SimpleUpdater.updateArchivePrefix) && name.endsWith(SimpleUpdater.updateArchiveExtension);
            }
        });
        int maxVersion = 0;
        for (int i = 0; i < updates.length; ++i) {
            int version = SimpleUpdater.getVersionForString(updates[i]);
            if (maxVersion >= version) continue;
            maxVersion = version;
        }
        String defaultUpdateFile = "";
        if (maxVersion > 0) {
            defaultUpdateFile = updateArchiveDir + File.separator + updateArchivePrefix + maxVersion + updateArchiveExtension;
        }
        String[] result = new String[2];
        if (!auto) {
            boolean gata = false;
            while (!gata) {
                String name;
                if (gui) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setCurrentDirectory(new File(updateArchiveDir));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setSelectedFile(new File(defaultUpdateFile));
                    fileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            String name = f.getName();
                            return name.startsWith(SimpleUpdater.updateArchivePrefix) && name.endsWith(SimpleUpdater.updateArchiveExtension);
                        }

                        @Override
                        public String getDescription() {
                            return "vpLibs_$$$.zip files";
                        }
                    });
                    int retValue = fileChooser.showOpenDialog(frame);
                    if (retValue == 0) {
                        File reportFile = fileChooser.getSelectedFile();
                        result[0] = reportFile.getAbsolutePath();
                        result[1] = reportFile.getName();
                        gata = true;
                        continue;
                    }
                    Utils.systemExit();
                    continue;
                }
                System.out.println("Introduceti calea relativa la fisierul de update: [" + defaultUpdateFile + "]");
                String inputFile = Utils.getCmdLineInput();
                if (Validators.correctString(inputFile)) {
                    result[0] = inputFile;
                    result[1] = inputFile;
                } else {
                    if (!Validators.correctString(defaultUpdateFile)) continue;
                    result[0] = defaultUpdateFile;
                    result[1] = defaultUpdateFile;
                    gata = true;
                }
                File f2 = new File(FileUtils.getCurrentDir() + File.separator + result);
                if (f2.exists() && f2.isFile() && (name = f2.getName()).startsWith(updateArchivePrefix) && name.endsWith(updateArchiveExtension)) {
                    gata = true;
                }
                if (gata) continue;
                System.out.println("Nume fisier incorect");
            }
        } else {
            result[0] = defaultUpdateFile;
            result[1] = defaultUpdateFile;
        }
        result[1] = SimpleUpdater.getVersionForString(result[1]) + "";
        return result;
    }
}

