/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import org.xml.sax.Attributes;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class TextUtils {
    public static String getHexString(short[] bytes, boolean spaced) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            short b = bytes[i];
            buf.append(Integer.toHexString(b));
            if (!spaced) continue;
            buf.append(' ');
        }
        return buf.toString().toUpperCase();
    }

    public static String getHexString(byte[] bytes, boolean spaced) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            short b = bytes[i];
            if (b < 0) {
                b = (short)(b + 256);
            }
            buf.append(Integer.toHexString(b));
            if (!spaced) continue;
            buf.append(' ');
        }
        return buf.toString().toUpperCase();
    }

    public static String trimChar(String target, char toErase) {
        StringBuffer result = new StringBuffer();
        char[] array = target.toCharArray();
        boolean stopDelete = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == toErase && !stopDelete) continue;
            result.append(array[i]);
            stopDelete = true;
        }
        String r1 = result.toString();
        return r1;
    }

    public static String escapeForXMLStripQuote(String shortName) {
        String s = shortName.replaceAll("'", "");
        s = TextUtils.escapeForXML(s);
        return s;
    }

    public static String escapeForXML(String unenscapedText) {
        if (unenscapedText == null) {
            unenscapedText = "";
        }
        String autocutter = "\u001dVB\u0000";
        String normal = "\u001b!\u0001";
        String tall = "\u001b!\u0010";
        String wide = "\u001b! ";
        String big = "\u001b!0";
        String escape = "\u001b";
        String escapedText = new String(unenscapedText);
        escapedText = escapedText.replaceAll("&", "&amp;");
        escapedText = escapedText.replaceAll("<", "&lt;");
        escapedText = escapedText.replaceAll(">", "&gt;");
        escapedText = escapedText.replaceAll("\\\\", "&#92;");
        escapedText = escapedText.replaceAll("\"", "&quot;");
        escapedText = escapedText.replaceAll("'", "&apos;");
        escapedText = escapedText.replaceAll("\\$", "&#36;");
        escapedText = escapedText.replaceAll(autocutter, "");
        escapedText = escapedText.replaceAll(normal, "");
        escapedText = escapedText.replaceAll(tall, "");
        escapedText = escapedText.replaceAll(wide, "");
        escapedText = escapedText.replaceAll(big, "");
        escapedText = escapedText.replaceAll(escape, "");
        escapedText = escapedText.replaceAll("\u0000", "");
        return escapedText;
    }

    public static String wrapText(String unwrappedText) {
        StringBuffer result = new StringBuffer();
        int lineLength = 80;
        int currentPos = 0;
        int end = Math.min(currentPos + lineLength, unwrappedText.length());
        String s = unwrappedText.substring(currentPos, end);
        while (s.length() > 0) {
            result.append(s);
            result.append("\n");
            currentPos = end;
            end = Math.min(currentPos + lineLength, unwrappedText.length());
            s = unwrappedText.substring(currentPos, end);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTextContainedInFile(String file, String startText) {
        BufferedReader r = null;
        boolean result = false;
        try {
            r = new LineNumberReader(new FileReader(file));
            String line = ((LineNumberReader)r).readLine();
            while (line != null) {
                if (line.contains(startText)) {
                    result = true;
                }
                line = ((LineNumberReader)r).readLine();
            }
        }
        catch (IOException e) {
            Logger.logException("TextUtils", (Exception)e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    public static String getLinesBetween(String file, String startText, String stopText, boolean includeStopLine, boolean startTextMissingAllowed) {
        boolean startTextInFile = TextUtils.isTextContainedInFile(file, startText);
        if (!startTextInFile && !startTextMissingAllowed) {
            return "";
        }
        boolean startFound = false;
        if (!startTextInFile) {
            startFound = true;
        }
        StringBuffer result = new StringBuffer();
        try {
            LineNumberReader r = new LineNumberReader(new FileReader(file));
            String line = r.readLine();
            while (line != null) {
                if (startFound) {
                    if (line.contains(stopText)) {
                        if (!includeStopLine) break;
                        result.append(line);
                        result.append('\n');
                        break;
                    }
                    result.append(line);
                    result.append('\n');
                } else if (line.contains(startText)) {
                    startFound = true;
                }
                line = r.readLine();
            }
            r.close();
        }
        catch (IOException e) {
            Logger.logException("TextUtils", (Exception)e);
        }
        return result.toString();
    }

    public static void dumpToXml(Object o, StringBuffer buffer, String name, String auxAttributes) throws IllegalAccessException {
        Class<?> oClass = o.getClass();
        buffer.append("<" + name);
        buffer.append(" " + auxAttributes);
        buffer.append(" classname=\"" + oClass.getName() + "\"");
        TextUtils.dumpToXmlRecurse(o, oClass, buffer);
        buffer.append("/>\n");
    }

    private static void dumpToXmlRecurse(Object object, Class oClass, StringBuffer buffer) throws IllegalAccessException {
        Class superclass = oClass.getSuperclass();
        if (superclass != Object.class) {
            TextUtils.dumpToXmlRecurse(object, superclass, buffer);
        }
        Field[] fields = oClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            buffer.append(" " + fields[i].getName());
            buffer.append("=\"");
            Object value = fields[i].get(object);
            if (value != null) {
                String s;
                Class<?> valueClass = value.getClass();
                if (valueClass.isPrimitive() || valueClass == Long.class || valueClass == Integer.class || valueClass == Boolean.class || valueClass == Short.class || valueClass == Byte.class || valueClass == Double.class || valueClass == Double.class) {
                    buffer.append(value);
                }
                if (value.getClass() == String.class) {
                    String s2 = (String)value;
                    buffer.append(TextUtils.escapeForXML(s2));
                }
                if (value.getClass() == Timestamp.class) {
                    Timestamp ts = (Timestamp)value;
                    s = "" + ts.getTime();
                    buffer.append(s);
                }
                if (value.getClass() == Date.class) {
                    java.util.Date d = (java.util.Date)value;
                    s = "" + d.getTime();
                    buffer.append(s);
                }
            }
            buffer.append("\"");
        }
    }

    public static void loadAttributesBySetters(Object object, Attributes xmlAttributes) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        Method[] methods = objectClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Long time;
            Method method = methods[j];
            if (!TextUtils.isSetter(method)) continue;
            String attributeName = method.getName();
            String last = attributeName.substring(4, attributeName.length());
            Character c1 = Character.valueOf(attributeName.charAt(3));
            String s1 = c1 + "";
            s1 = s1.toLowerCase();
            String s2 = s1 + last;
            String value = xmlAttributes.getValue(s2);
            Class<?>[] params = method.getParameterTypes();
            Class<?> expectedClass = params[0];
            if (expectedClass == Double.TYPE) {
                Double v = 0.0;
                if (Validators.correctDouble(value)) {
                    v = Utils.parseDouble(value);
                }
                method.invoke(object, v);
                continue;
            }
            if (expectedClass == Integer.TYPE) {
                Integer i = new Integer(0);
                if (Validators.correctInteger(value)) {
                    i = Integer.parseInt(value);
                }
                method.invoke(object, i);
                continue;
            }
            if (expectedClass == Boolean.TYPE) {
                Boolean b = Boolean.FALSE;
                if (Validators.correctBoolean(value)) {
                    b = Boolean.parseBoolean(value);
                }
                method.invoke(object, b);
                continue;
            }
            if (expectedClass == Timestamp.class) {
                if (!Validators.correctBigInteger(value)) continue;
                time = Long.parseLong(value);
                Timestamp ts = new Timestamp(time);
                method.invoke(object, ts);
                continue;
            }
            if (expectedClass == java.util.Date.class) {
                if (!Validators.correctBigInteger(value)) continue;
                time = Long.parseLong(value);
                java.util.Date d = new java.util.Date(time);
                method.invoke(object, d);
                continue;
            }
            method.invoke(object, value);
        }
    }

    public static void printGettersSetters(Class aClass) {
        Method[] methods = aClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            if (TextUtils.isGetter(method)) {
                System.out.println("getter: " + method);
            }
            if (!TextUtils.isSetter(method)) continue;
            System.out.println("setter: " + method);
        }
    }

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static String dump(Object o) {
        StringBuffer buffer = new StringBuffer();
        Class<?> oClass = o.getClass();
        if (oClass.isArray()) {
            buffer.append("Array: ");
            buffer.append("[");
            for (int i = 0; i < Array.getLength(o); ++i) {
                Object value = Array.get(o, i);
                if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == String.class || value.getClass() == Short.class || value.getClass() == Byte.class) {
                    buffer.append(value);
                    if (i == Array.getLength(o) - 1) continue;
                    buffer.append(",");
                    continue;
                }
                buffer.append(TextUtils.dump(value));
            }
            buffer.append("]\n");
        } else {
            buffer.append("Class: " + oClass.getName());
            buffer.append("{\n");
            while (oClass != null) {
                Field[] fields = oClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    buffer.append(fields[i].getName());
                    buffer.append("=");
                    try {
                        Object value = fields[i].get(o);
                        if (value != null) {
                            if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == String.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Short.class || value.getClass() == Byte.class) {
                                buffer.append(value);
                            } else {
                                buffer.append(TextUtils.dump(value));
                            }
                        }
                    }
                    catch (IllegalAccessException e) {
                        buffer.append(e.getMessage());
                    }
                    buffer.append("\n");
                }
                oClass = oClass.getSuperclass();
            }
            buffer.append("}\n");
        }
        return buffer.toString();
    }
}

