/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IpAddressBean;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.sql.SqlUtils;

public class Utils
extends LangRoAll {
    public static final int DEVER_MAIN_VERSION = 2017;
    public static boolean isDecimalPointComma;
    public static boolean forceDotAsDecimalPoint;
    public static boolean numbersUseThousandsSeparator;
    public static boolean forceShowAllDecimals;
    public static final String IMAGES_PREFIX = "images/";
    public static final int BUFFER_SIZE = 65536;
    public static String localComputerName;

    public static String[] getStringArray(Vector v) {
        String[] result = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            String o;
            result[i] = o = (String)v.elementAt(i);
        }
        return result;
    }

    public static String getFloatStringOrEmpty3Decimals(double toConvert) {
        if (toConvert == 0.0) {
            return "";
        }
        return Utils.getString3Decimals(toConvert);
    }

    public static String getFloatStringOrEmpty2Decimals(double toConvert) {
        if (toConvert == 0.0) {
            return "";
        }
        return Utils.getString2Decimals(toConvert);
    }

    public static InputStream getResource(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static String encodeString(String string) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
            msgDigest.update(string.getBytes());
            byte[] byteArr = msgDigest.digest();
            return Utils.hexArrayAsString(byteArr);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String hexArrayAsString(byte[] byteArray) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            buff.append(Utils.hexString(byteArray[i]));
            buff.append(' ');
        }
        return buff.toString();
    }

    public static String decStringAsString(String toConvert) {
        StringBuffer buff = new StringBuffer();
        byte[] byteArray = toConvert.getBytes();
        for (int i = 0; i < byteArray.length; ++i) {
            buff.append(Utils.hexString(byteArray[i]));
            buff.append(' ');
        }
        return buff.toString();
    }

    public static String hexString(byte b) {
        StringBuffer strBuff = new StringBuffer(2);
        for (int j = 0; j < 2; ++j) {
            byte semi = j == 0 ? (byte)(b >> 4 & 0xF) : (byte)(b & 0xF);
            char currentChar = '0';
            switch (semi) {
                case 0: {
                    currentChar = '0';
                    break;
                }
                case 1: {
                    currentChar = '1';
                    break;
                }
                case 2: {
                    currentChar = '2';
                    break;
                }
                case 3: {
                    currentChar = '3';
                    break;
                }
                case 4: {
                    currentChar = '4';
                    break;
                }
                case 5: {
                    currentChar = '5';
                    break;
                }
                case 6: {
                    currentChar = '6';
                    break;
                }
                case 7: {
                    currentChar = '7';
                    break;
                }
                case 8: {
                    currentChar = '8';
                    break;
                }
                case 9: {
                    currentChar = '9';
                    break;
                }
                case 10: {
                    currentChar = 'A';
                    break;
                }
                case 11: {
                    currentChar = 'B';
                    break;
                }
                case 12: {
                    currentChar = 'C';
                    break;
                }
                case 13: {
                    currentChar = 'D';
                    break;
                }
                case 14: {
                    currentChar = 'E';
                    break;
                }
                case 15: {
                    currentChar = 'F';
                }
            }
            strBuff.append(currentChar);
        }
        return strBuff.toString();
    }

    public static ImageIcon getImageResource(String imageName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL imageURL = cl.getResource(IMAGES_PREFIX + imageName);
        return new ImageIcon(imageURL);
    }

    public static ImageIcon getImageFromDisk(String imageName) throws MalformedURLException {
        File f = new File(IMAGES_PREFIX + imageName);
        if (!f.exists()) {
            return null;
        }
        String file = f.getAbsolutePath();
        URL imageURL = new URL("file://" + file);
        return new ImageIcon(imageURL);
    }

    public static ImageIcon getImageFromDiskAbsolutePath(String imageName) throws MalformedURLException {
        File f = new File(imageName);
        if (!f.exists()) {
            return null;
        }
        String file = f.getAbsolutePath();
        return new ImageIcon(file);
    }

    public static ImageIcon getImageFromDiskAbsolutePath(String imageName, int dx, int dy) {
        ImageIcon result = null;
        try {
            BufferedImage img = ImageIO.read(new File(imageName));
            Image dimg = img.getScaledInstance(dx, dy, 4);
            result = new ImageIcon(dimg);
        }
        catch (Exception e) {
            Logger.logException(Utils.class.getName(), e);
        }
        return result;
    }

    public static void writeBuffer(StringBuffer buf, String dir, String file) throws IOException {
        int toCopy;
        File d = new File(dir);
        if (!d.exists()) {
            d.mkdirs();
        }
        if (d.isFile()) {
            throw new IOException("directory exists but it is a file");
        }
        File f = new File(dir + File.separator + file);
        FileWriter w = new FileWriter(f);
        char[] chars = new char[65536];
        int poz = 0;
        for (int remaining = buf.length(); remaining > 0; remaining -= toCopy) {
            toCopy = Math.min(remaining, 65536);
            buf.getChars(poz, poz + toCopy, chars, 0);
            w.write(chars, 0, toCopy);
            poz += toCopy;
        }
        w.flush();
        w.close();
    }

    public static Date getDate(String source, SimpleDateFormat format) {
        if (Validators.correctDate(source, format)) {
            try {
                return format.parse(source);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCurrentDateAndTimeForPrinter() {
        return Formatters.currentDateAndTimeForPrinter.format(new Date());
    }

    public static String getString3Decimals(double number) {
        String result;
        String string = result = forceShowAllDecimals ? Formatters.NUMBER_3DECIMALS_NO_TRUNC.format(number) : Formatters.NUMBER_3DECIMALS.format(number);
        if (numbersUseThousandsSeparator) {
            result = forceShowAllDecimals ? Formatters.NUMBER_3DECIMALS_NO_TRUNC_THOUSANDS.format(number) : Formatters.NUMBER_3DECIMALS_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    public static String getString2DecimalsNoTrunc(double number) {
        String result = Formatters.NUMBER_2DECIMALS_NO_TRUNC.format(number);
        if (numbersUseThousandsSeparator) {
            result = Formatters.NUMBER_2DECIMALS_NO_TRUNC_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    public static String getString3DecimalsNoTrunc(double number) {
        String result = Formatters.NUMBER_3DECIMALS_NO_TRUNC.format(number);
        if (numbersUseThousandsSeparator) {
            result = Formatters.NUMBER_3DECIMALS_NO_TRUNC_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    public static String getString2Decimals(double number) {
        String result;
        String string = result = forceShowAllDecimals ? Formatters.NUMBER_2DECIMALS_NO_TRUNC.format(number) : Formatters.NUMBER_2DECIMALS.format(number);
        if (numbersUseThousandsSeparator) {
            result = forceShowAllDecimals ? Formatters.NUMBER_2DECIMALS_NO_TRUNC_THOUSANDS.format(number) : Formatters.NUMBER_2DECIMALS_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    @Deprecated
    public static String getString6Decimals(double number) {
        String s;
        String string = s = forceShowAllDecimals ? Formatters.NUMBER_6DECIMALS_NO_TRUNC.format(number) : Formatters.NUMBER_6DECIMALS.format(number);
        if (numbersUseThousandsSeparator) {
            s = forceShowAllDecimals ? Formatters.NUMBER_6DECIMALS_NO_TRUNC_THOUSANDS.format(number) : Formatters.NUMBER_6DECIMALS_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(s);
    }

    public static String getStringXDecimals(double number, int decimals) {
        String formatS = "";
        formatS = decimals == 0 ? (numbersUseThousandsSeparator ? "#,##0" : "###0") : (numbersUseThousandsSeparator ? "#,##0." : "###0.");
        String decS = Utils.getStringMaxSize(decimals, "", Character.valueOf(forceShowAllDecimals ? (char)'0' : '#'), false);
        formatS = formatS + decS;
        DecimalFormat NUMBER_XDECIMALS_NO_TRUNC = new DecimalFormat(formatS);
        String s = NUMBER_XDECIMALS_NO_TRUNC.format(number);
        return Utils.switchDecimalSimbols(s);
    }

    public static String getString6DecimalsNoTrunc(double number) {
        String s = Formatters.NUMBER_6DECIMALS_NO_TRUNC.format(number);
        if (numbersUseThousandsSeparator) {
            s = Formatters.NUMBER_6DECIMALS_NO_TRUNC_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(s);
    }

    public static String getString5DecimalsNoTrunc(double number) {
        String s = Formatters.NUMBER_5DECIMALS_NO_TRUNC.format(number);
        if (numbersUseThousandsSeparator) {
            s = Formatters.NUMBER_5DECIMALS_NO_TRUNC_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(s);
    }

    public static String getString10Decimals(double number) {
        String s;
        String string = s = forceShowAllDecimals ? Formatters.NUMBER_10DECIMALS_NO_TRUNC.format(number) : Formatters.NUMBER_10DECIMALS.format(number);
        if (numbersUseThousandsSeparator) {
            s = forceShowAllDecimals ? Formatters.NUMBER_10DECIMALS__NO_TRUNC_THOUSANDS.format(number) : Formatters.NUMBER_10DECIMALS_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(s);
    }

    public static String getString4Decimals(double number) {
        String result;
        String string = result = forceShowAllDecimals ? Formatters.NUMBER_4DECIMALS_NO_TRUNC.format(number) : Formatters.NUMBER_4DECIMALS.format(number);
        if (numbersUseThousandsSeparator) {
            result = forceShowAllDecimals ? Formatters.NUMBER_4DECIMALS_NO_TRUNC_THOUSANDS.format(number) : Formatters.NUMBER_4DECIMALS_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    public static String getString4DecimalsNoTrunc(double number) {
        String result = Formatters.NUMBER_4DECIMALS_NO_TRUNC.format(number);
        if (numbersUseThousandsSeparator) {
            result = Formatters.NUMBER_4DECIMALS_NO_TRUNC_THOUSANDS.format(number);
        }
        return Utils.switchDecimalSimbols(result);
    }

    public static Vector splitString(String toSplit, char separator) {
        StringTokenizer token = new StringTokenizer(toSplit, "" + separator);
        Vector<String> result = new Vector<String>();
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            result.add(s);
        }
        return result;
    }

    public static String pasteString(Vector<String> toPaste, char separator) {
        String result = new String();
        for (String s : toPaste) {
            result = result + s + separator;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static boolean findInt(int toFind, String inWhat, char separator) {
        Vector vec = Utils.splitString(inWhat, separator);
        for (int i = 0; i < vec.size(); ++i) {
            String s = (String)vec.elementAt(i);
            int i1 = Integer.parseInt(s);
            if (i1 != toFind) continue;
            return true;
        }
        return false;
    }

    public static Vector splitStringKeepStructure(String toSplit, char separator, char nullChar) {
        StringTokenizer token = new StringTokenizer(toSplit, "" + separator, true);
        Vector<String> result = new Vector<String>();
        boolean lastStringisSeparator = false;
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            if (s.equalsIgnoreCase("" + separator)) {
                if (lastStringisSeparator) {
                    result.add("" + nullChar);
                }
                lastStringisSeparator = true;
                continue;
            }
            lastStringisSeparator = false;
            result.add(s);
        }
        return result;
    }

    public static String getStringMaxSize(int totalDigits, String toConvert, Character fillChar, boolean before) {
        if (toConvert == null) {
            toConvert = "";
        }
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            if (fillChar != null) {
                for (int i = toConvert.length(); i < totalDigits; ++i) {
                    result = before ? fillChar.charValue() + result : result + fillChar.charValue();
                }
            }
            return result;
        }
        return toConvert;
    }

    public static String arrange(String left, String right, int charsPerLine, char c) {
        int rightSize;
        Character c1 = new Character(c);
        int leftSize = left.length();
        int rest = charsPerLine - leftSize - (rightSize = right.length()) - 2;
        if (rest < 0) {
            rest = 0;
        }
        return left + " " + Utils.getStringMaxSize(rest, "", c1, false) + " " + right;
    }

    public static Class[] getStringClass(int elementCount) {
        Class[] types = new Class[elementCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = String.class;
        }
        return types;
    }

    public static Class[] getBooleanClass(int elementCount) {
        Class[] types = new Class[elementCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Boolean.class;
        }
        return types;
    }

    public static String getCmdlineValue(String key, String[] params, String defaultValue) {
        for (int i = 0; i < params.length; i += 2) {
            String string = params[i];
            if (!string.equalsIgnoreCase(key)) continue;
            String value = params[i + 1];
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static String getCmdlineValue(String key, String[] params) {
        for (int i = 0; i < params.length; i += 2) {
            String string = params[i];
            if (!string.equalsIgnoreCase(key)) continue;
            String value = params[i + 1];
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    public static Vector getCmdlineValues(String key, String[] params, int requiredSize, String defaultValue) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < params.length; i += 2) {
            String string = params[i];
            if (!string.equalsIgnoreCase(key)) continue;
            String value = params[i + 1];
            if (value != null) {
                result.add(value);
                continue;
            }
            result.add(defaultValue);
        }
        while (result.size() < requiredSize) {
            result.add(defaultValue);
        }
        return result;
    }

    public static void restartVirtualMachine(String restartCommand) {
        final String s = restartCommand;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (s != null) {
                        Runtime.getRuntime().exec(s);
                    }
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        });
        Utils.systemExit();
    }

    public static String getStringForJDialogList(String textForItems, String textForNoItems, Vector items) {
        String result = "<html>";
        if (items.size() > 0) {
            result = result + textForItems + "<br><br>";
            for (Object element : items) {
                result = result + "<li>" + element;
            }
        } else {
            result = result + textForNoItems;
        }
        result = result + "</html>";
        return result;
    }

    public static void importXml(DefaultHandler handler, String filename) throws IOException, SAXException {
        SAXParser r = new SAXParser();
        r.setContentHandler(handler);
        r.setErrorHandler(handler);
        r.parse(filename);
    }

    public static void importXml(DefaultHandler handler, ByteArrayInputStream source) throws IOException, SAXException {
        SAXParser r = new SAXParser();
        r.setContentHandler(handler);
        r.setErrorHandler(handler);
        InputSource inputsource = new InputSource(source);
        r.parse(inputsource);
    }

    public static void breakString(StringBuffer result, String toBreak, String separator, int maxChars) {
        StringTokenizer token = new StringTokenizer(toBreak);
        if (!token.hasMoreTokens()) {
            return;
        }
        String currentLine = token.nextToken();
        String newWord = "";
        while (token.hasMoreTokens()) {
            newWord = token.nextToken();
            if (currentLine.length() + newWord.length() > maxChars) {
                result.append(currentLine);
                result.append(separator);
                currentLine = newWord;
                continue;
            }
            currentLine = currentLine + " " + newWord;
        }
        result.append(currentLine);
    }

    public static void setLocalComputerName(String localComputerName) {
        Utils.localComputerName = localComputerName;
    }

    public static String getLocalComputerName() {
        return localComputerName;
    }

    public static String getSqlInSequence(Vector elements) {
        return Utils.getSqlInSequence(elements, false);
    }

    public static String getSqlInSequence(Vector elements, boolean spaced) {
        return Utils.getSqlInSequence(elements, spaced, ',');
    }

    public static String getSqlInSequence(Vector elements, boolean spaced, char separator) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < elements.size(); ++i) {
            Object id = elements.elementAt(i);
            sb.append(id);
            if (i >= elements.size() - 1) continue;
            sb.append(separator);
            if (!spaced) continue;
            sb.append(' ');
        }
        sb.append(")");
        return sb.toString();
    }

    public static void runCommand(String exec, File dir, long timeout) {
        try {
            Process onlineProcess = Runtime.getRuntime().exec(exec, null, dir);
            try {
                onlineProcess.wait(timeout);
            }
            catch (InterruptedException e) {
            }
            catch (Throwable th1) {
                Logger.logError((Object)"Utils", th1);
            }
        }
        catch (IOException e) {
            Logger.logException("Utils", (Exception)e);
        }
    }

    public static final void systemExit() {
        System.exit(0);
    }

    public static String getCmdLineInput() {
        String result = "";
        byte[] buffer = new byte[65536];
        try {
            int size = System.in.read(buffer);
            result = new String(buffer, 0, size);
            result = result.replaceAll("\n", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static final char getDecimalSeparator() {
        String s = Utils.getString2Decimals(0.01);
        char c = s.charAt(1);
        return c;
    }

    public static final String switchDecimalSimbolsNoCheck(String s) {
        int size = s.length();
        char[] chars = new char[size];
        s.getChars(0, size, chars, 0);
        for (int i = 0; i < size; ++i) {
            if (chars[i] == '.') {
                chars[i] = 44;
            }
            if (chars[i] != ',') continue;
            chars[i] = 46;
        }
        return new String(chars);
    }

    public static final String switchToPointAsDecimalSymbolStripComma(String s) {
        int size = s.length();
        char[] chars = new char[size];
        s.getChars(0, size, chars, 0);
        for (int i = 0; i < size; ++i) {
            if (chars[i] == '.') {
                chars[i] = 44;
            }
            if (chars[i] != ',') continue;
            chars[i] = 46;
        }
        return new String(chars);
    }

    public static final String switchDecimalSimbols(String s) {
        if (forceDotAsDecimalPoint && isDecimalPointComma) {
            return Utils.switchDecimalSimbolsNoCheck(s);
        }
        return s;
    }

    public static final String getOperatingSystem() {
        String s = System.getProperty("os.name").toUpperCase();
        if (s.indexOf("WINDOWS") >= 0) {
            return "WINDOWS";
        }
        return s;
    }

    public static Vector getDistinct(Vector all) {
        Hashtable h = new Hashtable();
        for (int i = 0; i < all.size(); ++i) {
            Object o = all.elementAt(i);
            h.put(o, o);
        }
        return new Vector(h.keySet());
    }

    public static boolean isValueZero(double value) {
        return value > -1.0E-4 && value < 1.0E-4;
    }

    public static boolean isValueGreaterThanZero(double value) {
        return value > 1.0E-4;
    }

    public static boolean isCodCantar(String c1) {
        return (c1.startsWith("24") || c1.startsWith("29") || c1.startsWith("27") || c1.startsWith("25")) && c1.length() == 13;
    }

    public static boolean isCodLot(String c1) {
        Vector prefixes = Utils.splitString(VpConfig.getInstance().lotBarcodePrefix, ',');
        for (String prefix : prefixes) {
            if (!c1.startsWith(prefix) || c1.length() != 13) continue;
            return true;
        }
        return false;
    }

    public static double getCantarCantitate(String c) {
        String c1 = c.substring(7, 12);
        double f1 = Utils.parseDouble(c1);
        return FloatUtils.roundFloat(f1 /= 1000.0, 3);
    }

    public static String getCantarCodBare(String c) {
        String c1 = c.substring(3, 7);
        c1 = TextUtils.trimChar(c1, '0');
        return c1;
    }

    public static Vector cutStringInPieces(String toSplit, int size) {
        Vector<String> result = new Vector<String>();
        int steps = toSplit.length() / size;
        ++steps;
        System.out.println("String: \"" + toSplit + "\"");
        System.out.println("Dimensiune string: " + toSplit.length());
        for (int i = 0; i < steps; ++i) {
            int startIndex = i * size;
            int stopIndex = Math.min((i + 1) * size, toSplit.length());
            String s = toSplit.substring(startIndex, stopIndex);
            System.out.println("Chunk " + i + ": startIndex: " + startIndex + " stopIndex: " + stopIndex);
            result.add(s);
        }
        return result;
    }

    public static void setSelectionForTextField(JTextField text) {
        text.setSelectionStart(0);
        text.setSelectionEnd(text.getText().length());
    }

    public static int getNumberFromMixedString(String mixedString) {
        String now;
        if (Validators.correctInteger(mixedString)) {
            return Integer.parseInt(mixedString);
        }
        int result = 0;
        for (int i = mixedString.length() - 1; i >= 0 && Validators.correctInteger(now = mixedString.substring(i, i + 1)); --i) {
            int nowI = Integer.parseInt(now);
            System.out.println("result : " + (result += (int)((double)nowI * Math.pow(10.0, mixedString.length() - i - 1))));
        }
        return result;
    }

    public static String escapeSpaceForFileSystem(String s) {
        return s.replaceAll(" ", "\\ ");
    }

    public static boolean executeExternalCommandWithSpaces(String[] cmd, File dir, String fullCommandForDebug) {
        try {
            Process onlineProcess = Runtime.getRuntime().exec(cmd, null, dir);
            int status = 0;
            try {
                status = onlineProcess.waitFor();
            }
            catch (InterruptedException e) {
                Logger.logException("Utils", (Exception)e);
            }
            catch (Throwable th1) {
                Logger.logError((Object)"Utils", th1);
            }
            if (status != 0) {
                Logger.logWarning("Utils", "Exec: " + fullCommandForDebug + " failed with status " + status);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Logger.logException("Utils", (Exception)e);
            return false;
        }
    }

    public static boolean executeExternalCommand(String exec, File dir) {
        try {
            Process onlineProcess = Runtime.getRuntime().exec(exec, null, dir);
            int status = 0;
            try {
                status = onlineProcess.waitFor();
            }
            catch (InterruptedException e) {
                Logger.logException("Utils", (Exception)e);
            }
            catch (Throwable th1) {
                Logger.logError((Object)"Utils", th1);
            }
            if (status != 0) {
                Logger.logWarning("Utils", "Exec: " + exec + " failed with status " + status);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Logger.logException("Utils", (Exception)e);
            return false;
        }
    }

    public static boolean isYes(String check) {
        return (check = check.trim()).equalsIgnoreCase("y") || check.equalsIgnoreCase("yes") || check.equalsIgnoreCase("1") || check.equalsIgnoreCase("da") || check.equalsIgnoreCase("d") || check.equalsIgnoreCase("true");
    }

    public static String getNotNullStringForDBF(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return Utils.getString2Decimals(d.floatValue());
        }
        String s = (String)o;
        return s;
    }

    public static Date extractDateFromCNP(String cnp) {
        try {
            String s = cnp.substring(0, 1);
            if (Validators.correctInteger(s)) {
                String yy = cnp.substring(1, 3);
                String mm = cnp.substring(3, 5);
                String dd = cnp.substring(5, 7);
                Date d = Formatters.SHORT_DATE_FORMAT_RO.parse(dd + "." + mm + "." + yy);
                int tipCnp = Integer.parseInt(s);
                switch (tipCnp) {
                    case 1: 
                    case 2: {
                        if (!d.after(DateUtils.getStartOf2000())) break;
                        d = DateUtils.addYearsToDate(d, -100);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (!d.after(DateUtils.getStartOf2000())) break;
                        d = DateUtils.addYearsToDate(d, -200);
                    }
                }
                return d;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            Logger.logWarning("Utils", e.getMessage());
        }
        catch (ParseException e) {
            Logger.logException("Utils", (Exception)e);
        }
        return new Date();
    }

    public static String getAsciiEncoding(String s) {
        StringBuffer result = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            byte b = (byte)chars[i];
            String encoding = Utils.hexString(b);
            result.append(encoding);
        }
        return result.toString();
    }

    public static ImageIcon scaleImageIcon(Image src, ImageObserver observer, int dX) {
        double ratio = (double)src.getWidth(observer) / (double)src.getHeight(observer);
        int dY = (int)((double)dX / ratio);
        int type = 1;
        BufferedImage dst = new BufferedImage(dX, dY, type);
        Graphics2D g2 = dst.createGraphics();
        g2.drawImage(src, 0, 0, dX, dY, observer);
        g2.dispose();
        return new ImageIcon(dst);
    }

    public static int getNumberOfDecimals(String number) {
        if (!number.contains(".")) {
            return 0;
        }
        int index = number.indexOf(".");
        return number.length() - (index + 1);
    }

    public static String getColor(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }

    public static List<String> splitEqually(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    public static void lock(String table, Connection lockConnection) throws SQLException {
        String s = "ACCESS EXCLUSIVE";
        SqlUtils.executeUpdate("lock table " + table + " in " + s + " MODE", lockConnection);
    }

    public static void release(Connection lockConnection) throws SQLException {
        lockConnection.commit();
    }

    public static Vector<IpAddressBean> getAddressesForLocalhost(boolean skipIPV6) {
        Vector<IpAddressBean> result = new Vector<IpAddressBean>();
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnumeration.hasMoreElements()) {
                NetworkInterface inter = interfaceEnumeration.nextElement();
                List<InterfaceAddress> addresses = inter.getInterfaceAddresses();
                for (InterfaceAddress addr : addresses) {
                    InetAddress address = addr.getAddress();
                    String ip = address.getHostAddress();
                    String host = address.getHostName();
                    if (skipIPV6 && address instanceof Inet6Address) {
                        System.out.println("IPV6 address : " + ip + " hostname : " + host);
                        continue;
                    }
                    if (ip.startsWith("127.0.0.1") || host.startsWith("localhost") || ip.startsWith("0:0:0:0:0:0:0:1") || ip.startsWith("::1")) {
                        System.out.println("Localhost address : " + ip + " hostname : " + host);
                        continue;
                    }
                    System.out.println("NON Localhost address : " + ip + " hostname : " + host);
                    IpAddressBean toAdd = new IpAddressBean();
                    toAdd.setHost(host);
                    toAdd.setIp(ip);
                    result.add(toAdd);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getIpsString(Vector<IpAddressBean> ips) {
        String result = "";
        for (IpAddressBean ip : ips) {
            result = result + ip.getHost() + "=" + ip.getIp() + ";";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String stripLeadingChar(String tostrip, char c) {
        int i;
        for (i = 0; i < tostrip.length() && tostrip.charAt(i) == c; ++i) {
        }
        return tostrip.substring(i, tostrip.length());
    }

    public static String stripDots(String toStrip, char c) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < toStrip.length(); ++i) {
            if (toStrip.charAt(i) == c) continue;
            result.append(toStrip.charAt(i));
        }
        return result.toString();
    }

    public static String getTranslation(MessageFormat format, String ... args) {
        if (args == null) {
            return "";
        }
        return format.format(args);
    }

    public static String getTranslation(String formatSource, String ... args) {
        if (formatSource == null || args == null) {
            return "";
        }
        MessageFormat format = new MessageFormat(formatSource);
        return format.format(args);
    }

    public static String getTranslation(String noTranslationNeeded) {
        return noTranslationNeeded;
    }

    public static String[] addOneElementToStringArray(String[] array, String toAdd) {
        String[] result = new String[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        result[array.length] = toAdd;
        return result;
    }

    public static double parseDouble(String toParse) throws NumberFormatException {
        if (numbersUseThousandsSeparator) {
            try {
                Number num = Formatters.NUMBER_10DECIMALS_THOUSANDS.parse(toParse);
                return num.doubleValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        try {
            return Formatters.NUMBER_10DECIMALS.parse(toParse).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static double parseDoubleIgnoreThousands(String toParse) throws NumberFormatException {
        try {
            return Formatters.NUMBER_10DECIMALS.parse(toParse).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static int parseInt(String toParse) throws NumberFormatException {
        if (numbersUseThousandsSeparator) {
            try {
                Number num = Formatters.NUMBER_0DECIMALS_THOUSANDS.parse(toParse);
                return num.intValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        try {
            return Formatters.NUMBER_0DECIMALS.parse(toParse).intValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static boolean isInteger(double variable) {
        return (variable = FloatUtils.round6Decimals(variable)) == Math.floor(variable) && !Double.isInfinite(variable);
    }

    public static final void main(String[] args) {
        String t = "T,1,______,_,__;8;";
        Vector s = Utils.splitString(t, ';');
        System.out.println(s);
    }

    static {
        forceDotAsDecimalPoint = true;
        numbersUseThousandsSeparator = false;
        forceShowAllDecimals = false;
        isDecimalPointComma = Utils.getDecimalSeparator() == ',';
        localComputerName = "";
    }
}

